/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.mutil.util;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
public class RotationHelper {
    public static Rotation rotationFromFacing(Direction facing) {
        switch (facing) {
            case UP: 
            case DOWN: 
            case NORTH: {
                return Rotation.NONE;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_180;
            }
            case EAST: {
                return Rotation.CLOCKWISE_90;
            }
            case WEST: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
        }
        return Rotation.NONE;
    }

    public static BlockPos rotatePitch(BlockPos pos, float pitch) {
        float f = Mth.m_14089_((float)pitch);
        float f1 = Mth.m_14031_((float)pitch);
        float x = pos.m_123341_();
        float y = (float)pos.m_123342_() * f + (float)pos.m_123343_() * f1;
        float z = (float)pos.m_123343_() * f - (float)pos.m_123342_() * f1;
        return new BlockPos(Math.round(x), Math.round(y), Math.round(z));
    }

    public static BlockPos rotateYaw(BlockPos pos, float yaw) {
        float f = Mth.m_14089_((float)yaw);
        float f1 = Mth.m_14031_((float)yaw);
        double x = (double)pos.m_123341_() * (double)f + (double)pos.m_123343_() * (double)f1;
        double y = pos.m_123342_();
        double z = (double)pos.m_123343_() * (double)f - (double)pos.m_123341_() * (double)f1;
        return new BlockPos(x, y, z);
    }

    public static BlockPos rotateDirection(BlockPos pos, Direction facing) {
        switch (facing) {
            default: {
                return pos;
            }
            case WEST: {
                return new BlockPos(-pos.m_123343_(), pos.m_123342_(), pos.m_123341_());
            }
            case NORTH: {
                return new BlockPos(-pos.m_123341_(), pos.m_123342_(), -pos.m_123343_());
            }
            case EAST: 
        }
        return new BlockPos(pos.m_123343_(), pos.m_123342_(), -pos.m_123341_());
    }

    public static VoxelShape rotateDirection(VoxelShape shape, Direction facing) {
        VoxelShape[] temp = new VoxelShape[]{shape.m_83216_(-0.5, 0.0, -0.5), Shapes.m_83040_()};
        for (int i = 0; i < facing.m_122416_(); ++i) {
            temp[0].m_83286_((x1, y1, z1, x2, y2, z2) -> {
                temp[1] = Shapes.m_83110_((VoxelShape)temp[1], (VoxelShape)Shapes.m_83048_((double)Math.min(-z1, -z2), (double)y1, (double)Math.min(x1, x2), (double)Math.max(-z1, -z2), (double)y2, (double)Math.max(x1, x2)));
            });
            temp[0] = temp[1];
            temp[1] = Shapes.m_83040_();
        }
        return temp[0].m_83216_(0.5, 0.0, 0.5);
    }

    public static Vec3i shiftAxis(Vec3i pos) {
        return new Vec3i(pos.m_123342_(), pos.m_123343_(), pos.m_123341_());
    }

    public static double getHorizontalAngle(Vec3 a, Vec3 b) {
        return Mth.m_14136_((double)(a.f_82479_ - b.f_82479_), (double)(a.f_82481_ - b.f_82481_));
    }
}

