/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.mutil.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.forgespi.Environment;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.mickelus.mutil.data.DataDistributor;

@ParametersAreNonnullByDefault
public class DataStore<V>
extends SimplePreparableReloadListener<Map<ResourceLocation, JsonElement>> {
    protected static final int jsonExtLength = ".json".length();
    private static final Logger logger = LogManager.getLogger();
    protected Gson gson;
    protected String namespace;
    protected String directory;
    protected Class<V> dataClass;
    protected Map<ResourceLocation, JsonElement> rawData;
    protected Map<ResourceLocation, V> dataMap;
    protected List<Runnable> listeners;
    private DataDistributor syncronizer;

    public DataStore(Gson gson, String namespace, String directory, Class<V> dataClass, DataDistributor synchronizer) {
        this.gson = gson;
        this.namespace = namespace;
        this.directory = directory;
        this.dataClass = dataClass;
        this.syncronizer = synchronizer;
        this.rawData = Collections.emptyMap();
        this.dataMap = Collections.emptyMap();
        this.listeners = new LinkedList<Runnable>();
    }

    protected Map<ResourceLocation, JsonElement> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        logger.debug("Reading data for {} data store...", (Object)this.directory);
        HashMap map = Maps.newHashMap();
        int i = this.directory.length() + 1;
        for (Map.Entry entry : resourceManager.m_214159_(this.directory, rl -> rl.m_135815_().endsWith(".json")).entrySet()) {
            if (!this.namespace.equals(((ResourceLocation)entry.getKey()).m_135827_())) continue;
            String path = ((ResourceLocation)entry.getKey()).m_135815_();
            ResourceLocation location = new ResourceLocation(((ResourceLocation)entry.getKey()).m_135827_(), path.substring(i, path.length() - jsonExtLength));
            try {
                BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                try {
                    JsonElement json = this.dataClass.isArray() ? (JsonElement)GsonHelper.m_13776_((Gson)this.gson, (Reader)reader, JsonArray.class) : (JsonElement)GsonHelper.m_13776_((Gson)this.gson, (Reader)reader, JsonElement.class);
                    if (json != null) {
                        if (this.shouldLoad(json)) {
                            JsonElement duplicate = map.put(location, json);
                            if (duplicate == null) continue;
                            throw new IllegalStateException("Duplicate data ignored with ID " + location);
                        }
                        logger.debug("Skipping data '{}' due to condition", entry.getKey());
                        continue;
                    }
                    logger.error("Couldn't load data from '{}' as it's null or empty", entry.getKey());
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                logger.error("Couldn't parse data '{}' from '{}'", (Object)location, entry.getKey(), (Object)exception);
            }
        }
        return map;
    }

    protected void apply(Map<ResourceLocation, JsonElement> splashList, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.rawData = splashList;
        if (Environment.get().getDist().isDedicatedServer() && ServerLifecycleHooks.getCurrentServer() != null) {
            this.syncronizer.sendToAll(this.directory, this.rawData);
        }
        this.parseData(this.rawData);
    }

    public void sendToPlayer(ServerPlayer player) {
        this.syncronizer.sendToPlayer(player, this.directory, this.rawData);
    }

    public void loadFromPacket(Map<ResourceLocation, String> data) {
        Map<ResourceLocation, JsonElement> splashList = data.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            if (this.dataClass.isArray()) {
                return (JsonElement)GsonHelper.m_13794_((Gson)this.gson, (String)((String)entry.getValue()), JsonArray.class);
            }
            return (JsonElement)GsonHelper.m_13794_((Gson)this.gson, (String)((String)entry.getValue()), JsonElement.class);
        }));
        this.parseData(splashList);
    }

    public void parseData(Map<ResourceLocation, JsonElement> splashList) {
        logger.info("Loaded {} {}", (Object)String.format("%3d", splashList.values().size()), (Object)this.directory);
        this.dataMap = splashList.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.gson.fromJson((JsonElement)entry.getValue(), this.dataClass)));
        this.processData();
        this.listeners.forEach(Runnable::run);
    }

    protected boolean shouldLoad(JsonElement json) {
        JsonArray arr;
        if (json.isJsonArray() && (arr = json.getAsJsonArray()).size() > 0) {
            json = arr.get(0);
        }
        if (!json.isJsonObject()) {
            return true;
        }
        JsonObject jsonObject = json.getAsJsonObject();
        return !jsonObject.has("conditions") || CraftingHelper.processConditions((JsonArray)GsonHelper.m_13933_((JsonObject)jsonObject, (String)"conditions"), (ICondition.IContext)ICondition.IContext.EMPTY);
    }

    protected void processData() {
    }

    public Map<ResourceLocation, JsonElement> getRawData() {
        return this.rawData;
    }

    public String getDirectory() {
        return this.directory;
    }

    public V getData(ResourceLocation resourceLocation) {
        return this.dataMap.get(resourceLocation);
    }

    public Map<ResourceLocation, V> getData() {
        return this.dataMap;
    }

    public Collection<V> getDataIn(ResourceLocation resourceLocation) {
        return this.getData().entrySet().stream().filter(entry -> resourceLocation.m_135827_().equals(((ResourceLocation)entry.getKey()).m_135827_()) && ((ResourceLocation)entry.getKey()).m_135815_().startsWith(resourceLocation.m_135815_())).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public void onReload(Runnable callback) {
        this.listeners.add(callback);
    }
}

