/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wires;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import commoble.morered.client.ClientProxy;
import commoble.morered.util.DirectionHelper;
import commoble.morered.wires.Edge;
import commoble.morered.wires.VoxelCache;
import commoble.morered.wires.WireUpdateBuffer;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class AbstractWireBlock
extends Block {
    public static final BooleanProperty DOWN = PipeBlock.f_55153_;
    public static final BooleanProperty UP = PipeBlock.f_55152_;
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty[] INTERIOR_FACES = new BooleanProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
    protected final VoxelShape[] shapesByStateIndex;
    protected final VoxelShape[] raytraceBackboards;
    protected final LoadingCache<Long, VoxelShape> voxelCache;
    protected final boolean useIndirectPower;

    public static VoxelShape[] makeVoxelShapes(VoxelShape[] nodeShapes, VoxelShape[] lineShapes) {
        VoxelShape[] result = new VoxelShape[64];
        for (int i = 0; i < 64; ++i) {
            VoxelShape nextShape = Shapes.m_83040_();
            boolean[] addedSides = new boolean[6];
            for (int side = 0; side < 6; ++side) {
                if ((i & 1 << side) == 0) continue;
                nextShape = Shapes.m_83110_((VoxelShape)nextShape, (VoxelShape)nodeShapes[side]);
                int sideAxis = side / 2;
                for (int secondarySide = 0; secondarySide < side; ++secondarySide) {
                    if (!addedSides[secondarySide] || sideAxis == secondarySide / 2) continue;
                    nextShape = Shapes.m_83110_((VoxelShape)nextShape, (VoxelShape)AbstractWireBlock.getLineShape(lineShapes, side, DirectionHelper.getCompressedSecondSide(side, secondarySide)));
                    nextShape = Shapes.m_83110_((VoxelShape)nextShape, (VoxelShape)AbstractWireBlock.getLineShape(lineShapes, secondarySide, DirectionHelper.getCompressedSecondSide(secondarySide, side)));
                }
                addedSides[side] = true;
            }
            result[i] = nextShape;
        }
        return result;
    }

    public static VoxelShape getLineShape(VoxelShape[] lineShapes, int side, int secondarySide) {
        return lineShapes[side * 4 + secondarySide];
    }

    public static int getShapeIndex(BlockState state) {
        int index = 0;
        int sideCount = INTERIOR_FACES.length;
        for (int side = 0; side < sideCount; ++side) {
            if (!((Boolean)state.m_61143_((Property)INTERIOR_FACES[side])).booleanValue()) continue;
            index |= 1 << side;
        }
        return index;
    }

    public static VoxelShape makeExpandedShapeForIndex(VoxelShape[] shapesByStateIndex, VoxelShape[] lineShapes, long index) {
        int primaryShapeIndex = (int)(index & 0x3FL);
        long expandedShapeIndex = index >> 6;
        VoxelShape shape = shapesByStateIndex[primaryShapeIndex];
        int flag = 1;
        for (int side = 0; side < 6; ++side) {
            for (int subSide = 0; subSide < 4; ++subSide) {
                if ((expandedShapeIndex & (long)flag) != 0L) {
                    shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)AbstractWireBlock.getLineShape(lineShapes, side, subSide));
                }
                flag <<= 1;
            }
        }
        return shape;
    }

    public static LoadingCache<Long, VoxelShape> makeVoxelCache(final VoxelShape[] shapesByStateIndex, final VoxelShape[] lineShapes) {
        return CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Long, VoxelShape>(){

            public VoxelShape load(Long key) throws Exception {
                return AbstractWireBlock.makeExpandedShapeForIndex(shapesByStateIndex, lineShapes, key);
            }
        });
    }

    public static boolean canWireConnectToAdjacentWireOrCable(BlockGetter world, BlockPos thisPos, BlockState thisState, BlockPos wirePos, BlockState wireState, Direction wireFace, Direction directionToWire) {
        BlockPos diagonalPos;
        BlockState diagonalState;
        if (wireFace.m_122434_() != directionToWire.m_122434_() && ((Boolean)thisState.m_61143_((Property)INTERIOR_FACES[wireFace.ordinal()])).booleanValue()) {
            return true;
        }
        Block wireBlock = wireState.m_60734_();
        return wireBlock == thisState.m_60734_() && (diagonalState = world.m_8055_(diagonalPos = thisPos.m_121945_(wireFace))).m_60734_() == wireBlock && (Boolean)diagonalState.m_61143_((Property)INTERIOR_FACES[directionToWire.ordinal()]) != false;
    }

    public AbstractWireBlock(BlockBehaviour.Properties properties, VoxelShape[] shapesByStateIndex, VoxelShape[] raytraceBackboards, LoadingCache<Long, VoxelShape> voxelCache, boolean useIndirectPower) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false)));
        this.shapesByStateIndex = shapesByStateIndex;
        this.raytraceBackboards = raytraceBackboards;
        this.voxelCache = voxelCache;
        this.useIndirectPower = useIndirectPower;
    }

    protected abstract boolean canAdjacentBlockConnectToFace(BlockGetter var1, BlockPos var2, BlockState var3, Block var4, Direction var5, Direction var6, BlockPos var7, BlockState var8);

    protected abstract void updatePowerAfterBlockUpdate(Level var1, BlockPos var2, BlockState var3);

    protected abstract void notifyNeighbors(Level var1, BlockPos var2, BlockState var3, EnumSet<Direction> var4, boolean var5);

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{DOWN, UP, NORTH, SOUTH, WEST, EAST});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return worldIn instanceof Level ? VoxelCache.get((Level)worldIn).getWireShape(pos) : this.shapesByStateIndex[AbstractWireBlock.getShapeIndex(state)];
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return this.shapesByStateIndex[AbstractWireBlock.getShapeIndex(state)];
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return this.isEmptyWireBlock(state);
    }

    public BlockState m_7417_(BlockState thisState, Direction directionToNeighbor, BlockState neighborState, LevelAccessor world, BlockPos thisPos, BlockPos neighborPos) {
        BooleanProperty sideProperty = INTERIOR_FACES[directionToNeighbor.ordinal()];
        if (((Boolean)thisState.m_61143_((Property)sideProperty)).booleanValue()) {
            Direction neighborSide = directionToNeighbor.m_122424_();
            boolean isNeighborSideSolid = neighborState.m_60783_((BlockGetter)world, neighborPos, neighborSide);
            if (!isNeighborSideSolid && world instanceof ServerLevel) {
                Block.m_49950_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)sideProperty, (Comparable)Boolean.valueOf(true))), (Level)((ServerLevel)world), (BlockPos)thisPos);
            }
            return (BlockState)thisState.m_61124_((Property)sideProperty, (Comparable)Boolean.valueOf(isNeighborSideSolid));
        }
        return thisState;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction[] dirs = Direction.values();
        for (int side = 0; side < 6; ++side) {
            Direction neighborSide;
            Direction dir;
            BlockPos neighborPos;
            BlockState neighborState;
            if (!((Boolean)state.m_61143_((Property)INTERIOR_FACES[side])).booleanValue() || (neighborState = world.m_8055_(neighborPos = pos.m_121945_(dir = dirs[side]))).m_60783_((BlockGetter)world, neighborPos, neighborSide = dir.m_122424_())) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        Direction sideOfNeighbor = context.m_43719_();
        Direction directionToNeighbor = sideOfNeighbor.m_122424_();
        BlockPos placePos = context.m_8083_();
        BlockPos neighborPos = placePos.m_121945_(directionToNeighbor);
        BlockState neighborState = world.m_8055_(neighborPos);
        return neighborState.m_60783_((BlockGetter)world, neighborPos, sideOfNeighbor) ? (BlockState)this.m_49966_().m_61124_((Property)INTERIOR_FACES[directionToNeighbor.ordinal()], (Comparable)Boolean.valueOf(true)) : null;
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        ClientProxy.initializeAbstractWireBlockClient(this, consumer);
    }

    @Deprecated
    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.updateShapeCache(worldIn, pos);
        super.m_6807_(state, worldIn, pos, oldState, isMoving);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!worldIn.f_46443_) {
            for (Direction directionToNeighbor : Direction.values()) {
                BlockPos neighborPos = pos.m_121945_(directionToNeighbor);
                BlockState neighborState = worldIn.m_8055_(neighborPos);
                if (!neighborState.m_60795_()) continue;
                this.addEmptyWireToAir(state, worldIn, neighborPos, directionToNeighbor);
            }
        }
        this.updateShapeCache(worldIn, pos);
        this.updatePowerAfterBlockUpdate(worldIn, pos, state);
        super.m_6402_(worldIn, pos, state, placer, stack);
    }

    @Deprecated
    public void m_6810_(BlockState oldState, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        boolean doPowerUpdate = true;
        if (newState.m_60734_() != this) {
            this.notifyNeighbors(worldIn, pos, newState, EnumSet.allOf(Direction.class), this.useIndirectPower);
            doPowerUpdate = false;
        } else if (this.isEmptyWireBlock(newState)) {
            long edgeFlags = this.getEdgeFlags((BlockGetter)worldIn, pos);
            if (edgeFlags == 0L) {
                worldIn.m_7471_(pos, false);
            } else {
                this.notifyNeighbors(worldIn, pos, newState, EnumSet.allOf(Direction.class), this.useIndirectPower);
            }
            doPowerUpdate = false;
        }
        this.updateShapeCache(worldIn, pos);
        super.m_6810_(oldState, worldIn, pos, newState, isMoving);
        if (doPowerUpdate) {
            this.updatePowerAfterBlockUpdate(worldIn, pos, newState);
        }
    }

    @Deprecated
    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean isMoving) {
        BlockPos offset = fromPos.m_121996_((Vec3i)pos);
        Direction directionToNeighbor = Direction.m_122378_((int)offset.m_123341_(), (int)offset.m_123342_(), (int)offset.m_123343_());
        long edgeFlags = this.getEdgeFlags((BlockGetter)worldIn, pos);
        if (this.isEmptyWireBlock(state)) {
            if (edgeFlags == 0L) {
                worldIn.m_7471_(pos, false);
            }
        } else if (worldIn.m_46859_(fromPos) && directionToNeighbor != null) {
            this.addEmptyWireToAir(state, worldIn, fromPos, directionToNeighbor);
        }
        this.updateShapeCache(worldIn, pos);
        this.updatePowerAfterBlockUpdate(worldIn, pos, state);
        if (edgeFlags != 0L) {
            EnumSet<Direction> edgeUpdateDirs = EnumSet.noneOf(Direction.class);
            Edge[] edges = Edge.values();
            for (int edgeFlag = 0; edgeFlag < 12; ++edgeFlag) {
                if ((edgeFlags & (long)(1 << edgeFlag)) == 0L) continue;
                Edge edge = edges[edgeFlag];
                if (edge.sideA == directionToNeighbor) {
                    edgeUpdateDirs.add(edge.sideB);
                    continue;
                }
                if (edge.sideB != directionToNeighbor) continue;
                edgeUpdateDirs.add(edge.sideA);
            }
            if (!edgeUpdateDirs.isEmpty() && !ForgeEventFactory.onNeighborNotify((Level)worldIn, (BlockPos)pos, (BlockState)state, edgeUpdateDirs, (boolean)false).isCanceled()) {
                BlockPos.MutableBlockPos mutaPos = pos.m_122032_();
                for (Direction dir : edgeUpdateDirs) {
                    BlockPos.MutableBlockPos neighborPos = mutaPos.m_122159_((Vec3i)pos, dir);
                    worldIn.m_46586_((BlockPos)neighborPos, (Block)this, pos);
                }
            }
        }
        super.m_6861_(state, worldIn, pos, neighborBlock, fromPos, isMoving);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        BlockState result = state;
        for (int i = 0; i < 4; ++i) {
            Direction dir = Direction.m_122407_((int)i);
            Direction newDir = rot.m_55954_(dir);
            result = (BlockState)result.m_61124_((Property)INTERIOR_FACES[newDir.ordinal()], (Comparable)((Boolean)state.m_61143_((Property)INTERIOR_FACES[dir.ordinal()])));
        }
        return result;
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        BlockState result = state;
        for (int i = 0; i < 4; ++i) {
            Direction dir = Direction.m_122407_((int)i);
            Direction newDir = mirrorIn.m_54848_(dir);
            result = (BlockState)result.m_61124_((Property)INTERIOR_FACES[newDir.ordinal()], (Comparable)((Boolean)state.m_61143_((Property)INTERIOR_FACES[dir.ordinal()])));
        }
        return result;
    }

    public int getWireCount(BlockState state) {
        int count = 0;
        for (int side = 0; side < 6; ++side) {
            if (!((Boolean)state.m_61143_((Property)INTERIOR_FACES[side])).booleanValue()) continue;
            ++count;
        }
        return count;
    }

    public boolean isEmptyWireBlock(BlockState state) {
        return state == this.m_49966_();
    }

    protected long getEdgeFlags(BlockGetter world, BlockPos pos) {
        long result = 0L;
        for (int edge = 0; edge < 12; ++edge) {
            if (!Edge.values()[edge].shouldEdgeRender(world, pos, this)) continue;
            result |= 1L << edge;
        }
        return result;
    }

    protected long getEdgeFlagsForNodeLineEdgeFormat(BlockGetter world, BlockPos pos) {
        return this.getEdgeFlags(world, pos) << 30;
    }

    @Nullable
    public Direction getInteriorFaceToBreak(BlockState state, BlockPos pos, Player player, BlockHitResult raytrace, float partialTicks) {
        Vec3 lookOffset = player.m_20252_(partialTicks);
        Vec3 hitVec = raytrace.m_82450_();
        Vec3 relativeHitVec = hitVec.m_82549_(lookOffset.m_82542_(0.001, 0.001, 0.001)).m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        for (int side = 0; side < 6; ++side) {
            if (!((Boolean)state.m_61143_((Property)INTERIOR_FACES[side])).booleanValue()) continue;
            VoxelShape faceShape = this.raytraceBackboards[side];
            for (AABB aabb : faceShape.m_83299_()) {
                if (!aabb.m_82390_(relativeHitVec)) continue;
                return Direction.m_122376_((int)side);
            }
        }
        return null;
    }

    protected void updateShapeCache(Level world, BlockPos pos) {
        LoadingCache<BlockPos, VoxelShape> cache = VoxelCache.get((Level)world).shapesByPos;
        cache.invalidate((Object)pos);
        for (int i = 0; i < 6; ++i) {
            cache.invalidate((Object)pos.m_121945_(Direction.m_122376_((int)i)));
        }
        if (world instanceof ServerLevel) {
            WireUpdateBuffer.get((ServerLevel)world).enqueue(pos);
        }
    }

    protected void addEmptyWireToAir(BlockState thisState, Level world, BlockPos neighborAirPos, Direction directionToNeighbor) {
        Direction directionFromNeighbor = directionToNeighbor.m_122424_();
        for (Direction dir : Direction.values()) {
            BooleanProperty thisAttachmentFace;
            if (dir == directionToNeighbor || dir == directionFromNeighbor || !((Boolean)thisState.m_61143_((Property)(thisAttachmentFace = INTERIOR_FACES[dir.ordinal()]))).booleanValue()) continue;
            BlockPos diagonalNeighbor = neighborAirPos.m_121945_(dir);
            BooleanProperty neighborAttachmentFace = INTERIOR_FACES[directionFromNeighbor.ordinal()];
            BlockState diagonalState = world.m_8055_(diagonalNeighbor);
            if (diagonalState.m_60734_() != this || !((Boolean)diagonalState.m_61143_((Property)neighborAttachmentFace)).booleanValue()) continue;
            world.m_46597_(neighborAirPos, this.m_49966_());
            break;
        }
    }

    public void destroyClickedSegment(BlockState state, Level world, BlockPos pos, Player player, Direction interiorFace, boolean dropItems) {
        int side = interiorFace.ordinal();
        BooleanProperty sideProperty = INTERIOR_FACES[side];
        if (((Boolean)state.m_61143_((Property)sideProperty)).booleanValue()) {
            BlockState newState = (BlockState)state.m_61124_((Property)sideProperty, (Comparable)Boolean.valueOf(false));
            Block newBlock = newState.m_60734_();
            BlockState removedState = (BlockState)newBlock.m_49966_().m_61124_((Property)sideProperty, (Comparable)Boolean.valueOf(true));
            Block removedBlock = removedState.m_60734_();
            if (dropItems) {
                removedBlock.m_6240_(world, player, pos, removedState, null, player.m_21205_().m_41777_());
            }
            if (world.f_46443_) {
                world.m_5898_(player, 2001, pos, Block.m_49956_((BlockState)removedState));
            } else {
                removedBlock.m_5707_(world, pos, removedState, player);
            }
            if (world.m_7731_(pos, newState, 11)) {
                removedBlock.m_6786_((LevelAccessor)world, pos, removedState);
            }
        }
        this.updateShapeCache(world, pos);
    }

    public long getExpandedShapeIndex(BlockState state, BlockGetter world, BlockPos pos) {
        long result = 0L;
        for (int side = 0; side < 6; ++side) {
            BooleanProperty attachmentSide = INTERIOR_FACES[side];
            if (!((Boolean)state.m_61143_((Property)attachmentSide)).booleanValue()) continue;
            result |= 1L << side;
            Direction attachmentDirection = Direction.m_122376_((int)side);
            for (int subSide = 0; subSide < 4; ++subSide) {
                int secondaryOrdinal = DirectionHelper.uncompressSecondSide(side, subSide);
                if (((Boolean)state.m_61143_((Property)INTERIOR_FACES[secondaryOrdinal])).booleanValue()) continue;
                Direction secondaryDir = Direction.m_122376_((int)secondaryOrdinal);
                Direction directionToWire = secondaryDir.m_122424_();
                BlockPos neighborPos = pos.m_121945_(secondaryDir);
                BlockState neighborState = world.m_8055_(neighborPos);
                Block neighborBlock = neighborState.m_60734_();
                if (!this.canAdjacentBlockConnectToFace(world, pos, state, neighborBlock, attachmentDirection, directionToWire, neighborPos, neighborState)) continue;
                result |= 1L << side * 4 + subSide + 6;
            }
        }
        return result |= this.getEdgeFlagsForNodeLineEdgeFormat(world, pos);
    }

    public VoxelShape getCachedExpandedShapeVoxel(BlockState wireState, Level world, BlockPos pos) {
        long index = this.getExpandedShapeIndex(wireState, (BlockGetter)world, pos);
        return (VoxelShape)this.voxelCache.getUnchecked((Object)index);
    }
}

