/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wire_post;

import commoble.morered.util.NestedBoundingBox;
import commoble.morered.wire_post.WirePostBlockEntity;
import commoble.morered.wire_post.WireRayTraceContext;
import commoble.morered.wire_post.WireRayTraceSelectionContext;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SlackInterpolator {
    public static Vec3[] getInterpolatedDifferences(Vec3 vector) {
        int points = 17;
        Vec3[] list = new Vec3[points];
        double dx = vector.m_7096_();
        double dy = vector.m_7098_();
        double dz = vector.m_7094_();
        for (int point = 0; point < points; ++point) {
            double startLerp = SlackInterpolator.getFractionalLerp(point, points - 1);
            double startYLerp = SlackInterpolator.getYLerp(startLerp, dy);
            list[point] = new Vec3(startLerp * dx, startYLerp * dy, startLerp * dz);
        }
        return list;
    }

    public static Vec3[] getInterpolatedPoints(Vec3 lower, Vec3 upper) {
        Vec3 diff = upper.m_82546_(lower);
        Vec3[] diffs = SlackInterpolator.getInterpolatedDifferences(diff);
        Vec3[] points = new Vec3[diffs.length];
        for (int i = 0; i < points.length; ++i) {
            points[i] = lower.m_82549_(diffs[i]);
        }
        return points;
    }

    public static double getFractionalLerp(int current, int max) {
        return (double)current / (double)max;
    }

    public static double getYLerp(double lerp, double dY) {
        return Math.pow(lerp, Math.log(Math.abs(dY) + 3.0));
    }

    @Nullable
    public static Vec3 doesBlockStateIntersectAnyWireOfPost(BlockGetter world, BlockPos postPos, BlockPos placePos, BlockState placeState, Map<BlockPos, NestedBoundingBox> remoteConnections, Set<BlockPos> checkedPostPositions) {
        for (Map.Entry<BlockPos, NestedBoundingBox> entry : remoteConnections.entrySet()) {
            Vec3 hit;
            BlockPos connectedPos = entry.getKey();
            if (checkedPostPositions.contains(connectedPos) || (hit = SlackInterpolator.doesBlockStateIntersectConnection(postPos, connectedPos, placePos, placeState, entry.getValue(), world)) == null) continue;
            return hit;
        }
        return null;
    }

    @Nullable
    public static Vec3 doesBlockStateIntersectConnection(BlockPos startPos, BlockPos endPos, BlockPos placePos, BlockState placeState, NestedBoundingBox box, BlockGetter world) {
        VoxelShape shape = placeState.m_60812_(world, placePos);
        for (AABB aabb : shape.m_83299_()) {
            if (!box.intersects(aabb.m_82338_(placePos))) continue;
            boolean lastPosIsHigher = startPos.m_123342_() < endPos.m_123342_();
            BlockPos upperPos = lastPosIsHigher ? endPos : startPos;
            BlockPos lowerPos = lastPosIsHigher ? startPos : endPos;
            return SlackInterpolator.getWireRaytraceHit(lowerPos, upperPos, world);
        }
        return null;
    }

    @Nullable
    public static Vec3 getWireRaytraceHit(BlockPos lower, BlockPos upper, BlockGetter world) {
        Vec3 startVec = WirePostBlockEntity.getConnectionVector(lower);
        Vec3 endVec = WirePostBlockEntity.getConnectionVector(upper);
        Vec3[] points = SlackInterpolator.getInterpolatedPoints(startVec, endVec);
        WireRayTraceSelectionContext selector = new WireRayTraceSelectionContext(lower, upper);
        int pointCount = points.length;
        int rayTraceCount = pointCount - 1;
        for (int i = 0; i < rayTraceCount; ++i) {
            WireRayTraceContext context = new WireRayTraceContext(selector, points[i], points[i + 1], ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE);
            BlockHitResult result = SlackInterpolator.rayTraceBlocks(world, context);
            if (result.m_6662_() == HitResult.Type.MISS) continue;
            return result.m_82450_();
        }
        return null;
    }

    public static BlockHitResult rayTraceBlocks(BlockGetter world, WireRayTraceContext context) {
        return SlackInterpolator.doRayTrace(context, (rayTraceContext, pos) -> {
            BlockState state = world.m_8055_(pos);
            Vec3 startVec = rayTraceContext.getFrom();
            Vec3 endVec = rayTraceContext.getTo();
            VoxelShape shape = rayTraceContext.getBlockShape(state, world, (BlockPos)pos);
            BlockHitResult result = world.m_45558_(startVec, endVec, pos, shape, state);
            return result;
        }, rayTraceContext -> {
            Vec3 difference = rayTraceContext.getFrom().m_82546_(rayTraceContext.getTo());
            return BlockHitResult.m_82426_((Vec3)rayTraceContext.getTo(), (Direction)Direction.m_122366_((double)difference.f_82479_, (double)difference.f_82480_, (double)difference.f_82481_), (BlockPos)new BlockPos(rayTraceContext.getTo()));
        });
    }

    static <T> T doRayTrace(WireRayTraceContext context, BiFunction<WireRayTraceContext, BlockPos, T> rayTracer, Function<WireRayTraceContext, T> missFactory) {
        int startZInt;
        int startYInt;
        Vec3 end;
        Vec3 start = context.getFrom();
        if (start.equals((Object)(end = context.getTo()))) {
            return missFactory.apply(context);
        }
        double endX = Mth.m_14139_((double)-1.0E-7, (double)end.f_82479_, (double)start.f_82479_);
        double endY = Mth.m_14139_((double)-1.0E-7, (double)end.f_82480_, (double)start.f_82480_);
        double endZ = Mth.m_14139_((double)-1.0E-7, (double)end.f_82481_, (double)start.f_82481_);
        double startX = Mth.m_14139_((double)-1.0E-7, (double)start.f_82479_, (double)end.f_82479_);
        double startY = Mth.m_14139_((double)-1.0E-7, (double)start.f_82480_, (double)end.f_82480_);
        double startZ = Mth.m_14139_((double)-1.0E-7, (double)start.f_82481_, (double)end.f_82481_);
        int startXInt = Mth.m_14107_((double)startX);
        BlockPos.MutableBlockPos mutaPos = new BlockPos.MutableBlockPos(startXInt, startYInt = Mth.m_14107_((double)startY), startZInt = Mth.m_14107_((double)startZ));
        T result = rayTracer.apply(context, (BlockPos)mutaPos);
        if (result != null) {
            return result;
        }
        double dx = endX - startX;
        double dy = endY - startY;
        double dz = endZ - startZ;
        int xSign = Mth.m_14205_((double)dx);
        int ySign = Mth.m_14205_((double)dy);
        int zSign = Mth.m_14205_((double)dz);
        double reciprocalX = xSign == 0 ? Double.MAX_VALUE : (double)xSign / dx;
        double reciprocalY = ySign == 0 ? Double.MAX_VALUE : (double)ySign / dy;
        double reciprocalZ = zSign == 0 ? Double.MAX_VALUE : (double)zSign / dz;
        double calcX = reciprocalX * (xSign > 0 ? 1.0 - Mth.m_14185_((double)startX) : Mth.m_14185_((double)startX));
        double calcY = reciprocalY * (ySign > 0 ? 1.0 - Mth.m_14185_((double)startY) : Mth.m_14185_((double)startY));
        double calcZ = reciprocalZ * (zSign > 0 ? 1.0 - Mth.m_14185_((double)startZ) : Mth.m_14185_((double)startZ));
        while (calcX <= 1.0 || calcY <= 1.0 || calcZ <= 1.0) {
            T fallbackResult;
            if (calcX < calcY) {
                if (calcX < calcZ) {
                    startXInt += xSign;
                    calcX += reciprocalX;
                } else {
                    startZInt += zSign;
                    calcZ += reciprocalZ;
                }
            } else if (calcY < calcZ) {
                startYInt += ySign;
                calcY += reciprocalY;
            } else {
                startZInt += zSign;
                calcZ += reciprocalZ;
            }
            if ((fallbackResult = rayTracer.apply(context, (BlockPos)mutaPos.m_122178_(startXInt, startYInt, startZInt))) == null) continue;
            return fallbackResult;
        }
        return missFactory.apply(context);
    }
}

