/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.client.jei;

import com.google.common.collect.ImmutableList;
import commoble.morered.MoreRed;
import commoble.morered.client.jei.GatecraftingCategory;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class JEIProxy
implements IModPlugin {
    public static final ResourceLocation ID = new ResourceLocation("morered", "morered");
    @Nullable
    private GatecraftingCategory gatecraftingCategory;

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.gatecraftingCategory = new GatecraftingCategory(registration.getJeiHelpers().getGuiHelper());
        registration.addRecipeCategories(new IRecipeCategory[]{this.gatecraftingCategory});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (this.gatecraftingCategory == null) {
            throw new NullPointerException("More Red's Gatecrafting JEI category failed to register! Notify the More Red author for assistance https://github.com/Commoble/morered/issues");
        }
        registration.addRecipes(GatecraftingCategory.TYPE, JEIProxy.getGatecraftingRecipes());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MoreRed.instance().gatecraftingPlinthBlock.get()), new RecipeType[]{GatecraftingCategory.TYPE});
    }

    public static List<Recipe<CraftingContainer>> getGatecraftingRecipes() {
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        if (clientLevel != null) {
            RecipeManager manager = clientLevel.m_7465_();
            return MoreRed.getAllGatecraftingRecipes(manager);
        }
        return ImmutableList.of();
    }
}

