/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import commoble.morered.HexidecrubrometerBlock;
import commoble.morered.ObjectNames;
import commoble.morered.PacketTypeFactory;
import commoble.morered.ServerConfig;
import commoble.morered.TagStackIngredient;
import commoble.morered.api.ChanneledPowerSupplier;
import commoble.morered.api.ExpandedPowerSupplier;
import commoble.morered.api.MoreRedAPI;
import commoble.morered.api.WireConnector;
import commoble.morered.api.internal.APIRegistries;
import commoble.morered.api.internal.DefaultWireProperties;
import commoble.morered.bitwise_logic.BitwiseLogicPlateBlock;
import commoble.morered.bitwise_logic.ChanneledPowerStorageBlockEntity;
import commoble.morered.bitwise_logic.SingleInputBitwiseLogicPlateBlock;
import commoble.morered.bitwise_logic.TwoInputBitwiseLogicPlateBlock;
import commoble.morered.client.ClientEvents;
import commoble.morered.gatecrafting_plinth.GatecraftingMenu;
import commoble.morered.gatecrafting_plinth.GatecraftingPlinthBlock;
import commoble.morered.gatecrafting_plinth.GatecraftingRecipeButtonPacket;
import commoble.morered.gatecrafting_plinth.GatecraftingRecipeSerializer;
import commoble.morered.plate_blocks.LatchBlock;
import commoble.morered.plate_blocks.LogicFunction;
import commoble.morered.plate_blocks.LogicFunctionPlateBlock;
import commoble.morered.plate_blocks.LogicFunctions;
import commoble.morered.plate_blocks.PlateBlock;
import commoble.morered.plate_blocks.PlateBlockStateProperties;
import commoble.morered.wire_post.BundledCablePostBlock;
import commoble.morered.wire_post.BundledCablePostBlockEntity;
import commoble.morered.wire_post.BundledCableRelayPlateBlock;
import commoble.morered.wire_post.BundledCableRelayPlateBlockEntity;
import commoble.morered.wire_post.FakeStateLevel;
import commoble.morered.wire_post.PostsInChunk;
import commoble.morered.wire_post.SlackInterpolator;
import commoble.morered.wire_post.SyncPostsInChunkPacket;
import commoble.morered.wire_post.WireBreakPacket;
import commoble.morered.wire_post.WirePostBlock;
import commoble.morered.wire_post.WirePostBlockEntity;
import commoble.morered.wire_post.WirePostPlateBlock;
import commoble.morered.wire_post.WireSpoolItem;
import commoble.morered.wires.AbstractWireBlock;
import commoble.morered.wires.BundledCableBlock;
import commoble.morered.wires.BundledCableBlockEntity;
import commoble.morered.wires.ColoredCableBlock;
import commoble.morered.wires.ColoredCableBlockEntity;
import commoble.morered.wires.RedAlloyWireBlock;
import commoble.morered.wires.WireBlockEntity;
import commoble.morered.wires.WireBlockItem;
import commoble.morered.wires.WireCountLootFunction;
import commoble.morered.wires.WireUpdateBuffer;
import commoble.morered.wires.WireUpdatePacket;
import commoble.useitemonblockevent.api.UseItemOnBlockEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="morered")
public class MoreRed {
    public static final String MODID = "morered";
    public static final Logger LOGGER = LogManager.getLogger();
    private static MoreRed instance;
    public static final String CHANNEL_PROTOCOL_VERSION = "2";
    public static final SimpleChannel CHANNEL;
    public final Map<ResourceLocation, RegistryObject<? extends LogicFunctionPlateBlock>> logicPlates = new HashMap<ResourceLocation, RegistryObject<? extends LogicFunctionPlateBlock>>();
    public final Map<ResourceLocation, RegistryObject<? extends BitwiseLogicPlateBlock>> bitwiseLogicPlates = new HashMap<ResourceLocation, RegistryObject<? extends BitwiseLogicPlateBlock>>();
    public final RegistryObject<GatecraftingPlinthBlock> gatecraftingPlinthBlock;
    public final RegistryObject<PlateBlock> stonePlateBlock;
    public final RegistryObject<LatchBlock> latchBlock;
    public final RegistryObject<WirePostBlock> redwirePostBlock;
    public final RegistryObject<WirePostPlateBlock> redwirePostPlateBlock;
    public final RegistryObject<WirePostPlateBlock> redwirePostRelayPlateBlock;
    public final RegistryObject<HexidecrubrometerBlock> hexidecrubrometerBlock;
    public final RegistryObject<RedAlloyWireBlock> redAlloyWireBlock;
    public final RegistryObject<ColoredCableBlock>[] networkCableBlocks;
    public final RegistryObject<BundledCableBlock> bundledNetworkCableBlock;
    public final RegistryObject<BundledCablePostBlock> bundledCablePostBlock;
    public final RegistryObject<BundledCableRelayPlateBlock> bundledCableRelayPlateBlock;
    public final RegistryObject<WireSpoolItem> redwireSpoolItem;
    public final RegistryObject<Item> bundledCableSpoolItem;
    public final RegistryObject<Item> redAlloyIngotItem;
    public final RegistryObject<BlockEntityType<WirePostBlockEntity>> redwirePostBeType;
    public final RegistryObject<BlockEntityType<WireBlockEntity>> wireBeType;
    public final RegistryObject<BlockEntityType<ColoredCableBlockEntity>> coloredNetworkCableBeType;
    public final RegistryObject<BlockEntityType<BundledCableBlockEntity>> bundledNetworkCableBeType;
    public final RegistryObject<BlockEntityType<BundledCablePostBlockEntity>> bundledCablePostBeType;
    public final RegistryObject<BlockEntityType<BundledCableRelayPlateBlockEntity>> bundledCableRelayPlateBeType;
    public final RegistryObject<BlockEntityType<ChanneledPowerStorageBlockEntity>> bitwiseLogicGateBeType;
    public final RegistryObject<MenuType<GatecraftingMenu>> gatecraftingMenuType;
    public final RegistryObject<GatecraftingRecipeSerializer> gatecraftingSerializer;
    public final RegistryObject<RecipeType<Recipe<CraftingContainer>>> gatecraftingRecipeType;
    public final RegistryObject<LootItemFunctionType> wireCountLootFunction;
    public final CreativeModeTab creativeTab = new CreativeModeTab("morered"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)Registry.f_122827_.m_7745_(new ResourceLocation(MoreRed.MODID, "nor_gate")));
        }
    };

    public static MoreRed instance() {
        return instance;
    }

    public static ResourceLocation getModRL(String name) {
        return new ResourceLocation(MODID, name);
    }

    public MoreRed() {
        instance = this;
        ModLoadingContext modContext = ModLoadingContext.get();
        FMLJavaModLoadingContext fmlContext = FMLJavaModLoadingContext.get();
        IEventBus modBus = fmlContext.getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        DeferredRegister blocks = MoreRed.createDeferredRegister(modBus, Registry.f_122901_);
        DeferredRegister items = MoreRed.createDeferredRegister(modBus, Registry.f_122904_);
        DeferredRegister blockEntityTypes = MoreRed.createDeferredRegister(modBus, Registry.f_122907_);
        DeferredRegister menuTypes = MoreRed.createDeferredRegister(modBus, Registry.f_122913_);
        DeferredRegister recipeSerializers = MoreRed.createDeferredRegister(modBus, Registry.f_122915_);
        DeferredRegister recipeTypes = MoreRed.createDeferredRegister(modBus, Registry.f_122914_);
        DeferredRegister lootFunctions = MoreRed.createDeferredRegister(modBus, Registry.f_122816_);
        this.gatecraftingPlinthBlock = MoreRed.registerBlockItem(blocks, items, "gatecrafting_plinth", () -> new GatecraftingPlinthBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(3.5f).m_60955_()));
        this.stonePlateBlock = MoreRed.registerBlockItem(blocks, items, "stone_plate", () -> new PlateBlock(BlockBehaviour.Properties.m_60939_((Material)PlateBlockStateProperties.PLATE_MATERIAL).m_60999_().m_60978_(1.5f).m_60918_(SoundType.f_56736_)));
        this.latchBlock = MoreRed.registerBlockItem(blocks, items, "latch", () -> new LatchBlock(BlockBehaviour.Properties.m_60939_((Material)PlateBlockStateProperties.PLATE_MATERIAL).m_60978_(0.0f).m_60918_(SoundType.f_56736_)));
        this.redwirePostBlock = MoreRed.registerBlockItem(blocks, items, "redwire_post", () -> new WirePostBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76364_).m_60913_(2.0f, 5.0f), WirePostBlock::getRedstoneConnectionDirections));
        this.redwirePostPlateBlock = MoreRed.registerBlockItem(blocks, items, "redwire_post_plate", () -> new WirePostPlateBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76364_).m_60913_(2.0f, 5.0f), WirePostPlateBlock::getRedstoneConnectionDirectionsForEmptyPlate));
        this.redwirePostRelayPlateBlock = MoreRed.registerBlockItem(blocks, items, "redwire_post_relay_plate", () -> new WirePostPlateBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76364_).m_60913_(2.0f, 5.0f), WirePostPlateBlock::getRedstoneConnectionDirectionsForRelayPlate));
        this.hexidecrubrometerBlock = MoreRed.registerBlockItem(blocks, items, "hexidecrubrometer", () -> new HexidecrubrometerBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76364_).m_60913_(2.0f, 5.0f)));
        this.bundledCablePostBlock = MoreRed.registerBlockItem(blocks, items, "bundled_cable_post", () -> new BundledCablePostBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76361_).m_60913_(2.0f, 5.0f)));
        this.bundledCableRelayPlateBlock = MoreRed.registerBlockItem(blocks, items, "bundled_cable_relay_plate", () -> new BundledCableRelayPlateBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76361_).m_60913_(2.0f, 5.0f)));
        this.redAlloyWireBlock = MoreRed.registerBlockItem(blocks, items, "red_alloy_wire", () -> new RedAlloyWireBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76310_, (MaterialColor)MaterialColor.f_76364_).m_60910_().m_60966_()), block -> new WireBlockItem((Block)block, new Item.Properties().m_41491_(this.creativeTab)));
        this.networkCableBlocks = (RegistryObject[])Util.m_137469_((Object)new RegistryObject[16], array -> Arrays.setAll(array, i -> MoreRed.registerBlockItem((DeferredRegister<Block>)blocks, (DeferredRegister<Item>)items, ObjectNames.NETWORK_CABLES[i], () -> new ColoredCableBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76310_, (MaterialColor)DyeColor.values()[i].m_41069_()).m_60910_().m_60966_(), DyeColor.values()[i]), block -> new WireBlockItem((Block)block, new Item.Properties().m_41491_(this.creativeTab)))));
        this.bundledNetworkCableBlock = MoreRed.registerBlockItem(blocks, items, "bundled_network_cable", () -> new BundledCableBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76310_, (MaterialColor)MaterialColor.f_76361_).m_60910_().m_60966_()), block -> new WireBlockItem((Block)block, new Item.Properties().m_41491_(this.creativeTab)));
        this.registerLogicGateType(blocks, items, "diode", LogicFunctions.INPUT_B, LogicFunctionPlateBlock.LINEAR_INPUT);
        this.registerLogicGateType(blocks, items, "not_gate", LogicFunctions.NOT_B, LogicFunctionPlateBlock.LINEAR_INPUT);
        this.registerLogicGateType(blocks, items, "nor_gate", LogicFunctions.NOR, LogicFunctionPlateBlock.THREE_INPUTS);
        this.registerLogicGateType(blocks, items, "nand_gate", LogicFunctions.NAND, LogicFunctionPlateBlock.THREE_INPUTS);
        this.registerLogicGateType(blocks, items, "or_gate", LogicFunctions.OR, LogicFunctionPlateBlock.THREE_INPUTS);
        this.registerLogicGateType(blocks, items, "and_gate", LogicFunctions.AND, LogicFunctionPlateBlock.THREE_INPUTS);
        this.registerLogicGateType(blocks, items, "xor_gate", LogicFunctions.XOR_AC, LogicFunctionPlateBlock.T_INPUTS);
        this.registerLogicGateType(blocks, items, "xnor_gate", LogicFunctions.XNOR_AC, LogicFunctionPlateBlock.T_INPUTS);
        this.registerLogicGateType(blocks, items, "multiplexer", LogicFunctions.MULTIPLEX, LogicFunctionPlateBlock.THREE_INPUTS);
        this.registerLogicGateType(blocks, items, "and_2_gate", LogicFunctions.AND_2, LogicFunctionPlateBlock.T_INPUTS);
        this.registerLogicGateType(blocks, items, "nand_2_gate", LogicFunctions.NAND_2, LogicFunctionPlateBlock.T_INPUTS);
        BiFunction<BlockBehaviour.Properties, LogicFunction, SingleInputBitwiseLogicPlateBlock> singleInput = SingleInputBitwiseLogicPlateBlock::new;
        BiFunction<BlockBehaviour.Properties, LogicFunction, TwoInputBitwiseLogicPlateBlock> twoInputs = TwoInputBitwiseLogicPlateBlock::new;
        this.registerBitwiseLogicGateType(blocks, items, "bitwise_diode", LogicFunctions.INPUT_B, singleInput);
        this.registerBitwiseLogicGateType(blocks, items, "bitwise_not_gate", LogicFunctions.NOT_B, singleInput);
        this.registerBitwiseLogicGateType(blocks, items, "bitwise_or_gate", LogicFunctions.OR, twoInputs);
        this.registerBitwiseLogicGateType(blocks, items, "bitwise_and_gate", LogicFunctions.AND_2, twoInputs);
        this.registerBitwiseLogicGateType(blocks, items, "bitwise_xor_gate", LogicFunctions.XOR_AC, twoInputs);
        this.registerBitwiseLogicGateType(blocks, items, "bitwise_xnor_gate", LogicFunctions.XNOR_AC, twoInputs);
        this.redwireSpoolItem = items.register("redwire_spool", () -> new WireSpoolItem(new Item.Properties().m_41491_(this.creativeTab).m_41503_(64), Tags.Blocks.REDWIRE_POSTS));
        this.bundledCableSpoolItem = items.register("bundled_cable_spool", () -> new WireSpoolItem(new Item.Properties().m_41491_(this.creativeTab).m_41503_(64), Tags.Blocks.BUNDLED_CABLE_POSTS));
        this.redAlloyIngotItem = items.register("red_alloy_ingot", () -> new Item(new Item.Properties().m_41491_(this.creativeTab)));
        this.redwirePostBeType = blockEntityTypes.register("redwire_post", () -> BlockEntityType.Builder.m_155273_(WirePostBlockEntity::new, (Block[])new Block[]{(Block)this.redwirePostBlock.get(), (Block)this.redwirePostPlateBlock.get(), (Block)this.redwirePostRelayPlateBlock.get()}).m_58966_(null));
        this.wireBeType = blockEntityTypes.register("wire", () -> BlockEntityType.Builder.m_155273_(WireBlockEntity::new, (Block[])new Block[]{(Block)this.redAlloyWireBlock.get()}).m_58966_(null));
        this.coloredNetworkCableBeType = blockEntityTypes.register("colored_network_cable", () -> BlockEntityType.Builder.m_155273_(ColoredCableBlockEntity::new, (Block[])((Block[])Arrays.stream(this.networkCableBlocks).map(RegistryObject::get).toArray(ColoredCableBlock[]::new))).m_58966_(null));
        this.bundledNetworkCableBeType = blockEntityTypes.register("bundled_network_cable", () -> BlockEntityType.Builder.m_155273_(BundledCableBlockEntity::new, (Block[])new Block[]{(Block)this.bundledNetworkCableBlock.get()}).m_58966_(null));
        this.bundledCablePostBeType = blockEntityTypes.register("bundled_cable_post", () -> BlockEntityType.Builder.m_155273_(BundledCablePostBlockEntity::new, (Block[])new Block[]{(Block)this.bundledCablePostBlock.get()}).m_58966_(null));
        this.bundledCableRelayPlateBeType = blockEntityTypes.register("bundled_cable_relay_plate", () -> BlockEntityType.Builder.m_155273_(BundledCableRelayPlateBlockEntity::new, (Block[])new Block[]{(Block)this.bundledCableRelayPlateBlock.get()}).m_58966_(null));
        this.bitwiseLogicGateBeType = blockEntityTypes.register("bitwise_logic_plate", () -> BlockEntityType.Builder.m_155273_(ChanneledPowerStorageBlockEntity::new, (Block[])((Block[])Util.m_137537_(() -> (Block[])this.bitwiseLogicPlates.values().stream().map(rob -> (BitwiseLogicPlateBlock)((Object)((Object)((Object)((Object)rob.get()))))).toArray(Block[]::new)))).m_58966_(null));
        this.gatecraftingMenuType = menuTypes.register("gatecrafting_plinth", () -> new MenuType(GatecraftingMenu::getClientContainer));
        this.gatecraftingSerializer = recipeSerializers.register("gatecrafting", () -> new GatecraftingRecipeSerializer());
        this.gatecraftingRecipeType = recipeTypes.register("gatecrafting", () -> RecipeType.simple((ResourceLocation)new ResourceLocation(MODID, "gatecrafting")));
        this.wireCountLootFunction = lootFunctions.register("set_wire_count", () -> new LootItemFunctionType((Serializer)WireCountLootFunction.INSTANCE));
        ServerConfig.initServerConfig(modContext, fmlContext);
        modBus.addListener(EventPriority.HIGH, this::onHighPriorityCommonSetup);
        modBus.addListener(this::onCommonSetup);
        modBus.addListener(this::onLoadComplete);
        modBus.addListener(this::onRegisterCapabilities);
        forgeBus.addGenericListener(LevelChunk.class, this::onAttachChunkCapabilities);
        forgeBus.addListener(EventPriority.LOW, this::onUseItemOnBlock);
        forgeBus.addListener(EventPriority.LOW, this::onLeftClickBlock);
        forgeBus.addListener(this::onLevelTick);
        forgeBus.addListener(this::onUseItemOnBlock);
        forgeBus.addListener(this::onChunkWatch);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientEvents.addClientListeners(modContext, fmlContext, modBus, forgeBus);
        }
    }

    public void addModListeners(IEventBus modBus) {
    }

    public static void subscribedDeferredRegisters(IEventBus modBus, DeferredRegister<?> ... registers) {
        for (DeferredRegister<?> register : registers) {
            register.register(modBus);
        }
    }

    private void onHighPriorityCommonSetup(FMLCommonSetupEvent event) {
        Map<Block, WireConnector> wireConnectors = MoreRedAPI.getWireConnectabilityRegistry();
        Map<Block, ExpandedPowerSupplier> expandedPowerSuppliers = MoreRedAPI.getExpandedPowerRegistry();
        Map<Block, WireConnector> cableConnectors = MoreRedAPI.getCableConnectabilityRegistry();
        wireConnectors.put(Blocks.f_50088_, DefaultWireProperties::isRedstoneWireConnectable);
        RedAlloyWireBlock redWireBlock = (RedAlloyWireBlock)((Object)this.redAlloyWireBlock.get());
        wireConnectors.put(redWireBlock, AbstractWireBlock::canWireConnectToAdjacentWireOrCable);
        expandedPowerSuppliers.put(redWireBlock, redWireBlock::getExpandedPower);
        for (int i = 0; i < 16; ++i) {
            ColoredCableBlock coloredCableBlock = (ColoredCableBlock)((Object)this.networkCableBlocks[i].get());
            wireConnectors.put(coloredCableBlock, coloredCableBlock::canConnectToAdjacentWireOrCable);
            expandedPowerSuppliers.put(coloredCableBlock, coloredCableBlock::getExpandedPower);
            cableConnectors.put(coloredCableBlock, coloredCableBlock::canConnectToAdjacentWireOrCable);
        }
        BundledCableBlock bundledCableBlock = (BundledCableBlock)((Object)this.bundledNetworkCableBlock.get());
        cableConnectors.put(bundledCableBlock, AbstractWireBlock::canWireConnectToAdjacentWireOrCable);
        BundledCableRelayPlateBlock cablePlateBlock = (BundledCableRelayPlateBlock)((Object)this.bundledCableRelayPlateBlock.get());
        cableConnectors.put(cablePlateBlock, cablePlateBlock::canConnectToAdjacentCable);
        this.bitwiseLogicPlates.values().stream().map(rob -> (BitwiseLogicPlateBlock)((Object)((Object)rob.get()))).forEach(block -> cableConnectors.put((Block)block, (world, thisPos, thisState, wirePos, wireState, wireFace, directionToWire) -> block.canConnectToAdjacentCable(world, thisPos, thisState, wirePos, wireState, wireFace, directionToWire)));
    }

    private void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(PostsInChunk.class);
        event.register(ChanneledPowerSupplier.class);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        int packetID = 0;
        CHANNEL.registerMessage(packetID++, GatecraftingRecipeButtonPacket.class, GatecraftingRecipeButtonPacket::write, GatecraftingRecipeButtonPacket::read, GatecraftingRecipeButtonPacket::handle);
        CHANNEL.registerMessage(packetID++, WireBreakPacket.class, WireBreakPacket::write, WireBreakPacket::read, WireBreakPacket::handle);
        CHANNEL.registerMessage(packetID++, SyncPostsInChunkPacket.class, SyncPostsInChunkPacket::write, SyncPostsInChunkPacket::read, SyncPostsInChunkPacket::handle);
        PacketTypeFactory.register(packetID++, CHANNEL, WireUpdatePacket.CODEC, new WireUpdatePacket((Set<BlockPos>)ImmutableSet.of()));
        event.enqueueWork(this::afterCommonSetup);
    }

    private void afterCommonSetup() {
        CraftingHelper.register((ResourceLocation)new ResourceLocation("morered:tag_stack"), TagStackIngredient.SERIALIZER);
    }

    private void onLoadComplete(FMLLoadCompleteEvent event) {
        APIRegistries.freezeRegistries();
    }

    private void onAttachChunkCapabilities(AttachCapabilitiesEvent<LevelChunk> event) {
        PostsInChunk cap = new PostsInChunk((LevelChunk)event.getObject());
        event.addCapability(MoreRed.getModRL("posts_in_chunk"), (ICapabilityProvider)cap);
        event.addListener(cap::onCapabilityInvalidated);
    }

    private void onUseItemOnBlock(UseItemOnBlockEvent event) {
        Item item;
        UseOnContext useContext = event.getUseOnContext();
        ItemStack stack = useContext.m_43722_();
        if (event.getUsePhase() == UseItemOnBlockEvent.UsePhase.POST_BLOCK && (item = stack.m_41720_()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Level level = useContext.m_43725_();
            BlockPlaceContext placeContext = new BlockPlaceContext(useContext);
            BlockPos placePos = placeContext.m_8083_();
            BlockState placementState = blockItem.m_5965_(placeContext);
            if (placementState == null) {
                return;
            }
            Set<ChunkPos> chunkPositions = PostsInChunk.getRelevantChunkPositionsNearPos(placePos);
            for (ChunkPos chunkPos : chunkPositions) {
                if (!level.m_46805_(chunkPos.m_45615_())) continue;
                LevelChunk chunk = level.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
                chunk.getCapability(PostsInChunk.CAPABILITY).ifPresent(posts -> {
                    Player player;
                    HashSet<BlockPos> checkedPostPositions = new HashSet<BlockPos>();
                    Iterator<BlockPos> iterator = posts.getPositions().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            return;
                        }
                        BlockPos postPos = iterator.next();
                        BlockEntity be = level.m_7702_(postPos);
                        if (!(be instanceof WirePostBlockEntity)) continue;
                        WirePostBlockEntity wire = (WirePostBlockEntity)be;
                        Vec3 hit = SlackInterpolator.doesBlockStateIntersectAnyWireOfPost(new FakeStateLevel((BlockGetter)level, placePos, placementState), postPos, placePos, placementState, wire.getRemoteConnectionBoxes(), checkedPostPositions);
                        if (hit != null) {
                            player = placeContext.m_43723_();
                            if (player instanceof ServerPlayer) {
                                ServerPlayer serverPlayer = (ServerPlayer)player;
                                if (level instanceof ServerLevel) {
                                    ServerLevel serverLevel = (ServerLevel)level;
                                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEquipmentPacket(serverPlayer.m_19879_(), (List)ImmutableList.of((Object)Pair.of((Object)EquipmentSlot.MAINHAND, (Object)serverPlayer.m_21120_(InteractionHand.MAIN_HAND)))));
                                    serverLevel.m_8624_(serverPlayer, (ParticleOptions)DustParticleOptions.f_123656_, false, hit.f_82479_, hit.f_82480_, hit.f_82481_, 5, 0.05, 0.05, 0.05, 0.0);
                                    break;
                                }
                            }
                            if (!level.f_46443_) break;
                            level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, hit.f_82479_, hit.f_82480_, hit.f_82481_, 0.05, 0.05, 0.05);
                            break;
                        }
                        checkedPostPositions.add(postPos.m_7949_());
                    }
                    if (player != null) {
                        player.m_6330_(SoundEvents.f_12587_, SoundSource.BLOCKS, 0.5f, 2.0f);
                    }
                    event.cancelWithResult(InteractionResult.SUCCESS);
                });
            }
        }
    }

    private void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        int exp;
        double reachDistance;
        double dz;
        double dy;
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        BlockPos pos = event.getPos();
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (!(block instanceof AbstractWireBlock)) {
            return;
        }
        AbstractWireBlock wireBlock = (AbstractWireBlock)block;
        boolean blockActionRestricted = player.m_36187_(level, pos, serverPlayer.f_8941_.m_9290_());
        boolean isCreative = player.m_7500_();
        if (!isCreative && (event.getUseItem() == Event.Result.DENY || blockActionRestricted)) {
            return;
        }
        if (pos.m_123342_() > serverLevel.m_151558_() || pos.m_123342_() < serverLevel.m_141937_()) {
            return;
        }
        if (!level.m_7966_(player, pos)) {
            return;
        }
        double dx = player.m_20185_() - ((double)pos.m_123341_() + 0.5);
        double distSquared = dx * dx + (dy = player.m_20186_() - ((double)pos.m_123342_() + 0.5) + 1.5) * dy + (dz = player.m_20189_() - ((double)pos.m_123343_() + 0.5)) * dz;
        if (distSquared > (reachDistance = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_() + 1.0) * reachDistance) {
            return;
        }
        event.setCanceled(true);
        Direction hitNormal = event.getFace();
        Direction destroySide = hitNormal.m_122424_();
        if (!isCreative && event.getUseBlock() != Event.Result.DENY) {
            state.m_60686_(level, pos, player);
        }
        if ((exp = ForgeHooks.onBlockBreakEvent((Level)level, (GameType)serverPlayer.f_8941_.m_9290_(), (ServerPlayer)serverPlayer, (BlockPos)pos)) == -1) {
            return;
        }
        if (player.m_21205_().onBlockStartBreak(pos, player)) {
            return;
        }
        if (blockActionRestricted) {
            return;
        }
        boolean dropItems = !isCreative;
        wireBlock.destroyClickedSegment(state, (Level)serverLevel, pos, (Player)serverPlayer, destroySide, dropItems);
    }

    private void onLevelTick(TickEvent.LevelTickEvent event) {
        Level level = event.level;
        if (event.phase == TickEvent.Phase.END && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            WireUpdateBuffer.get(serverLevel).sendPackets(serverLevel);
        }
    }

    private void onChunkWatch(ChunkWatchEvent.Watch event) {
        ServerPlayer player = event.getPlayer();
        LevelChunk chunk = event.getChunk();
        ChunkPos pos = chunk.m_7697_();
        chunk.getCapability(PostsInChunk.CAPABILITY).ifPresent(cap -> CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncPostsInChunkPacket(pos, cap.getPositions())));
    }

    private static <T> DeferredRegister<T> createDeferredRegister(IEventBus modBus, ResourceKey<Registry<T>> registryKey) {
        DeferredRegister reg = DeferredRegister.create(registryKey, (String)MODID);
        reg.register(modBus);
        return reg;
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> RegistryObject<BLOCK> registerBlockItem(DeferredRegister<Block> blocks, DeferredRegister<Item> items, String name, Supplier<? extends BLOCK> blockFactory, Function<? super BLOCK, ? extends ITEM> itemFactory) {
        RegistryObject block = blocks.register(name, blockFactory);
        items.register(name, () -> (BlockItem)itemFactory.apply((Object)block.get()));
        return block;
    }

    private static <BLOCK extends Block> RegistryObject<BLOCK> registerBlockItem(DeferredRegister<Block> blocks, DeferredRegister<Item> items, String name, Supplier<? extends BLOCK> blockFactory) {
        return MoreRed.registerBlockItem(blocks, items, name, blockFactory, block -> new BlockItem(block, new Item.Properties().m_41491_(MoreRed.instance().creativeTab)));
    }

    public static List<Recipe<CraftingContainer>> getAllGatecraftingRecipes(RecipeManager manager) {
        Map map = manager.f_44007_.getOrDefault(MoreRed.instance().gatecraftingRecipeType.get(), Collections.emptyMap());
        return map.entrySet().stream().map(Map.Entry::getValue).sorted(Comparator.comparing(recipe -> recipe.m_8043_().m_41778_())).collect(Collectors.toList());
    }

    public static Optional<Recipe<CraftingContainer>> getGatecraftingRecipe(RecipeManager manager, ResourceLocation id) {
        Map map = manager.f_44007_.getOrDefault(MoreRed.instance().gatecraftingRecipeType.get(), Collections.emptyMap());
        return Optional.ofNullable((Recipe)map.get(id));
    }

    public RegistryObject<LogicFunctionPlateBlock> registerLogicGateType(DeferredRegister<Block> blocks, DeferredRegister<Item> items, String name, LogicFunction function, LogicFunctionPlateBlock.LogicFunctionPlateBlockFactory factory) {
        Supplier<LogicFunctionPlateBlock> blockFactory = () -> factory.makeBlock(function, BlockBehaviour.Properties.m_60939_((Material)PlateBlockStateProperties.PLATE_MATERIAL).m_60978_(0.0f).m_60918_(SoundType.f_56736_));
        RegistryObject<LogicFunctionPlateBlock> blockGetter = MoreRed.registerBlockItem(blocks, items, name, blockFactory);
        this.logicPlates.put(blockGetter.getId(), blockGetter);
        return blockGetter;
    }

    public <B extends BitwiseLogicPlateBlock> RegistryObject<B> registerBitwiseLogicGateType(DeferredRegister<Block> blocks, DeferredRegister<Item> items, String name, LogicFunction function, BiFunction<BlockBehaviour.Properties, LogicFunction, B> blockFactory) {
        Supplier<BitwiseLogicPlateBlock> actualBlockFactory = () -> (BitwiseLogicPlateBlock)((Object)((Object)blockFactory.apply(BlockBehaviour.Properties.m_60944_((Material)PlateBlockStateProperties.PLATE_MATERIAL, (MaterialColor)MaterialColor.f_76412_).m_60978_(0.0f).m_60918_(SoundType.f_56736_), function)));
        RegistryObject<BitwiseLogicPlateBlock> rob = MoreRed.registerBlockItem(blocks, items, name, actualBlockFactory);
        this.bitwiseLogicPlates.put(rob.getId(), rob);
        return rob;
    }

    static {
        CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(MODID, "main"), () -> CHANNEL_PROTOCOL_VERSION, CHANNEL_PROTOCOL_VERSION::equals, CHANNEL_PROTOCOL_VERSION::equals);
    }

    public static class Tags {

        public static class Items {
            public static final TagKey<Item> RED_ALLOY_WIRES = Items.tag("red_alloy_wires");
            public static final TagKey<Item> COLORED_NETWORK_CABLES = Items.tag("colored_network_cables");

            private static TagKey<Item> tag(String name) {
                return TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(MoreRed.MODID, name));
            }
        }

        public static class Blocks {
            public static final TagKey<Block> REDWIRE_POSTS = Blocks.tag("redwire_posts");
            public static final TagKey<Block> BUNDLED_CABLE_POSTS = Blocks.tag("bundled_cable_posts");

            private static TagKey<Block> tag(String name) {
                return TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(MoreRed.MODID, name));
            }
        }
    }
}

