/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.network.messages;

import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookEntry;
import com.klikli_dev.modonomicon.data.BookDataManager;
import com.klikli_dev.modonomicon.network.Message;
import com.klikli_dev.modonomicon.registry.CapabilityRegistry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class ClickReadAllButtonMessage
implements Message {
    public ResourceLocation bookId;
    public boolean readAll;

    public ClickReadAllButtonMessage(ResourceLocation bookId, boolean readAll) {
        this.bookId = bookId;
        this.readAll = readAll;
    }

    public ClickReadAllButtonMessage(FriendlyByteBuf buf) {
        this.decode(buf);
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.bookId);
        buf.writeBoolean(this.readAll);
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        this.bookId = buf.m_130281_();
        this.readAll = buf.readBoolean();
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player, NetworkEvent.Context context) {
        player.getCapability(CapabilityRegistry.BOOK_UNLOCK).ifPresent(capability -> {
            Book book = BookDataManager.get().getBook(this.bookId);
            if (book != null) {
                boolean anyRead = false;
                for (BookEntry entry : book.getEntries().values()) {
                    if (!this.readAll && !capability.isUnlocked(entry) || !capability.read(player, entry)) continue;
                    anyRead = true;
                }
                if (anyRead) {
                    capability.update(player);
                    capability.sync(player);
                }
            }
        });
    }
}

