/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.screen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.core.ModernFixMixinPlugin;
import org.embeddedt.modernfix.core.config.Option;
import org.embeddedt.modernfix.core.config.OptionCategories;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.screen.ModernFixConfigScreen;
import org.embeddedt.modernfix.screen.ModernFixOptionInfoScreen;

public class OptionList
extends ContainerObjectSelectionList<Entry> {
    private int maxNameWidth = 0;
    private static final int DEPTH_OFFSET = 20;
    private static final Component OPTION_ON = Component.m_237115_((String)"modernfix.option.on").m_130938_(style -> style.m_131140_(ChatFormatting.GREEN));
    private static final Component OPTION_OFF = Component.m_237115_((String)"modernfix.option.off").m_130938_(style -> style.m_131140_(ChatFormatting.RED));
    private static final Set<String> OPTIONS_MISSING_HELP = new HashSet<String>();
    private ModernFixConfigScreen mainScreen;
    private final Set<Option> addedOptions = new HashSet<Option>();

    private static MutableComponent getOptionComponent(Option option) {
        String friendlyKey = "modernfix.option.name." + option.getName();
        MutableComponent baseComponent = Component.m_237113_((String)option.getSelfName());
        if (I18n.m_118936_((String)friendlyKey)) {
            return Component.m_237115_((String)friendlyKey).m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)baseComponent)));
        }
        return baseComponent;
    }

    public void updateOptionEntryStatuses() {
        for (Entry e : this.m_6702_()) {
            if (!(e instanceof OptionEntry)) continue;
            ((OptionEntry)e).updateStatus();
        }
    }

    private void addOption(Option option) {
        if (this.addedOptions.add(option)) {
            int w = this.f_93386_.f_91062_.m_92852_((FormattedText)OptionList.getOptionComponent(option)) + 20 * option.getDepth();
            this.maxNameWidth = Math.max(w, this.maxNameWidth);
            this.m_7085_((AbstractSelectionList.Entry)new OptionEntry(option.getName(), option));
            ModernFixMixinPlugin.instance.config.getOptionMap().values().stream().filter(subOption -> subOption.getParent() == option).sorted(Comparator.comparing(Option::getName)).forEach(this::addOption);
        }
    }

    public OptionList(ModernFixConfigScreen arg, Minecraft arg2) {
        super(arg2, arg.f_96543_ + 45, arg.f_96544_, 43, arg.f_96544_ - 32, 20);
        this.mainScreen = arg;
        Multimap<String, Option> optionsByCategory = ModernFixMixinPlugin.instance.config.getOptionCategoryMap();
        List<String> theCategories = OptionCategories.getCategoriesInOrder();
        for (String category : theCategories) {
            String categoryTranslationKey = "modernfix.option.category." + category;
            this.m_7085_((AbstractSelectionList.Entry)new CategoryEntry((Component)Component.m_237115_((String)categoryTranslationKey).m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)(categoryTranslationKey + ".description")))))));
            optionsByCategory.get((Object)category).stream().filter(key -> {
                int dotCount = 0;
                for (char c : key.getName().toCharArray()) {
                    if (c != '.') continue;
                    ++dotCount;
                }
                return dotCount >= 2;
            }).sorted(Comparator.comparing(Option::getName)).forEach(this::addOption);
        }
    }

    protected int m_5756_() {
        return super.m_5756_() + 15 + 20;
    }

    public int m_5759_() {
        return super.m_5759_() + 32;
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
    }

    class OptionEntry
    extends Entry {
        private final String name;
        private final Button toggleButton;
        private final Button helpButton;
        private final Option option;

        public OptionEntry(String optionName, Option option) {
            this.name = optionName;
            this.option = option;
            this.toggleButton = new Button(0, 0, 55, 20, (Component)Component.m_237113_((String)""), arg -> {
                this.option.setEnabled(!this.option.isEnabled(), !this.option.isUserDefined());
                try {
                    ModernFixMixinPlugin.instance.config.save();
                    if (!OptionList.this.mainScreen.madeChanges) {
                        OptionList.this.mainScreen.madeChanges = true;
                    }
                }
                catch (IOException e) {
                    this.option.setEnabled(!this.option.isEnabled(), !this.option.isUserDefined());
                    ModernFix.LOGGER.error("Unable to save config", (Throwable)e);
                }
                OptionList.this.updateOptionEntryStatuses();
            }, (btn, gfx, x, y) -> {
                if (this.option.isModDefined()) {
                    String disablingMods = String.join((CharSequence)", ", this.option.getDefiningMods());
                    OptionList.this.mainScreen.m_96602_(gfx, (Component)Component.m_237115_((String)("modernfix.option." + (this.option.isEnabled() ? "enabled" : "disabled"))).m_7220_((Component)Component.m_237110_((String)"modernfix.option.mod_override", (Object[])new Object[]{disablingMods})), x, y);
                }
            });
            this.updateStatus();
            this.helpButton = new Button(75, 0, 20, 20, (Component)Component.m_237113_((String)"?"), arg -> Minecraft.m_91087_().m_91152_((Screen)new ModernFixOptionInfoScreen(OptionList.this.mainScreen, optionName)));
            if (!I18n.m_118936_((String)("modernfix.option." + optionName))) {
                this.helpButton.f_93623_ = false;
                if (ModernFixPlatformHooks.INSTANCE.isDevEnv() && OPTIONS_MISSING_HELP.add(optionName)) {
                    ModernFix.LOGGER.warn("Missing help for {}", (Object)optionName);
                }
            }
        }

        void updateStatus() {
            this.toggleButton.f_93623_ = !this.option.isModDefined() && !this.option.isEffectivelyDisabledByParent();
        }

        public void m_6311_(PoseStack matrixStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            MutableComponent nameComponent = OptionList.getOptionComponent(this.option);
            if (this.option.isUserDefined()) {
                nameComponent = nameComponent.m_130938_(style -> style.m_131155_(Boolean.valueOf(true))).m_7220_((Component)Component.m_237115_((String)"modernfix.config.not_default"));
            }
            float textX = left + 20 * this.option.getDepth() + 160 - OptionList.this.maxNameWidth;
            float textY = top + height / 2 - 4;
            ((OptionList)OptionList.this).f_93386_.f_91062_.m_92889_(matrixStack, (Component)nameComponent, textX, textY, 0xFFFFFF);
            this.toggleButton.f_93620_ = left + 175;
            this.toggleButton.f_93621_ = top;
            this.toggleButton.m_93666_(this.getOptionMessage(this.option));
            this.toggleButton.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            this.helpButton.f_93620_ = left + 175 + 55;
            this.helpButton.f_93621_ = top;
            this.helpButton.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            if ((float)mouseX >= textX && (float)mouseY >= textY && (float)mouseX <= textX + (float)OptionList.this.maxNameWidth) {
                float f = mouseY;
                Objects.requireNonNull(((OptionList)OptionList.this).f_93386_.f_91062_);
                if (f <= textY + 9.0f) {
                    OptionList.this.mainScreen.m_96570_(matrixStack, nameComponent.m_7383_(), mouseX, mouseY);
                }
            }
        }

        private Component getOptionMessage(Option option) {
            return option.isEnabled() ? OPTION_ON : OPTION_OFF;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.toggleButton, (Object)this.helpButton);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            for (GuiEventListener guiEventListener : this.m_6702_()) {
                if (!guiEventListener.m_6375_(mouseX, mouseY, button)) continue;
                return true;
            }
            return false;
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            for (GuiEventListener guiEventListener : this.m_6702_()) {
                if (!guiEventListener.m_6348_(mouseX, mouseY, button)) continue;
                return true;
            }
            return false;
        }

        public List<? extends NarratableEntry> m_142437_() {
            return Collections.emptyList();
        }
    }

    class CategoryEntry
    extends Entry {
        private final Component name;
        private final int width;

        public CategoryEntry(Component component) {
            this.name = component;
            this.width = ((OptionList)OptionList.this).f_93386_.f_91062_.m_92852_((FormattedText)this.name);
        }

        public void m_6311_(PoseStack matrixStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            Font var10000 = ((OptionList)OptionList.this).f_93386_.f_91062_;
            float x = ((OptionList)OptionList.this).f_93386_.f_91080_.f_96543_ / 2 - this.width / 2;
            int y = top + height - 10;
            var10000.m_92889_(matrixStack, this.name, x, (float)y, 0xFFFFFF);
            if ((float)mouseX >= x && mouseY >= y && (float)mouseX <= x + (float)this.width) {
                Objects.requireNonNull(((OptionList)OptionList.this).f_93386_.f_91062_);
                if (mouseY <= y + 9) {
                    OptionList.this.mainScreen.m_96570_(matrixStack, this.name.m_7383_(), mouseX, mouseY);
                }
            }
        }

        public boolean m_5755_(boolean focus) {
            return false;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> m_142437_() {
            return Collections.emptyList();
        }
    }
}

