/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.api.colony.fields.registry.FieldRegistries;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.Log;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewRemoveFieldViewMessage
implements IMessage {
    private int colonyId;
    private ResourceKey<Level> dimension;
    private FieldRegistries.FieldEntry type;
    private BlockPos position;
    private FriendlyByteBuf fieldData;

    public ColonyViewRemoveFieldViewMessage() {
    }

    public ColonyViewRemoveFieldViewMessage(@NotNull IColony colony, @NotNull IField field) {
        this.colonyId = colony.getID();
        this.dimension = colony.getDimension();
        this.type = field.getFieldType();
        this.position = field.getPosition();
        this.fieldData = new FriendlyByteBuf(Unpooled.buffer());
        field.serialize(this.fieldData);
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.m_130070_(this.dimension.m_135782_().toString());
        buf.writeRegistryId(FieldRegistries.getFieldRegistry(), (Object)this.type);
        buf.m_130064_(this.position);
        buf.writeBytes((ByteBuf)this.fieldData);
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.colonyId = buf.readInt();
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(buf.m_130136_(Short.MAX_VALUE)));
        this.type = (FieldRegistries.FieldEntry)buf.readRegistryIdSafe(FieldRegistries.FieldEntry.class);
        this.position = buf.m_130135_();
        this.fieldData = new FriendlyByteBuf(Unpooled.buffer((int)buf.readableBytes()));
        buf.readBytes((ByteBuf)this.fieldData, buf.readableBytes());
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        IColonyView view = IColonyManager.getInstance().getColonyView(this.colonyId, this.dimension);
        if (view != null) {
            view.handleColonyRemoveFieldViewMessage(this.type, this.position, this.fieldData);
        } else {
            Log.getLogger().error("Colony view does not exist for ID #{}", (Object)this.colonyId);
        }
    }
}

