/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client;

import com.minecolonies.api.network.IMessage;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemParticleEffectMessage
implements IMessage {
    private static final Random RAND = new Random();
    private ItemStack stack;
    private double rotationPitch;
    private double rotationYaw;
    private double eyeHeight;
    private double posX;
    private double posY;
    private double posZ;

    public ItemParticleEffectMessage() {
    }

    public ItemParticleEffectMessage(ItemStack stack, double posX, double posY, double posZ, double rotationPitch, double rotationYaw, double eyeHeight) {
        this.stack = stack;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.rotationPitch = rotationPitch;
        this.rotationYaw = rotationYaw;
        this.eyeHeight = eyeHeight;
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        this.stack = buf.m_130267_();
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.rotationPitch = buf.readDouble();
        this.rotationYaw = buf.readDouble();
        this.eyeHeight = buf.readDouble();
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        buf.m_130055_(this.stack);
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeDouble(this.rotationPitch);
        buf.writeDouble(this.rotationYaw);
        buf.writeDouble(this.eyeHeight);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        ItemStack localStack = this.stack;
        if (localStack.m_41780_() == UseAnim.EAT) {
            for (int i = 0; i < 5; ++i) {
                Vec3 randomPos = new Vec3((RAND.nextDouble() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                randomPos = randomPos.m_82496_((float)(-this.rotationPitch * 0.01745329238474369));
                randomPos = randomPos.m_82524_((float)(-this.rotationYaw * 0.01745329238474369));
                double d0 = -RAND.nextDouble() * 0.6 - 0.3;
                Vec3 randomOffset = new Vec3((RAND.nextDouble() - 0.5) * 0.3, d0, 0.6);
                randomOffset = randomOffset.m_82496_((float)(-this.rotationPitch * 0.01745329238474369));
                randomOffset = randomOffset.m_82524_((float)(-this.rotationYaw * 0.01745329238474369));
                randomOffset = randomOffset.m_82520_(this.posX, this.posY + this.eyeHeight, this.posZ);
                world.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, localStack), randomOffset.f_82479_, randomOffset.f_82480_, randomOffset.f_82481_, randomPos.f_82479_, randomPos.f_82480_ + 0.05, randomPos.f_82481_);
            }
        }
    }
}

