/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.creativetab.ModCreativeTabs;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.requestsystem.locations.EntityLocation;
import com.minecolonies.coremod.colony.requestsystem.locations.StaticLocation;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class ItemBannerRallyGuards
extends AbstractItemMinecolonies {
    private static final String TAG_IS_ACTIVE = "isActive";

    public ItemBannerRallyGuards(Item.Properties properties) {
        super("banner_rally_guards", properties.m_41487_(1).m_41503_(0).m_41491_(ModCreativeTabs.MINECOLONIES));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        ItemStack banner = context.m_43723_().m_21120_(context.m_43724_());
        CompoundTag compound = ItemBannerRallyGuards.checkForCompound(banner);
        if (ItemBannerRallyGuards.isGuardBuilding(context.m_43725_(), context.m_8083_())) {
            if (context.m_43725_().m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            IGuardBuilding building = ItemBannerRallyGuards.getGuardBuilding(context.m_43725_(), context.m_8083_());
            if (!building.getColony().getPermissions().hasPermission(player, Action.RALLY_GUARDS)) {
                MessageUtils.format("com.minecolonies.coremod.permission.no", new Object[0]).sendTo(player);
                return InteractionResult.FAIL;
            }
            ILocation location = building.getLocation();
            if (ItemBannerRallyGuards.removeGuardTowerAtLocation(banner, location)) {
                MessageUtils.format("com.minecolonies.coremod.item.bannerrallyguards.deselected", building.getSchematicName(), location.toString()).sendTo(player);
            } else {
                ListTag guardTowers = compound.m_128437_("guardtowerpositions", 10);
                guardTowers.add((Object)StandardFactoryController.getInstance().serialize(location));
                MessageUtils.format("com.minecolonies.coremod.item.bannerrallyguards.selected", building.getSchematicName(), location.toString()).sendTo(player);
            }
        } else if (context.m_43725_().m_8055_(context.m_8083_()).m_60734_().equals(ModBlocks.blockColonyBanner)) {
            if (context.m_43725_().m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            IColony colony = ItemBannerRallyGuards.getColony(compound, context.m_43725_());
            if (colony != null && colony.getPermissions().hasPermission(player, Action.RALLY_GUARDS)) {
                if (colony.getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.STANDARD) <= 0.0) {
                    MessageUtils.format("item.minecolonies.banner_rally_guards.activated.needsresearch", new Object[0]).sendTo(context.m_43723_());
                    return InteractionResult.FAIL;
                }
                compound.m_128379_(TAG_IS_ACTIVE, true);
                int numGuards = ItemBannerRallyGuards.broadcastPlayerToRally(banner, context.m_43723_().m_20193_(), new StaticLocation(context.m_8083_(), (ResourceKey<Level>)context.m_43725_().m_46472_()));
                if (numGuards > 0) {
                    MessageUtils.format("item.minecolonies.banner_rally_guards.activated", numGuards).sendTo(context.m_43723_());
                } else {
                    MessageUtils.format("item.minecolonies.banner_rally_guards.activated.noguards", new Object[0]).sendTo(context.m_43723_());
                }
            }
        } else {
            this.handleRightClick(banner, context.m_43723_());
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    private static IColony getColony(CompoundTag compound, Level world) {
        ListTag guardTowersListNBT = compound.m_128437_("guardtowerpositions", 10);
        if (guardTowersListNBT == null) {
            Log.getLogger().error("Compound corrupt, missing TAG_RALLIED_GUARDTOWERS");
            return null;
        }
        ArrayList resultList = new ArrayList(guardTowersListNBT.size());
        for (Tag guardTowerNBT : guardTowersListNBT) {
            IGuardBuilding building;
            ILocation location = (ILocation)StandardFactoryController.getInstance().deserialize((CompoundTag)guardTowerNBT);
            if (!location.getDimension().equals((Object)world.m_46472_()) || (building = ItemBannerRallyGuards.getGuardBuilding(world, location.getInDimensionLocation())) == null) continue;
            return building.getColony();
        }
        return null;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack banner = playerIn.m_21120_(handIn);
        this.handleRightClick(banner, playerIn);
        return InteractionResultHolder.m_19090_((Object)banner);
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        if (!player.m_20193_().m_5776_()) {
            CompoundTag compound = ItemBannerRallyGuards.checkForCompound(item);
            compound.m_128379_(TAG_IS_ACTIVE, false);
            ItemBannerRallyGuards.broadcastPlayerToRally(item, player.m_20193_(), null);
        }
        return super.onDroppedByPlayer(item, player);
    }

    private void handleRightClick(ItemStack banner, Player playerIn) {
        if (playerIn.m_6144_() && !playerIn.m_20193_().m_5776_()) {
            ItemBannerRallyGuards.toggleBanner(banner, playerIn);
        } else if (!playerIn.m_6144_() && playerIn.m_20193_().m_5776_()) {
            if (ItemBannerRallyGuards.getGuardTowerLocations(banner).isEmpty()) {
                MessageUtils.format("com.minecolonies.coremod.item.bannerrallyguards.tooltipempty", new Object[0]).sendTo(playerIn);
            } else {
                MineColonies.proxy.openBannerRallyGuardsWindow(banner);
            }
        }
    }

    public static void toggleBanner(ItemStack banner, Player playerIn) {
        if (playerIn.m_20193_().m_5776_()) {
            Log.getLogger().error("Tried to run server-side function #toggleBanner() on the client-side!");
            return;
        }
        CompoundTag compound = ItemBannerRallyGuards.checkForCompound(banner);
        ListTag guardTowers = (ListTag)compound.m_128423_("guardtowerpositions");
        if (guardTowers == null) {
            Log.getLogger().error("Compound corrupt, missing TAG_RALLIED_GUARDTOWERS");
            return;
        }
        if (guardTowers.isEmpty()) {
            compound.m_128379_(TAG_IS_ACTIVE, false);
            MessageUtils.format("com.minecolonies.coremod.item.bannerrallyguards.tooltipempty", new Object[0]).sendTo(playerIn);
        } else if (compound.m_128471_(TAG_IS_ACTIVE)) {
            compound.m_128379_(TAG_IS_ACTIVE, false);
            ItemBannerRallyGuards.broadcastPlayerToRally(banner, playerIn.m_20193_(), null);
            MessageUtils.format("item.minecolonies.banner_rally_guards.deactivated", new Object[0]).sendTo(playerIn);
        } else {
            compound.m_128379_(TAG_IS_ACTIVE, true);
            IColony colony = ItemBannerRallyGuards.getColony(compound, playerIn.m_9236_());
            if (colony != null && colony.getPermissions().hasPermission(playerIn, Action.RALLY_GUARDS)) {
                int numGuards = ItemBannerRallyGuards.broadcastPlayerToRally(banner, playerIn.m_20193_(), playerIn == null ? null : new EntityLocation(playerIn.m_20148_()));
                if (numGuards > 0) {
                    MessageUtils.format("item.minecolonies.banner_rally_guards.activated", numGuards).sendTo(playerIn);
                } else {
                    MessageUtils.format("item.minecolonies.banner_rally_guards.activated.noguards", new Object[0]).sendTo(playerIn);
                }
            }
        }
    }

    public static int broadcastPlayerToRally(ItemStack banner, Level worldIn, @Nullable ILocation rallyLocation) {
        if (worldIn.m_5776_()) {
            Log.getLogger().error("Tried to run server-side function #broadcastPlayerToRally() on the client-side!");
            return 0;
        }
        ILocation rallyTarget = null;
        rallyTarget = !ItemBannerRallyGuards.isActive(banner) || rallyLocation == null ? null : rallyLocation;
        int numGuards = 0;
        for (ILocation guardTowerLocation : ItemBannerRallyGuards.getGuardTowerLocations(banner)) {
            IGuardBuilding building = ItemBannerRallyGuards.getGuardBuilding((Level)ServerLifecycleHooks.getCurrentServer().m_129880_(guardTowerLocation.getDimension()), guardTowerLocation.getInDimensionLocation());
            if (building == null) continue;
            building.setRallyLocation(rallyTarget);
            numGuards += building.getAllAssignedCitizen().size();
        }
        return numGuards;
    }

    public static ImmutableList<ILocation> getGuardTowerLocations(ItemStack banner) {
        CompoundTag compound = ItemBannerRallyGuards.checkForCompound(banner);
        ListTag guardTowersListNBT = compound.m_128437_("guardtowerpositions", 10);
        if (guardTowersListNBT == null) {
            Log.getLogger().error("Compound corrupt, missing TAG_RALLIED_GUARDTOWERS");
            return ImmutableList.of();
        }
        ArrayList<ILocation> resultList = new ArrayList<ILocation>(guardTowersListNBT.size());
        for (Tag guardTowerNBT : guardTowersListNBT) {
            resultList.add((ILocation)StandardFactoryController.getInstance().deserialize((CompoundTag)guardTowerNBT));
        }
        return ImmutableList.copyOf(resultList);
    }

    public static boolean isGuardBuilding(Level worldIn, BlockPos position) {
        if (worldIn.m_5776_()) {
            return IColonyManager.getInstance().getBuildingView((ResourceKey<Level>)worldIn.m_46472_(), position) instanceof AbstractBuildingGuards.View;
        }
        return IColonyManager.getInstance().getBuilding(worldIn, position) instanceof IGuardBuilding;
    }

    @Nullable
    public static AbstractBuildingGuards.View getGuardBuildingView(Level worldIn, BlockPos position) {
        if (!worldIn.m_5776_()) {
            Log.getLogger().error("Tried to run client-side function #getGuardBuildingView() on the server-side!");
            return null;
        }
        return ItemBannerRallyGuards.isGuardBuilding(worldIn, position) ? (AbstractBuildingGuards.View)IColonyManager.getInstance().getBuildingView((ResourceKey<Level>)worldIn.m_46472_(), position) : null;
    }

    @Nullable
    public static IGuardBuilding getGuardBuilding(Level worldIn, BlockPos position) {
        if (worldIn.m_5776_()) {
            Log.getLogger().error("Tried to run server-side function #getGuardBuilding() on the client-side!");
            return null;
        }
        return ItemBannerRallyGuards.isGuardBuilding(worldIn, position) ? (IGuardBuilding)IColonyManager.getInstance().getBuilding(worldIn, position) : null;
    }

    public static List<Pair<ILocation, AbstractBuildingGuards.View>> getGuardTowerViews(ItemStack banner) {
        LinkedList<Pair> result = new LinkedList<Pair>();
        for (ILocation guardTowerLocation : ItemBannerRallyGuards.getGuardTowerLocations(banner)) {
            result.add(new Pair((Object)guardTowerLocation, (Object)ItemBannerRallyGuards.getGuardBuildingView(MineColonies.proxy.getWorld(guardTowerLocation.getDimension()), guardTowerLocation.getInDimensionLocation())));
        }
        return ImmutableList.copyOf(result);
    }

    public boolean isActiveForGuardTower(ItemStack banner, IGuardBuilding guardTower) {
        if (!ItemBannerRallyGuards.isActive(banner)) {
            return false;
        }
        for (ILocation existingTower : ItemBannerRallyGuards.getGuardTowerLocations(banner)) {
            if (!existingTower.equals(guardTower.getLocation())) continue;
            return true;
        }
        return false;
    }

    public static boolean isActive(ItemStack banner) {
        CompoundTag compound = ItemBannerRallyGuards.checkForCompound(banner);
        return compound.m_128471_(TAG_IS_ACTIVE);
    }

    public static boolean removeGuardTowerAtLocation(ItemStack banner, ILocation guardTowerLocation) {
        CompoundTag compound = ItemBannerRallyGuards.checkForCompound(banner);
        ListTag guardTowers = compound.m_128437_("guardtowerpositions", 10);
        for (int i = 0; i < guardTowers.size(); ++i) {
            if (!StandardFactoryController.getInstance().deserialize((CompoundTag)guardTowers.get(i)).equals(guardTowerLocation)) continue;
            guardTowers.remove(i);
            banner.m_41751_(compound);
            return true;
        }
        return false;
    }

    public static CompoundTag checkForCompound(ItemStack banner) {
        CompoundTag compound;
        if (!banner.m_41782_()) {
            compound = new CompoundTag();
            banner.m_41751_(compound);
        }
        if (!(compound = banner.m_41783_()).m_128441_("guardtowerpositions")) {
            compound.m_128379_(TAG_IS_ACTIVE, false);
            @NotNull ListTag guardTowerList = new ListTag();
            compound.m_128365_("guardtowerpositions", (Tag)guardTowerList);
        } else if (compound.m_128441_("id")) {
            compound.m_128473_("id");
        }
        return compound;
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        CompoundTag compound = ItemBannerRallyGuards.checkForCompound(stack);
        return compound.m_128471_(TAG_IS_ACTIVE);
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        MutableComponent guiHint = Component.m_237115_((String)"com.minecolonies.coremod.item.bannerrallyguards.gui");
        guiHint.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY));
        tooltip.add((Component)guiHint);
        MutableComponent rallyHint = Component.m_237115_((String)"com.minecolonies.coremod.item.bannerrallyguards.rally");
        rallyHint.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY));
        tooltip.add((Component)rallyHint);
        ImmutableList<ILocation> guardTowerPositions = ItemBannerRallyGuards.getGuardTowerLocations(stack);
        if (guardTowerPositions.isEmpty()) {
            MutableComponent emptyTooltip = Component.m_237115_((String)"com.minecolonies.coremod.item.bannerrallyguards.tooltipempty");
            emptyTooltip.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY));
            tooltip.add((Component)emptyTooltip);
        } else {
            MutableComponent numGuardTowers = Component.m_237110_((String)"com.minecolonies.coremod.item.bannerrallyguards.tooltip", (Object[])new Object[]{guardTowerPositions.size()});
            numGuardTowers.m_6270_(Style.f_131099_.m_131140_(ChatFormatting.DARK_AQUA));
            tooltip.add((Component)numGuardTowers);
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }
}

