/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.generation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.crafting.registry.ModRecipeSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.jetbrains.annotations.NotNull;

public class CompostRecipeBuilder {
    private final List<Ingredient> inputs = new ArrayList<Ingredient>();
    private final int strength;

    public CompostRecipeBuilder(int strength) {
        this.strength = strength;
    }

    public static CompostRecipeBuilder strength(int strength) {
        return new CompostRecipeBuilder(strength);
    }

    public CompostRecipeBuilder input(@NotNull Ingredient ingredient) {
        this.inputs.add(ingredient);
        return this;
    }

    public void save(@NotNull Consumer<FinishedRecipe> consumer, @NotNull ResourceLocation id) {
        JsonArray inputsJson = new JsonArray();
        for (Ingredient input : this.inputs) {
            inputsJson.add(input.m_43942_());
        }
        Ingredient merged = CraftingHelper.getIngredient((JsonElement)inputsJson);
        consumer.accept(new Result(id, merged, this.strength));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient input;
        private final int strength;

        public Result(@NotNull ResourceLocation id, @NotNull Ingredient input, int strength) {
            this.id = id;
            this.input = input;
            this.strength = strength;
        }

        public void m_7917_(@NotNull JsonObject json) {
            json.add("input", this.input.m_43942_());
            json.addProperty("strength", (Number)this.strength);
        }

        @NotNull
        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipeSerializer.CompostRecipeSerializer.get();
        }

        @NotNull
        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return new ResourceLocation("");
        }
    }
}

