/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.farmer;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.blocks.BlockScarecrow;
import com.minecolonies.coremod.colony.buildings.modules.FieldsModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFarmer;
import com.minecolonies.coremod.colony.fields.FarmField;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.JobFarmer;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAICrafting;
import com.minecolonies.coremod.network.messages.client.CompostParticleMessage;
import com.minecolonies.coremod.util.AdvancementUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.MelonBlock;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkFarmer
extends AbstractEntityAICrafting<JobFarmer, BuildingFarmer> {
    private static final int MAX_BLOCKS_MINED = 64;
    private static final int STANDARD_DELAY = 40;
    private static final int SMALLEST_DELAY = 1;
    private static final double DELAY_DIVIDER = 1.0;
    private static final double XP_PER_HARVEST = 0.5;
    private static final int MAX_DEPTH = 5;
    private static final VisibleCitizenStatus FARMING_ICON = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/farmer.png"), "com.minecolonies.gui.visiblestatus.farmer");
    private boolean shouldDumpInventory = false;
    @Nullable
    private BlockPos workingOffset;
    @Nullable
    private BlockPos prevPos;
    private int cell = -1;

    public EntityAIWorkFarmer(@NotNull JobFarmer job) {
        super(job);
        super.registerTargets(new AITarget<Object>(AIWorkerState.PREPARING, this::prepareForFarming, 20), new AITarget<Object>(AIWorkerState.FARMER_HOE, this::workAtField, 5), new AITarget<Object>(AIWorkerState.FARMER_PLANT, this::workAtField, 5), new AITarget<Object>(AIWorkerState.FARMER_HARVEST, this::workAtField, 5));
        this.worker.m_21553_(true);
    }

    @Override
    public Class<BuildingFarmer> getExpectedBuildingClass() {
        return BuildingFarmer.class;
    }

    @Override
    protected boolean wantInventoryDumped() {
        if (this.shouldDumpInventory || ((JobFarmer)this.job).getActionsDone() >= this.getActionRewardForCraftingSuccess()) {
            this.shouldDumpInventory = false;
            return true;
        }
        return super.wantInventoryDumped();
    }

    @Override
    protected int getActionRewardForCraftingSuccess() {
        return 64;
    }

    @Override
    protected void updateRenderMetaData() {
        this.worker.setRenderMetadata(this.getState() == AIWorkerState.FARMER_PLANT || this.getState() == AIWorkerState.FARMER_HARVEST ? "working" : "");
    }

    @Override
    protected IAIState decide() {
        IAIState state = super.decide();
        if (state == AIWorkerState.IDLE) {
            return AIWorkerState.PREPARING;
        }
        return state;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 64;
    }

    @NotNull
    private IAIState prepareForFarming() {
        int amountOfCompostInInv;
        int amountOfCompostInBuilding;
        this.worker.getCitizenData().setIdleAtJob(true);
        if (this.building == null || ((BuildingFarmer)this.building).getBuildingLevel() < 1) {
            return AIWorkerState.PREPARING;
        }
        FieldsModule module = (FieldsModule)((BuildingFarmer)this.building).getFirstModuleOccurance(FieldsModule.class);
        module.claimFields();
        if (module.getOwnedFields().size() == ((BuildingFarmer)this.building).getMaxBuildingLevel()) {
            AdvancementUtils.TriggerAdvancementPlayersForColony(((BuildingFarmer)this.building).getColony(), AdvancementTriggers.MAX_FIELDS::trigger);
        }
        if ((amountOfCompostInBuilding = InventoryUtils.hasBuildingEnoughElseCount((IBuilding)this.building, this::isCompost, 1)) + (amountOfCompostInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this::isCompost)) <= 0) {
            if (((BuildingFarmer)this.building).requestFertilizer() && !((BuildingFarmer)this.building).hasWorkerOpenRequestsOfType(this.worker.getCitizenData().getId(), TypeToken.of(StackList.class))) {
                ArrayList<ItemStack> compostAbleItems = new ArrayList<ItemStack>();
                compostAbleItems.add(new ItemStack((ItemLike)ModItems.compost, 1));
                compostAbleItems.add(new ItemStack((ItemLike)Items.f_42499_, 1));
                this.worker.getCitizenData().createRequestAsync(new StackList(compostAbleItems, "com.minecolonies.coremod.request.fertilizer", 64, 1));
            }
        } else if (amountOfCompostInInv <= 0 && amountOfCompostInBuilding > 0) {
            this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(this::isCompost, 64);
            return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
        }
        if (module.hasNoFields()) {
            if (this.worker.getCitizenData() != null) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.m_237115_((String)"entity.farmer.nofreefields"), ChatPriority.BLOCKING));
            }
            return AIWorkerState.IDLE;
        }
        module.resetCurrentField();
        IField fieldToWork = module.getFieldToWorkOn();
        if (fieldToWork instanceof FarmField) {
            FarmField farmField = (FarmField)fieldToWork;
            this.worker.getCitizenData().setIdleAtJob(false);
            this.worker.getCitizenData().setVisibleStatus(FARMING_ICON);
            if (farmField.getFieldStage() == FarmField.Stage.PLANTED && this.checkIfShouldExecute(farmField, pos -> this.findHarvestableSurface((BlockPos)pos) != null)) {
                return AIWorkerState.FARMER_HARVEST;
            }
            if (farmField.getFieldStage() == FarmField.Stage.HOED) {
                return this.canGoPlanting(farmField);
            }
            if (farmField.getFieldStage() == FarmField.Stage.EMPTY && this.checkIfShouldExecute(farmField, pos -> this.findHoeableSurface((BlockPos)pos, farmField) != null)) {
                return AIWorkerState.FARMER_HOE;
            }
            farmField.nextState();
        }
        return AIWorkerState.PREPARING;
    }

    private boolean isCompost(ItemStack itemStack) {
        if (itemStack.m_41720_() == ModItems.compost) {
            return true;
        }
        return itemStack.m_41720_() == Items.f_42499_;
    }

    private boolean checkIfShouldExecute(@NotNull FarmField farmField, @NotNull Predicate<BlockPos> predicate) {
        BlockPos position;
        do {
            this.workingOffset = this.nextValidCell(farmField);
            if (this.workingOffset != null) continue;
            return false;
        } while (!predicate.test(position = farmField.getPosition().m_7495_().m_122020_(this.workingOffset.m_123343_()).m_122030_(this.workingOffset.m_123341_())));
        return true;
    }

    private IAIState canGoPlanting(@NotNull FarmField farmField) {
        if (farmField.getSeed() == null) {
            return AIWorkerState.PREPARING;
        }
        ItemStack seeds = farmField.getSeed();
        int slot = this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(seeds.m_41720_());
        if (slot != -1) {
            return AIWorkerState.FARMER_PLANT;
        }
        if (this.walkToBuilding()) {
            return AIWorkerState.PREPARING;
        }
        seeds.m_41764_(seeds.m_41741_());
        this.checkIfRequestForItemExistOrCreateAsync(seeds, seeds.m_41741_(), 1);
        farmField.nextState();
        return AIWorkerState.PREPARING;
    }

    private BlockPos findHoeableSurface(@NotNull BlockPos position, @NotNull FarmField farmField) {
        if ((position = this.getSurfacePos(position)) == null || farmField.isNoPartOfField(this.world, position) || this.world.m_8055_(position.m_7494_()).m_60734_() instanceof CropBlock || this.world.m_8055_(position.m_7494_()).m_60734_() instanceof BlockScarecrow || !this.world.m_8055_(position).m_204336_(BlockTags.f_144274_)) {
            return null;
        }
        return position;
    }

    private BlockPos getSurfacePos(BlockPos position) {
        return this.getSurfacePos(position, 0);
    }

    private BlockPos getSurfacePos(BlockPos position, Integer depth) {
        if (Math.abs(depth) > 5) {
            return null;
        }
        BlockState curBlockState = this.world.m_8055_(position);
        @Nullable Block curBlock = curBlockState.m_60734_();
        if (curBlockState.m_60767_().m_76333_() && !(curBlock instanceof PumpkinBlock) && !(curBlock instanceof MelonBlock) && !(curBlock instanceof WebBlock) || curBlockState.m_60767_().m_76332_()) {
            if (depth < 0) {
                return position;
            }
            return this.getSurfacePos(position.m_7494_(), depth + 1);
        }
        if (depth > 0) {
            return position.m_7495_();
        }
        return this.getSurfacePos(position.m_7495_(), depth - 1);
    }

    protected BlockPos nextValidCell(FarmField farmField) {
        int x;
        int z;
        if (this.workingOffset == null) {
            this.cell = -1;
        }
        do {
            if (++this.cell == this.getLargestCell(farmField)) {
                return null;
            }
            int ring = (int)Math.floor((Math.sqrt((double)this.cell + 1.0) + 1.0) / 2.0);
            int ringCell = this.cell - (int)(4.0 * Math.pow((double)ring - 1.0, 2.0) + (double)(4 * (ring - 1)));
            Direction facing = Direction.m_122407_((int)Math.floorDiv(ringCell, 2 * ring));
            if (facing.m_122434_() == Direction.Axis.Z) {
                x = (facing == Direction.NORTH ? -1 : 1) * (ring - ringCell % (2 * ring));
                z = (facing == Direction.NORTH ? -1 : 1) * ring;
                continue;
            }
            x = (facing == Direction.WEST ? -1 : 1) * ring;
            z = (facing == Direction.EAST ? -1 : 1) * (ring - ringCell % (2 * ring));
        } while (-z > farmField.getRadius(Direction.NORTH) || x > farmField.getRadius(Direction.EAST) || z > farmField.getRadius(Direction.SOUTH) || -x > farmField.getRadius(Direction.WEST));
        return new BlockPos(x, 0, z);
    }

    protected int getLargestCell(FarmField farmField) {
        return (int)Math.pow((double)farmField.getMaxRadius() * 2.0 + 1.0, 2.0);
    }

    private IAIState workAtField() {
        FieldsModule module = (FieldsModule)((BuildingFarmer)this.building).getFirstModuleOccurance(FieldsModule.class);
        if (this.checkForToolOrWeapon(ToolType.HOE) || module.getCurrentField() == null) {
            return AIWorkerState.PREPARING;
        }
        this.worker.getCitizenData().setVisibleStatus(FARMING_ICON);
        IField field = module.getCurrentField();
        if (field instanceof FarmField) {
            FarmField farmField = (FarmField)field;
            if (this.workingOffset != null) {
                BlockPos position = farmField.getPosition().m_7495_().m_122020_(this.workingOffset.m_123343_()).m_122030_(this.workingOffset.m_123341_());
                if (this.walkToBlock(position.m_7494_())) {
                    return this.getState();
                }
                switch ((AIWorkerState)this.getState()) {
                    case FARMER_HOE: {
                        if (this.hoeIfAble(position, farmField)) break;
                        return this.getState();
                    }
                    case FARMER_PLANT: {
                        if (this.tryToPlant(farmField, position)) break;
                        return AIWorkerState.PREPARING;
                    }
                    case FARMER_HARVEST: {
                        if (this.harvestIfAble(position)) break;
                        return this.getState();
                    }
                    default: {
                        return AIWorkerState.PREPARING;
                    }
                }
                this.prevPos = position;
                this.setDelay(this.getLevelDelay());
            }
            this.workingOffset = this.nextValidCell(farmField);
            if (this.workingOffset == null) {
                this.shouldDumpInventory = true;
                farmField.nextState();
                this.prevPos = null;
                return AIWorkerState.IDLE;
            }
        } else {
            return AIWorkerState.IDLE;
        }
        return this.getState();
    }

    private boolean hoeIfAble(BlockPos position, FarmField farmField) {
        if ((position = this.findHoeableSurface(position, farmField)) != null && !this.checkForToolOrWeapon(ToolType.HOE)) {
            if (this.mineBlock(position.m_7494_())) {
                this.equipHoe();
                this.worker.m_6674_(this.worker.m_7655_());
                this.world.m_46597_(position, Blocks.f_50093_.m_49966_());
                this.worker.getCitizenItemHandler().damageItemInHand(InteractionHand.MAIN_HAND, 1);
                this.worker.decreaseSaturationForContinuousAction();
                this.worker.getCitizenColonyHandler().getColony().getStatisticsManager().increment("land_tilled");
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean harvestIfAble(BlockPos position) {
        if ((position = this.findHarvestableSurface(position)) != null) {
            if (Compatibility.isPamsInstalled()) {
                this.worker.getCitizenExperienceHandler().addExperience(0.5);
                this.harvestCrop(position.m_7494_());
                this.worker.getCitizenColonyHandler().getColony().getStatisticsManager().increment("crops_harvested");
                return true;
            }
            if (this.mineBlock(position.m_7494_())) {
                this.worker.getCitizenColonyHandler().getColony().getStatisticsManager().increment("crops_harvested");
                this.worker.getCitizenExperienceHandler().addExperience(0.5);
            } else {
                return false;
            }
        }
        return true;
    }

    protected int getLevelDelay() {
        return (int)Math.max(1.0, 40.0 - (double)this.getPrimarySkillLevel() / 2.0 * 1.0);
    }

    private boolean tryToPlant(FarmField farmField, BlockPos position) {
        return (position = this.findPlantableSurface(position, farmField)) == null || this.plantCrop(farmField.getSeed(), position);
    }

    private void equipHoe() {
        this.worker.getCitizenItemHandler().setHeldItem(InteractionHand.MAIN_HAND, this.getHoeSlot());
    }

    private BlockPos findPlantableSurface(@NotNull BlockPos position, @NotNull FarmField farmField) {
        if ((position = this.getSurfacePos(position)) == null || farmField.isNoPartOfField(this.world, position) || this.world.m_8055_(position.m_7494_()).m_60734_() instanceof CropBlock || this.world.m_8055_(position.m_7494_()).m_60734_() instanceof StemBlock || this.world.m_8055_(position).m_60734_() instanceof BlockScarecrow || !(this.world.m_8055_(position).m_60734_() instanceof FarmBlock)) {
            return null;
        }
        return position;
    }

    private boolean plantCrop(ItemStack item, @NotNull BlockPos position) {
        BlockItem blockItem;
        if (item == null || item.m_41619_()) {
            return false;
        }
        int slot = this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(item.m_41720_());
        if (slot == -1) {
            return false;
        }
        Item item2 = item.m_41720_();
        if (item2 instanceof BlockItem && ((blockItem = (BlockItem)item2).m_40614_() instanceof CropBlock || blockItem.m_40614_() instanceof StemBlock)) {
            @NotNull Item seed = item.m_41720_();
            if (!(seed != Items.f_42578_ && seed != Items.f_42577_ || this.prevPos == null || this.world.m_46859_(this.prevPos.m_7494_()))) {
                return true;
            }
            this.world.m_46597_(position.m_7494_(), ((BlockItem)item.m_41720_()).m_40614_().m_49966_());
            this.worker.decreaseSaturationForContinuousAction();
            this.getInventory().extractItem(slot, 1, false);
        }
        return true;
    }

    private BlockPos findHarvestableSurface(@NotNull BlockPos position) {
        if ((position = this.getSurfacePos(position)) == null) {
            return null;
        }
        BlockState state = this.world.m_8055_(position.m_7494_());
        Block block = state.m_60734_();
        if (block == Blocks.f_50133_ || block == Blocks.f_50186_) {
            return position;
        }
        if (this.isCrop(block)) {
            @NotNull CropBlock crop = (CropBlock)block;
            if (crop.m_52307_(state)) {
                return position;
            }
            int amountOfCompostInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this::isCompost);
            if (amountOfCompostInInv == 0) {
                return null;
            }
            if (InventoryUtils.shrinkItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this::isCompost)) {
                Network.getNetwork().sendToPosition(new CompostParticleMessage(position.m_7494_()), new PacketDistributor.TargetPoint((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_(), 16.0, this.world.m_46472_()));
                crop.m_52263_(this.world, position.m_7494_(), state);
                state = this.world.m_8055_(position.m_7494_());
                block = state.m_60734_();
                if (this.isCrop(block)) {
                    crop = (CropBlock)block;
                } else {
                    return null;
                }
            }
            return crop.m_52307_(state) ? position : null;
        }
        return null;
    }

    public boolean isCrop(Block block) {
        return block instanceof CropBlock;
    }

    @Override
    protected List<ItemStack> increaseBlockDrops(List<ItemStack> drops) {
        double increaseCrops = this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.FARMING);
        if (increaseCrops == 0.0) {
            return drops;
        }
        ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>();
        for (ItemStack stack : drops) {
            ItemStack drop = stack.m_41777_();
            if (this.worker.m_217043_().m_188500_() < increaseCrops) {
                drop.m_41764_(drop.m_41613_() * 2);
            }
            newDrops.add(drop);
        }
        return newDrops;
    }

    @Override
    public int getBreakSpeedLevel() {
        return this.getSecondarySkillLevel();
    }

    private void harvestCrop(@NotNull BlockPos pos) {
        ItemStack tool = this.worker.m_21205_();
        int fortune = ItemStackUtils.getFortuneOf(tool);
        BlockState state = this.world.m_8055_(pos);
        double chance = this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.FARMING);
        NonNullList drops = NonNullList.m_122779_();
        state.m_60724_(new LootContext.Builder((ServerLevel)this.world).m_78963_((float)fortune).m_78963_((float)fortune).m_78972_(LootContextParams.f_81460_, (Object)this.worker.m_20182_()).m_78972_(LootContextParams.f_81463_, (Object)tool).m_78972_(LootContextParams.f_81455_, (Object)this.getCitizen()));
        for (ItemStack item : drops) {
            ItemStack drop = item.m_41777_();
            if (this.worker.m_217043_().m_188500_() < chance) {
                drop.m_41764_(drop.m_41613_() * 2);
            }
            InventoryUtils.addItemStackToItemHandler((IItemHandler)this.worker.getInventoryCitizen(), drop);
        }
        Block block = state.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock crops = (CropBlock)block;
            this.world.m_46597_(pos, crops.m_52289_(0));
        }
        this.incrementActionsDone();
        this.worker.decreaseSaturationForContinuousAction();
    }

    private int getHoeSlot() {
        return InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)this.getInventory(), ToolType.HOE, 0, ((BuildingFarmer)this.building).getMaxToolLevel());
    }

    @Nullable
    public AbstractEntityCitizen getCitizen() {
        return this.worker;
    }
}

