/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity;

import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.coremod.colony.jobs.JobDruid;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DruidPotionEntity
extends ThrownPotion {
    public static final double SPLASH_SIZE = 4.0;
    public static final double SPLASH_HEIGTH = 2.0;
    public static final double MAX_DISTANCE = 16.0;
    public static final int MIN_DURATION = 20;
    @Nullable
    private BiPredicate<LivingEntity, MobEffect> entitySelectionPredicate = null;

    public DruidPotionEntity(EntityType<? extends ThrownPotion> type, Level world) {
        super(type, world);
    }

    public void setEntitySelectionPredicate(@Nullable BiPredicate<LivingEntity, MobEffect> entitySelectionPredicate) {
        this.entitySelectionPredicate = entitySelectionPredicate;
    }

    public void m_37547_(List<MobEffectInstance> effects, @Nullable Entity entity) {
        AABB axisalignedbb;
        List list;
        AbstractEntityCitizen citizen = this.getOwner();
        if (citizen != null && citizen.getCitizenData() != null && citizen.getCitizenData().getJob() instanceof JobDruid && !(list = this.f_19853_.m_45976_(LivingEntity.class, axisalignedbb = this.m_20191_().m_82377_(4.0, 2.0, 4.0))).isEmpty()) {
            for (LivingEntity livingentity : list) {
                double distanceSq;
                if (!livingentity.m_5801_() || !((distanceSq = this.m_20280_((Entity)livingentity)) < 16.0)) continue;
                double d1 = 1.0 - Math.sqrt(distanceSq) / 4.0;
                if (livingentity == entity) {
                    d1 = 1.0;
                }
                for (MobEffectInstance effectinstance : effects) {
                    MobEffect effect = effectinstance.m_19544_();
                    if (this.entitySelectionPredicate != null && !this.entitySelectionPredicate.test(livingentity, effect)) continue;
                    if (effect.m_8093_()) {
                        effect.m_19461_((Entity)this, (Entity)this.getOwner(), livingentity, effectinstance.m_19564_(), d1);
                        continue;
                    }
                    int duration = (int)(d1 * (double)effectinstance.m_19557_());
                    livingentity.m_7292_(new MobEffectInstance(effect, duration, effectinstance.m_19564_(), effectinstance.m_19571_(), effectinstance.m_19572_()));
                }
            }
        }
    }

    @Nullable
    public AbstractEntityCitizen getOwner() {
        Entity owner = super.m_37282_();
        if (owner instanceof AbstractEntityCitizen) {
            return (AbstractEntityCitizen)owner;
        }
        return null;
    }

    public static void throwPotionAt(ItemStack potionStack, LivingEntity target, AbstractEntityCitizen thrower, Level world, float velocity, float inaccuracy, BiPredicate<LivingEntity, MobEffect> entitySelectionPredicate) {
        DruidPotionEntity potionentity = (DruidPotionEntity)ModEntities.DRUID_POTION.m_20615_(world);
        potionentity.m_5602_((Entity)thrower);
        potionentity.setEntitySelectionPredicate(entitySelectionPredicate);
        potionentity.m_37446_(potionStack);
        potionentity.m_6034_(thrower.m_20185_(), thrower.m_20186_() + 1.0, thrower.m_20189_());
        thrower.f_19853_.m_6263_(null, thrower.m_20185_(), thrower.m_20186_(), thrower.m_20189_(), SoundEvents.f_12553_, thrower.m_5720_(), 1.0f, 0.8f + thrower.m_217043_().m_188501_() * 0.4f);
        Vec3 movement = target.m_20184_();
        double x = target.m_20185_() + movement.f_82479_ - thrower.m_20185_();
        double y = target.m_20188_() - (double)1.1f - thrower.m_20186_();
        double z = target.m_20189_() + movement.f_82481_ - thrower.m_20189_();
        double distance = Math.sqrt(x * x + z * z);
        potionentity.m_6686_(x, y + distance * 0.2, z, velocity, inaccuracy);
        world.m_7967_((Entity)potionentity);
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

