/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.ai.citizen.guard.EntityAIKnight;
import com.minecolonies.coremod.util.AttributeModifierUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class JobKnight
extends AbstractJobGuard<JobKnight> {
    public static final String DESC = "com.minecolonies.coremod.job.knight";

    public JobKnight(ICitizenData entity) {
        super(entity);
    }

    public EntityAIKnight generateGuardAI() {
        return new EntityAIKnight(this);
    }

    @Override
    public void onLevelUp() {
        if (this.getCitizen().getEntity().isPresent()) {
            AbstractEntityCitizen citizen = this.getCitizen().getEntity().get();
            AttributeModifier healthModLevel = new AttributeModifier("MinecoloniesGuardLevelHealth", (double)(this.getCitizen().getCitizenSkillHandler().getLevel(Skill.Stamina) + 15), AttributeModifier.Operation.ADDITION);
            AttributeModifierUtils.addHealthModifier((LivingEntity)citizen, healthModLevel);
        }
    }

    @Override
    public ResourceLocation getModel() {
        return ModModelTypes.KNIGHT_GUARD_ID;
    }

    @Override
    public boolean ignoresDamage(@NotNull DamageSource damageSource) {
        if (damageSource.m_19372_() && this.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SHIELD_USAGE) > 0.0 && InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.getCitizen().getInventory(), Items.f_42740_) != -1) {
            if (!this.getCitizen().getEntity().isPresent()) {
                return true;
            }
            AbstractEntityCitizen worker = this.getCitizen().getEntity().get();
            worker.getCitizenItemHandler().setHeldItem(InteractionHand.OFF_HAND, InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.getCitizen().getInventory(), Items.f_42740_));
            worker.m_6672_(InteractionHand.OFF_HAND);
            ItemStack shieldStack = worker.getInventoryCitizen().getHeldItem(InteractionHand.OFF_HAND);
            CompoundTag nbt = shieldStack.m_41698_("BlockEntityTag");
            nbt.m_128365_("Patterns", (Tag)worker.getCitizenColonyHandler().getColony().getColonyFlag());
            worker.decreaseSaturationForContinuousAction();
            return true;
        }
        return super.ignoresDamage(damageSource);
    }
}

