/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.CitizenNameFile;
import com.minecolonies.api.colony.ColonyState;
import com.minecolonies.api.colony.ICitizen;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.managers.interfaces.ICitizenManager;
import com.minecolonies.api.colony.managers.interfaces.IColonyPackageManager;
import com.minecolonies.api.colony.managers.interfaces.IEventDescriptionManager;
import com.minecolonies.api.colony.managers.interfaces.IEventManager;
import com.minecolonies.api.colony.managers.interfaces.IGraveManager;
import com.minecolonies.api.colony.managers.interfaces.IProgressManager;
import com.minecolonies.api.colony.managers.interfaces.IRaiderManager;
import com.minecolonies.api.colony.managers.interfaces.IRegisteredStructureManager;
import com.minecolonies.api.colony.managers.interfaces.IReproductionManager;
import com.minecolonies.api.colony.managers.interfaces.IStatisticsManager;
import com.minecolonies.api.colony.managers.interfaces.IVisitorManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.compatibility.newstruct.BlueprintMapping;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.quests.IQuestManager;
import com.minecolonies.api.research.IResearchManager;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.colony.managers.CitizenManager;
import com.minecolonies.coremod.colony.managers.ColonyPackageManager;
import com.minecolonies.coremod.colony.managers.EventDescriptionManager;
import com.minecolonies.coremod.colony.managers.EventManager;
import com.minecolonies.coremod.colony.managers.GraveManager;
import com.minecolonies.coremod.colony.managers.ProgressManager;
import com.minecolonies.coremod.colony.managers.RaidManager;
import com.minecolonies.coremod.colony.managers.RegisteredStructureManager;
import com.minecolonies.coremod.colony.managers.ReproductionManager;
import com.minecolonies.coremod.colony.managers.ResearchManager;
import com.minecolonies.coremod.colony.managers.StatisticsManager;
import com.minecolonies.coremod.colony.managers.VisitorManager;
import com.minecolonies.coremod.colony.permissions.ColonyPermissionEventHandler;
import com.minecolonies.coremod.colony.permissions.Permissions;
import com.minecolonies.coremod.colony.pvp.AttackingPlayer;
import com.minecolonies.coremod.colony.requestsystem.management.manager.StandardRequestManager;
import com.minecolonies.coremod.colony.workorders.WorkManager;
import com.minecolonies.coremod.datalistener.CitizenNameListener;
import com.minecolonies.coremod.network.messages.client.colony.ColonyViewRemoveWorkOrderMessage;
import com.minecolonies.coremod.quests.QuestManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Colony
implements IColony {
    private String pack = "Colonial";
    private final int id;
    private ResourceKey<Level> dimensionId;
    private Set<Long> loadedChunks = new HashSet<Long>();
    public Set<Long> ticketedChunks = new HashSet<Long>();
    private boolean ticketedChunksDirty = true;
    private Set<Long> pendingChunks = new HashSet<Long>();
    private Set<Long> pendingToUnloadChunks = new HashSet<Long>();
    private final Map<BlockPos, BlockState> wayPoints = new HashMap<BlockPos, BlockState>();
    private final WorkManager workManager = new WorkManager(this);
    private final IRegisteredStructureManager buildingManager = new RegisteredStructureManager(this);
    private final IGraveManager graveManager = new GraveManager(this);
    private final ICitizenManager citizenManager = new CitizenManager(this);
    private final IVisitorManager visitorManager = new VisitorManager(this);
    private final IRaiderManager raidManager = new RaidManager(this);
    private final IEventManager eventManager = new EventManager(this);
    private final IReproductionManager reproductionManager = new ReproductionManager(this);
    private final IEventDescriptionManager eventDescManager = new EventDescriptionManager(this);
    private final IColonyPackageManager packageManager = new ColonyPackageManager(this);
    private final IProgressManager progressManager = new ProgressManager(this);
    private final IStatisticsManager statisticManager = new StatisticsManager(this);
    private final IStatisticsManager reputationManager = new StatisticsManager(this);
    private IQuestManager questManager;
    private final Set<BlockPos> freePositions = new HashSet<BlockPos>();
    private final Set<Block> freeBlocks = new HashSet<Block>();
    private ColonyPermissionEventHandler eventHandler;
    private boolean canColonyBeAutoDeleted = true;
    private boolean isDay = true;
    @Nullable
    private Level world = null;
    private boolean manualHiring = false;
    private boolean manualHousing = false;
    private boolean moveIn = true;
    private String name = "ERROR(Wasn't placed by player)";
    private BlockPos center;
    @NotNull
    private Permissions permissions;
    private IRequestManager requestManager;
    private IResearchManager researchManager;
    private CompoundTag colonyTag;
    private final List<Player> visitingPlayers = new ArrayList<Player>();
    private final List<AttackingPlayer> attackingPlayers = new ArrayList<AttackingPlayer>();
    private final ITickRateStateMachine<ColonyState> colonyStateMachine;
    private boolean isDirty = true;
    private ChatFormatting colonyTeamColor = ChatFormatting.WHITE;
    private ListTag colonyFlag = new BannerPattern.Builder().m_222705_(BannerPatterns.f_222726_, DyeColor.WHITE).m_58587_();
    private long mercenaryLastUse = 0L;
    private int additionalChildTime = 0;
    private static final int maxAdditionalChildTime = 70000;
    private boolean hasChilds = false;
    public long lastOnlineTime = 0L;
    private int forceLoadTimer = 0;
    private String textureStyle = "default";
    private String nameStyle = "default";
    private int day = 0;

    Colony(int id, @Nullable Level w, BlockPos c) {
        this(id, w);
        this.center = c;
        this.permissions = new Permissions(this);
        this.requestManager = new StandardRequestManager(this);
        this.researchManager = new ResearchManager(this);
        this.questManager = new QuestManager(this);
    }

    protected Colony(int id, @Nullable Level world) {
        this.questManager = new QuestManager(this);
        this.id = id;
        if (world != null) {
            this.dimensionId = world.m_46472_();
            this.onWorldLoad(world);
            this.checkOrCreateTeam();
        }
        this.permissions = new Permissions(this);
        this.researchManager = new ResearchManager(this);
        this.colonyStateMachine = new TickRateStateMachine<ColonyState>(ColonyState.INACTIVE, e -> {});
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.INACTIVE, () -> true, this::updateState, 100));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.UNLOADED, () -> true, this::updateState, 100));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, () -> true, this::updateState, 100));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, this.citizenManager::tickCitizenData, () -> ColonyState.ACTIVE, 60));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, this::updateSubscribers, () -> ColonyState.ACTIVE, 20));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, this::tickRequests, () -> ColonyState.ACTIVE, 11));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, this::checkDayTime, () -> ColonyState.ACTIVE, 20));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, this::updateWayPoints, () -> ColonyState.ACTIVE, 100));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.ACTIVE, this::worldTickSlow, () -> ColonyState.ACTIVE, 500));
        this.colonyStateMachine.addTransition(new TickingTransition<ColonyState>(ColonyState.UNLOADED, this::worldTickUnloaded, () -> ColonyState.UNLOADED, 500));
    }

    private ColonyState updateState() {
        if (this.world == null) {
            return ColonyState.INACTIVE;
        }
        this.packageManager.updateAwayTime();
        if (!this.packageManager.getCloseSubscribers().isEmpty() || this.loadedChunks.size() > 40 && !this.packageManager.getImportantColonyPlayers().isEmpty()) {
            this.isDirty = true;
            return ColonyState.ACTIVE;
        }
        if (!this.packageManager.getImportantColonyPlayers().isEmpty() || this.forceLoadTimer > 0) {
            this.isDirty = true;
            return ColonyState.UNLOADED;
        }
        return ColonyState.INACTIVE;
    }

    private boolean updateSubscribers() {
        this.packageManager.updateSubscribers();
        return false;
    }

    private boolean tickRequests() {
        if (this.getRequestManager() != null) {
            this.getRequestManager().tick();
        }
        return false;
    }

    private boolean worldTickSlow() {
        long pastTime;
        this.buildingManager.cleanUpBuildings(this);
        this.citizenManager.onColonyTick(this);
        this.visitorManager.onColonyTick(this);
        this.updateAttackingPlayers();
        this.eventManager.onColonyTick(this);
        this.buildingManager.onColonyTick(this);
        this.graveManager.onColonyTick(this);
        this.workManager.onColonyTick(this);
        this.reproductionManager.onColonyTick(this);
        this.questManager.onColonyTick();
        long currTime = System.currentTimeMillis();
        if (this.lastOnlineTime != 0L && (pastTime = currTime - this.lastOnlineTime) > 3600000L) {
            for (IBuilding building : this.buildingManager.getBuildings().values()) {
                building.processOfflineTime(pastTime / 1000L);
            }
        }
        this.lastOnlineTime = currTime;
        this.updateChildTime();
        this.updateChunkLoadTimer();
        return false;
    }

    private void updateChunkLoadTimer() {
        if (((Boolean)MineColonies.getConfig().getServer().forceLoadColony.get()).booleanValue()) {
            for (ServerPlayer sub : this.getPackageManager().getCloseSubscribers()) {
                if (!this.getPermissions().hasPermission((Player)sub, Action.CAN_KEEP_COLONY_ACTIVE_WHILE_AWAY)) continue;
                this.forceLoadTimer = (Integer)MineColonies.getConfig().getServer().loadtime.get() * 20 * 60;
                this.pendingChunks.addAll(this.pendingToUnloadChunks);
                for (long pending : this.pendingChunks) {
                    this.checkChunkAndRegisterTicket(pending, this.world.m_6325_(ChunkPos.m_45592_((long)pending), ChunkPos.m_45602_((long)pending)));
                }
                this.pendingToUnloadChunks.clear();
                this.pendingChunks.clear();
                return;
            }
            if (this.forceLoadTimer > 0) {
                this.forceLoadTimer -= 500;
                if (this.forceLoadTimer <= 0) {
                    Iterator<Object> iterator = this.ticketedChunks.iterator();
                    while (iterator.hasNext()) {
                        long chunkPos = (Long)iterator.next();
                        int chunkX = ChunkPos.m_45592_((long)chunkPos);
                        int chunkZ = ChunkPos.m_45602_((long)chunkPos);
                        if (!(this.world instanceof ServerLevel)) continue;
                        ChunkPos pos = new ChunkPos(chunkX, chunkZ);
                        ((ServerChunkCache)this.world.m_7726_()).m_8438_(ColonyConstants.KEEP_LOADED_TYPE, pos, 2, (Object)pos);
                        this.pendingToUnloadChunks.add(chunkPos);
                    }
                    this.ticketedChunks.clear();
                    this.ticketedChunksDirty = true;
                }
            }
        }
    }

    private void checkChunkAndRegisterTicket(long chunkPos, LevelChunk chunk) {
        if (this.forceLoadTimer > 0 && this.world instanceof ServerLevel && !this.ticketedChunks.contains(chunkPos) && this.buildingManager.isWithinBuildingZone(chunk)) {
            this.ticketedChunks.add(chunkPos);
            this.ticketedChunksDirty = true;
            ((ServerChunkCache)this.world.m_7726_()).m_8387_(ColonyConstants.KEEP_LOADED_TYPE, chunk.m_7697_(), 2, (Object)chunk.m_7697_());
        }
    }

    private boolean worldTickUnloaded() {
        this.updateChildTime();
        this.updateChunkLoadTimer();
        return false;
    }

    private void updateChildTime() {
        this.additionalChildTime = this.hasChilds && this.additionalChildTime < 70000 ? (this.additionalChildTime += 500) : 0;
    }

    private boolean checkDayTime() {
        if (this.isDay && !WorldUtil.isDayTime(this.world)) {
            this.isDay = false;
            this.eventManager.onNightFall();
            this.raidManager.onNightFall();
            if (!this.packageManager.getCloseSubscribers().isEmpty()) {
                this.citizenManager.checkCitizensForHappiness();
            }
            this.citizenManager.updateCitizenSleep(false);
        } else if (!this.isDay && WorldUtil.isDayTime(this.world)) {
            this.isDay = true;
            ++this.day;
            this.citizenManager.onWakeUp();
        }
        return false;
    }

    public void updateAttackingPlayers() {
        ArrayList<Player> visitors = new ArrayList<Player>(this.visitingPlayers);
        for (Player player : visitors) {
            if (this.packageManager.getCloseSubscribers().contains(player)) continue;
            this.visitingPlayers.remove(player);
            this.attackingPlayers.remove(new AttackingPlayer(player));
        }
        for (AttackingPlayer attackingPlayer : this.attackingPlayers) {
            if (attackingPlayer.getGuards().isEmpty()) continue;
            attackingPlayer.refreshList(this);
            if (!attackingPlayer.getGuards().isEmpty()) continue;
            MessageUtils.format("com.minecolonies.coremod.pvp.defended.success", attackingPlayer.getPlayer().m_7755_()).sendTo(this).forManagers();
        }
    }

    @Override
    public PlayerTeam getTeam() {
        return this.checkOrCreateTeam();
    }

    private PlayerTeam checkOrCreateTeam() {
        if (this.world.m_6188_().m_83489_(this.getTeamName()) == null) {
            this.world.m_6188_().m_83492_(this.getTeamName());
            this.world.m_6188_().m_83489_(this.getTeamName()).m_83355_(false);
        }
        return this.world.m_6188_().m_83489_(this.getTeamName());
    }

    @Override
    public void setColonyColor(ChatFormatting colonyColor) {
        if (this.world != null) {
            this.checkOrCreateTeam();
            this.colonyTeamColor = colonyColor;
            this.world.m_6188_().m_83489_(this.getTeamName()).m_83351_(colonyColor);
            this.world.m_6188_().m_83489_(this.getTeamName()).m_83360_((Component)Component.m_237113_((String)colonyColor.toString()));
        }
        this.markDirty();
    }

    @Override
    public void setColonyFlag(ListTag colonyFlag) {
        this.colonyFlag = colonyFlag;
        this.markDirty();
    }

    @Nullable
    public static Colony loadColony(@NotNull CompoundTag compound, @Nullable Level world) {
        try {
            int id = compound.m_128451_("id");
            @NotNull Colony c = new Colony(id, world);
            c.name = compound.m_128461_("name");
            c.center = BlockPosUtil.read(compound, "center");
            c.dimensionId = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(compound.m_128461_("dimension")));
            c.setRequestManager();
            c.read(compound);
            return c;
        }
        catch (Exception e) {
            Log.getLogger().warn("Something went wrong loading a colony, please report this to the administrators", (Throwable)e);
            return null;
        }
    }

    private void setRequestManager() {
        this.requestManager = new StandardRequestManager(this);
    }

    @Override
    public void read(@NotNull CompoundTag compound) {
        this.manualHiring = compound.m_128471_("manualHiring");
        this.dimensionId = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(compound.m_128461_("dimension")));
        this.mercenaryLastUse = compound.m_128454_("mercenaryUseTime");
        this.additionalChildTime = compound.m_128451_("childTime");
        this.permissions.loadPermissions(compound);
        this.citizenManager.read(compound.m_128469_("citizenManager"));
        this.visitorManager.read(compound);
        this.buildingManager.read(compound.m_128469_("buildingManager"));
        this.citizenManager.calculateMaxCitizens();
        this.graveManager.read(compound.m_128469_("graveManager"));
        if (compound.m_128441_("progressManager")) {
            this.progressManager.read(compound);
        }
        this.eventManager.readFromNBT(compound);
        this.statisticManager.readFromNBT(compound);
        this.questManager.deserializeNBT((Tag)compound.m_128469_("quest_manager"));
        this.eventDescManager.deserializeNBT((Tag)compound.m_128469_("event_desc_manager"));
        if (compound.m_128441_("research")) {
            this.researchManager.readFromNBT(compound.m_128469_("research"));
            this.researchManager.checkAutoStartResearch();
        }
        this.workManager.read(compound.m_128469_("work"));
        this.wayPoints.clear();
        ListTag wayPointTagList = compound.m_128437_("waypoints", 10);
        for (int i = 0; i < wayPointTagList.size(); ++i) {
            CompoundTag blockAtPos = wayPointTagList.m_128728_(i);
            BlockPos pos = BlockPosUtil.read(blockAtPos, "waypoints");
            BlockState state = NbtUtils.m_129241_((CompoundTag)blockAtPos);
            this.wayPoints.put(pos, state);
        }
        this.freeBlocks.clear();
        ListTag freeBlockTagList = compound.m_128437_("freeBlocks", 8);
        for (int i = 0; i < freeBlockTagList.size(); ++i) {
            this.freeBlocks.add((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(freeBlockTagList.m_128778_(i))));
        }
        this.freePositions.clear();
        ListTag freePositionTagList = compound.m_128437_("freePositions", 10);
        for (int i = 0; i < freePositionTagList.size(); ++i) {
            CompoundTag blockTag = freePositionTagList.m_128728_(i);
            BlockPos block = BlockPosUtil.read(blockTag, "freePositions");
            this.freePositions.add(block);
        }
        this.packageManager.setLastContactInHours(compound.m_128451_("abandoned"));
        this.manualHousing = compound.m_128471_("manualHousing");
        if (compound.m_128441_("moveIn")) {
            this.moveIn = compound.m_128471_("moveIn");
        }
        this.pack = compound.m_128441_("style") ? BlueprintMapping.getStyleMapping(compound.m_128461_("style")) : compound.m_128461_("pack");
        this.raidManager.read(compound);
        this.canColonyBeAutoDeleted = compound.m_128441_("autoDelete") ? compound.m_128471_("autoDelete") : true;
        if (compound.m_128441_("teamcolor")) {
            this.colonyTeamColor = ChatFormatting.values()[compound.m_128451_("teamcolor")];
        }
        if (compound.m_128441_("colonyflag")) {
            this.setColonyFlag(compound.m_128437_("colonyflag", 10));
        }
        this.requestManager.reset();
        if (compound.m_128441_("requestManager")) {
            this.requestManager.deserializeNBT((Tag)compound.m_128469_("requestManager"));
        }
        this.lastOnlineTime = compound.m_128454_("lastOnlineTime");
        if (compound.m_128441_("textstyle")) {
            this.textureStyle = compound.m_128461_("textstyle");
        }
        if (compound.m_128441_("namestyle")) {
            this.nameStyle = compound.m_128461_("namestyle");
        }
        this.day = compound.m_128451_("colonyday");
        this.colonyTag = compound;
    }

    public ColonyPermissionEventHandler getEventHandler() {
        return this.eventHandler;
    }

    @Override
    public CompoundTag write(@NotNull CompoundTag compound) {
        compound.m_128405_("id", this.id);
        compound.m_128359_("dimension", this.dimensionId.m_135782_().toString());
        compound.m_128359_("name", this.name);
        BlockPosUtil.write(compound, "center", this.center);
        compound.m_128379_("manualHiring", this.manualHiring);
        compound.m_128356_("mercenaryUseTime", this.mercenaryLastUse);
        compound.m_128405_("childTime", this.additionalChildTime);
        this.permissions.savePermissions(compound);
        CompoundTag buildingCompound = new CompoundTag();
        this.buildingManager.write(buildingCompound);
        compound.m_128365_("buildingManager", (Tag)buildingCompound);
        CompoundTag citizenCompound = new CompoundTag();
        this.citizenManager.write(citizenCompound);
        compound.m_128365_("citizenManager", (Tag)citizenCompound);
        this.visitorManager.write(compound);
        CompoundTag graveCompound = new CompoundTag();
        this.graveManager.write(graveCompound);
        compound.m_128365_("graveManager", (Tag)graveCompound);
        @NotNull CompoundTag workManagerCompound = new CompoundTag();
        this.workManager.write(workManagerCompound);
        compound.m_128365_("work", (Tag)workManagerCompound);
        this.progressManager.write(compound);
        this.eventManager.writeToNBT(compound);
        this.statisticManager.writeToNBT(compound);
        compound.m_128365_("quest_manager", this.questManager.serializeNBT());
        compound.m_128365_("event_desc_manager", this.eventDescManager.serializeNBT());
        this.raidManager.write(compound);
        @NotNull CompoundTag researchManagerCompound = new CompoundTag();
        this.researchManager.writeToNBT(researchManagerCompound);
        compound.m_128365_("research", (Tag)researchManagerCompound);
        @NotNull ListTag wayPointTagList = new ListTag();
        for (Map.Entry<BlockPos, BlockState> entry : this.wayPoints.entrySet()) {
            @NotNull CompoundTag wayPointCompound = new CompoundTag();
            BlockPosUtil.write(wayPointCompound, "waypoints", entry.getKey());
            wayPointCompound.m_128365_("block", (Tag)NbtUtils.m_129202_((BlockState)entry.getValue()));
            wayPointTagList.add((Object)wayPointCompound);
        }
        compound.m_128365_("waypoints", (Tag)wayPointTagList);
        @NotNull ListTag freeBlocksTagList = new ListTag();
        for (Block block : this.freeBlocks) {
            freeBlocksTagList.add((Object)StringTag.m_129297_((String)ForgeRegistries.BLOCKS.getKey((Object)block).toString()));
        }
        compound.m_128365_("freeBlocks", (Tag)freeBlocksTagList);
        @NotNull ListTag listTag = new ListTag();
        for (BlockPos pos : this.freePositions) {
            @NotNull CompoundTag wayPointCompound = new CompoundTag();
            BlockPosUtil.write(wayPointCompound, "freePositions", pos);
            listTag.add((Object)wayPointCompound);
        }
        compound.m_128365_("freePositions", (Tag)listTag);
        compound.m_128405_("abandoned", this.packageManager.getLastContactInHours());
        compound.m_128379_("manualHousing", this.manualHousing);
        compound.m_128379_("moveIn", this.moveIn);
        compound.m_128365_("requestManager", this.getRequestManager().serializeNBT());
        compound.m_128359_("pack", this.pack);
        compound.m_128379_("autoDelete", this.canColonyBeAutoDeleted);
        compound.m_128405_("teamcolor", this.colonyTeamColor.ordinal());
        compound.m_128365_("colonyflag", (Tag)this.colonyFlag);
        compound.m_128356_("lastOnlineTime", this.lastOnlineTime);
        compound.m_128359_("textstyle", this.textureStyle);
        compound.m_128359_("namestyle", this.nameStyle);
        compound.m_128405_("colonyday", this.day);
        this.colonyTag = compound;
        this.isDirty = false;
        return compound;
    }

    @Override
    public ResourceKey<Level> getDimension() {
        return this.dimensionId;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public IResearchManager getResearchManager() {
        return this.researchManager;
    }

    @Override
    public void onWorldLoad(@NotNull Level w) {
        if (w.m_46472_() == this.dimensionId) {
            this.world = w;
            if (this.eventHandler == null) {
                this.eventHandler = new ColonyPermissionEventHandler(this);
                this.questManager.onWorldLoad();
                MinecraftForge.EVENT_BUS.register((Object)this.eventHandler);
            }
            this.setColonyColor(this.colonyTeamColor);
        }
    }

    @Override
    public void onWorldUnload(@NotNull Level w) {
        if (w != this.world) {
            return;
        }
        if (this.eventHandler != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)this.eventHandler);
        }
        this.world = null;
    }

    @Override
    public void onServerTick(@NotNull TickEvent.ServerTickEvent event) {
    }

    @Override
    @NotNull
    public IWorkManager getWorkManager() {
        return this.workManager;
    }

    public Set<BlockPos> getFreePositions() {
        return new HashSet<BlockPos>(this.freePositions);
    }

    public Set<Block> getFreeBlocks() {
        return new HashSet<Block>(this.freeBlocks);
    }

    @Override
    public void addFreePosition(@NotNull BlockPos pos) {
        this.freePositions.add(pos);
        this.markDirty();
    }

    @Override
    public void addFreeBlock(@NotNull Block block) {
        this.freeBlocks.add(block);
        this.markDirty();
    }

    @Override
    public void removeFreePosition(@NotNull BlockPos pos) {
        this.freePositions.remove(pos);
        this.markDirty();
    }

    @Override
    public void removeFreeBlock(@NotNull Block block) {
        this.freeBlocks.remove(block);
        this.markDirty();
    }

    @Override
    public void onWorldTick(@NotNull TickEvent.LevelTickEvent event) {
        if (event.level != this.getWorld()) {
            return;
        }
        this.colonyStateMachine.tick();
    }

    public static boolean shallUpdate(Level world, int averageTicks) {
        return world.m_46467_() % (long)(world.f_46441_.m_188503_(averageTicks * 2) + 1) == 0L;
    }

    private boolean updateWayPoints() {
        if (!this.wayPoints.isEmpty() && this.world != null) {
            int randomPos = this.world.f_46441_.m_188503_(this.wayPoints.size());
            int count = 0;
            for (Map.Entry<BlockPos, BlockState> entry : this.wayPoints.entrySet()) {
                Block worldBlock;
                if (count++ != randomPos) continue;
                if (WorldUtil.isBlockLoaded((LevelAccessor)this.world, entry.getKey()) && ((worldBlock = this.world.m_8055_(entry.getKey()).m_60734_()) != entry.getValue().m_60734_() && entry.getValue().m_60734_() != ModBlocks.blockWayPoint && worldBlock != ModBlocks.blockConstructionTape || this.world.m_46859_(entry.getKey().m_7495_()) && !entry.getValue().m_60767_().m_76333_())) {
                    this.wayPoints.remove(entry.getKey());
                    this.markDirty();
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public BlockPos getCenter() {
        return this.center;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String n) {
        this.name = n;
        this.markDirty();
    }

    @Override
    @NotNull
    public Permissions getPermissions() {
        return this.permissions;
    }

    @Override
    public boolean isCoordInColony(@NotNull Level w, @NotNull BlockPos pos) {
        if (w.m_46472_() != this.dimensionId) {
            return false;
        }
        LevelChunk chunk = w.m_46745_(pos);
        IColonyTagCapability cap = chunk.getCapability(CLOSE_COLONY_CAP, null).resolve().orElse(null);
        return cap != null && cap.getOwningColony() == this.getID();
    }

    @Override
    public long getDistanceSquared(@NotNull BlockPos pos) {
        return BlockPosUtil.getDistanceSquared2D(this.center, pos);
    }

    @Override
    public boolean hasTownHall() {
        return this.buildingManager.hasTownHall();
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public boolean hasWarehouse() {
        return this.buildingManager.hasWarehouse();
    }

    @Override
    public boolean hasBuilding(String name, int level, boolean singleBuilding) {
        int sum = 0;
        for (IBuilding building : this.getBuildingManager().getBuildings().values()) {
            if (!building.getBuildingType().getRegistryName().m_135815_().equalsIgnoreCase(name) || !(singleBuilding ? building.getBuildingLevel() >= level : (sum += building.getBuildingLevel()) >= level)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getLastContactInHours() {
        return this.packageManager.getLastContactInHours();
    }

    @Override
    @Nullable
    public Level getWorld() {
        return this.world;
    }

    @Override
    @NotNull
    public IRequestManager getRequestManager() {
        return this.requestManager;
    }

    @Override
    public void markDirty() {
        this.packageManager.setDirty();
        this.isDirty = true;
    }

    @Override
    public boolean canBeAutoDeleted() {
        return this.canColonyBeAutoDeleted;
    }

    @Override
    @Nullable
    public IRequester getRequesterBuildingForPosition(@NotNull BlockPos pos) {
        return this.buildingManager.getBuilding(pos);
    }

    @Override
    @NotNull
    public List<Player> getMessagePlayerEntities() {
        ArrayList<Player> players = new ArrayList<Player>();
        for (ServerPlayer player : this.packageManager.getCloseSubscribers()) {
            if (!this.permissions.hasPermission((Player)player, Action.RECEIVE_MESSAGES)) continue;
            players.add((Player)player);
        }
        return players;
    }

    @Override
    @NotNull
    public List<Player> getImportantMessageEntityPlayers() {
        HashSet<Player> playerList = new HashSet<Player>(this.getMessagePlayerEntities());
        for (ServerPlayer player : this.packageManager.getImportantColonyPlayers()) {
            if (!this.permissions.hasPermission((Player)player, Action.RECEIVE_MESSAGES_FAR_AWAY)) continue;
            playerList.add((Player)player);
        }
        return new ArrayList<Player>(playerList);
    }

    @Override
    public boolean isManualHiring() {
        return this.manualHiring;
    }

    @Override
    public void setManualHiring(boolean manualHiring) {
        this.manualHiring = manualHiring;
        this.progressManager.progressEmploymentModeChange();
        this.markDirty();
    }

    @Override
    public boolean isManualHousing() {
        return this.manualHousing;
    }

    @Override
    public void setManualHousing(boolean manualHousing) {
        this.manualHousing = manualHousing;
        this.markDirty();
    }

    @Override
    public boolean canMoveIn() {
        return this.moveIn;
    }

    @Override
    public void setMoveIn(boolean newMoveIn) {
        this.moveIn = newMoveIn;
        this.markDirty();
    }

    public void removeWorkOrderInView(int orderId) {
        for (ServerPlayer player : this.packageManager.getCloseSubscribers()) {
            Network.getNetwork().sendToPlayer(new ColonyViewRemoveWorkOrderMessage(this, orderId), player);
        }
    }

    @Override
    public void addWayPoint(BlockPos point, BlockState block) {
        this.wayPoints.put(point, block);
        this.markDirty();
    }

    @Override
    public double getOverallHappiness() {
        if (this.citizenManager.getCitizens().size() <= 0) {
            return 5.5;
        }
        double happinessSum = 0.0;
        for (ICitizenData citizen : this.citizenManager.getCitizens()) {
            happinessSum += citizen.getCitizenHappinessHandler().getHappiness(citizen.getColony(), citizen);
        }
        return happinessSum / (double)this.citizenManager.getCitizens().size();
    }

    @Override
    public Map<BlockPos, BlockState> getWayPoints() {
        return new HashMap<BlockPos, BlockState>(this.wayPoints);
    }

    @Override
    public void setCanBeAutoDeleted(boolean canBeDeleted) {
        this.canColonyBeAutoDeleted = canBeDeleted;
        this.markDirty();
    }

    @Override
    public String getStructurePack() {
        return this.pack;
    }

    @Override
    public void setStructurePack(String style) {
        this.pack = style;
        this.markDirty();
    }

    @Override
    public IRegisteredStructureManager getBuildingManager() {
        return this.buildingManager;
    }

    @Override
    public IGraveManager getGraveManager() {
        return this.graveManager;
    }

    @Override
    public ICitizenManager getCitizenManager() {
        return this.citizenManager;
    }

    @Override
    public IVisitorManager getVisitorManager() {
        return this.visitorManager;
    }

    @Override
    public IRaiderManager getRaiderManager() {
        return this.raidManager;
    }

    @Override
    public IEventManager getEventManager() {
        return this.eventManager;
    }

    @Override
    public IStatisticsManager getStatisticsManager() {
        return this.statisticManager;
    }

    @Override
    public IReproductionManager getReproductionManager() {
        return this.reproductionManager;
    }

    @Override
    public IEventDescriptionManager getEventDescriptionManager() {
        return this.eventDescManager;
    }

    @Override
    public IColonyPackageManager getPackageManager() {
        return this.packageManager;
    }

    @Override
    public IProgressManager getProgressManager() {
        return this.progressManager;
    }

    public ImmutableList<Player> getVisitingPlayers() {
        return ImmutableList.copyOf(this.visitingPlayers);
    }

    @Override
    public void addVisitingPlayer(Player player) {
        Rank rank = this.getPermissions().getRank(player);
        if (!rank.isColonyManager() && !this.visitingPlayers.contains(player) && ((Boolean)MineColonies.getConfig().getServer().sendEnteringLeavingMessages.get()).booleanValue()) {
            this.visitingPlayers.add(player);
            if (!this.getImportantMessageEntityPlayers().contains(player)) {
                MessageUtils.format("com.minecolonies.coremod.enteringcolony", this.getName()).sendTo(player);
            }
            MessageUtils.format("com.minecolonies.coremod.enteringcolonynotify", player.m_7755_()).sendTo(this, true).forManagers();
        }
    }

    @Override
    public void removeVisitingPlayer(Player player) {
        if (this.visitingPlayers.contains(player) && ((Boolean)MineColonies.getConfig().getServer().sendEnteringLeavingMessages.get()).booleanValue()) {
            this.visitingPlayers.remove(player);
            if (!this.getImportantMessageEntityPlayers().contains(player)) {
                MessageUtils.format("com.minecolonies.coremod.leavingcolony", this.getName()).sendTo(player);
            }
            MessageUtils.format("com.minecolonies.coremod.leavingcolonynotify", player.m_7755_()).sendTo(this, true).forManagers();
        }
    }

    @Override
    public CompoundTag getColonyTag() {
        try {
            if (this.colonyTag == null || this.isDirty) {
                this.write(new CompoundTag());
            }
        }
        catch (Exception e) {
            Log.getLogger().warn("Something went wrong persisting colony: " + this.id, (Throwable)e);
        }
        return this.colonyTag;
    }

    @Override
    public boolean isValidAttackingPlayer(Player player) {
        if (this.packageManager.getLastContactInHours() > 1) {
            return false;
        }
        for (AttackingPlayer attackingPlayer : this.attackingPlayers) {
            if (!attackingPlayer.getPlayer().equals((Object)player)) continue;
            return attackingPlayer.isValidAttack(this);
        }
        return false;
    }

    @Override
    public boolean isValidAttackingGuard(AbstractEntityCitizen entity) {
        if (this.packageManager.getLastContactInHours() > 1) {
            return false;
        }
        return AttackingPlayer.isValidAttack(entity, this);
    }

    @Override
    public void addGuardToAttackers(AbstractEntityCitizen IEntityCitizen, Player player) {
        if (player == null) {
            return;
        }
        for (AttackingPlayer attackingPlayer : this.attackingPlayers) {
            if (!attackingPlayer.getPlayer().equals((Object)player)) continue;
            if (attackingPlayer.addGuard(IEntityCitizen)) {
                MessageUtils.format("com.minecolonies.coremod.pvp.attack.guardgroupsize", attackingPlayer.getPlayer().m_7755_(), attackingPlayer.getGuards().size()).sendTo(this).forManagers();
            }
            return;
        }
        for (Player visitingPlayer : this.visitingPlayers) {
            if (!visitingPlayer.equals((Object)player)) continue;
            AttackingPlayer attackingPlayer = new AttackingPlayer(visitingPlayer);
            attackingPlayer.addGuard(IEntityCitizen);
            this.attackingPlayers.add(attackingPlayer);
            MessageUtils.format("com.minecolonies.coremod.pvp.attack.start", visitingPlayer.m_7755_()).sendTo(this).forManagers();
        }
    }

    @Override
    public boolean isColonyUnderAttack() {
        return !this.attackingPlayers.isEmpty();
    }

    @Override
    public ChatFormatting getTeamColonyColor() {
        return this.colonyTeamColor;
    }

    @Override
    public ListTag getColonyFlag() {
        return this.colonyFlag;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    @Override
    public void usedMercenaries() {
        this.mercenaryLastUse = this.world.m_46467_();
        this.markDirty();
    }

    @Override
    public long getMercenaryUseTime() {
        return this.mercenaryLastUse;
    }

    @Override
    public boolean useAdditionalChildTime(int amount) {
        if (this.additionalChildTime < amount) {
            return false;
        }
        this.additionalChildTime -= amount;
        return true;
    }

    @Override
    public void updateHasChilds() {
        for (ICitizenData data : this.getCitizenManager().getCitizens()) {
            if (!data.isChild()) continue;
            this.hasChilds = true;
            return;
        }
        this.hasChilds = false;
    }

    @Override
    public void addLoadedChunk(long chunkPos, LevelChunk chunk) {
        if (this.world instanceof ServerLevel && ((Boolean)MineColonies.getConfig().getServer().forceLoadColony.get()).booleanValue()) {
            if (this.forceLoadTimer > 0) {
                this.checkChunkAndRegisterTicket(chunkPos, chunk);
            } else {
                this.pendingChunks.add(chunkPos);
            }
        }
        this.loadedChunks.add(chunkPos);
    }

    @Override
    public void removeLoadedChunk(long chunkPos) {
        this.loadedChunks.remove(chunkPos);
        this.pendingToUnloadChunks.remove(chunkPos);
    }

    @Override
    public int getLoadedChunkCount() {
        return this.loadedChunks.size();
    }

    @Override
    public Set<Long> getLoadedChunks() {
        return this.loadedChunks;
    }

    @Override
    public ColonyState getState() {
        return (ColonyState)this.colonyStateMachine.getState();
    }

    @Override
    public boolean isActive() {
        return this.colonyStateMachine.getState() != ColonyState.INACTIVE;
    }

    @Override
    public boolean isDay() {
        return this.isDay;
    }

    @Override
    public Set<Long> getTicketedChunks() {
        return this.ticketedChunks;
    }

    @Override
    public void setTextureStyle(String style) {
        this.textureStyle = style;
        this.markDirty();
    }

    @Override
    public String getTextureStyleId() {
        return this.textureStyle;
    }

    @Override
    public void setNameStyle(String style) {
        this.nameStyle = style;
        this.markDirty();
    }

    @Override
    public String getNameStyle() {
        return this.nameStyle;
    }

    @Override
    public CitizenNameFile getCitizenNameFile() {
        return CitizenNameListener.nameFileMap.getOrDefault(this.nameStyle, CitizenNameListener.nameFileMap.get("default"));
    }

    public boolean isTicketedChunksDirty() {
        return this.ticketedChunksDirty;
    }

    @Override
    public int getDay() {
        return this.day;
    }

    @Override
    public IQuestManager getQuestManager() {
        return this.questManager;
    }

    @Override
    public ICitizen getCitizen(int id) {
        return this.citizenManager.getCivilian(id);
    }
}

