/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.tileentities.TileEntityRack;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.render.worldevent.HighlightManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class WindowHutAllInventory
extends AbstractWindowSkeleton {
    List<ItemStorage> allItems = new ArrayList<ItemStorage>();
    private final ScrollingList stackList;
    private String filter = "";
    private int sortDescriptor = 0;
    private final IBuildingView building;
    private final BOWindow prev;
    private int tick;

    public WindowHutAllInventory(IBuildingView b, BOWindow prev) {
        super("minecolonies:gui/windowhutallinventory.xml");
        this.building = b;
        this.registerButton("sortStorageFilter", this::setSortFlag);
        this.registerButton("back", this::back);
        this.stackList = (ScrollingList)this.findPaneOfTypeByID("allinventorylist", ScrollingList.class);
        this.updateResources();
        this.registerButton("locate", this::locate);
        this.prev = prev;
        ((TextField)this.window.findPaneOfTypeByID("names", TextField.class)).setHandler(input -> {
            String newFilter = input.getText();
            if (!newFilter.equals(this.filter)) {
                this.filter = newFilter;
                this.tick = 10;
            }
        });
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.tick > 0 && --this.tick == 0) {
            this.updateResources();
        }
    }

    private void locate(Button button) {
        int row = this.stackList.getListElementIndexByPane((Pane)button);
        ItemStorage storage = this.allItems.get(row);
        HashSet<BlockPos> containerList = new HashSet<BlockPos>(this.building.getContainerList());
        containerList.add(this.building.getID());
        HighlightManager.clearCategory("inventoryHighlight");
        MessageUtils.format("com.minecolonies.coremod.locating", new Object[0]).sendTo(new Player[]{Minecraft.m_91087_().f_91074_});
        this.close();
        for (BlockPos blockPos : containerList) {
            int count;
            BlockEntity rack = Minecraft.m_91087_().f_91073_.m_7702_(blockPos);
            if (!(rack instanceof TileEntityRack) || (count = ((TileEntityRack)rack).getCount(storage.getItemStack(), storage.ignoreDamageValue(), false)) <= 0) continue;
            int color = 0x40000000 | Mth.m_14045_((int)((int)(255.0f * (2.0f - (float)count / 32.0f))), (int)0, (int)255) << 16 | Mth.m_14045_((int)((int)((float)(255 * count) / 32.0f)), (int)0, (int)255) << 8;
            HighlightManager.addRenderBox("inventoryHighlight", new HighlightManager.TimedBoxRenderData().setPos(blockPos).setRemovalTimePoint(Minecraft.m_91087_().f_91073_.m_46467_() + 1200L).addText("" + count).setColor(color));
        }
    }

    private void back() {
        this.close();
        this.prev.open();
    }

    private void setSortFlag() {
        ++this.sortDescriptor;
        if (this.sortDescriptor > 4) {
            this.sortDescriptor = 0;
        }
        switch (this.sortDescriptor) {
            case 0: {
                ((ButtonImage)this.findPaneOfTypeByID("sortStorageFilter", ButtonImage.class)).setText(Component.m_237113_((String)"v^"));
                break;
            }
            case 1: {
                ((ButtonImage)this.findPaneOfTypeByID("sortStorageFilter", ButtonImage.class)).setText(Component.m_237113_((String)"A^"));
                break;
            }
            case 2: {
                ((ButtonImage)this.findPaneOfTypeByID("sortStorageFilter", ButtonImage.class)).setText(Component.m_237113_((String)"Av"));
                break;
            }
            case 3: {
                ((ButtonImage)this.findPaneOfTypeByID("sortStorageFilter", ButtonImage.class)).setText(Component.m_237113_((String)"1^"));
                break;
            }
            case 4: {
                ((ButtonImage)this.findPaneOfTypeByID("sortStorageFilter", ButtonImage.class)).setText(Component.m_237113_((String)"1v"));
                break;
            }
        }
        this.updateResources();
    }

    private void updateResources() {
        HashSet<BlockPos> containerList = new HashSet<BlockPos>(this.building.getContainerList());
        HashMap<ItemStorage, Integer> storedItems = new HashMap<ItemStorage, Integer>();
        Level world = this.building.getColony().getWorld();
        containerList.add(this.building.getPosition());
        for (BlockPos blockPos : containerList) {
            BlockEntity rack = world.m_7702_(blockPos);
            if (!(rack instanceof TileEntityRack)) continue;
            Map<ItemStorage, Integer> rackStorage = ((TileEntityRack)rack).getAllContent();
            for (Map.Entry<ItemStorage, Integer> entry : rackStorage.entrySet()) {
                if (storedItems.containsKey(entry.getKey())) {
                    storedItems.put(entry.getKey(), (Integer)storedItems.get(entry.getKey()) + entry.getValue());
                    continue;
                }
                storedItems.put(entry.getKey(), entry.getValue());
            }
        }
        ArrayList filterItems = new ArrayList();
        storedItems.forEach((storage, amount) -> {
            storage.setAmount((int)amount);
            filterItems.add(storage);
        });
        Predicate<ItemStorage> filterPredicate = stack -> this.filter.isEmpty() || stack.getItemStack().m_41778_().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || WindowHutAllInventory.getString(stack.getItemStack()).toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US));
        this.allItems.clear();
        if (this.filter.isEmpty()) {
            this.allItems.addAll(filterItems);
        } else {
            this.allItems.addAll(filterItems.stream().filter(filterPredicate).collect(Collectors.toList()));
        }
        this.allItems.sort(Comparator.comparingInt(s1 -> StringUtils.getLevenshteinDistance((CharSequence)s1.getItemStack().m_41786_().getString(), (CharSequence)this.filter)));
        Comparator<ItemStorage> compareByName = Comparator.comparing(o -> o.getItemStack().m_41786_().getString());
        Comparator<ItemStorage> compareByCount = Comparator.comparingInt(ItemStorage::getAmount);
        switch (this.sortDescriptor) {
            case 0: {
                break;
            }
            case 1: {
                this.allItems.sort(compareByName);
                break;
            }
            case 2: {
                this.allItems.sort(compareByName.reversed());
                break;
            }
            case 3: {
                this.allItems.sort(compareByCount);
                break;
            }
            case 4: {
                this.allItems.sort(compareByCount.reversed());
                break;
            }
        }
        this.updateResourceList();
    }

    private static String getString(ItemStack stack) {
        StringBuilder output = new StringBuilder();
        for (Component comp : stack.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.Default.NORMAL)) {
            output.append(comp.getString()).append(" ");
        }
        return output.toString();
    }

    private void updateResourceList() {
        this.stackList.enable();
        this.stackList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowHutAllInventory.this.allItems.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStorage resource = WindowHutAllInventory.this.allItems.get(index);
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("ressourceStackName", Text.class);
                String name = resource.getItemStack().m_41786_().getString();
                resourceLabel.setText(Component.m_237113_((String)name.substring(0, Math.min(17, name.length()))));
                Text qtys = (Text)rowPane.findPaneOfTypeByID("quantities", Text.class);
                if (!Screen.m_96638_()) {
                    qtys.setText(Component.m_237113_((String)Utils.format(resource.getAmount())));
                } else {
                    qtys.setText(Component.m_237113_((String)Integer.toString(resource.getAmount())));
                }
                Item imagesrc = resource.getItemStack().m_41720_();
                ItemStack image = new ItemStack((ItemLike)imagesrc, 1);
                image.m_41751_(resource.getItemStack().m_41783_());
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(image);
            }
        });
    }
}

