/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.citizen;

import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.entity.pathfinding.IStuckHandlerEntity;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.sounds.SoundManager;
import com.minecolonies.api.util.SoundUtils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.ITeleporter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCivilianEntity
extends AgeableMob
implements Npc,
IStuckHandlerEntity {
    private boolean canBeStuck = true;
    protected long nextPlayerCollisionTime = 0L;
    private SoundManager soundManager;

    protected AbstractCivilianEntity(EntityType<? extends AgeableMob> type, Level worldIn) {
        super(type, worldIn);
        if (worldIn.f_46443_) {
            this.soundManager = new SoundManager((ClientLevel)worldIn);
        }
    }

    public abstract void setCivilianData(@Nullable ICivilianData var1);

    public abstract ICivilianData getCivilianData();

    public abstract void markDirty();

    public abstract int getCivilianID();

    public abstract void setCitizenId(int var1);

    public boolean m_6573_(Player player) {
        return false;
    }

    @Override
    public boolean canBeStuck() {
        return this.canBeStuck;
    }

    public void setCanBeStuck(boolean canBeStuck) {
        this.canBeStuck = canBeStuck;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.soundManager.tick();
        }
    }

    public void m_7334_(@NotNull Entity entityIn) {
        if (entityIn instanceof ServerPlayer) {
            this.onPlayerCollide((Player)entityIn);
        }
        super.m_7334_(entityIn);
    }

    public void onPlayerCollide(Player player) {
        if (player.f_19853_.m_46467_() > this.nextPlayerCollisionTime) {
            this.nextPlayerCollisionTime = player.f_19853_.m_46467_() + 300L;
            this.m_21573_().m_26573_();
            this.m_21563_().m_148051_((Entity)player);
            SoundUtils.playSoundAtCitizenWith(this.f_19853_, this.m_20183_(), EventType.GREETING, this.getCivilianData());
        }
    }

    public SoundManager getSoundManager() {
        return this.soundManager;
    }

    protected void m_147225_() {
    }

    protected void m_147226_() {
    }

    @Nullable
    public Entity changeDimension(@NotNull ServerLevel serverWorld, @NotNull ITeleporter teleporter) {
        return null;
    }
}

