/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeCraftingType<C extends Container, T extends Recipe<C>>
extends CraftingType {
    private final RecipeType<T> recipeType;
    private final Predicate<T> predicate;

    public RecipeCraftingType(@NotNull ResourceLocation id, @NotNull RecipeType<T> recipeType, @Nullable Predicate<T> predicate) {
        super(id);
        this.recipeType = recipeType;
        this.predicate = predicate;
    }

    @Override
    @NotNull
    public List<IGenericRecipe> findRecipes(@NotNull RecipeManager recipeManager, @Nullable Level world) {
        ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>();
        for (Recipe recipe : recipeManager.m_44013_(this.recipeType)) {
            if (this.predicate != null && !this.predicate.test(recipe)) continue;
            RecipeCraftingType.tryAddingVanillaRecipe(recipes, recipe, world);
        }
        return recipes;
    }

    private static void tryAddingVanillaRecipe(@NotNull List<IGenericRecipe> recipes, @NotNull Recipe<?> recipe, @Nullable Level world) {
        if (recipe.m_5598_() || recipe.m_8043_().m_41619_()) {
            return;
        }
        try {
            IGenericRecipe genericRecipe = GenericRecipe.of(recipe, world);
            if (genericRecipe == null || genericRecipe.getInputs().isEmpty()) {
                return;
            }
            recipes.add(genericRecipe);
        }
        catch (Exception ex) {
            Log.getLogger().warn("Error evaluating recipe " + recipe.m_6423_() + "; ignoring.", (Throwable)ex);
        }
    }
}

