/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.managers.interfaces;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IMysticalSite;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHall;
import com.minecolonies.api.colony.buildings.workerbuildings.IWareHouse;
import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IRegisteredStructureManager {
    public void read(@NotNull CompoundTag var1);

    public void write(@NotNull CompoundTag var1);

    public void clearDirty();

    public void sendPackets(Set<ServerPlayer> var1, Set<ServerPlayer> var2);

    public void onColonyTick(IColony var1);

    public void cleanUpBuildings(IColony var1);

    public IBuilding getBuilding(BlockPos var1);

    public List<BlockPos> getLeisureSites();

    @Nullable
    public BlockPos getFirstBuildingMatching(Predicate<IBuilding> var1);

    public void addLeisureSite(BlockPos var1);

    public void removeLeisureSite(BlockPos var1);

    @Nullable
    public IWareHouse getClosestWarehouseInColony(BlockPos var1);

    @NotNull
    public Map<BlockPos, IBuilding> getBuildings();

    public ITownHall getTownHall();

    public int getMysticalSiteMaxBuildingLevel();

    public boolean hasWarehouse();

    public boolean hasMysticalSite();

    public boolean hasTownHall();

    @Nullable
    public <B extends IBuilding> B getBuilding(BlockPos var1, @NotNull Class<B> var2);

    public void removeBuilding(@NotNull IBuilding var1, Set<ServerPlayer> var2);

    public void markBuildingsDirty();

    @Nullable
    public IBuilding addNewBuilding(@NotNull AbstractTileEntityColonyBuilding var1, Level var2);

    public BlockPos getBestBuilding(AbstractEntityCitizen var1, Class<? extends IBuilding> var2);

    public BlockPos getBestBuilding(BlockPos var1, Class<? extends IBuilding> var2);

    public BlockPos getRandomBuilding(Predicate<IBuilding> var1);

    public boolean hasGuardBuildingNear(IBuilding var1);

    public void guardBuildingChangedAt(IBuilding var1, int var2);

    public void setTownHall(@Nullable ITownHall var1);

    public void removeWareHouse(IWareHouse var1);

    public List<IWareHouse> getWareHouses();

    public void removeMysticalSite(IMysticalSite var1);

    public List<IMysticalSite> getMysticalSites();

    public boolean canPlaceAt(Block var1, BlockPos var2, Player var3);

    public boolean isWithinBuildingZone(LevelChunk var1);

    public IBuilding getHouseWithSpareBed();

    public void onBuildingUpgradeComplete(@Nullable IBuilding var1, int var2);

    public BlockPos getRandomLeisureSite();

    public void trackBuildingLevelUp(@NotNull BuildingEntry var1, @NotNull IQuestInstance var2);

    public void stopTrackingBuildingLevelUp(@NotNull BuildingEntry var1, @NotNull IQuestInstance var2);

    @NotNull
    public List<IField> getFields(Predicate<IField> var1);

    public Optional<IField> getField(Predicate<IField> var1);

    public boolean addField(IField var1);

    public void removeField(Predicate<IField> var1);
}

