/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.blocks;

import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.blocks.interfaces.IAnchorBlock;
import com.ldtteam.structurize.blocks.interfaces.IInvisibleBlueprintAnchorBlock;
import com.ldtteam.structurize.blocks.interfaces.ILeveledBlueprintAnchorBlock;
import com.ldtteam.structurize.blocks.interfaces.INamedBlueprintAnchorBlock;
import com.ldtteam.structurize.blocks.interfaces.IRequirementsBlueprintAnchorBlock;
import com.ldtteam.structurize.blocks.interfaces.ISpecialCreativeHandlerAnchorBlock;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.placement.structure.AbstractStructureHandler;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.blocks.AbstractBlockMinecolonies;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.blocks.interfaces.IBuildingBrowsableBlock;
import com.minecolonies.api.blocks.interfaces.ITickableBlockMinecolonies;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyTagCapability;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.entity.ai.citizen.builder.IBuilderUndestroyable;
import com.minecolonies.api.items.ItemBlockHut;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.CreativeBuildingStructureHandler;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.SoundUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBlockHut<B extends AbstractBlockHut<B>>
extends AbstractBlockMinecolonies<B>
implements IBuilderUndestroyable,
IAnchorBlock,
ITickableBlockMinecolonies,
INamedBlueprintAnchorBlock,
ILeveledBlueprintAnchorBlock,
IRequirementsBlueprintAnchorBlock,
IInvisibleBlueprintAnchorBlock,
ISpecialCreativeHandlerAnchorBlock,
IBuildingBrowsableBlock {
    private static final int HARDNESS_PVP_FACTOR = 4;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final float HARDNESS = 10.0f;
    public static final float RESISTANCE = Float.POSITIVE_INFINITY;
    private static final VoxelShape SHAPE = Shapes.m_83048_((double)0.1, (double)0.1, (double)0.1, (double)0.9, (double)0.9, (double)0.9);
    private final String name;
    private long lastBreakTickWarn = 0L;

    public AbstractBlockHut() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(10.0f, Float.POSITIVE_INFINITY).m_60955_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        this.name = this.getHutName();
    }

    public float m_5880_(BlockState state, @NotNull Player player, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        IBuilding building = IColonyManager.getInstance().getBuilding(player.f_19853_, pos);
        if (building != null && !building.getChildren().isEmpty() && player.f_19853_.m_46467_() - this.lastBreakTickWarn < 100L) {
            this.lastBreakTickWarn = player.f_19853_.m_46467_();
            MessageUtils.format("block.minecolonies.blockhut.breakwarn.children", new Object[0]).sendTo(player);
        }
        return ((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getServer().pvp_mode.get() != false ? 0.025f : 0.1f) / 30.0f;
    }

    public AbstractBlockHut(BlockBehaviour.Properties properties) {
        super(properties.m_60955_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        this.name = this.getHutName();
    }

    public abstract String getHutName();

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        TileEntityColonyBuilding building = (TileEntityColonyBuilding)((BlockEntityType)MinecoloniesTileEntities.BUILDING.get()).m_155264_(blockPos, blockState);
        building.registryName = this.getBuildingEntry().getRegistryName();
        return building;
    }

    public abstract BuildingEntry getBuildingEntry();

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (worldIn.f_46443_) {
            TileEntityColonyBuilding te;
            if (hand == InteractionHand.OFF_HAND) {
                return InteractionResult.FAIL;
            }
            @Nullable IBuildingView building = IColonyManager.getInstance().getBuildingView((ResourceKey<Level>)worldIn.m_46472_(), pos);
            IColonyTagCapability cap = worldIn.m_46745_(pos).getCapability(IColony.CLOSE_COLONY_CAP, null).resolve().orElse(null);
            BlockEntity entity = worldIn.m_7702_(pos);
            if (entity instanceof TileEntityColonyBuilding && (te = (TileEntityColonyBuilding)entity).getPositionedTags().containsKey(BlockPos.f_121853_) && te.getPositionedTags().get(BlockPos.f_121853_).contains("deactivated")) {
                if (building == null && cap.getOwningColony() == 0) {
                    MessageUtils.format("com.minecolonies.coremod.building.missingcolony", new Object[0]).sendTo(player);
                    return InteractionResult.FAIL;
                }
                if (building == null && cap.getAllClaimingBuildings().values().stream().flatMap(Collection::stream).noneMatch(p -> p.equals((Object)pos))) {
                    IColonyManager.getInstance().openReactivationWindow(pos);
                    return InteractionResult.SUCCESS;
                }
            }
            if (building == null) {
                MessageUtils.format("com.minecolonies.coremod.gui.nobuilding", new Object[0]).sendTo(player);
                return InteractionResult.FAIL;
            }
            if (building.getColony() == null) {
                MessageUtils.format("com.minecolonies.coremod.gui.nocolony", new Object[0]).sendTo(player);
                return InteractionResult.FAIL;
            }
            if (!building.getColony().getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
                MessageUtils.format("com.minecolonies.coremod.permission.no", new Object[0]).sendTo(player);
                return InteractionResult.FAIL;
            }
            building.openGui(player.m_6144_());
        }
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        @NotNull Direction facing = context.m_43723_() == null ? Direction.NORTH : Direction.m_122364_((double)context.m_43723_().m_146908_());
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_6402_(@NotNull Level worldIn, @NotNull BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (worldIn.f_46443_) {
            return;
        }
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity instanceof TileEntityColonyBuilding) {
            IColony colony;
            @NotNull TileEntityColonyBuilding hut = (TileEntityColonyBuilding)tileEntity;
            if (hut.getBuildingName() != this.getBuildingEntry().getRegistryName()) {
                hut.registryName = this.getBuildingEntry().getRegistryName();
            }
            if ((colony = IColonyManager.getInstance().getColonyByPosFromWorld(worldIn, hut.getPosition())) != null) {
                colony.getBuildingManager().addNewBuilding(hut, worldIn);
                colony.getProgressManager().progressBuildingPlacement(this);
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public void onBlockPlacedByBuildTool(@NotNull Level worldIn, @NotNull BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack, boolean mirror, String style, String blueprintPath) {
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity instanceof AbstractTileEntityColonyBuilding) {
            ((AbstractTileEntityColonyBuilding)tileEntity).setMirror(mirror);
            ((AbstractTileEntityColonyBuilding)tileEntity).setPackName(style);
            ((AbstractTileEntityColonyBuilding)tileEntity).setBlueprintPath(blueprintPath);
        }
        this.m_6402_(worldIn, pos, state, placer, stack);
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("minecolonies", this.getHutName());
    }

    @Override
    public B registerBlock(IForgeRegistry<Block> registry) {
        registry.register(this.getRegistryName(), (Object)this);
        return (B)this;
    }

    public boolean isVisible(@Nullable CompoundTag beData) {
        Map data = IBlueprintDataProviderBE.readTagPosMapFrom((CompoundTag)beData.m_128469_("blueprintDataProvider"));
        return !((List)data.getOrDefault(BlockPos.f_121853_, new ArrayList())).contains("invisible");
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<MutableComponent> getRequirements(ClientLevel level, BlockPos pos, LocalPlayer player) {
        ArrayList<MutableComponent> requirements = new ArrayList<MutableComponent>();
        IColonyView colonyView = IColonyManager.getInstance().getClosestColonyView((Level)level, pos);
        if (colonyView == null) {
            requirements.add(Component.m_237115_((String)"com.minecolonies.coremod.hut.incolony").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            return requirements;
        }
        if (InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((Container)player.m_150109_()), this) == -1) {
            requirements.add(Component.m_237110_((String)"com.minecolonies.coremod.hut.cost", (Object[])new Object[]{Component.m_237115_((String)("block.minecolonies." + this.getHutName()))}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            return requirements;
        }
        ResourceLocation effectId = colonyView.getResearchManager().getResearchEffectIdFrom(this);
        if (colonyView.getResearchManager().getResearchEffects().getEffectStrength(effectId) > 0.0) {
            return requirements;
        }
        if (MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().getResearchForEffect(effectId) != null) {
            requirements.add(Component.m_237110_((String)"com.minecolonies.coremod.research.item1", (Object[])new Object[]{this.m_49954_()}));
            requirements.add(Component.m_237110_((String)"com.minecolonies.coremod.research.item2", (Object[])new Object[]{this.m_49954_()}));
        }
        return requirements;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean areRequirementsMet(ClientLevel level, BlockPos pos, LocalPlayer player) {
        if (player.m_7500_()) {
            return true;
        }
        return this.getRequirements(level, pos, player).isEmpty();
    }

    public List<MutableComponent> getDesc() {
        ArrayList<MutableComponent> desc = new ArrayList<MutableComponent>();
        desc.add(Component.m_237115_((String)(this.getBuildingEntry().getTranslationKey() + ".desc")));
        return desc;
    }

    public Component getBlueprintDisplayName() {
        return Component.m_237115_((String)("block.minecolonies." + this.getHutName()));
    }

    public int getLevel(CompoundTag beData) {
        if (beData == null) {
            return 0;
        }
        try {
            return Integer.parseInt(beData.m_128469_("blueprintDataProvider").m_128461_("schematicName").replaceAll("[^0-9]", ""));
        }
        catch (NumberFormatException exception) {
            Log.getLogger().error("Couldn't get level from hut: " + this.getHutName() + ". Potential corrubt blockEntity data.");
            return 0;
        }
    }

    public AbstractStructureHandler getStructureHandler(Level level, BlockPos blockPos, Blueprint blueprint, PlacementSettings placementSettings, boolean b) {
        return new CreativeBuildingStructureHandler(level, blockPos, blueprint, placementSettings, b);
    }

    public boolean setup(ServerPlayer player, Level world, BlockPos pos, Blueprint blueprint, PlacementSettings settings, boolean fancyPlacement, String pack, String path) {
        BlockState anchor = blueprint.getBlockState(blueprint.getPrimaryBlockOffset());
        if (!(anchor.m_60734_() instanceof AbstractBlockHut) || !fancyPlacement && player.m_7500_()) {
            return true;
        }
        if (!((Boolean)IMinecoloniesAPI.getInstance().getConfig().getServer().blueprintBuildMode.get()).booleanValue() && !this.canPaste(anchor.m_60734_(), (Player)player, pos)) {
            return false;
        }
        world.m_46961_(pos, true);
        world.m_46597_(pos, anchor);
        ((AbstractBlockHut)anchor.m_60734_()).onBlockPlacedByBuildTool(world, pos, anchor, (LivingEntity)player, null, settings.getMirror() != Mirror.NONE, pack, path);
        if (((Boolean)IMinecoloniesAPI.getInstance().getConfig().getServer().blueprintBuildMode.get()).booleanValue()) {
            return true;
        }
        @Nullable IBuilding building = IColonyManager.getInstance().getBuilding(world, pos);
        if (building == null) {
            if (anchor.m_60734_() != ModBlocks.blockHutTownHall) {
                SoundUtils.playErrorSound((Player)player, player.m_20183_());
                Log.getLogger().error("BuildTool: building is null!", (Throwable)new Exception());
                return false;
            }
        } else {
            SoundUtils.playSuccessSound((Player)player, player.m_20183_());
            if (building.getTileEntity() != null) {
                IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, pos);
                if (colony == null) {
                    Log.getLogger().info("No colony for " + player.m_7755_().getString());
                    return false;
                }
                building.getTileEntity().setColony(colony);
            }
            String adjusted = path.replace(".blueprint", "");
            String num = adjusted.substring(path.replace(".blueprint", "").length() - 2, adjusted.length() - 1);
            building.setStructurePack(pack);
            building.setBlueprintPath(path);
            try {
                building.setBuildingLevel(Integer.parseInt(num));
            }
            catch (NumberFormatException ex) {
                building.setBuildingLevel(1);
            }
            building.setIsMirrored(settings.mirror != Mirror.NONE);
            building.onUpgradeComplete(building.getBuildingLevel());
        }
        return true;
    }

    private boolean canPaste(Block anchor, Player player, BlockPos pos) {
        IColony colony = IColonyManager.getInstance().getIColony(player.f_19853_, pos);
        if (colony == null) {
            if (anchor == ModBlocks.blockHutTownHall) {
                return true;
            }
            if (IColonyManager.getInstance().getIColonyByOwner(player.f_19853_, player) == null) {
                MessageUtils.format("tile.blockhut.messagenotownhall", new Object[0]).sendTo(player);
            } else {
                MessageUtils.format("tile.blockhut.messagetoofarfromtownhall", new Object[0]).sendTo(player);
            }
            return false;
        }
        if (!colony.getPermissions().hasPermission(player, Action.PLACE_HUTS)) {
            MessageUtils.format("tile.blockhut.messagenopermission", colony.getName()).sendTo(player);
            return false;
        }
        return colony.getBuildingManager().canPlaceAt(anchor, pos, player);
    }

    public String getBlueprintName() {
        return this.getBuildingEntry().getRegistryName().m_135815_();
    }

    @Override
    public void registerBlockItem(IForgeRegistry<Item> registry, Item.Properties properties) {
        registry.register(this.getRegistryName(), (Object)new ItemBlockHut(this, properties));
    }
}

