/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.definition;

import appeng.block.AEBaseBlock;
import appeng.block.AEBaseBlockItem;
import appeng.block.crafting.CraftingMonitorBlock;
import appeng.block.crafting.CraftingUnitBlock;
import appeng.block.crafting.ICraftingUnitType;
import appeng.block.networking.EnergyCellBlock;
import appeng.block.networking.EnergyCellBlockItem;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.AEParts;
import appeng.core.definitions.BlockDefinition;
import gripe._90.megacells.block.MEGACraftingBlockItem;
import gripe._90.megacells.block.MEGACraftingUnitType;
import gripe._90.megacells.block.MEGAPatternProviderBlock;
import gripe._90.megacells.definition.MEGAItems;
import gripe._90.megacells.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;

public final class MEGABlocks {
    private static final List<BlockDefinition<?>> BLOCKS = new ArrayList();
    private static final BlockBehaviour.Properties props = BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(2.2f, 11.0f).m_60918_(SoundType.f_56743_);
    public static final BlockDefinition<EnergyCellBlock> MEGA_ENERGY_CELL = MEGABlocks.block("Superdense Energy Cell", "mega_energy_cell", () -> new EnergyCellBlock(1.28E7, 3200.0, 12800), EnergyCellBlockItem::new);
    public static final BlockDefinition<CraftingUnitBlock> MEGA_CRAFTING_UNIT = MEGABlocks.block("MEGA Crafting Unit", "mega_crafting_unit", () -> new CraftingUnitBlock(props, (ICraftingUnitType)MEGACraftingUnitType.UNIT), null);
    public static final BlockDefinition<CraftingUnitBlock> CRAFTING_ACCELERATOR = MEGABlocks.craftingBlock("MEGA Crafting Co-Processing Unit", "mega_crafting_accelerator", () -> new CraftingUnitBlock(props, (ICraftingUnitType)MEGACraftingUnitType.ACCELERATOR), () -> AEItems.ENGINEERING_PROCESSOR);
    public static final BlockDefinition<CraftingUnitBlock> CRAFTING_STORAGE_1M = MEGABlocks.craftingBlock("1M MEGA Crafting Storage", "1m_crafting_storage", () -> new CraftingUnitBlock(props, (ICraftingUnitType)MEGACraftingUnitType.STORAGE_1M), () -> MEGAItems.CELL_COMPONENT_1M);
    public static final BlockDefinition<CraftingUnitBlock> CRAFTING_STORAGE_4M = MEGABlocks.craftingBlock("4M MEGA Crafting Storage", "4m_crafting_storage", () -> new CraftingUnitBlock(props, (ICraftingUnitType)MEGACraftingUnitType.STORAGE_4M), () -> MEGAItems.CELL_COMPONENT_4M);
    public static final BlockDefinition<CraftingUnitBlock> CRAFTING_STORAGE_16M = MEGABlocks.craftingBlock("16M MEGA Crafting Storage", "16m_crafting_storage", () -> new CraftingUnitBlock(props, (ICraftingUnitType)MEGACraftingUnitType.STORAGE_16M), () -> MEGAItems.CELL_COMPONENT_16M);
    public static final BlockDefinition<CraftingUnitBlock> CRAFTING_STORAGE_64M = MEGABlocks.craftingBlock("64M MEGA Crafting Storage", "64m_crafting_storage", () -> new CraftingUnitBlock(props, (ICraftingUnitType)MEGACraftingUnitType.STORAGE_64M), () -> MEGAItems.CELL_COMPONENT_64M);
    public static final BlockDefinition<CraftingUnitBlock> CRAFTING_STORAGE_256M = MEGABlocks.craftingBlock("256M MEGA Crafting Storage", "256m_crafting_storage", () -> new CraftingUnitBlock(props, (ICraftingUnitType)MEGACraftingUnitType.STORAGE_256M), () -> MEGAItems.CELL_COMPONENT_256M);
    public static final BlockDefinition<CraftingMonitorBlock> CRAFTING_MONITOR = MEGABlocks.craftingBlock("MEGA Crafting Monitor", "mega_crafting_monitor", () -> new CraftingMonitorBlock(props, (ICraftingUnitType)MEGACraftingUnitType.MONITOR), () -> AEParts.STORAGE_MONITOR);
    public static final BlockDefinition<MEGAPatternProviderBlock> MEGA_PATTERN_PROVIDER = MEGABlocks.block("MEGA Pattern Provider", "mega_pattern_provider", () -> new MEGAPatternProviderBlock(props), MEGAPatternProviderBlock.Item::new);

    public static void init() {
        Utils.LOGGER.info("Initialised blocks.");
    }

    public static List<BlockDefinition<?>> getBlocks() {
        return Collections.unmodifiableList(BLOCKS);
    }

    private static <T extends Block> BlockDefinition<T> craftingBlock(String englishName, String id, Supplier<T> blockSupplier, Supplier<ItemLike> disassemblyExtra) {
        return MEGABlocks.block(englishName, id, blockSupplier, (block, props) -> new MEGACraftingBlockItem((Block)block, (Item.Properties)props, disassemblyExtra));
    }

    private static <T extends Block> BlockDefinition<T> block(String englishName, String id, Supplier<T> blockSupplier, BiFunction<Block, Item.Properties, BlockItem> itemFactory) {
        Object item;
        Block block = (Block)blockSupplier.get();
        Item.Properties itemProperties = new Item.Properties().m_41491_(MEGAItems.CREATIVE_TAB);
        if (itemFactory != null) {
            item = itemFactory.apply(block, itemProperties);
            if (item == null) {
                throw new IllegalArgumentException("BlockItem factory for " + id + " returned null");
            }
        } else {
            item = block instanceof AEBaseBlock ? new AEBaseBlockItem(block, itemProperties) : new BlockItem(block, itemProperties);
        }
        BlockDefinition definition = new BlockDefinition(englishName, Utils.makeId(id), block, item);
        BLOCKS.add(definition);
        return definition;
    }
}

