/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidTools {
    @Nonnull
    public static ItemStack convertFluidToBucket(@Nonnull FluidStack fluidStack) {
        return FluidUtil.getFluidHandler((ItemStack)new ItemStack((ItemLike)Items.f_42446_)).map(handler -> {
            handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            return handler.getContainer();
        }).orElse(ItemStack.f_41583_);
    }

    @Nonnull
    public static FluidStack convertBucketToFluid(@Nonnull ItemStack bucket) {
        return FluidUtil.getFluidHandler((ItemStack)bucket).map(handler -> {
            for (int i = 0; i < handler.getTanks(); ++i) {
                FluidStack contents = handler.getFluidInTank(i);
                if (contents.isEmpty()) continue;
                return contents;
            }
            return FluidStack.EMPTY;
        }).orElse(FluidStack.EMPTY);
    }

    public static boolean isEmptyContainer(@Nonnull ItemStack itemStack) {
        return FluidUtil.getFluidHandler((ItemStack)itemStack).map(handler -> {
            for (int i = 0; i < handler.getTanks(); ++i) {
                if (handler.getTankCapacity(i) <= 0) continue;
                FluidStack contents = handler.getFluidInTank(i);
                if (contents.isEmpty()) {
                    return true;
                }
                if (contents.getAmount() <= 0) continue;
                return false;
            }
            return false;
        }).orElse(false);
    }

    public static boolean isFilledContainer(@Nonnull ItemStack itemStack) {
        return FluidUtil.getFluidHandler((ItemStack)itemStack).map(handler -> {
            for (int i = 0; i < handler.getTanks(); ++i) {
                FluidStack contents = handler.getFluidInTank(i);
                if (!contents.isEmpty() && contents.getAmount() >= handler.getTankCapacity(i)) continue;
                return false;
            }
            return true;
        }).orElse(false);
    }

    @Nonnull
    public static ItemStack drainContainer(@Nonnull ItemStack container) {
        ItemStack empty = container.m_41777_();
        empty.m_41764_(1);
        return FluidUtil.getFluidHandler((ItemStack)empty).map(handler -> {
            if (!handler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE).isEmpty()) {
                return handler.getContainer();
            }
            return ItemStack.f_41583_;
        }).orElse(ItemStack.f_41583_);
    }

    @Nonnull
    public static ItemStack fillContainer(@Nonnull FluidStack fluidStack, @Nonnull ItemStack itemStack) {
        return FluidUtil.getFluidHandler((ItemStack)itemStack.m_41777_()).map(handler -> {
            int filled = handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            if (filled == 0) {
                return ItemStack.f_41583_;
            }
            return handler.getContainer();
        }).orElse(ItemStack.f_41583_);
    }

    @Nonnull
    public static FluidStack pickupFluidBlock(Level world, BlockPos pos, @Nonnull Predicate<FluidStack> action, @Nonnull Runnable clearBlock) {
        BlockState blockstate = world.m_8055_(pos);
        FluidState fluidstate = world.m_6425_(pos);
        Material material = blockstate.m_60767_();
        Fluid fluid = fluidstate.m_76152_();
        if (blockstate.m_60734_() instanceof LiquidBlock) {
            FluidStack stack = new FluidStack(fluid, 1000);
            if (action.test(stack)) {
                clearBlock.run();
            }
            return stack;
        }
        if (blockstate.m_60734_() instanceof BucketPickup && fluid != Fluids.f_76191_) {
            FluidStack stack = new FluidStack(fluid, 1000);
            if (action.test(stack)) {
                ItemStack fluidBucket = ((BucketPickup)blockstate.m_60734_()).m_142598_((LevelAccessor)world, pos, blockstate);
                return FluidUtil.getFluidContained((ItemStack)fluidBucket).map(f -> new FluidStack(f, 1000)).orElse(FluidStack.EMPTY);
            }
            return stack;
        }
        if (material == Material.f_76301_ || material == Material.f_76304_) {
            FluidStack stack = new FluidStack((Fluid)Fluids.f_76193_, 1000);
            if (action.test(stack)) {
                BlockEntity tileentity = blockstate.m_60734_() instanceof EntityBlock ? world.m_7702_(pos) : null;
                Block.m_49892_((BlockState)blockstate, (LevelAccessor)world, (BlockPos)pos, (BlockEntity)tileentity);
                clearBlock.run();
            }
            return stack;
        }
        return FluidStack.EMPTY;
    }
}

