/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.typed;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.typed.Key;

public record TypedMap(Map<Key<?>, Object> map) {
    public static final TypedMap EMPTY = TypedMap.builder().build();

    public Set<Key<?>> getKeys() {
        return this.map.keySet();
    }

    public int size() {
        return this.map.size();
    }

    public <V> V get(@Nonnull Key<V> key) {
        return (V)this.map.get(key);
    }

    public <V> Optional<V> getOptional(@Nonnull Key<V> key) {
        return Optional.ofNullable(this.map.get(key));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<Key<?>, Object> map = new HashMap();

        Builder() {
        }

        public <V> Builder put(@Nonnull Key<V> key, V value) {
            this.map.put(key, value);
            return this;
        }

        public TypedMap build() {
            return new TypedMap(this.map);
        }
    }
}

