/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.preferences;

import javax.annotation.Nonnull;
import mcjty.lib.McJtyLib;
import mcjty.lib.gui.BuffStyle;
import mcjty.lib.gui.GuiStyle;
import mcjty.lib.network.PacketSendPreferencesToClient;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.network.NetworkDirection;

public class PreferencesProperties {
    private static final int DEFAULT_BUFFX = -20;
    private static final int DEFAULT_BUFFY = -20;
    private static final GuiStyle DEFAULT_STYLE = GuiStyle.STYLE_FLAT_GRADIENT;
    private int buffX = -20;
    private int buffY = -20;
    private BuffStyle buffStyle = BuffStyle.BOTRIGHT;
    private GuiStyle style = DEFAULT_STYLE;
    private boolean dirty = true;

    public void tick(ServerPlayer player) {
        if (this.dirty) {
            this.syncToClient(player);
        }
    }

    private void syncToClient(ServerPlayer player) {
        McJtyLib.networkHandler.sendTo((Object)new PacketSendPreferencesToClient(this.buffStyle, this.buffX, this.buffY, this.style), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        this.dirty = false;
    }

    public void saveNBTData(CompoundTag compound) {
        compound.m_128359_("buffStyle", this.buffStyle.getName());
        compound.m_128405_("buffX", this.buffX);
        compound.m_128405_("buffY", this.buffY);
        compound.m_128359_("style", this.style.getStyle());
    }

    public void loadNBTData(CompoundTag compound) {
        this.buffStyle = BuffStyle.getStyle(compound.m_128461_("buffStyle"));
        if (this.buffStyle == null) {
            this.buffStyle = BuffStyle.BOTRIGHT;
            this.buffX = -20;
            this.buffY = -20;
        } else {
            this.buffX = compound.m_128451_("buffX");
            this.buffY = compound.m_128451_("buffY");
        }
        String s = compound.m_128461_("style");
        this.style = GuiStyle.getStyle(s);
        if (this.style == null) {
            this.style = DEFAULT_STYLE;
        }
        this.dirty = true;
    }

    public void reset() {
        this.buffStyle = BuffStyle.TOPLEFT;
        this.buffX = -20;
        this.buffY = -20;
        this.style = DEFAULT_STYLE;
        this.dirty = true;
    }

    public boolean setStyle(String s) {
        GuiStyle st = GuiStyle.getStyle(s);
        if (st == null) {
            return false;
        }
        this.style = st;
        this.dirty = true;
        return true;
    }

    public boolean setStyle(GuiStyle st) {
        if (st == null) {
            return false;
        }
        this.style = st;
        this.dirty = true;
        return true;
    }

    @Nonnull
    public GuiStyle getStyle() {
        return this.style;
    }

    public void setBuffXY(BuffStyle buffStyle, int x, int y) {
        this.buffStyle = buffStyle;
        this.buffX = x;
        this.buffY = y;
        this.dirty = true;
    }

    public BuffStyle getBuffStyle() {
        return this.buffStyle;
    }

    public int getBuffX() {
        return this.buffX;
    }

    public int getBuffY() {
        return this.buffY;
    }

    public static void register(RegisterCapabilitiesEvent event) {
        event.register(PreferencesProperties.class);
    }
}

