/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import mcjty.lib.varia.TriConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class DelayedRenderer {
    private static final Map<RenderType, List<Pair<BlockPos, BiConsumer<PoseStack, VertexConsumer>>>> RENDERS = new HashMap<RenderType, List<Pair<BlockPos, BiConsumer<PoseStack, VertexConsumer>>>>();
    private static final Map<BlockPos, TriConsumer<PoseStack, Vec3, RenderType>> DELAYED_RENDERS = new HashMap<BlockPos, TriConsumer<PoseStack, Vec3, RenderType>>();
    private static final Map<BlockPos, BiFunction<Level, BlockPos, Boolean>> RENDER_VALIDATIONS = new HashMap<BlockPos, BiFunction<Level, BlockPos, Boolean>>();

    public static void render(PoseStack matrixStack) {
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        Vec3 projectedView = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        HashSet todelete = new HashSet();
        DELAYED_RENDERS.forEach((pos, consumer) -> {
            if (RENDER_VALIDATIONS.getOrDefault(pos, (level, blockPos) -> false).apply((Level)Minecraft.m_91087_().f_91073_, (BlockPos)pos).booleanValue()) {
                consumer.accept(matrixStack, projectedView, null);
            } else {
                todelete.add(pos);
            }
        });
        for (BlockPos pos2 : todelete) {
            DELAYED_RENDERS.remove(pos2);
            RENDER_VALIDATIONS.remove(pos2);
        }
        RENDERS.forEach((type, renderlist) -> {
            VertexConsumer consumer = buffer.m_6299_(type);
            renderlist.forEach(r -> {
                RenderSystem.m_69482_();
                BlockPos pos = (BlockPos)r.getKey();
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)pos.m_123341_() - projectedView.f_82479_, (double)pos.m_123342_() - projectedView.f_82480_, (double)pos.m_123343_() - projectedView.f_82481_);
                ((BiConsumer)r.getValue()).accept(matrixStack, consumer);
                matrixStack.m_85849_();
            });
            RenderSystem.m_69482_();
            buffer.m_109912_(type);
        });
        RENDERS.clear();
        buffer.m_109911_();
    }

    public static void addRender(BlockPos pos, TriConsumer<PoseStack, Vec3, RenderType> renderer, BiFunction<Level, BlockPos, Boolean> validator) {
        DELAYED_RENDERS.put(pos, renderer);
        RENDER_VALIDATIONS.put(pos, validator);
    }

    public static void removeRender(BlockPos pos) {
        DELAYED_RENDERS.remove(pos);
        RENDER_VALIDATIONS.remove(pos);
    }

    public static void addRender(RenderType type, BlockPos pos, BiConsumer<PoseStack, VertexConsumer> renderer) {
        RENDERS.computeIfAbsent(type, renderType -> new ArrayList()).add(Pair.of((Object)pos, renderer));
    }
}

