/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.shader.old;

import com.mojang.blaze3d.platform.GlStateManager;
import java.nio.FloatBuffer;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.opengl.GL13C;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.MemoryUtil;
import stepsword.mahoutsukai.render.RenderUtils;

public class FogShader {
    public static ResourceLocation FOG_TEX = new ResourceLocation("mahoutsukai", "textures/particle/fog3.png");
    public static ResourceLocation DEPTH_TEX = new ResourceLocation("mahoutsukai", "textures/particle/depth.png");
    public static boolean doDepth = true;
    int prog = -1;
    FloatBuffer SMOKE_SOFTNESS;
    FloatBuffer SMOKE_COLOR;
    FloatBuffer Z_NEAR_FAR;
    FloatBuffer W_H;
    FloatBuffer INVERTED;
    FloatBuffer b;

    public FogShader(int prog) {
        this.prog = prog;
        this.SMOKE_SOFTNESS = MemoryUtil.memAllocFloat((int)1);
        this.SMOKE_COLOR = MemoryUtil.memAllocFloat((int)4);
        this.Z_NEAR_FAR = MemoryUtil.memAllocFloat((int)2);
        this.W_H = MemoryUtil.memAllocFloat((int)2);
        this.INVERTED = MemoryUtil.memAllocFloat((int)2);
        this.b = MemoryUtil.memAllocFloat((int)16);
        this.smoke(0.06f);
        this.color(1.0f, 1.0f, 1.0f, 0.7f);
        this.nearfar(0.07f, 400.0f);
    }

    public void smoke(float f) {
        this.SMOKE_SOFTNESS.position(0);
        this.SMOKE_SOFTNESS.put(f);
    }

    public void nearfar(float n, float f) {
        this.Z_NEAR_FAR.position(0);
        this.Z_NEAR_FAR.put(n);
        this.Z_NEAR_FAR.put(f);
    }

    public void color(float r, float g, float b, float a) {
        this.SMOKE_COLOR.position(0);
        this.SMOKE_COLOR.put(r);
        this.SMOKE_COLOR.put(g);
        this.SMOKE_COLOR.put(b);
        this.SMOKE_COLOR.put(a);
    }

    public void resize(float w, float h) {
        this.W_H.position(0);
        this.W_H.put(1.0f / w);
        this.W_H.put(1.0f / h);
    }

    public void initFog(int w, int h) {
        this.resize(w, h);
        this.printGLERROR("RESIZE");
        this.set_near_far();
        this.printGLERROR("SET_NEAR_FAR");
        this.set_inverted();
        this.printGLERROR("SET_INVERTED");
        this.set_smoke_color();
        this.printGLERROR("SET_COLOR");
        this.set_smoke_softness();
        this.printGLERROR("SET_SOFTNESS");
        this.depth(w, h);
        this.printGLERROR("DEPTH");
        this.finishFog();
    }

    public void finishFog() {
        GL13C.glActiveTexture((int)33984);
        this.printGLERROR("ACTIVE0");
        GlStateManager.m_84538_((int)33984);
        RenderUtils.bindTexture(FOG_TEX);
        this.printGLERROR("BIND");
    }

    public void depth(int w, int h) {
        GL30.glEnable((int)2929);
        GL13C.glActiveTexture((int)34001);
        RenderUtils.bindTexture(DEPTH_TEX);
        this.printGLERROR("BINDTEXTURE");
        GL30.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL30.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL30.glTexParameterf((int)3553, (int)10242, (float)10496.0f);
        GL30.glTexParameterf((int)3553, (int)10243, (float)10496.0f);
        this.printGLERROR("PARAMETER");
        if (doDepth) {
            GL30.glCopyTexImage2D((int)3553, (int)0, (int)6402, (int)0, (int)0, (int)w, (int)h, (int)0);
        }
        this.printGLERROR("TEXIMAGE");
        GlStateManager.m_84467_((int)this.uni("uDepthTexture"), (int)17);
        doDepth = false;
    }

    public void set_near_far() {
        GL30.glUniform2f((int)this.uni("uNearFar"), (float)this.Z_NEAR_FAR.get(0), (float)this.Z_NEAR_FAR.get(1));
    }

    public void set_inverted() {
        GL30.glUniform2f((int)this.uni("uInvertedVp"), (float)this.W_H.get(0), (float)this.W_H.get(1));
    }

    public void set_smoke_color() {
        GL30.glUniform4f((int)this.uni("uSmokeColor"), (float)this.SMOKE_COLOR.get(0), (float)this.SMOKE_COLOR.get(1), (float)this.SMOKE_COLOR.get(2), (float)this.SMOKE_COLOR.get(3));
    }

    public void set_smoke_softness() {
        GL30.glUniform1f((int)this.uni("uSmokeSoftness"), (float)this.SMOKE_SOFTNESS.get(0));
    }

    public int uni(String s) {
        return GlStateManager.m_84345_((int)this.prog, (CharSequence)s);
    }

    public void printGLERROR(String s) {
        int errorCheckValue = GL30.glGetError();
        if (errorCheckValue != 0) {
            System.err.println(s + ": Could not create shaders " + errorCheckValue);
        }
    }
}

