/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.secret;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.capability.scrollmahou.IScrollMahou;
import stepsword.mahoutsukai.capability.scrollmahou.ScrollMahouStorage;
import stepsword.mahoutsukai.capability.settingsmahou.MahouSettings;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.mahoujin.GandrEntity;
import stepsword.mahoutsukai.item.FaeEssence;
import stepsword.mahoutsukai.item.spells.SpellScroll;
import stepsword.mahoutsukai.networking.MagicCircleBoomParticlePacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.util.Utils;

public class GandrSpellScroll
extends SpellScroll {
    public static HashMap<UUID, GandrUserStorage> gandrs = new HashMap();

    public GandrSpellScroll() {
        super("gandr");
    }

    @Override
    public int getInitialManaCost() {
        return 0;
    }

    public int getManaCostScaling(IMahou mahou) {
        boolean manascales = MTConfig.GANDR_MANA_SCALES;
        double factor = MTConfig.GANDR_MANA_COST_FACTOR;
        if (manascales) {
            return (int)Math.floor(factor * (double)mahou.getMaxMana());
        }
        return (int)Math.floor(factor);
    }

    public double getDamage(IMahou mahou) {
        boolean scales = MTConfig.GANDR_DAMAGE_SCALES;
        double factor = MTConfig.GANDR_DAMAGE_FACTOR;
        double mindamage = MTConfig.GANDR_MIN_DAMAGE;
        double maxdamage = MTConfig.GANDR_MAX_DAMAGE;
        double ret = 0.0;
        if (mahou != null) {
            ret = scales ? (double)mahou.getMaxMana() * factor : factor;
            ret = Math.max(mindamage, Math.min(ret, maxdamage));
        }
        return ret;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (!player.f_19853_.f_46443_) {
            if (gandrs.containsKey(player.m_20148_())) {
                GandrUserStorage storage = gandrs.get(player.m_20148_());
            } else {
                GandrUserStorage storage = new GandrUserStorage();
                gandrs.put(player.m_20148_(), storage);
                if (player instanceof Player) {
                    List<Integer> settings = MahouSettings.getIntSettings((Player)player, MahouSettings.Spell.GANDR);
                    storage.gandr = new GandrEntity(player.f_19853_, player, MahouSettings.colorConvert(settings.get(0)), MahouSettings.colorConvert(settings.get(1)), MahouSettings.colorConvert(settings.get(2)), 1.0f, MahouSettings.colorConvert(settings.get(3)), MahouSettings.colorConvert(settings.get(4)), MahouSettings.colorConvert(settings.get(5)));
                    storage.gandr.setLookPos(player.f_19853_.f_46443_, player, storage.gandr);
                    player.f_19853_.m_7967_((Entity)storage.gandr);
                }
            }
        }
    }

    @Override
    public void useAction(ItemStack stack, Level worldIn, LivingEntity entityLiving, boolean consume) {
        if (!worldIn.f_46443_) {
            IScrollMahou scrollMahou = this.getCapability(stack);
            if (entityLiving instanceof Player && Utils.getPlayerMahou((Player)entityLiving) != null) {
                Player user = (Player)entityLiving;
                int cost = this.getManaCostScaling(Utils.getPlayerMahou((Player)entityLiving));
                if (scrollMahou != null && (user.m_20148_().equals(scrollMahou.getCasterUUID()) || scrollMahou.getCasterUUID() == null || scrollMahou.getCasterUUID().equals(FaeEssence.faeID) || scrollMahou.getCasterUUID().equals(new UUID(0L, 0L)) || user.m_7500_())) {
                    if (PlayerManaManager.drainMana(user, cost, false, false) == cost) {
                        if (this.shouldConsume(user, scrollMahou, consume)) {
                            stack.m_41774_(1);
                        }
                        stack.m_41751_((CompoundTag)ScrollMahouStorage.writeNBT(scrollMahou));
                    } else if (gandrs.containsKey(user.m_20148_())) {
                        GandrUserStorage storage = gandrs.get(user.m_20148_());
                        storage.gandr.m_146870_();
                        gandrs.remove(user.m_20148_());
                    }
                }
            }
        }
    }

    @Override
    public boolean doSpell(Player user, IScrollMahou scrollMahou) {
        double speed = MTConfig.GANDR_SPEED;
        int launch_particles = MTConfig.GANDR_RED_PARTICLES_LAUNCH;
        if (gandrs.containsKey(user.m_20148_())) {
            GandrUserStorage storage = gandrs.get(user.m_20148_());
            if ((float)storage.gandr.getLife() > storage.gandr.getGrowingLife()) {
                storage.gandr.setFired(true);
                storage.gandr.effects = new ArrayList(user.m_21220_());
                storage.gandr.damage = (float)this.getDamage(Utils.getPlayerMahou(user));
                Iterator iter = user.m_21220_().iterator();
                ArrayList<MobEffect> lst = new ArrayList<MobEffect>();
                while (iter.hasNext()) {
                    MobEffectInstance ei = (MobEffectInstance)iter.next();
                    if (!GandrEntity.validEffect(ei)) continue;
                    lst.add(ei.m_19544_());
                }
                for (MobEffect e : lst) {
                    user.m_21195_(e);
                }
                Vec3 v = user.m_20154_().m_82541_().m_82490_(speed);
                storage.gandr.m_20334_(v.f_82479_, v.f_82480_, v.f_82481_);
                Vec3 look = storage.gandr.m_20252_(1.0f);
                float[] rgbs = storage.gandr.getColor();
                PacketHandler.sendTracking(storage.gandr, new MagicCircleBoomParticlePacket(storage.gandr.m_20185_(), storage.gandr.m_20186_(), storage.gandr.m_20189_(), look.f_82479_, look.f_82480_, look.f_82481_, 0.2f, 0, 0, launch_particles, false, false, rgbs[0], rgbs[1], rgbs[2], rgbs[4], rgbs[5], rgbs[6]));
                PacketHandler.sendTracking(storage.gandr, new MagicCircleBoomParticlePacket(storage.gandr.m_20185_(), storage.gandr.m_20186_(), storage.gandr.m_20189_(), look.f_82479_, look.f_82480_, look.f_82481_, 0.3f, 1, 0, launch_particles, false, false, rgbs[0], rgbs[1], rgbs[2], rgbs[4], rgbs[5], rgbs[6]));
                gandrs.remove(user.m_20148_());
                return true;
            }
            storage.gandr.m_146870_();
            gandrs.remove(user.m_20148_());
            return false;
        }
        return false;
    }

    public class GandrUserStorage {
        GandrEntity gandr;
    }
}

