/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.mysticcode;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import stepsword.mahoutsukai.capability.containers.MysticCodeInventory;
import stepsword.mahoutsukai.capability.containers.MysticCodeInventoryProvider;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.item.MagicalItemRender;
import stepsword.mahoutsukai.item.spells.SpellScroll;
import stepsword.mahoutsukai.item.spells.boundary.BoundarySpellScroll;
import stepsword.mahoutsukai.item.spells.secret.FallenDownSpellScroll;
import stepsword.mahoutsukai.item.spells.secret.GandrSpellScroll;
import stepsword.mahoutsukai.render.item.MysticCodeRenderer;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class MysticCode
extends ItemBase
implements MenuProvider {
    public MysticCode(String name, Item.Properties prop) {
        super(name, prop);
        this.addPropertyOverrides();
    }

    public MysticCode() {
        super("mystic_code", new Item.Properties().m_41487_(1));
        this.addPropertyOverrides();
    }

    public void addPropertyOverrides() {
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new MysticCodeInventoryProvider();
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (playerIn.m_20163_()) {
            if (!worldIn.f_46443_) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)playerIn), (MenuProvider)this);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.m_21120_(handIn));
        }
        playerIn.m_6672_(handIn);
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)playerIn.m_21120_(handIn));
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        ItemStack ammo;
        int slot;
        IItemHandler inventory;
        if (stack != null && (inventory = Utils.getMCInventory(stack)) != null && (slot = MysticCode.getSlot(stack)) >= 0 && slot < 3 && (ammo = inventory.getStackInSlot(slot)).m_41720_() instanceof SpellScroll) {
            ((SpellScroll)ammo.m_41720_()).useAction(ammo, worldIn, entityLiving, true);
            if (!worldIn.f_46443_) {
                this.saveCapabilityToStack(stack);
            }
        }
        if (!worldIn.f_46443_) {
            MysticCode.triggerUpdate((ServerPlayer)entityLiving, stack);
        }
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Player player = ctx.m_43723_();
        if (player != null) {
            int slot;
            IItemHandler inventory;
            Level worldIn = player.f_19853_;
            InteractionHand hand = ctx.m_43724_();
            BlockPos pos = ctx.m_8083_();
            Direction facing = ctx.m_43719_();
            ItemStack stack = player.m_21120_(hand);
            if (player.m_20163_()) {
                if (!worldIn.f_46443_) {
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this);
                }
                return InteractionResult.SUCCESS;
            }
            if (stack != null && (inventory = Utils.getMCInventory(stack)) != null && (slot = MysticCode.getSlot(stack)) >= 0 && slot < 3) {
                ItemStack ammo = inventory.getStackInSlot(slot);
                if (ammo.m_41720_() instanceof BoundarySpellScroll) {
                    InteractionResult s = ((BoundarySpellScroll)ammo.m_41720_()).boundaryScrollUse(player, worldIn, ammo, pos, facing, true);
                    if (!worldIn.f_46443_) {
                        this.saveCapabilityToStack(stack);
                    }
                    return s;
                }
                player.m_6672_(hand);
            }
            if (!worldIn.f_46443_) {
                MysticCode.triggerUpdate((ServerPlayer)player, stack);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }

    public static void setSlot(ItemStack stack, int g) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        nbt.m_128405_("slot_selected", g);
        stack.m_41751_(nbt);
    }

    public static int getSlot(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_("slot_selected")) {
            return nbt.m_128451_("slot_selected");
        }
        return 0;
    }

    public void setRandomColor(ItemStack stack, RandomSource rand) {
        this.setColor(stack, rand.m_188503_(8));
    }

    public void setColor(ItemStack stack, int z) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        nbt.m_128405_("color", z);
        stack.m_41751_(nbt);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        ItemStack ammo;
        int slot;
        IItemHandler inventory;
        if (stack != null && (inventory = Utils.getMCInventory(stack)) != null && (slot = MysticCode.getSlot(stack)) >= 0 && slot < 3 && ((ammo = inventory.getStackInSlot(slot)).m_41720_() instanceof GandrSpellScroll || ammo.m_41720_() instanceof FallenDownSpellScroll)) {
            ammo.m_41720_().onUsingTick(ammo, player, count);
        }
    }

    public int getColor(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null && nbt.m_128441_("color")) {
            return nbt.m_128451_("color");
        }
        return 0;
    }

    public void setSlotsForWheel(ItemStack code, ItemStack s1, ItemStack s2, ItemStack s3) {
        CompoundTag nbt = code.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        nbt.m_128359_("slot1", MysticCode.convertStackToString(s1));
        nbt.m_128359_("slot2", MysticCode.convertStackToString(s2));
        nbt.m_128359_("slot3", MysticCode.convertStackToString(s3));
        code.m_41751_(nbt);
    }

    public List<String> getSlotsForWheel(ItemStack code) {
        CompoundTag nbt = code.m_41783_();
        ArrayList<String> lst = new ArrayList<String>();
        if (nbt != null && nbt.m_128441_("slot1")) {
            lst.add(nbt.m_128461_("slot1"));
        } else {
            lst.add("SLOT EMPTY");
        }
        if (nbt != null && nbt.m_128441_("slot2")) {
            lst.add(nbt.m_128461_("slot2"));
        } else {
            lst.add("SLOT EMPTY");
        }
        if (nbt != null && nbt.m_128441_("slot3")) {
            lst.add(nbt.m_128461_("slot3"));
        } else {
            lst.add("SLOT EMPTY");
        }
        return lst;
    }

    public static String convertStackToString(ItemStack s) {
        if (s.m_41619_()) {
            return "SLOT EMPTY";
        }
        return s.m_41720_().m_7626_(s).getString();
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        CompoundTag c;
        ItemStackHandler inv;
        if (nbt != null && nbt.m_128441_("capability") && (inv = (ItemStackHandler)Utils.getMCInventory(stack)) != null && (c = (CompoundTag)nbt.m_128423_("capability")).m_128441_("Items")) {
            inv.deserializeNBT(c);
        }
        super.readShareTag(stack, nbt);
    }

    public void saveCapabilityToStack(ItemStack stack) {
        ItemStackHandler inventory;
        if (stack != null && !stack.m_41619_() && stack.m_41720_() instanceof MysticCode && (inventory = (ItemStackHandler)Utils.getMCInventory(stack)) != null) {
            CompoundTag capnbt = inventory.serializeNBT();
            CompoundTag stacknbt = stack.m_41783_();
            if (stacknbt == null) {
                stacknbt = new CompoundTag();
            }
            stacknbt.m_128365_("capability", (Tag)capnbt);
            stack.m_41751_(stacknbt);
            this.setSlotsForWheel(stack, inventory.getStackInSlot(0), inventory.getStackInSlot(1), inventory.getStackInSlot(2));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public static void triggerUpdate(ServerPlayer player, ItemStack stack) {
        player.f_8906_.m_9829_((Packet)new ClientboundSetCarriedItemPacket(player.m_150109_().f_35977_));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (EffectUtil.inEnchantBlacklist(enchantment, MTConfig.MYSTIC_CODE_ENCHANT_BLACKLIST)) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Mystic Code");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player Player2) {
        ItemStack stack = Player2.m_21205_().m_41720_() instanceof MysticCode ? Player2.m_21205_() : Player2.m_21206_();
        return new MysticCodeInventory(i, (ItemStackHandler)Utils.getMCInventory(stack), (Container)playerInventory, stack);
    }

    public Object getRenderPropertiesInternal() {
        return new MagicalItemRender(MysticCodeRenderer::new);
    }
}

