/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.fluids;

import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.event.TickEvent;
import stepsword.mahoutsukai.capability.chunks.IChunkMahou;
import stepsword.mahoutsukai.fluids.ModFluids;
import stepsword.mahoutsukai.networking.ChunkMahouPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.util.ChunkDim;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class MurkyWaterBlock
extends LiquidBlock {
    private static boolean pushesEntity;
    protected String name;
    public static HashSet<ChunkDim> murkies;

    public MurkyWaterBlock(FlowingFluid fluid, BlockBehaviour.Properties properties) {
        super(fluid, properties);
        this.name = "murky_water";
    }

    public MurkyWaterBlock() {
        super(() -> (FlowingFluid)ModFluids.MURKY_STILL.get(), BlockBehaviour.Properties.m_60939_((Material)Material.f_76305_).m_222994_().m_60910_().m_60978_(100.0f));
    }

    public FlowingFluid getFluid() {
        return (FlowingFluid)ModFluids.MURKY_STILL.get();
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState state2, boolean v1) {
        if (!world.f_46443_) {
            IChunkMahou chunkMahou;
            ChunkAccess c = world.m_46865_(pos);
            if (c instanceof LevelChunk && (chunkMahou = Utils.getChunkMahou((LevelChunk)c)) != null && chunkMahou.getLakeBlocks() != null) {
                chunkMahou.getLakeBlocks().remove((Object)pos);
            }
            if (murkies == null) {
                murkies = new HashSet();
            }
            murkies.add(new ChunkDim(c.m_7697_(), EffectUtil.getDimension(world)));
        }
        super.m_6810_(state, world, pos, state2, v1);
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!world.f_46443_) {
            IChunkMahou chunkMahou;
            ChunkAccess c = world.m_46865_(pos);
            if (c instanceof LevelChunk && (chunkMahou = Utils.getChunkMahou((LevelChunk)c)) != null && chunkMahou.getLakeBlocks() != null) {
                chunkMahou.getLakeBlocks().add((Object)pos);
            }
            if (murkies == null) {
                murkies = new HashSet();
            }
            murkies.add(new ChunkDim(c.m_7697_(), EffectUtil.getDimension(world)));
        }
        super.m_6807_(state, world, pos, oldState, isMoving);
    }

    public static void murkyUpdateTick(TickEvent.LevelTickEvent event) {
        if (!event.level.f_46443_ && event.phase == TickEvent.Phase.END && event.level.m_46467_() % 4L == 0L) {
            for (ChunkDim p : murkies) {
                ServerLevel world = EffectUtil.getNewDimensionByName((ServerLevel)event.level, p.dim);
                LevelChunk c = world.m_6325_(p.pos.f_45578_, p.pos.f_45579_);
                IChunkMahou chunkMahou = Utils.getChunkMahou(c);
                if (chunkMahou == null) continue;
                PacketHandler.sendTrackingBlock(p.pos.m_45615_(), (Level)EffectUtil.getNewDimensionByName((ServerLevel)event.level, p.dim), new ChunkMahouPacket(chunkMahou.getLakeBlocks(), p.pos.f_45578_, p.pos.f_45579_));
            }
            murkies.clear();
        }
    }

    static {
        murkies = new HashSet();
    }
}

