/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.Bakuretsu;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.MysticStaff;
import stepsword.mahoutsukai.networking.BakuretsuPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.util.Utils;

public class MysticStaffMahoujinEntity
extends Entity {
    private static final String TAG_ROTATION_YAW = "MAHOUTSUKAI_ROTATION_YAW";
    private static final String TAG_ROTATION_ROLL = "MAHOUTSUKAI_ROTATION_ROLL";
    private static final String TAG_ROTATION_PITCH = "MAHOUTSUKAI_ROTATION_PITCH";
    private static final String TAG_ROTATION_SPEED = "MAHOUTSUKAI_ROTATION_SPEED";
    private static final String TAG_CIRCLE_SIZE = "MAHOUTSUKAI_ROTATION_SPEED";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_BEAM = "MAHOUTSUKAI_BEAM";
    private static final String TAG_BEAM_SIZE = "MAHOUTSUKAI_BEAM_SIZE";
    private static final String TAG_BEAM_LENGTH = "MAHOUTSUKAI_BEAM_LENGTH";
    private static final String TAG_BEAM_OFFSET = "MAHOUTSUKAI_BEAM_OFFSET";
    private static final String TAG_SHOOTING_TICKS = "MAHOUTSUKAI_SHOOTING_TICKS";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_DISTANCE = "MAHOUTSUKAI_DISTANCE";
    private static final AABB ZERO_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final int loadUpTime = 20;
    public static final AABB bb = new AABB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final EntityDataAccessor<Float> ROTATION_YAW = SynchedEntityData.m_135353_(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROTATION_ROLL = SynchedEntityData.m_135353_(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROTATION_PITCH = SynchedEntityData.m_135353_(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROTATION_SPEED = SynchedEntityData.m_135353_(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> CIRCLE_SIZE = SynchedEntityData.m_135353_(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> BEAM_SIZE = SynchedEntityData.m_135353_(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.m_135353_(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> BEAM = SynchedEntityData.m_135353_(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> BEAM_LENGTH = SynchedEntityData.m_135353_(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> BEAM_OFFSET = SynchedEntityData.m_135353_(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> SHOOTING_TICKS = SynchedEntityData.m_135353_(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.m_135353_(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.m_135353_(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.m_135353_(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.m_135353_(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DISTANCE = SynchedEntityData.m_135353_(MysticStaffMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    Vec3 target;
    public UUID casterUUID = null;
    public static final String entityName = "mahoujin_entity";

    public MysticStaffMahoujinEntity(PlayMessages.SpawnEntity packet, Level worldIn) {
        super((EntityType)ModEntities.EXPLOSION_MAHOUJIN.get(), worldIn);
        this.f_19811_ = true;
    }

    public MysticStaffMahoujinEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public MysticStaffMahoujinEntity(Level world) {
        super((EntityType)ModEntities.EXPLOSION_MAHOUJIN.get(), world);
        this.f_19811_ = true;
    }

    public MysticStaffMahoujinEntity(Level world, Player caster) {
        this(world);
        this.casterUUID = caster.m_20148_();
    }

    public MysticStaffMahoujinEntity(Level world, Player caster, boolean hasBeam, float r, float g, float b, float a) {
        this(world);
        this.casterUUID = caster.m_20148_();
        this.setHasBeam(hasBeam);
        this.setColor(r, g, b, a);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ROTATION_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROTATION_ROLL, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROTATION_PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROTATION_SPEED, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(CIRCLE_SIZE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LIFE, (Object)0);
        this.f_19804_.m_135372_(BEAM, (Object)false);
        this.f_19804_.m_135372_(BEAM_SIZE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(BEAM_LENGTH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(BEAM_OFFSET, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(COLOR_R, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_G, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_B, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_A, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SHOOTING_TICKS, (Object)-1);
        this.f_19804_.m_135372_(DISTANCE, (Object)Float.valueOf(0.0f));
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_20334_(0.0, 0.0, 0.0);
        if (this.getLife() < 20) {
            this.setLife(this.getLife() + 1);
        }
        this.f_19859_ = this.f_19857_;
        if (this.f_19859_ < 0.0f) {
            this.f_19859_ += 360.0f;
        }
        this.setRotationYaw(this.getRotationYaw() + this.getRotationSpeed());
        this.f_19857_ = this.getRotationYaw();
        this.f_19858_ = this.getRotationPitch();
        this.m_19915_(this.f_19857_, this.f_19858_);
        if (!this.f_19853_.f_46443_) {
            if (this.casterUUID == null) {
                this.m_146870_();
            } else {
                Player caster = this.f_19853_.m_46003_(this.casterUUID);
                if (caster == null || !caster.m_6084_()) {
                    this.m_146870_();
                } else {
                    if (!(caster.m_21211_().m_41720_() instanceof MysticStaff && this.getShootingTicks() < 0 || this.target != null)) {
                        this.m_146870_();
                    }
                    if (this.target != null) {
                        int shooting = this.getShootingTicks();
                        int shootFinish = 12;
                        int maxBeamLength = 6;
                        if (shooting >= 0 && shooting < shootFinish + maxBeamLength) {
                            this.setBeamOffset(this.getBeamOffset() - this.getDistance() / (float)shootFinish);
                            this.setBeamSize(this.getBeamSize() + 0.03f);
                            if (shooting < maxBeamLength) {
                                this.setBeamLength(this.getBeamLength() + this.getDistance() / (float)shootFinish);
                            }
                            if (shooting > shootFinish) {
                                this.setBeamLength(this.getBeamLength() - this.getDistance() / (float)shootFinish);
                            }
                            this.setShootingTicks(this.getShootingTicks() + 1);
                        } else if (shooting >= shootFinish + maxBeamLength) {
                            double x = this.target.f_82479_;
                            double y = this.target.f_82480_;
                            double z = this.target.f_82481_;
                            int radius = MTConfig.MYSTIC_STAFF_AOE_SIZE;
                            Bakuretsu explosion = new Bakuretsu(radius, (float)x, (float)y, (float)z, MysticStaff.getExplosionDamage(true, Utils.getPlayerMahou(caster)));
                            explosion.explosionA(this.f_19853_, caster);
                            for (Player entityplayer : this.f_19853_.m_6907_()) {
                                if (!(entityplayer.m_20275_(x, y, z) < 16384.0)) continue;
                                Vec3 vec = null;
                                if (explosion.knockback.containsKey(caster)) {
                                    vec = explosion.knockback.get(caster);
                                }
                                if (vec == null) {
                                    PacketHandler.sendTo((ServerPlayer)caster, new BakuretsuPacket(x, y, z, radius, 0.0f, 0.0f, 0.0f));
                                    continue;
                                }
                                PacketHandler.sendTo((ServerPlayer)caster, new BakuretsuPacket(x, y, z, radius, (float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_));
                            }
                            this.m_146870_();
                        }
                    }
                }
            }
        }
    }

    public void startShoot(Vec3 target) {
        this.setShootingTicks(0);
        this.target = target;
    }

    public AABB m_20191_() {
        return ZERO_AABB;
    }

    public void setColor(float r, float g, float b, float a) {
        this.f_19804_.m_135381_(COLOR_R, (Object)Float.valueOf(r));
        this.f_19804_.m_135381_(COLOR_G, (Object)Float.valueOf(g));
        this.f_19804_.m_135381_(COLOR_B, (Object)Float.valueOf(b));
        this.f_19804_.m_135381_(COLOR_A, (Object)Float.valueOf(a));
    }

    public float[] getColor() {
        return new float[]{((Float)this.f_19804_.m_135370_(COLOR_R)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_G)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_B)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_A)).floatValue()};
    }

    public void angleCircleAroundBlock(float circleDegrees, float groundDegrees, float distance, Vec3 pos) {
        double height = (double)distance * Math.cos(MysticStaffMahoujinEntity.toRad(groundDegrees));
        double radius = Math.sqrt((double)(distance * distance) - height * height);
        double zplus = radius * Math.sin(MysticStaffMahoujinEntity.toRad(circleDegrees));
        double xplus = -radius * Math.cos(MysticStaffMahoujinEntity.toRad(circleDegrees));
        this.setRotationPitch(groundDegrees);
        this.setRotationRoll(circleDegrees - 90.0f);
        this.m_6034_(pos.f_82479_ + xplus, pos.f_82480_ + height, pos.f_82481_ + zplus);
    }

    public static float toRad(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public void setCasterUUID(UUID uuid) {
        this.casterUUID = uuid;
    }

    public void sizer(float f) {
        this.setCircleSize(f);
    }

    public void m_7378_(CompoundTag compound) {
        this.setRotationYaw(compound.m_128457_(TAG_ROTATION_YAW));
        this.setRotationRoll(compound.m_128457_(TAG_ROTATION_ROLL));
        this.setRotationPitch(compound.m_128457_(TAG_ROTATION_PITCH));
        this.setRotationSpeed(compound.m_128457_("MAHOUTSUKAI_ROTATION_SPEED"));
        this.setCircleSize(compound.m_128457_("MAHOUTSUKAI_ROTATION_SPEED"));
        this.setLife(compound.m_128451_(TAG_LIFE));
        this.setHasBeam(compound.m_128471_(TAG_BEAM));
        this.setBeamSize(compound.m_128457_(TAG_BEAM_SIZE));
        this.setBeamLength(compound.m_128457_(TAG_BEAM_LENGTH));
        this.setBeamOffset(compound.m_128457_(TAG_BEAM_OFFSET));
        this.casterUUID = compound.m_128342_(TAG_CASTER);
        this.setColor(compound.m_128457_(TAG_COLOR_R), compound.m_128457_(TAG_COLOR_G), compound.m_128457_(TAG_COLOR_B), compound.m_128457_(TAG_COLOR_A));
        this.setShootingTicks(compound.m_128451_(TAG_SHOOTING_TICKS));
        this.setDistance(compound.m_128457_(TAG_DISTANCE));
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128350_(TAG_ROTATION_YAW, this.getRotationYaw());
        compound.m_128350_(TAG_ROTATION_ROLL, this.getRotationRoll());
        compound.m_128350_(TAG_ROTATION_PITCH, this.getRotationPitch());
        compound.m_128350_("MAHOUTSUKAI_ROTATION_SPEED", this.getRotationSpeed());
        compound.m_128350_("MAHOUTSUKAI_ROTATION_SPEED", this.getCircleSize());
        compound.m_128405_(TAG_LIFE, this.getLife());
        compound.m_128362_(TAG_CASTER, this.casterUUID);
        compound.m_128350_(TAG_BEAM_OFFSET, this.getBeamOffset());
        compound.m_128350_(TAG_BEAM_LENGTH, this.getBeamLength());
        compound.m_128379_(TAG_BEAM, this.hasBeam());
        compound.m_128350_(TAG_BEAM_SIZE, this.getBeamSize());
        float[] colors = this.getColor();
        compound.m_128350_(TAG_COLOR_R, colors[0]);
        compound.m_128350_(TAG_COLOR_G, colors[1]);
        compound.m_128350_(TAG_COLOR_B, colors[2]);
        compound.m_128350_(TAG_COLOR_A, colors[3]);
        compound.m_128405_(TAG_SHOOTING_TICKS, this.getShootingTicks());
        compound.m_128350_(TAG_DISTANCE, this.getDistance());
    }

    public AABB m_6921_() {
        return bb;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6783_(double distance) {
        return true;
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    public float getRotationYaw() {
        return ((Float)this.f_19804_.m_135370_(ROTATION_YAW)).floatValue();
    }

    public void setRotationYaw(float y) {
        this.f_19804_.m_135381_(ROTATION_YAW, (Object)Float.valueOf(y));
    }

    public float getRotationRoll() {
        return ((Float)this.f_19804_.m_135370_(ROTATION_ROLL)).floatValue();
    }

    public void setRotationRoll(float y) {
        this.f_19804_.m_135381_(ROTATION_ROLL, (Object)Float.valueOf(y));
    }

    public float getRotationPitch() {
        return ((Float)this.f_19804_.m_135370_(ROTATION_PITCH)).floatValue();
    }

    public void setRotationPitch(float p) {
        this.f_19804_.m_135381_(ROTATION_PITCH, (Object)Float.valueOf(p));
    }

    public float getRotationSpeed() {
        return ((Float)this.f_19804_.m_135370_(ROTATION_SPEED)).floatValue();
    }

    public void setRotationSpeed(float s) {
        this.f_19804_.m_135381_(ROTATION_SPEED, (Object)Float.valueOf(s));
    }

    public float getCircleSize() {
        return ((Float)this.f_19804_.m_135370_(CIRCLE_SIZE)).floatValue();
    }

    public void setCircleSize(float s) {
        this.f_19804_.m_135381_(CIRCLE_SIZE, (Object)Float.valueOf(s));
    }

    public int getLife() {
        return (Integer)this.f_19804_.m_135370_(LIFE);
    }

    public void setLife(int l) {
        this.f_19804_.m_135381_(LIFE, (Object)l);
    }

    public boolean hasBeam() {
        return (Boolean)this.f_19804_.m_135370_(BEAM);
    }

    public void setHasBeam(boolean b) {
        this.f_19804_.m_135381_(BEAM, (Object)b);
    }

    public float getBeamSize() {
        return ((Float)this.f_19804_.m_135370_(BEAM_SIZE)).floatValue();
    }

    public void setBeamSize(float b) {
        this.f_19804_.m_135381_(BEAM_SIZE, (Object)Float.valueOf(b));
    }

    public float getBeamLength() {
        return ((Float)this.f_19804_.m_135370_(BEAM_LENGTH)).floatValue();
    }

    public void setBeamLength(float b) {
        this.f_19804_.m_135381_(BEAM_LENGTH, (Object)Float.valueOf(b));
    }

    public float getBeamOffset() {
        return ((Float)this.f_19804_.m_135370_(BEAM_OFFSET)).floatValue();
    }

    public void setBeamOffset(float b) {
        this.f_19804_.m_135381_(BEAM_OFFSET, (Object)Float.valueOf(b));
    }

    public int getShootingTicks() {
        return (Integer)this.f_19804_.m_135370_(SHOOTING_TICKS);
    }

    public void setShootingTicks(int t) {
        this.f_19804_.m_135381_(SHOOTING_TICKS, (Object)t);
    }

    public float getDistance() {
        return ((Float)this.f_19804_.m_135370_(DISTANCE)).floatValue();
    }

    public void setDistance(float d) {
        this.f_19804_.m_135381_(DISTANCE, (Object)Float.valueOf(d));
    }
}

