/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Field;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.projection.ClarentEffect;
import stepsword.mahoutsukai.effects.projection.RealityMarbleSpellEffect;
import stepsword.mahoutsukai.entity.GateWeaponProjectileEntity;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.butterfly.SafeFakePlayer;
import stepsword.mahoutsukai.item.clarent.Clarent;

public class WeaponProjectileEntity
extends Arrow {
    public static final String entityName = "weapon_projectile_entity";
    public static Field a1 = null;
    protected static final UUID BASE_ATTACK_DAMAGE_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    int wpe_life = 0;
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.m_135353_(WeaponProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

    public WeaponProjectileEntity(PlayMessages.SpawnEntity packet, Level worldIn) {
        super((EntityType)ModEntities.WEAPON_PROJECTILE.get(), worldIn);
        this.f_19811_ = true;
    }

    public WeaponProjectileEntity(Level worldIn) {
        super((EntityType)ModEntities.WEAPON_PROJECTILE.get(), worldIn);
        this.f_19811_ = true;
        this.setStack(new ItemStack((ItemLike)Items.f_42383_));
    }

    public WeaponProjectileEntity(Level worldIn, double x, double y, double z, ItemStack stack) {
        this(worldIn);
        this.m_6034_(x, y, z);
        this.setStack(stack);
        this.f_19811_ = true;
    }

    public WeaponProjectileEntity(Level worldIn, LivingEntity shooter, ItemStack stack) {
        this(worldIn, shooter.m_20185_(), shooter.m_20186_() + (double)shooter.m_20192_() - (double)0.1f, shooter.m_20189_(), stack);
        this.m_5602_((Entity)shooter);
        this.f_36705_ = AbstractArrow.Pickup.ALLOWED;
        this.f_19811_ = true;
        this.wpe_life = 0;
    }

    public boolean m_142391_() {
        return !RealityMarbleSpellEffect.inMarble(this.f_19853_);
    }

    public WeaponProjectileEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(ITEM, (Object)new ItemStack((ItemLike)Items.f_42383_));
        super.m_8097_();
    }

    public void m_7380_(CompoundTag nbt) {
        if (this.getStack() != null) {
            nbt.m_128365_("stackNBT", (Tag)this.getStack().serializeNBT());
        }
        nbt.m_128405_("wpe_life", this.wpe_life);
        super.m_7380_(nbt);
    }

    public void m_7378_(CompoundTag nbt) {
        if (nbt.m_128441_("stackNBT")) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)((CompoundTag)nbt.m_128423_("stackNBT")));
            stack.m_41764_(1);
            this.setStack(stack);
        }
        this.wpe_life = nbt.m_128451_("wpe_life");
        super.m_7378_(nbt);
    }

    protected ItemStack m_7941_() {
        return this.getStack();
    }

    protected void m_5790_(EntityHitResult result) {
        double d = this.m_20184_().m_82553_();
        double damage = Mth.m_14165_((double)d);
        Entity entity = result.m_82443_();
        if (this.f_19853_ instanceof ServerLevel && !GateWeaponProjectileEntity.shouldAvoid(this.m_37282_(), entity)) {
            SafeFakePlayer fake_player = new SafeFakePlayer((ServerLevel)this.f_19853_, "faker");
            ItemStack stack = this.m_7941_();
            fake_player.m_21008_(InteractionHand.MAIN_HAND, stack);
            HashMultimap multimap = HashMultimap.create();
            multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Weapon Modifier", MTConfig.WEAPON_SHOOTER_DAMAGE_MULTIPLIER - 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            fake_player.m_21204_().m_22178_(stack.m_41638_(EquipmentSlot.MAINHAND));
            fake_player.m_21204_().m_22178_((Multimap)multimap);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (this.getStack().m_41720_() instanceof Clarent && this.m_37282_() instanceof Player) {
                    int mana = ClarentEffect.getManaCostClarent(this.getStack(), (Player)this.m_37282_());
                    PlayerManaManager.donateManaToFakePlayer(fake_player, (Player)this.m_37282_(), mana);
                }
                fake_player.f_20922_ = 1000;
                fake_player.m_5706_(entity);
                this.m_7761_(livingEntity);
                Entity shooter = null;
                if (this.m_37282_() != null && this.f_19853_ != null && (shooter = this.m_37282_()) != null && entity != shooter && livingEntity instanceof Player && shooter instanceof ServerPlayer) {
                    ((ServerPlayer)shooter).f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
                }
            }
        }
    }

    public void m_8119_() {
        if (this.f_36697_ > 5) {
            this.f_36697_ = 4;
        }
        ++this.wpe_life;
        if (this.wpe_life > 3600) {
            this.m_146870_();
        }
        super.m_8119_();
    }

    public void m_6123_(Player player) {
        if (!this.f_19853_.f_46443_ && this.f_36703_) {
            boolean flag = true;
            ItemStack stack = this.m_7941_().m_41777_();
            stack.m_41764_(1);
            stack.m_41622_(2, (LivingEntity)player, z -> {});
            if (!player.m_150109_().m_36054_(stack)) {
                flag = false;
            }
            if (flag) {
                player.m_7938_((Entity)this, 1);
                this.m_146870_();
            }
        }
    }

    public void shoot(Entity shooter, float pitch, float yaw, float p_184547_4_, float velocity, float inaccuracy) {
        float f = -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)(pitch * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180)));
        this.m_6686_(f, f1, f2, velocity, inaccuracy);
        this.m_20256_(this.m_20184_().m_82520_(shooter.m_20184_().f_82479_, shooter.m_20096_() ? 0.0 : shooter.m_20184_().f_82480_, shooter.m_20184_().f_82481_));
    }

    public ItemStack getStack() {
        return (ItemStack)this.m_20088_().m_135370_(ITEM);
    }

    public void setStack(ItemStack stack) {
        this.m_20088_().m_135381_(ITEM, (Object)stack);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public AABB m_6921_() {
        return new AABB(this.m_20185_() - 1.0, this.m_20186_() - 1.0, this.m_20189_() - 1.0, this.m_20185_() + 1.0, this.m_20186_() + 1.0, this.m_20189_() + 1.0);
    }

    public boolean m_6783_(double distance) {
        return distance < 4096.0;
    }
}

