/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.displacement;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.MahouTsukaiTeleporter;
import stepsword.mahoutsukai.util.Utils;

public class ProtectiveDisplacementSpellEffect {
    public static boolean addProtectionToUser(Player player) {
        IMahou mahou;
        if (player != null && (mahou = Utils.getPlayerMahou(player)) != null) {
            mahou.setProtectiveDisplacement(mahou.getProtectiveDisplacement() + 5);
            return true;
        }
        return false;
    }

    public static boolean protectiveDisplacementProjectileImpact(ProjectileImpactEvent event) {
        int protD;
        Player player;
        IMahou mahou;
        if (!event.getEntity().f_19853_.f_46443_ && event.getRayTraceResult() != null && event.getRayTraceResult() instanceof EntityHitResult && ((EntityHitResult)event.getRayTraceResult()).m_82443_() instanceof Player && (mahou = Utils.getPlayerMahou(player = (Player)((EntityHitResult)event.getRayTraceResult()).m_82443_())) != null && (protD = mahou.getProtectiveDisplacement()) > 0) {
            for (int i = 0; i < 256 && !ProtectiveDisplacementSpellEffect.teleportRandomly(player, player.f_19853_); ++i) {
            }
            mahou.setProtectiveDisplacement(protD - 1);
            return true;
        }
        return false;
    }

    protected static boolean teleportRandomly(Player player, Level world) {
        RandomSource rand = player.m_217043_();
        double d0 = player.m_20185_() + (rand.m_188500_() - 0.5) * 6.0;
        double d1 = player.m_20186_() + (double)(rand.m_188503_(4) - 2);
        double d2 = player.m_20189_() + (rand.m_188500_() - 0.5) * 6.0;
        return ProtectiveDisplacementSpellEffect.teleportTo(d0, d1, d2, player, world);
    }

    private static boolean teleportTo(double x, double y, double z, Player player, Level world) {
        boolean flag = ProtectiveDisplacementSpellEffect.attemptTeleport(x, y, z, player, world);
        if (flag) {
            world.m_6263_(null, player.f_19854_, player.f_19855_, player.f_19856_, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        }
        return flag;
    }

    public static boolean attemptTeleport(double x, double y, double z, Player player, Level world) {
        double d0 = x;
        double d1 = y;
        double d2 = z;
        BlockPos bp = new BlockPos(d0, d1, d2);
        if (Utils.isBlockAir(world, bp.m_7918_(0, 1, 0)) && Utils.isBlockAir(world, bp.m_7918_(0, 2, 0)) && !Utils.isBlockAir(world, bp)) {
            MahouTsukaiTeleporter.teleport((Entity)player, d0, d1 + 1.0, d2, EffectUtil.getDimension(player.f_19853_));
            return true;
        }
        return false;
    }
}

