/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.client;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import stepsword.mahoutsukai.client.BorrowedAuthorityClientEffect;
import stepsword.mahoutsukai.client.ButterflyClientEffect;
import stepsword.mahoutsukai.client.ClarentClientEffect;
import stepsword.mahoutsukai.client.ConfusionClientEffect;
import stepsword.mahoutsukai.client.ManaClientEvents;
import stepsword.mahoutsukai.client.MentalDisplacementClientEffect;
import stepsword.mahoutsukai.client.MorganClientEffect;
import stepsword.mahoutsukai.client.MysticCodeClientEffect;
import stepsword.mahoutsukai.client.PossessEntityClientEffect;
import stepsword.mahoutsukai.client.RipperClientEffect;
import stepsword.mahoutsukai.commands.ModCommands;
import stepsword.mahoutsukai.effects.projection.PowerConsolidationSpellEffect;
import stepsword.mahoutsukai.effects.projection.ProximityProjectionSpellEffect;
import stepsword.mahoutsukai.entity.MentalDisplacementEntity;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.potion.BoundPotion;
import stepsword.mahoutsukai.render.ProjectorRenderer;
import stepsword.mahoutsukai.render.RenderUtils;
import stepsword.mahoutsukai.render.enchant.RenderProjectorEnchant;
import stepsword.mahoutsukai.render.gui.MahouGui;
import stepsword.mahoutsukai.render.gui.RenderPowerConsolidationInnateCap;
import stepsword.mahoutsukai.render.gui.RenderRuleBreakerModulus;
import stepsword.mahoutsukai.render.gui.RenderStrengthening;
import stepsword.mahoutsukai.render.overlay.RenderBlackBurning;
import stepsword.mahoutsukai.render.overlay.RenderBoundOverlay;
import stepsword.mahoutsukai.render.overlay.RenderClairvoyance;
import stepsword.mahoutsukai.render.overlay.RenderFogProjectors;
import stepsword.mahoutsukai.render.overlay.RenderInsightOverlay;
import stepsword.mahoutsukai.render.overlay.RenderInterestingBlock;
import stepsword.mahoutsukai.render.overlay.RenderLeyLines;
import stepsword.mahoutsukai.render.overlay.RenderPowerConsolidation;
import stepsword.mahoutsukai.render.overlay.RenderRevertedOverlay;
import stepsword.mahoutsukai.render.overlay.RenderSelectedEntity;

public class ClientHandler {
    public static long clientTickCounter = 0L;

    @SubscribeEvent
    public void clientLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        ProjectorRenderer.cacheClear();
    }

    @SubscribeEvent
    public void registerClientCommands(RegisterClientCommandsEvent event) {
        ModCommands.registerClient((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void renderOverlay(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay().id().equals((Object)VanillaGuiOverlay.PORTAL.id())) {
            RenderInsightOverlay.insightOverlay(event.getPoseStack());
            RenderBoundOverlay.boundOverlay(event.getPoseStack());
            RenderRevertedOverlay.revertedOverlay(event.getPoseStack());
            MahouGui.mahoujinOverlay(event.getPoseStack());
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void renderWorldLast(RenderLevelStageEvent event) {
        Entity re = Minecraft.m_91087_().m_91288_();
        if (re != null && event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            RenderLeyLines.leyRender(re, event.getPoseStack(), event.getPartialTick());
            RenderUtils.entityRenders(re, event.getPoseStack(), event.getPartialTick());
            RenderUtils.particleRenders(re, event.getPoseStack(), event.getPartialTick());
            RenderClairvoyance.renderPrediction(event.getPoseStack(), re, event.getPartialTick());
            RenderInterestingBlock.interestingBlockOverlay(event.getPoseStack(), event.getPartialTick());
            if (re instanceof MentalDisplacementEntity) {
                MentalDisplacementClientEffect.mentalDisplacementRenderWorldLast(event);
            }
            PossessEntityClientEffect.possessionRenderWorldLast(event);
            RenderSelectedEntity.renderSelectedEntity(event);
        }
    }

    @SubscribeEvent
    public void renderLivingPre(RenderLivingEvent.Pre event) {
        RenderBlackBurning.renderEntityFire(event.getEntity(), event.getPoseStack(), event.getMultiBufferSource(), event.getPartialTick(), event.getRenderer());
        RenderProjectorEnchant.renderProjectorEnchantment(event);
    }

    @SubscribeEvent
    public void renderLivingPre(RenderHandEvent event) {
        RenderBlackBurning.renderOverlayFire(event.getPoseStack(), event.getPartialTick());
        ServerHandler.cancelEvent((Event)event, PossessEntityClientEffect.possessEntityRenderHand());
        ServerHandler.cancelEvent((Event)event, MentalDisplacementClientEffect.mentalDisplacementRenderHand());
        if (!event.isCanceled()) {
            MysticCodeClientEffect.renderHand(event);
        }
    }

    @SubscribeEvent
    public void leftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        ProximityProjectionSpellEffect.proximityProjectionLeftClickEmpty(event.getEntity());
        PowerConsolidationSpellEffect.caliburnLeftClickSpace(event);
        ButterflyClientEffect.butterflyHit((PlayerInteractEvent)event);
        ServerHandler.cancelEvent((Event)event, PossessEntityClientEffect.possessEntityDisallowedAction((PlayerInteractEvent)event));
        ServerHandler.cancelEvent((Event)event, MentalDisplacementClientEffect.mentalDisplacementDisallowedAction(event.getEntity()));
    }

    @SubscribeEvent
    public void itemTooltip(ItemTooltipEvent event) {
        RenderStrengthening.strengthenTooltip(event.getItemStack(), event.getToolTip());
        RenderPowerConsolidationInnateCap.innateCapTooltip(event.getItemStack(), event.getToolTip());
        RenderRuleBreakerModulus.modulusTooltip(event.getItemStack(), event.getToolTip());
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ManaClientEvents.keyPress();
            RenderSelectedEntity.selectedEntity((Entity)Minecraft.m_91087_().f_91074_);
        }
        if (event.phase == TickEvent.Phase.START) {
            ++clientTickCounter;
            clientTickCounter %= 50000L;
            RenderInsightOverlay.insightCounters();
        }
    }

    @SubscribeEvent
    public void keyBindPressed(InputEvent.MouseButton event) {
        PossessEntityClientEffect.possessEntityMouseInput();
        MentalDisplacementClientEffect.mentalDisplacementMouseInput();
        BorrowedAuthorityClientEffect.borrowedAuthorityLeftClickingJump(event);
    }

    @SubscribeEvent
    public void clickInputPressed(InputEvent.InteractionKeyMappingTriggered event) {
        ServerHandler.cancelEvent((Event)event, RipperClientEffect.ripperPlayerLeftClick(event));
    }

    @SubscribeEvent
    public void inputUpdate(MovementInputUpdateEvent event) {
        PossessEntityClientEffect.possessEntityInputUpdate(event.getInput(), event.getEntity());
        MentalDisplacementClientEffect.mentalDisplacementInputUpdate(event.getInput(), event.getEntity());
        BoundPotion.boundMovement(event.getEntity(), event.getInput());
        ConfusionClientEffect.confusionInputUpdate(event.getEntity(), event.getInput());
        BorrowedAuthorityClientEffect.borrowedAuthorityJumpEffect(event.getEntity(), event.getInput());
    }

    @SubscribeEvent
    public void rightClickEventBlockP(PlayerInteractEvent.RightClickBlock event) {
        ServerHandler.cancelEvent((Event)event, PossessEntityClientEffect.possessEntityDisallowedAction((PlayerInteractEvent)event));
        ServerHandler.cancelEvent((Event)event, MentalDisplacementClientEffect.mentalDisplacementDisallowedAction(event.getEntity()));
    }

    @SubscribeEvent
    public void rightClickEventItemP(PlayerInteractEvent.RightClickItem event) {
        ServerHandler.cancelEvent((Event)event, PossessEntityClientEffect.possessEntityDisallowedAction((PlayerInteractEvent)event));
        ServerHandler.cancelEvent((Event)event, MentalDisplacementClientEffect.mentalDisplacementDisallowedAction(event.getEntity()));
    }

    @SubscribeEvent
    public void rightClickEventEmptyP(PlayerInteractEvent.RightClickEmpty event) {
        ServerHandler.cancelEvent((Event)event, PossessEntityClientEffect.possessEntityDisallowedAction((PlayerInteractEvent)event));
        ServerHandler.cancelEvent((Event)event, MentalDisplacementClientEffect.mentalDisplacementDisallowedAction(event.getEntity()));
    }

    @SubscribeEvent
    public void leftClickEventBlockP(PlayerInteractEvent.LeftClickBlock event) {
        ServerHandler.cancelEvent((Event)event, PossessEntityClientEffect.possessEntityDisallowedAction((PlayerInteractEvent)event));
        ServerHandler.cancelEvent((Event)event, MentalDisplacementClientEffect.mentalDisplacementDisallowedAction(event.getEntity()));
    }

    @SubscribeEvent
    public void attackEntity(AttackEntityEvent event) {
        ServerHandler.cancelEvent((Event)event, PossessEntityClientEffect.possessEntityDisallowedAction(event.getEntity()));
        ServerHandler.cancelEvent((Event)event, MentalDisplacementClientEffect.mentalDisplacementDisallowedAction(event.getEntity()));
    }

    @SubscribeEvent
    public void entityJoinWorld(EntityJoinLevelEvent event) {
        MentalDisplacementClientEffect.mentalDisplacementEntityJoin(event.getEntity());
    }

    @SubscribeEvent
    public void textOverlay(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay().id().equals((Object)VanillaGuiOverlay.TITLE_TEXT.id())) {
            MahouGui.manaText(event.getPoseStack());
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void fogColorEvent(ViewportEvent.ComputeFogColor event) {
        boolean lake = RenderPowerConsolidation.powerConsolidationFogColor(event);
        ServerHandler.cancelEvent((Event)event, lake);
        if (!lake) {
            ServerHandler.cancelEvent((Event)event, RenderFogProjectors.fogProjectorColor(event));
        }
    }

    @SubscribeEvent
    public void blockOverlay(RenderBlockScreenEffectEvent event) {
        ServerHandler.cancelEvent((Event)event, RenderPowerConsolidation.powerConsolidationBlockOverlay(event));
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void renderFog(ViewportEvent.RenderFog event) {
        boolean lake = RenderPowerConsolidation.powerConsolidationRenderFog(event);
        ServerHandler.cancelEvent((Event)event, lake);
        if (!lake) {
            ServerHandler.cancelEvent((Event)event, RenderFogProjectors.fogProjectorRenderFog(event));
        }
        RenderPowerConsolidation.powerConsolidationFogDensity(event);
    }

    @SubscribeEvent
    public void renderPlayerPre(RenderPlayerEvent.Pre event) {
        ClarentClientEffect.clarentRenderPlayer(event);
        ServerHandler.cancelEvent((Event)event, RipperClientEffect.ripperRenderPlayer(event.getEntity()));
    }

    @SubscribeEvent
    public void renderPlayerPost(RenderPlayerEvent.Post event) {
        ClarentClientEffect.clarentRenderPlayer(event);
    }

    @SubscribeEvent
    public void livingUpdate(LivingEvent.LivingTickEvent event) {
        MorganClientEffect.morganParticlesLivingUpdate(event.getEntity());
        BorrowedAuthorityClientEffect.borrowedAuthorityParticlesLivingUpdate(event.getEntity());
        BorrowedAuthorityClientEffect.borrowedAuthorityJumpingPunch(event.getEntity());
    }
}

