/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.capability.mahou;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import stepsword.mahoutsukai.capability.gemmahou.GemMahouStorage;
import stepsword.mahoutsukai.capability.gemmahou.IGemMahou;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.Leylines;
import stepsword.mahoutsukai.effects.secret.GeasEffect;
import stepsword.mahoutsukai.entity.butterfly.SafeFakePlayer;
import stepsword.mahoutsukai.entity.fae.FaeEntity;
import stepsword.mahoutsukai.item.attunedgems.AttunedGem;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.PlayerMahouPacket;
import stepsword.mahoutsukai.tile.circuits.ManaCircuitTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class PlayerManaManager {
    public static void damagePlayer(Player player, int mana) {
        boolean z;
        if (player != null && !player.f_19853_.f_46443_ && ((z = false) || MTConfig.MAGIC_DAMAGES_PLAYER)) {
            double v = 0.0;
            v = MTConfig.MAGIC_DAMAGE_FLAT ? MTConfig.MAGIC_DAMAGE_VALUE : MTConfig.MAGIC_DAMAGE_VALUE * (double)mana;
            player.m_6469_(MTConfig.MAGIC_DAMAGE_GENERIC ? DamageSource.f_19318_ : DamageSource.f_19319_, (float)v);
            player.f_20889_ = 100;
        }
    }

    public static void donateManaToFakePlayer(SafeFakePlayer fake, Player player, int mana) {
        if (PlayerManaManager.drainMana(player, mana, false, false) == mana) {
            fake.setMana(mana);
        }
    }

    public static int drainMana(Player player, int drain, boolean nogems, boolean nocircuits) {
        return PlayerManaManager.drainMana(player, drain, nogems, nocircuits, true, false);
    }

    public static int drainMana(Player player, int drain, boolean nogems, boolean nocircuits, boolean maxincr, boolean noupdate) {
        return PlayerManaManager.drainMana(player, drain, nogems, nocircuits, maxincr, noupdate, false);
    }

    public static int drainMana(Player player, int drain, boolean nogems, boolean nocircuits, boolean maxincr, boolean noupdate, boolean drainifnotenough) {
        IMahou mahou = Utils.getPlayerMahou(player);
        if (player.m_7500_() && MTConfig.CREATIVE_IGNORES_MANA_COSTS && !player.f_19853_.f_46443_) {
            return drain;
        }
        BlockPos p = player.m_20183_();
        if (player instanceof FakePlayer) {
            p = player.m_20183_();
        }
        int playerUsedMana = 0;
        int returnManaUsed = 0;
        Utils.debug(mahou);
        if (mahou != null) {
            int playerMana = mahou.getStoredMana();
            if (player instanceof FakePlayer) {
                playerMana = 0;
            }
            if (player instanceof SafeFakePlayer) {
                playerMana = ((SafeFakePlayer)player).getMana();
            }
            int remaining = drain;
            Set<BlockEntity> circuits = null;
            ArrayList<ItemStack> playerGems = null;
            if (!nogems) {
                playerGems = PlayerManaManager.gemsInInventory(player);
            }
            if (!nocircuits) {
                circuits = PlayerManaManager.nearbyBatteries(p, player.f_19853_);
            }
            if (playerMana >= drain) {
                playerUsedMana = drain;
                returnManaUsed = drain;
            } else {
                int totalMana = playerMana;
                if (playerGems != null) {
                    totalMana += PlayerManaManager.countManaInGems(playerGems);
                }
                if (circuits != null) {
                    totalMana += PlayerManaManager.countManaInNearbyBatteries(p, player.f_19853_, circuits, player.m_20148_());
                }
                if (totalMana < drain) {
                    if (drainifnotenough) {
                        playerUsedMana = playerMana;
                        returnManaUsed = playerMana;
                        int tmp = remaining;
                        if (circuits != null && !nocircuits) {
                            remaining = PlayerManaManager.drainManaFromNearbyBatteries(p, player.f_19853_, circuits, remaining, player.m_20148_());
                        }
                        returnManaUsed += tmp - remaining;
                        tmp = remaining;
                        if (playerGems != null && !nogems) {
                            remaining = PlayerManaManager.drainManaFromGems(playerGems, remaining);
                        }
                        returnManaUsed += tmp - remaining;
                    } else if (!nogems) {
                        playerUsedMana = 0;
                        returnManaUsed = 0;
                    } else {
                        playerUsedMana = playerMana;
                        returnManaUsed = playerMana;
                        int tmp = remaining;
                        if (circuits != null) {
                            remaining = PlayerManaManager.drainManaFromNearbyBatteries(p, player.f_19853_, circuits, remaining, player.m_20148_());
                        }
                        returnManaUsed += tmp - remaining;
                    }
                } else {
                    remaining = drain - playerMana;
                    playerUsedMana = playerMana;
                    returnManaUsed = drain;
                    if (playerGems != null) {
                        remaining = PlayerManaManager.drainManaFromGems(playerGems, remaining);
                    }
                    if (circuits != null) {
                        remaining = PlayerManaManager.drainManaFromNearbyBatteries(p, player.f_19853_, circuits, remaining, player.m_20148_());
                    }
                }
            }
            mahou.setManaFull(false);
            mahou.setStoredMana(Math.max(0, playerMana - playerUsedMana));
            if (maxincr) {
                PlayerManaManager.updateManaCounter((ServerPlayer)player, playerUsedMana);
            }
            if (!noupdate) {
                PlayerManaManager.updateClientMahou((ServerPlayer)player, mahou);
            }
            if (playerUsedMana > 0) {
                PlayerManaManager.damagePlayer(player, playerUsedMana);
            }
        }
        return returnManaUsed;
    }

    public static int countMana(Player player) {
        IMahou mahou = Utils.getPlayerMahou(player);
        if (mahou == null) {
            return 0;
        }
        int totalMana = mahou.getStoredMana();
        Set<BlockEntity> circuits = null;
        ArrayList<ItemStack> playerGems = null;
        playerGems = PlayerManaManager.gemsInInventory(player);
        circuits = PlayerManaManager.nearbyBatteries(player.m_20183_(), player.f_19853_);
        if (player instanceof SafeFakePlayer) {
            return ((SafeFakePlayer)player).getMana();
        }
        if (playerGems != null) {
            totalMana += PlayerManaManager.countManaInGems(playerGems);
        }
        if (circuits != null) {
            totalMana += PlayerManaManager.countManaInNearbyBatteries(player.m_20183_(), player.f_19853_, circuits, player.m_20148_());
        }
        return totalMana;
    }

    public static int chargeCircuit(Player player, int drain) {
        IMahou mahou = Utils.getPlayerMahou(player);
        int playerUsedMana = 0;
        int remaining = drain;
        int ret = 0;
        if (mahou != null) {
            int playerMana = mahou.getStoredMana();
            if (player instanceof FakePlayer) {
                playerMana = 0;
            }
            if (player instanceof SafeFakePlayer) {
                playerMana = ((SafeFakePlayer)player).getMana();
            }
            ArrayList<ItemStack> playerGems = null;
            playerGems = PlayerManaManager.gemsInInventory(player);
            if (playerMana >= drain) {
                playerUsedMana = drain;
                ret = drain;
            } else {
                int totalMana = playerMana;
                if (playerGems != null) {
                    totalMana += PlayerManaManager.countManaInGems(playerGems);
                }
                if (totalMana < drain) {
                    playerUsedMana = playerMana;
                    ret = playerMana;
                    if (playerGems != null) {
                        remaining = PlayerManaManager.drainManaFromGems(playerGems, drain - playerUsedMana);
                    }
                    ret += drain - playerUsedMana - remaining;
                } else {
                    remaining = drain - playerMana;
                    playerUsedMana = playerMana;
                    ret = playerMana;
                    if (playerGems != null) {
                        ret += remaining - PlayerManaManager.drainManaFromGems(playerGems, remaining);
                    }
                }
            }
            mahou.setManaFull(false);
            mahou.setStoredMana(Math.max(0, playerMana - playerUsedMana));
            PlayerManaManager.updateManaCounter((ServerPlayer)player, playerUsedMana);
            PlayerManaManager.updateClientMahou((ServerPlayer)player, mahou);
            if (playerUsedMana > 0) {
                PlayerManaManager.damagePlayer(player, playerUsedMana);
            }
        } else {
            Utils.debug("Getting Mana from Batteries");
            return PlayerManaManager.getManaFromBatteriesFirst(new BlockPos((Vec3i)player.m_20183_()), player.f_19853_, player.m_20148_(), drain) ? drain : 0;
        }
        return ret;
    }

    public static int chargeAnyNearbyBatteries(BlockPos p, Level world, Set<BlockEntity> tes, int charge) {
        Set<BlockEntity> tes2 = tes;
        if (tes2 == null) {
            tes2 = PlayerManaManager.nearbyBatteries(p, world);
        }
        int remaining = charge;
        for (BlockEntity te : tes2) {
            ManaCircuitTileEntity mte;
            int tmp;
            if (!(te instanceof ManaCircuitTileEntity) || (tmp = (mte = (ManaCircuitTileEntity)te).getMaxMana() - mte.getMana()) <= 0) continue;
            if (tmp > remaining) {
                mte.setMana(mte.getMana() + remaining);
                remaining = 0;
            } else {
                mte.setMana(mte.getMaxMana());
                remaining -= tmp;
            }
            mte.sendUpdates();
            if (remaining > 0) continue;
            break;
        }
        return remaining;
    }

    public static ArrayList<ItemStack> gemsInInventory(Player player) {
        ArrayList<ItemStack> playerGems = new ArrayList<ItemStack>();
        for (List list : Arrays.asList(player.m_150109_().f_35974_, player.m_150109_().f_35975_, player.m_150109_().f_35976_)) {
            for (ItemStack itemstack : list) {
                if (itemstack.m_41619_() || !(itemstack.m_41720_() instanceof AttunedGem)) continue;
                playerGems.add(itemstack);
            }
        }
        return playerGems;
    }

    public static int countManaInGems(ArrayList<ItemStack> playerGems) {
        int ret = 0;
        for (ItemStack itemstack : playerGems) {
            IGemMahou gemMahou;
            if (itemstack.m_41619_() || !(itemstack.m_41720_() instanceof AttunedGem) || (gemMahou = Utils.getGemMahou(itemstack)) == null) continue;
            ret += gemMahou.getStoredMana();
        }
        return ret;
    }

    public static int drainManaFromGems(ArrayList<ItemStack> playerGems, int drain) {
        int remaining = drain;
        for (ItemStack stack : playerGems) {
            IGemMahou gemMahou;
            if (remaining <= 0) break;
            if (stack.m_41619_() || !(stack.m_41720_() instanceof AttunedGem) || (gemMahou = Utils.getGemMahou(stack)) == null) continue;
            int tmp = gemMahou.getStoredMana();
            if (remaining >= tmp) {
                remaining -= tmp;
                gemMahou.setStoredMana(0);
            } else {
                gemMahou.setStoredMana(gemMahou.getStoredMana() - remaining);
                remaining = 0;
            }
            stack.m_41751_((CompoundTag)GemMahouStorage.writeNBT(gemMahou));
        }
        return remaining;
    }

    public static int countManaInNearbyBatteries(BlockPos p, Level world, Set<BlockEntity> tes, UUID uuid) {
        Set<BlockEntity> tes2 = tes;
        if (tes2 == null) {
            tes2 = PlayerManaManager.nearbyBatteries(p, world);
        }
        int ret = 0;
        for (BlockEntity te : tes2) {
            if (!(te instanceof ManaCircuitTileEntity)) continue;
            ManaCircuitTileEntity mte = (ManaCircuitTileEntity)te;
            if (uuid == null || !uuid.equals(mte.getOwnerUUID()) && !mte.getFae()) continue;
            ret += mte.getMana();
        }
        return ret;
    }

    public static int drainManaFromNearbyBatteries(BlockPos p, Level world, Set<BlockEntity> tes, int drain, UUID uuid) {
        Set<BlockEntity> tes2 = tes;
        if (tes2 == null) {
            tes2 = PlayerManaManager.nearbyBatteries(p, world);
        }
        int remaining = drain;
        for (BlockEntity te : tes2) {
            if (!(te instanceof ManaCircuitTileEntity)) continue;
            ManaCircuitTileEntity mte = (ManaCircuitTileEntity)te;
            Utils.debug("Getting Mana from Batteries: Fay: " + mte.getFae() + ", UUID: " + uuid + ", Owner UUID:" + mte.getOwnerUUID());
            if (uuid == null || !uuid.equals(mte.getOwnerUUID()) && !mte.getFae()) continue;
            if (remaining <= 0) break;
            int tmp = mte.getMana();
            if (remaining >= tmp) {
                remaining -= tmp;
                mte.setMana(0);
            } else {
                mte.setMana(mte.getMana() - remaining);
                remaining = 0;
            }
            mte.sendUpdates();
        }
        return remaining;
    }

    public static Set<BlockEntity> nearbyBatteries(final BlockPos p, Level world) {
        final int range = MTConfig.MANA_CIRCUIT_RANGE;
        BlockPos min = p.m_7918_(-range, -range, -range);
        BlockPos max = p.m_7918_(range, range, range);
        Utils.debug("Getting Mana from Batteries BlockPos:" + p.toString());
        ChunkPos cmin = new ChunkPos(min);
        ChunkPos cmax = new ChunkPos(max);
        HashSet<BlockEntity> tes = new HashSet<BlockEntity>();
        List<Object> tmp = new ArrayList();
        for (int i = Math.min(cmin.f_45578_, cmax.f_45578_); i <= Math.max(cmin.f_45578_, cmax.f_45578_); ++i) {
            for (int j = Math.min(cmin.f_45579_, cmax.f_45579_); j <= Math.max(cmin.f_45579_, cmax.f_45579_); ++j) {
                LevelChunk c = world.m_6325_(i, j);
                tmp = c.m_62954_().values().stream().filter(new Predicate<BlockEntity>(){

                    @Override
                    public boolean test(BlockEntity tileEntity) {
                        return tileEntity instanceof ManaCircuitTileEntity && ((ManaCircuitTileEntity)tileEntity).isRedstoneOn() && Math.abs(tileEntity.m_58899_().m_123341_() - p.m_123341_()) < range && Math.abs(tileEntity.m_58899_().m_123343_() - p.m_123343_()) < range;
                    }
                }).collect(Collectors.toList());
                tes.addAll(tmp);
            }
        }
        return tes;
    }

    public static boolean getManaFromBatteriesFirst(BlockPos p, Level world, UUID uuid, int drain) {
        Set<BlockEntity> tes = PlayerManaManager.nearbyBatteries(p, world);
        if (PlayerManaManager.countManaInNearbyBatteries(p, world, tes, uuid) >= drain) {
            PlayerManaManager.drainManaFromNearbyBatteries(p, world, tes, drain, uuid);
            return true;
        }
        return false;
    }

    public static void regenMana(Player player, boolean sleep) {
        IMahou mahou = Utils.getPlayerMahou(player);
        if (mahou != null) {
            double sleepregen = MTConfig.MANA_RECOVERY_SLEEP;
            int playerMaxMana = mahou.getMaxMana();
            int playerStoredMana = mahou.getStoredMana();
            int punishment = (int)(MTConfig.DEATH_COLLECTION_DRAIN_PER_SOUL * (double)mahou.getDeathCollectionUsesLeft());
            if (playerMaxMana <= playerStoredMana) {
                mahou.setStoredMana(Math.max(0, playerMaxMana - punishment));
            } else {
                int regen = !sleep ? PlayerManaManager.getManaRegen(player) : (int)(sleepregen * (double)playerMaxMana);
                if (punishment > mahou.getStoredMana() + regen && MTConfig.DEATH_COLLECTION_NEGATIVE_REGEN_PUNISHMENT) {
                    mahou.setDeathCollectionUsesLeft(Math.max(0.0f, (float)((double)mahou.getDeathCollectionUsesLeft() - MTConfig.DEATH_COLLECTION_SOUL_VALUE_PLAYER)));
                }
                mahou.setStoredMana(Math.min(Math.max(mahou.getStoredMana() + regen - punishment, 0), mahou.getMaxMana()));
            }
            PlayerManaManager.updateClientMahou((ServerPlayer)player, mahou);
        }
    }

    public static void updateManaCounter(ServerPlayer player, int mana) {
        IMahou mahou = Utils.getPlayerMahou((Player)player);
        int default_MANA_UP_COUNTER = MTConfig.MANA_UP_COUNTER;
        int default_MANA_INCREASE = MTConfig.MANA_INCREASE;
        if (mahou != null) {
            int max = mahou.getMaxMana();
            int mana_up_counter = MTConfig.MANA_UP_COUNTER_RATIO > 0.0 ? (int)Math.max(Math.min(MTConfig.MANA_UP_COUNTER_MAX, (double)max * MTConfig.MANA_UP_COUNTER_RATIO), (double)default_MANA_UP_COUNTER) : default_MANA_UP_COUNTER;
            double punishment = MTConfig.MANA_INCREASE_PUNISHMENT_FACTOR;
            punishment = MTConfig.MANA_INCREASE_LOG_PUNISHMENT ? (punishment *= Math.log(max)) : (punishment *= (double)max);
            int counter = mahou.getManaToUseCounter();
            int leftover = 0;
            if ((counter -= mana) <= 0) {
                int increase = default_MANA_INCREASE;
                if (counter < 0) {
                    increase += Math.abs(counter * default_MANA_INCREASE / mana_up_counter);
                    leftover = Math.abs(counter) % mana_up_counter;
                }
                increase = (int)Math.max(1L, Math.round((double)increase - punishment));
                counter = mana_up_counter - leftover;
                PlayerManaManager.increaseMaxMana((Player)player, increase);
            }
            mahou.setManaToUseCounter(counter);
            PlayerManaManager.updateClientMahou(player, mahou);
        }
    }

    public static void increaseMaxMana(Player player, int increase) {
        int true_MAX_MANA = MTConfig.MAX_MANA_CAP;
        IMahou mahou = Utils.getPlayerMahou(player);
        mahou.setMaxMana(Math.min(true_MAX_MANA, mahou.getMaxMana() + increase));
    }

    public static int getManaRegen(Player player) {
        int true_MAX_MANA = MTConfig.MAX_MANA_CAP;
        int default_MANA_REGEN_RATE_PER_TICK = MTConfig.MANA_REGEN_PER_TICK;
        double scaling_regen_factor = MTConfig.MANA_ADDED_SCALING_REGEN_PER_TICK;
        IMahou mahou = Utils.getPlayerMahou(player);
        FoodData fs = player.m_36324_();
        int hunger = fs.m_38702_();
        double saturation = fs.m_38722_();
        double regenRatio = (float)mahou.getMaxMana() / (float)true_MAX_MANA;
        boolean flat = MTConfig.LEY_FLAT;
        float punishment = MTConfig.LEY_PUNISHMENT;
        float leyfactor = (float)MTConfig.LEY_FACTOR;
        int ley = Leylines.nearbyLeyValue(player.m_20183_());
        float ley2 = (float)ley / 19.0f;
        float addonleymana = 0.0f;
        if (MTConfig.LEY_AFFECTS_MANA) {
            addonleymana = !flat ? punishment + ley2 * (float)mahou.getMaxMana() * leyfactor : punishment + leyfactor * ley2;
        }
        if (!Leylines.leyDimensionValid(EffectUtil.getDimension(player.f_19853_))) {
            addonleymana = 0.0f;
        } else if (ley >= 13 && mahou.getFaeSpawn() && Math.random() < 0.1 * MTConfig.FAE_SPAWN_RATE && mahou.hasMagic() && !player.f_19853_.f_46443_) {
            FaeEntity fae = new FaeEntity(player.f_19853_);
            fae.m_6034_(player.m_20185_() + (double)player.m_217043_().m_188503_(10), player.m_20186_(), player.m_20189_() + (double)player.m_217043_().m_188503_(10));
            if (Utils.isBlockAir(player.f_19853_, fae.m_20183_())) {
                try {
                    player.f_19853_.m_7967_((Entity)fae);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return default_MANA_REGEN_RATE_PER_TICK + (int)(scaling_regen_factor * (double)mahou.getMaxMana()) + (int)Math.ceil(((double)hunger + saturation) * regenRatio * MTConfig.MANA_REGEN_HUNGER_FACTOR) + (int)addonleymana + (int)((double)GeasEffect.getUniqueGeasCount(player) * MTConfig.MANA_REGEN_PER_GEAS);
    }

    public static void updateClientMahou(ServerPlayer player, IMahou mahou) {
        if (player != null && mahou != null) {
            PacketHandler.sendTo(player, new PlayerMahouPacket(mahou));
        }
    }

    public static boolean hasMana(Player player, int drain) {
        return PlayerManaManager.countMana(player) > drain;
    }

    public static void playerDeath(LivingDeathEvent event) {
        IMahou mahou;
        if (MTConfig.ONE_LIFE && event.getEntity() instanceof Player && (mahou = Utils.getPlayerMahou((Player)event.getEntity())) != null) {
            mahou.setMaxMana(100);
            mahou.setManaToUseCounter(100);
            mahou.setDeathCollectionUsesLeft(0.0f);
            mahou.setDamageReplicationTarget(null);
            mahou.clearBuffs();
        }
    }
}

