/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.vessel.barge;

import dev.murad.shipping.entity.custom.vessel.barge.AbstractBargeEntity;
import dev.murad.shipping.entity.custom.vessel.tug.AbstractTugEntity;
import dev.murad.shipping.setup.ModEntityTypes;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.util.FluidDisplayUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidTankBargeEntity
extends AbstractBargeEntity {
    public static int CAPACITY = 10000;
    protected FluidTank tank = new FluidTank(CAPACITY){

        protected void onContentsChanged() {
            FluidTankBargeEntity.this.sendInfoToClient();
        }
    };
    private static final EntityDataAccessor<Integer> VOLUME = SynchedEntityData.m_135353_(AbstractTugEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> FLUID_TYPE = SynchedEntityData.m_135353_(AbstractTugEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private Fluid clientCurrFluid = Fluids.f_76191_;
    private int clientCurrAmount = 0;
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);

    public FluidTankBargeEntity(EntityType<? extends AbstractBargeEntity> type, Level world) {
        super(type, world);
    }

    public FluidTankBargeEntity(Level worldIn, double x, double y, double z) {
        super((EntityType<? extends AbstractBargeEntity>)((EntityType)ModEntityTypes.FLUID_TANK_BARGE.get()), worldIn, x, y, z);
    }

    @Override
    public Item getDropItem() {
        return (Item)ModItems.FLUID_BARGE.get();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLUID_TYPE, (Object)"minecraft:empty");
        this.f_19804_.m_135372_(VOLUME, (Object)0);
    }

    @Override
    protected void doInteract(Player player) {
        FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)InteractionHand.MAIN_HAND, (IFluidHandler)this.tank);
        player.m_5661_(FluidDisplayUtil.getFluidDisplay(this.tank), false);
    }

    public FluidStack getFluidStack() {
        return this.tank.getFluid();
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.tank.readFromNBT(tag);
        this.sendInfoToClient();
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.tank.writeToNBT(tag);
    }

    private void sendInfoToClient() {
        this.f_19804_.m_135381_(VOLUME, (Object)this.tank.getFluidAmount());
        this.f_19804_.m_135381_(FLUID_TYPE, (Object)ForgeRegistries.FLUIDS.getKey((Object)this.tank.getFluid().getFluid()).toString());
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (this.f_19853_.f_46443_) {
            if (VOLUME.equals(key)) {
                this.clientCurrAmount = (Integer)this.f_19804_.m_135370_(VOLUME);
                this.tank.setFluid(new FluidStack(this.clientCurrFluid, this.clientCurrAmount));
            } else if (FLUID_TYPE.equals(key)) {
                ResourceLocation fluidName = new ResourceLocation((String)this.f_19804_.m_135370_(FLUID_TYPE));
                this.clientCurrFluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidName);
                this.tank.setFluid(new FluidStack(this.clientCurrFluid, this.clientCurrAmount));
            }
        }
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }
}

