/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.accessor;

import dev.murad.shipping.entity.accessor.HeadVehicleDataAccessor;
import dev.murad.shipping.entity.accessor.SupplierIntArray;
import java.util.function.IntSupplier;
import net.minecraft.world.inventory.ContainerData;

public class EnergyHeadVehicleDataAccessor
extends HeadVehicleDataAccessor {
    private static final int SHORT_MASK = 65535;

    public EnergyHeadVehicleDataAccessor(ContainerData data) {
        super(data);
    }

    public int getEnergy() {
        int lo = this.data.m_6413_(15) & 0xFFFF;
        int hi = this.data.m_6413_(16) & 0xFFFF;
        return lo | hi << 16;
    }

    public int getCapacity() {
        int lo = this.data.m_6413_(17) & 0xFFFF;
        int hi = this.data.m_6413_(18) & 0xFFFF;
        return lo | hi << 16;
    }

    public static class Builder
    extends HeadVehicleDataAccessor.Builder {
        public Builder() {
            this.arr = new SupplierIntArray(20);
        }

        public Builder withEnergy(IntSupplier energy) {
            this.arr.setSupplier(15, () -> energy.getAsInt() & 0xFFFF);
            this.arr.setSupplier(16, () -> energy.getAsInt() >> 16 & 0xFFFF);
            return this;
        }

        public Builder withCapacity(IntSupplier capacity) {
            this.arr.setSupplier(17, () -> capacity.getAsInt() & 0xFFFF);
            this.arr.setSupplier(18, () -> capacity.getAsInt() >> 16 & 0xFFFF);
            return this;
        }

        @Override
        public EnergyHeadVehicleDataAccessor build() {
            return new EnergyHeadVehicleDataAccessor(this.arr);
        }
    }
}

