/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.script.data;

import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.ResourcePackFileNotFoundException;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import org.jetbrains.annotations.Nullable;

public abstract class GeneratedResourcePack
implements PackResources {
    private final PackType packType;
    private Map<ResourceLocation, byte[]> generated;

    public GeneratedResourcePack(PackType t) {
        this.packType = t;
    }

    private static String getFullPath(PackType type, ResourceLocation location) {
        return String.format("%s/%s/%s", type.m_10305_(), location.m_135827_(), location.m_135815_());
    }

    public InputStream m_5542_(String fileName) throws IOException {
        if (fileName.equals("pack.png")) {
            return Files.newInputStream((Path)KubeJS.thisMod.findResource(new String[]{"kubejs_logo.png"}).get(), new OpenOption[0]);
        }
        throw new ResourcePackFileNotFoundException(KubeJSPaths.DIRECTORY.toFile(), fileName);
    }

    public InputStream m_8031_(PackType type, ResourceLocation location) throws IOException {
        byte[] bytes;
        byte[] byArray = bytes = type == this.packType ? this.getGenerated().get(location) : null;
        if (bytes != null) {
            return new ByteArrayInputStream(bytes);
        }
        throw new ResourcePackFileNotFoundException(KubeJSPaths.DIRECTORY.toFile(), GeneratedResourcePack.getFullPath(type, location));
    }

    public boolean m_7211_(PackType type, ResourceLocation location) {
        return type == this.packType && this.getGenerated().get(location) != null;
    }

    public Map<ResourceLocation, byte[]> getGenerated() {
        if (this.generated == null) {
            this.generated = new HashMap<ResourceLocation, byte[]>();
            this.generate(this.generated);
        }
        return this.generated;
    }

    public void generate(Map<ResourceLocation, byte[]> map) {
    }

    public Collection<ResourceLocation> m_214146_(PackType type, String namespace, String path, Predicate<ResourceLocation> filter) {
        if (type != this.packType) {
            return Collections.emptySet();
        }
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        if (this.packType == PackType.CLIENT_RESOURCES && path.equals("lang")) {
            list.add(new ResourceLocation("kubejs", "lang/en_us.json"));
        }
        for (BuilderBase<?> builder : RegistryInfo.ALL_BUILDERS) {
            builder.addResourcePackLocations(path, list, this.packType);
        }
        return list;
    }

    public Set<String> m_5698_(PackType type0) {
        if (type0 != this.packType) {
            return Collections.emptySet();
        }
        HashSet<String> namespaces = new HashSet<String>();
        for (Map.Entry<ResourceLocation, byte[]> key : this.getGenerated().entrySet()) {
            namespaces.add(key.getKey().m_135827_());
        }
        return namespaces;
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> serializer) {
        return null;
    }

    public String m_8017_() {
        return "KubeJS Resource Pack [" + this.packType.m_10305_() + "]";
    }

    public void close() {
        this.generated = null;
    }
}

