/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity.item;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.capability.BackpackCapabilityProvider;
import com.buuz135.industrial.capability.MultipleFluidHandlerScreenProviderItemStack;
import com.buuz135.industrial.container.BackpackContainer;
import com.buuz135.industrial.gui.component.SlotDefinitionGuiAddon;
import com.buuz135.industrial.item.infinity.InfinityEnergyStorage;
import com.buuz135.industrial.item.infinity.InfinityTier;
import com.buuz135.industrial.item.infinity.ItemInfinity;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.module.ModuleTransportStorage;
import com.buuz135.industrial.proxy.CommonProxy;
import com.buuz135.industrial.proxy.network.BackpackOpenedMessage;
import com.buuz135.industrial.proxy.network.BackpackSyncMessage;
import com.buuz135.industrial.recipe.DissolutionChamberRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.buuz135.industrial.worlddata.BackpackDataManager;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.capability.FluidHandlerScreenProviderItemStack;
import com.hrznstudio.titanium.client.screen.addon.AssetScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.hrznstudio.titanium.item.BasicItem;
import com.hrznstudio.titanium.itemstack.ItemStackHarnessRegistry;
import com.hrznstudio.titanium.network.locator.LocatorFactory;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.locator.PlayerInventoryFinder;
import com.hrznstudio.titanium.network.locator.instance.HeldStackLocatorInstance;
import com.hrznstudio.titanium.network.locator.instance.InventoryStackLocatorInstance;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ItemInfinityBackpack
extends ItemInfinity {
    public static int POWER_CONSUMPTION = 0;
    public static int FUEL_CONSUMPTION = 1;
    private static String NBT_MAGNET = "Magnet";
    private static String NBT_PICKUP = "AutoPickUpMode";

    public ItemInfinityBackpack() {
        super("infinity_backpack", (CreativeModeTab)ModuleTool.TAB_TOOL, new Item.Properties().m_41487_(1), POWER_CONSUMPTION, FUEL_CONSUMPTION, false);
        this.disableArea();
        EventManager.forge(EntityItemPickupEvent.class).filter(entityItemPickupEvent -> !entityItemPickupEvent.getItem().m_32055_().m_41619_()).process(entityItemPickupEvent -> {
            for (PlayerInventoryFinder.Target target : ItemInfinityBackpack.findAllBackpacks(entityItemPickupEvent.getEntity())) {
                BackpackDataManager.BackpackItemHandler handler;
                BackpackDataManager manager;
                ItemStack stack = (ItemStack)target.getFinder().getStackGetter().apply(entityItemPickupEvent.getEntity(), target.getSlot());
                if (stack.m_41619_() || !(stack.m_41720_() instanceof ItemInfinityBackpack) || ItemInfinityBackpack.getPickUpMode(stack) != 1 && ItemInfinityBackpack.getPickUpMode(stack) != 0 || (manager = BackpackDataManager.getData((LevelAccessor)entityItemPickupEvent.getItem().f_19853_)) == null || !stack.m_41784_().m_128441_("Id") || (handler = manager.getBackpack(stack.m_41784_().m_128461_("Id"))) == null) continue;
                ItemStack picked = entityItemPickupEvent.getItem().m_32055_();
                for (int pos = 0; pos < handler.getSlots(); ++pos) {
                    ItemStack slotStack = handler.getSlotDefinition(pos).getStack().m_41777_();
                    slotStack.m_41764_(1);
                    if (slotStack.m_41619_() || !slotStack.m_41656_(picked) || !ItemStack.m_41658_((ItemStack)slotStack, (ItemStack)picked)) continue;
                    ItemStack returned = handler.insertItem(pos, picked.m_41777_(), false);
                    picked.m_41764_(returned.m_41613_());
                    entityItemPickupEvent.setResult(Event.Result.ALLOW);
                    if (entityItemPickupEvent.getEntity() instanceof ServerPlayer) {
                        ItemInfinityBackpack.sync(entityItemPickupEvent.getEntity().f_19853_, stack.m_41784_().m_128461_("Id"), (ServerPlayer)entityItemPickupEvent.getEntity());
                    }
                    return;
                }
            }
        }).subscribe();
        EventManager.forge(PlayerXpEvent.PickupXp.class).filter(pickupXp -> pickupXp.getOrb().m_6084_()).process(pickupXp -> ItemInfinityBackpack.findFirstBackpack(pickupXp.getEntity()).ifPresent(target -> {
            ItemStack stack = (ItemStack)target.getFinder().getStackGetter().apply(pickupXp.getEntity(), target.getSlot());
            if (!stack.m_41619_() && stack.m_41720_() instanceof ItemInfinityBackpack && (ItemInfinityBackpack.getPickUpMode(stack) == 2 || ItemInfinityBackpack.getPickUpMode(stack) == 0) && stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
                ExperienceOrb entity = pickupXp.getOrb();
                IFluidHandlerItem handlerItem = (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse(null);
                if (handlerItem != null && handlerItem.fill(new FluidStack((Fluid)ModuleCore.ESSENCE.getSourceFluid().get(), entity.m_20801_() * 20), IFluidHandler.FluidAction.SIMULATE) > 0) {
                    handlerItem.fill(new FluidStack((Fluid)ModuleCore.ESSENCE.getSourceFluid().get(), entity.m_20801_() * 20), IFluidHandler.FluidAction.EXECUTE);
                    entity.m_142687_(Entity.RemovalReason.KILLED);
                    pickupXp.setCanceled(true);
                }
            }
        })).subscribe();
    }

    public static int getSlotSize(ItemStack stack) {
        InfinityTier braquet = (InfinityTier)((Object)InfinityTier.getTierBraquet(ItemInfinityBackpack.getPowerFromStack(stack)).getLeft());
        return braquet == InfinityTier.ARTIFACT ? Integer.MAX_VALUE : (int)(2048.0 * Math.pow(8.0, braquet.getRadius()));
    }

    public static void sync(Level world, String id, ServerPlayer player) {
        IndustrialForegoing.NETWORK.get().sendTo((Object)new BackpackSyncMessage(id, BackpackDataManager.getData((LevelAccessor)world).getBackpack(id).serializeNBT()), player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public static boolean isMagnetEnabled(ItemStack stack) {
        return stack.m_41784_().m_128471_(NBT_MAGNET);
    }

    public static void setMagnet(ItemStack stack, boolean enabled) {
        stack.m_41784_().m_128379_(NBT_MAGNET, enabled);
    }

    public static int getPickUpMode(ItemStack stack) {
        return stack.m_41784_().m_128451_(NBT_PICKUP);
    }

    public static void setPickUpMode(ItemStack stack, int mode) {
        stack.m_41784_().m_128405_(NBT_PICKUP, mode);
    }

    public static List<PlayerInventoryFinder.Target> findAllBackpacks(Player entity) {
        ArrayList<PlayerInventoryFinder.Target> list = new ArrayList<PlayerInventoryFinder.Target>();
        for (String name : PlayerInventoryFinder.FINDERS.keySet()) {
            PlayerInventoryFinder finder = (PlayerInventoryFinder)PlayerInventoryFinder.FINDERS.get(name);
            for (int i = 0; i < (Integer)finder.getSlotAmountGetter().apply(entity); ++i) {
                if (!(((ItemStack)finder.getStackGetter().apply(entity, i)).m_41720_() instanceof ItemInfinityBackpack)) continue;
                list.add(new PlayerInventoryFinder.Target(name, finder, i));
            }
        }
        return Collections.unmodifiableList(list);
    }

    public static Optional<PlayerInventoryFinder.Target> findFirstBackpack(Player entity) {
        for (String name : PlayerInventoryFinder.FINDERS.keySet()) {
            PlayerInventoryFinder finder = (PlayerInventoryFinder)PlayerInventoryFinder.FINDERS.get(name);
            for (int i = 0; i < (Integer)finder.getSlotAmountGetter().apply(entity); ++i) {
                if (!(((ItemStack)finder.getStackGetter().apply(entity, i)).m_41720_() instanceof ItemInfinityBackpack)) continue;
                return Optional.of(new PlayerInventoryFinder.Target(name, finder, i));
            }
        }
        return Optional.empty();
    }

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new BackpackCapabilityProvider(stack, this.getTankConstructor(stack), this.getEnergyConstructor(stack));
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player player, InteractionHand handIn) {
        ItemStack stack = player.m_21120_(handIn);
        if (player instanceof ServerPlayer) {
            Object id;
            if (!stack.m_41782_() || !stack.m_41783_().m_128441_("Id")) {
                id = UUID.randomUUID();
                CompoundTag nbt = stack.m_41784_();
                nbt.m_128359_("Id", ((UUID)id).toString());
                BackpackDataManager.getData((LevelAccessor)worldIn).createBackPack((UUID)id);
                stack.m_41751_(nbt);
            }
            id = stack.m_41783_().m_128461_("Id");
            IndustrialForegoing.NETWORK.get().sendTo((Object)new BackpackOpenedMessage(player.f_36093_.f_35977_, PlayerInventoryFinder.MAIN), ((ServerPlayer)player).f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
            ItemInfinityBackpack.sync(worldIn, (String)id, (ServerPlayer)player);
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buffer -> LocatorFactory.writePacketBuffer((FriendlyByteBuf)buffer, (LocatorInstance)new HeldStackLocatorInstance(handIn == InteractionHand.MAIN_HAND)));
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(handIn));
        }
        if (CommonProxy.CONTRIBUTORS.contains(player.m_20148_().toString())) {
            player.m_21120_(handIn).m_41784_().m_128379_("Special", true);
        }
        return super.m_7203_(worldIn, player, handIn);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (ItemInfinityBackpack.isMagnetEnabled(stack)) {
            for (ItemEntity itemEntity : entityIn.f_19853_.m_45976_(ItemEntity.class, new AABB(entityIn.m_20185_(), entityIn.m_20186_(), entityIn.m_20186_(), entityIn.m_20185_(), entityIn.m_20186_(), entityIn.m_20189_()).m_82400_(5.0))) {
                if (entityIn.f_19853_.f_46443_) {
                    if (!itemEntity.m_20096_() || worldIn.f_46441_.m_188503_(5) >= 1) continue;
                    itemEntity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, itemEntity.m_20185_(), itemEntity.m_20186_() + 0.5, itemEntity.m_20189_(), 0.0, -0.5, 0.0);
                    continue;
                }
                if (itemEntity.m_32063_() || !this.enoughFuel(stack)) continue;
                itemEntity.m_6021_(entityIn.m_20185_(), entityIn.m_20186_(), entityIn.m_20189_());
                this.consumeFuel(stack);
            }
        }
        if (!entityIn.f_19853_.f_46443_ && entityIn instanceof Player) {
            BackpackDataManager.BackpackItemHandler handler;
            BackpackDataManager manager;
            FluidStack fluidStack;
            IFluidHandlerItem handlerItem;
            if (this.enoughFuel(stack) && (((Player)entityIn).m_36324_().m_38721_() || ((Player)entityIn).m_36324_().m_38722_() < 10.0f) && stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent() && (handlerItem = (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElseGet(null)) instanceof MultipleFluidHandlerScreenProviderItemStack && !(fluidStack = handlerItem.getFluidInTank(2)).isEmpty() && fluidStack.getAmount() >= 400) {
                ((MultipleFluidHandlerScreenProviderItemStack)handlerItem).setFluidInTank(2, new FluidStack((Fluid)ModuleCore.MEAT.getSourceFluid().get(), fluidStack.getAmount() - 400));
                ((Player)entityIn).m_36324_().m_38707_(1, 1.0f);
                this.consumeFuel(stack);
            }
            if (entityIn.f_19853_.m_46467_() % 10L == 0L && (manager = BackpackDataManager.getData((LevelAccessor)entityIn.f_19853_)) != null && stack.m_41784_().m_128441_("Id") && (handler = manager.getBackpack(stack.m_41784_().m_128461_("Id"))) != null) {
                if (ItemInfinityBackpack.getSlotSize(stack) != handler.getSlotLimit(0)) {
                    handler.setMaxAmount(ItemInfinityBackpack.getSlotSize(stack));
                }
                if (this.enoughFuel(stack)) {
                    for (int i = 0; i < 32; ++i) {
                        if (handler.getStackInSlot(i).m_41619_() || !handler.getSlotDefinition(i).isRefillItems()) continue;
                        Inventory inventory = ((Player)entityIn).f_36093_;
                        for (int inv = 0; inv <= 35; ++inv) {
                            ItemStack inventoryStack = inventory.m_8020_(inv);
                            if (inventoryStack.m_41619_() || inventoryStack.m_41613_() >= inventoryStack.m_41741_() || !handler.isItemValid(i, inventoryStack) || !this.enoughFuel(stack)) continue;
                            int extracting = inventoryStack.m_41741_() - inventoryStack.m_41613_();
                            ItemStack extractedSLot = handler.extractItem(i, extracting, false);
                            inventoryStack.m_41764_(inventoryStack.m_41613_() + extractedSLot.m_41613_());
                            if (entityIn instanceof ServerPlayer) {
                                ItemInfinityBackpack.sync(entityIn.f_19853_, stack.m_41784_().m_128461_("Id"), (ServerPlayer)entityIn);
                            }
                            this.consumeFuel(stack);
                            return;
                        }
                    }
                }
            }
        }
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public IFactory<FluidHandlerScreenProviderItemStack> getTankConstructor(ItemStack stack) {
        int y = 88;
        return () -> new MultipleFluidHandlerScreenProviderItemStack(stack, 1000000, new MultipleFluidHandlerScreenProviderItemStack.TankDefinition("biofuel", -21, y + 0, fluidStack -> fluidStack.getFluid().m_6212_((Fluid)ModuleCore.BIOFUEL.getSourceFluid().get()), false, true, FluidTankComponent.Type.SMALL), new MultipleFluidHandlerScreenProviderItemStack.TankDefinition("essence", -21, y + 25, fluidStack -> fluidStack.getFluid().m_205067_(IndustrialTags.Fluids.EXPERIENCE), true, true, FluidTankComponent.Type.SMALL), new MultipleFluidHandlerScreenProviderItemStack.TankDefinition("meat", -21, y + 50, fluidStack -> fluidStack.getFluid().m_6212_((Fluid)ModuleCore.MEAT.getSourceFluid().get()), false, true, FluidTankComponent.Type.SMALL));
    }

    @Override
    public IFactory<InfinityEnergyStorage> getEnergyConstructor(final ItemStack stack) {
        return () -> new InfinityEnergyStorage(InfinityTier.ARTIFACT.getPowerNeeded(), -21, 24){

            @Override
            public long getLongEnergyStored() {
                if (stack.m_41782_()) {
                    return Math.min(stack.m_41783_().m_128454_("Energy"), InfinityTier.ARTIFACT.getPowerNeeded());
                }
                return 0L;
            }

            @Override
            public void setEnergyStored(long energy) {
                if (!stack.m_41782_()) {
                    stack.m_41751_(new CompoundTag());
                }
                stack.m_41783_().m_128356_("Energy", Math.min(energy, InfinityTier.ARTIFACT.getPowerNeeded()));
            }

            @Override
            public boolean canReceive() {
                return ItemInfinity.canCharge(stack);
            }
        };
    }

    @Override
    public void handleButtonMessage(int id, Player playerEntity, CompoundTag compound) {
        ItemInfinityBackpack.findFirstBackpack(playerEntity).ifPresent(target -> {
            ItemStack stack = (ItemStack)target.getFinder().getStackGetter().apply(playerEntity, target.getSlot());
            if (!stack.m_41619_()) {
                if (id == 4 && playerEntity instanceof ServerPlayer) {
                    String backpackId = compound.m_128461_("Id");
                    ItemStack cursor = playerEntity.f_36096_.m_142621_();
                    boolean shift = compound.m_128471_("Shift");
                    boolean ctrl = compound.m_128471_("Ctrl");
                    int button = compound.m_128451_("Button");
                    int slot = compound.m_128451_("Slot");
                    BackpackDataManager dataManager = BackpackDataManager.getData((LevelAccessor)playerEntity.f_19853_);
                    BackpackDataManager.BackpackItemHandler handler = dataManager.getBackpack(backpackId);
                    ItemStack result = ItemStack.f_41583_;
                    boolean hasCursorChanged = false;
                    if (button == 2) {
                        ItemStack simulated = handler.extractItem(slot, 1, true);
                        if (!simulated.m_41619_() && (cursor.m_41619_() || ItemHandlerHelper.canItemStacksStack((ItemStack)simulated, (ItemStack)cursor))) {
                            result = handler.extractItem(slot, 1, false);
                            result.m_41764_(cursor.m_41613_() + 1);
                            hasCursorChanged = true;
                        }
                    } else if (cursor.m_41619_()) {
                        int maxStack = handler.getStackInSlot(slot).m_41741_();
                        if (button == 0) {
                            if (ctrl) {
                                BackpackDataManager.SlotDefinition definition;
                                definition.setVoidItems(!(definition = handler.getSlotDefinition(slot)).isVoidItems());
                            } else if (shift) {
                                if (handler.getSlotDefinition(slot).getAmount() == 0) {
                                    handler.getSlotDefinition(slot).setStack(ItemStack.f_41583_);
                                    handler.getSlotDefinition(slot).setAmount(0);
                                } else {
                                    ItemHandlerHelper.giveItemToPlayer((Player)playerEntity, (ItemStack)handler.extractItem(slot, maxStack, false));
                                }
                            } else {
                                result = handler.extractItem(slot, maxStack, false);
                                hasCursorChanged = true;
                            }
                        } else if (button == 1) {
                            if (ctrl) {
                                BackpackDataManager.SlotDefinition definition;
                                definition.setRefillItems(!(definition = handler.getSlotDefinition(slot)).isRefillItems());
                            } else {
                                result = handler.extractItem(slot, maxStack / 2, false);
                                hasCursorChanged = true;
                            }
                        }
                    } else if (button == 0) {
                        result = handler.insertItem(slot, cursor, false);
                        hasCursorChanged = true;
                    } else if (button == 1 && handler.insertItem(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)cursor, (int)1), false).m_41619_()) {
                        cursor.m_41774_(1);
                        result = cursor;
                        hasCursorChanged = true;
                    }
                    if (hasCursorChanged) {
                        playerEntity.f_36096_.m_142503_(result);
                        ((ServerPlayer)playerEntity).f_36096_.m_38946_();
                    }
                    ItemInfinityBackpack.sync(playerEntity.f_19853_, backpackId, (ServerPlayer)playerEntity);
                }
                if (id == 10) {
                    ItemInfinityBackpack.setMagnet(stack, !ItemInfinityBackpack.isMagnetEnabled(stack));
                }
                if (id == 11) {
                    ItemInfinityBackpack.setPickUpMode(stack, (ItemInfinityBackpack.getPickUpMode(stack) + 1) % 4);
                }
                if (id == 3) {
                    this.setCanCharge(stack, !ItemInfinityBackpack.canCharge(stack));
                }
                if (id == -10) {
                    this.setSpecialEnabled(stack, !this.isSpecialEnabled(stack));
                }
            }
        });
    }

    @Override
    public void addNbt(ItemStack stack, long power, int fuel, boolean special) {
        CompoundTag tagCompound = new CompoundTag();
        tagCompound.m_128356_("Energy", power);
        tagCompound.m_128379_("Special", special);
        tagCompound.m_128359_("Selected", ((InfinityTier)((Object)InfinityTier.getTierBraquet(power).getLeft())).name());
        tagCompound.m_128379_("CanCharge", true);
        stack.m_41751_(tagCompound);
    }

    @Override
    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GRAY + Component.m_237115_((String)"text.industrialforegoing.tooltip.can_hold").getString() + ": " + ChatFormatting.DARK_AQUA + NumberFormat.getInstance(Locale.ROOT).format(ItemInfinityBackpack.getSlotSize(stack)) + ChatFormatting.GRAY + " " + Component.m_237115_((String)"text.industrialforegoing.tooltip.items").getString())));
        super.addTooltipDetails(key, stack, tooltip, advanced);
    }

    @Override
    public int getFuelFromStack(ItemStack stack) {
        int fuelAmount = 0;
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Tanks") && stack.m_41783_().m_128469_("Tanks").m_128441_("biofuel")) {
            fuelAmount = stack.m_41783_().m_128469_("Tanks").m_128469_("biofuel").m_128451_("Amount");
        }
        return fuelAmount;
    }

    @Override
    public boolean enoughFuel(ItemStack stack) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)stack);
        return this.getFuelFromStack(stack) >= FUEL_CONSUMPTION * (1 / (i + 1));
    }

    @Override
    public void consumeFuel(ItemStack stack) {
        int i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)stack);
        if (this.getFuelFromStack(stack) >= FUEL_CONSUMPTION * (1 / (i + 1))) {
            stack.m_41783_().m_128469_("Tanks").m_128469_("biofuel").m_128405_("Amount", Math.max(0, this.getFuelFromStack(stack) - FUEL_CONSUMPTION * (1 / (i + 1))));
        }
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ListMultimap multimap = MultimapBuilder.hashKeys().arrayListValues().build();
        return multimap;
    }

    @Override
    public boolean m_8120_(ItemStack stack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return Enchantments.f_44986_ == enchantment;
    }

    @Override
    public float m_8102_(ItemStack stack, BlockState state) {
        return 1.0f;
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int menu, Inventory p_createMenu_2_, Player playerEntity) {
        return ItemInfinityBackpack.findFirstBackpack(playerEntity).map(target -> {
            ItemStack stack = (ItemStack)target.getFinder().getStackGetter().apply(playerEntity, target.getSlot());
            if (!stack.m_41619_()) {
                Object id;
                if (!stack.m_41782_() || !stack.m_41783_().m_128441_("Id")) {
                    id = UUID.randomUUID();
                    CompoundTag nbt = stack.m_41784_();
                    nbt.m_128359_("Id", ((UUID)id).toString());
                    BackpackDataManager.getData((LevelAccessor)playerEntity.f_19853_).createBackPack((UUID)id);
                    stack.m_41751_(nbt);
                }
                id = stack.m_41783_().m_128461_("Id");
                return new BackpackContainer(((Function)ItemStackHarnessRegistry.getHarnessCreators().get(ModuleTool.INFINITY_BACKPACK)).apply(stack), (LocatorInstance)new InventoryStackLocatorInstance(target.getName(), target.getSlot()), new ContainerLevelAccess(){

                    public <T> Optional<T> m_6721_(BiFunction<Level, BlockPos, T> p_221484_1_) {
                        return Optional.empty();
                    }
                }, playerEntity.f_36093_, menu, (String)id);
            }
            return null;
        }).orElse(null);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<IFactory<? extends IScreenAddon>> getScreenAddons(final Supplier<ItemStack> stack) {
        ArrayList<IFactory<? extends IScreenAddon>> factory = new ArrayList<IFactory<? extends IScreenAddon>>();
        int i = 0;
        while (i < 32) {
            int x = i % 8;
            int y = i / 8;
            int finalI = i++;
            factory.add(() -> new SlotDefinitionGuiAddon(new ButtonComponent(16 + 18 * x, 21 + 18 * y, 18, 18).setId(4), finalI){

                @Override
                public ItemStack getItemStack() {
                    return (ItemStack)stack.get();
                }
            });
        }
        factory.add(() -> new AssetScreenAddon(AssetTypes.AUGMENT_BACKGROUND_LEFT_TALL, -27, 10, true));
        factory.add(() -> new AssetScreenAddon(AssetTypes.AUGMENT_BACKGROUND, 175, 10, true));
        int x = 181;
        int y = 19;
        factory.add(() -> new StateButtonAddon(new ButtonComponent(x, 16 + y * 0, 14, 14).setId(10), new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[]{ChatFormatting.GREEN + Component.m_237115_((String)"tooltip.industrialforegoing.backpack.magnet_enabled").getString()}), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[]{ChatFormatting.RED + Component.m_237115_((String)"tooltip.industrialforegoing.backpack.magnet_disabled").getString()})}){

            public int getState() {
                return ItemInfinityBackpack.isMagnetEnabled((ItemStack)stack.get()) ? 0 : 1;
            }
        });
        factory.add(() -> new StateButtonAddon(new ButtonComponent(x, 16 + y * 1, 14, 14).setId(11), new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[]{ChatFormatting.GREEN + Component.m_237115_((String)"tooltip.industrialforegoing.backpack.pickup_all").getString(), ChatFormatting.GRAY + Component.m_237115_((String)"tooltip.industrialforegoing.backpack.pickup_extra").getString(), ChatFormatting.GRAY + Component.m_237115_((String)"tooltip.industrialforegoing.backpack.pickup_extra_1").getString()}), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_PULL, new String[]{ChatFormatting.GREEN + Component.m_237115_((String)"tooltip.industrialforegoing.backpack.item_pickup_enabled").getString(), ChatFormatting.GRAY + Component.m_237115_((String)"tooltip.industrialforegoing.backpack.pickup_extra").getString(), ChatFormatting.GRAY + Component.m_237115_((String)"tooltip.industrialforegoing.backpack.pickup_extra_1").getString()}), new StateButtonInfo(2, AssetTypes.BUTTON_SIDENESS_PUSH, new String[]{ChatFormatting.GREEN + Component.m_237115_((String)"tooltip.industrialforegoing.backpack.xp_pickup_enabled").getString(), ChatFormatting.GRAY + Component.m_237115_((String)"tooltip.industrialforegoing.backpack.pickup_extra").getString(), ChatFormatting.GRAY + Component.m_237115_((String)"tooltip.industrialforegoing.backpack.pickup_extra_1").getString()}), new StateButtonInfo(3, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[]{ChatFormatting.RED + Component.m_237115_((String)"tooltip.industrialforegoing.backpack.pickup_disabled").getString(), ChatFormatting.GRAY + Component.m_237115_((String)"tooltip.industrialforegoing.backpack.pickup_extra").getString(), ChatFormatting.GRAY + Component.m_237115_((String)"tooltip.industrialforegoing.backpack.pickup_extra_1").getString()})}){

            public int getState() {
                return ItemInfinityBackpack.getPickUpMode((ItemStack)stack.get());
            }
        });
        factory.add(() -> new StateButtonAddon(new ButtonComponent(x, 16 + y * 2, 14, 14).setId(3), new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[]{ChatFormatting.GREEN + Component.m_237115_((String)"text.industrialforegoing.display.charging").getString() + Component.m_237115_((String)"text.industrialforegoing.display.enabled").getString()}), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[]{ChatFormatting.RED + Component.m_237115_((String)"text.industrialforegoing.display.charging").getString() + Component.m_237115_((String)"text.industrialforegoing.display.disabled").getString()})}){

            public int getState() {
                return ItemInfinity.canCharge((ItemStack)stack.get()) ? 0 : 1;
            }
        });
        if (this.isSpecial(stack.get())) {
            factory.add((IFactory<? extends IScreenAddon>)((IFactory)() -> new StateButtonAddon(new ButtonComponent(x, 16 + y * 3, 14, 14).setId(-10), new StateButtonInfo[]{new StateButtonInfo(0, AssetTypes.BUTTON_SIDENESS_ENABLED, new String[]{ChatFormatting.GOLD + Component.m_237115_((String)"text.industrialforegoing.display.special").getString()}), new StateButtonInfo(1, AssetTypes.BUTTON_SIDENESS_DISABLED, new String[]{ChatFormatting.GOLD + Component.m_237115_((String)"text.industrialforegoing.display.special").getString()})}){

                public int getState() {
                    return ((ItemInfinityBackpack)ModuleTool.INFINITY_BACKPACK.get()).isSpecialEnabled((ItemStack)stack.get()) ? 0 : 1;
                }
            }));
        }
        return factory;
    }

    @Override
    public void registerRecipe(Consumer<FinishedRecipe> consumer) {
        new DissolutionChamberRecipe(ForgeRegistries.ITEMS.getKey((Object)this), new Ingredient.Value[]{new Ingredient.ItemValue(new ItemStack((ItemLike)((RegistryObject)ModuleTransportStorage.BLACK_HOLE_UNIT_COMMON.getLeft()).get())), new Ingredient.TagValue(IndustrialTags.Items.GEAR_DIAMOND), new Ingredient.ItemValue(new ItemStack((ItemLike)((RegistryObject)ModuleTransportStorage.BLACK_HOLE_UNIT_COMMON.getLeft()).get())), new Ingredient.ItemValue(new ItemStack((ItemLike)((RegistryObject)ModuleTransportStorage.BLACK_HOLE_TANK_COMMON.getLeft()).get())), new Ingredient.ItemValue(new ItemStack((ItemLike)((RegistryObject)ModuleTransportStorage.BLACK_HOLE_TANK_COMMON.getLeft()).get())), new Ingredient.TagValue(IndustrialTags.Items.GEAR_GOLD), new Ingredient.TagValue(IndustrialTags.Items.GEAR_GOLD), new Ingredient.TagValue(IndustrialTags.Items.GEAR_GOLD)}, new FluidStack((Fluid)ModuleCore.PINK_SLIME.getSourceFluid().get(), 2000), 400, new ItemStack((ItemLike)this), FluidStack.EMPTY);
    }
}

