/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.gui.component;

import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IAssetType;
import com.hrznstudio.titanium.api.client.assets.types.ITankAsset;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ItemStackTankScreenAddon
extends BasicScreenAddon {
    private IFluidHandler tank;
    private ITankAsset asset;
    private FluidTankComponent.Type type;
    private int tankSlot;

    public ItemStackTankScreenAddon(int posX, int posY, IFluidHandler tank, int tankSlot, FluidTankComponent.Type type) {
        super(posX, posY);
        this.tank = tank;
        this.type = type;
        this.tankSlot = tankSlot;
    }

    public void drawBackgroundLayer(PoseStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        this.asset = (ITankAsset)IAssetProvider.getAsset((IAssetProvider)provider, (IAssetType)this.type.getAssetType());
        Rectangle area = this.asset.getArea();
        if (!this.tank.getFluidInTank(this.tankSlot).isEmpty()) {
            TextureAtlasSprite sprite;
            AbstractTexture texture;
            FluidStack fluidStack = this.tank.getFluidInTank(this.tankSlot);
            int stored = fluidStack.getAmount();
            int capacity = this.tank.getTankCapacity(this.tankSlot);
            int topBottomPadding = this.asset.getFluidRenderPadding(Direction.UP) + this.asset.getFluidRenderPadding(Direction.DOWN);
            int offset = stored * (area.height - topBottomPadding) / capacity;
            IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            ResourceLocation flowing = renderProperties.getStillTexture(fluidStack);
            if (flowing != null && (texture = screen.getMinecraft().m_91097_().m_118506_(TextureAtlas.f_118259_)) instanceof TextureAtlas && (sprite = ((TextureAtlas)texture).m_118316_(flowing)) != null) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
                Color color = new Color(renderProperties.getTintColor());
                RenderSystem.m_157429_((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
                RenderSystem.m_69478_();
                Screen.m_93200_((PoseStack)stack, (int)(this.getPosX() + guiX + this.asset.getFluidRenderPadding(Direction.WEST)), (int)(this.getPosY() + guiY + this.asset.getFluidRenderPadding(Direction.UP) + (fluidStack.getFluid().m_205067_(Tags.Fluids.GASEOUS) ? 0 : area.height - topBottomPadding - offset)), (int)0, (int)((int)(area.getWidth() - (double)this.asset.getFluidRenderPadding(Direction.EAST) - (double)this.asset.getFluidRenderPadding(Direction.WEST))), (int)offset, (TextureAtlasSprite)sprite);
                RenderSystem.m_69461_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ITankAsset asset = (ITankAsset)IAssetProvider.getAsset((IAssetProvider)provider, (IAssetType)this.type.getAssetType());
        AssetUtil.drawAsset((PoseStack)stack, (Screen)screen, (IAsset)asset, (int)(guiX + this.getPosX()), (int)(guiY + this.getPosY()));
    }

    public void drawForegroundLayer(PoseStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
    }

    public List<Component> getTooltipLines() {
        ArrayList<Component> strings = new ArrayList<Component>();
        strings.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + Component.m_237115_((String)"tooltip.titanium.tank.fluid").getString())).m_7220_((Component)(this.tank.getFluidInTank(this.tankSlot).isEmpty() ? Component.m_237115_((String)"tooltip.titanium.tank.empty").m_130940_(ChatFormatting.WHITE) : Component.m_237115_((String)this.tank.getFluidInTank(this.tankSlot).getFluid().getFluidType().getDescriptionId()))).m_130940_(ChatFormatting.WHITE));
        strings.add((Component)Component.m_237115_((String)"tooltip.titanium.tank.amount").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)(ChatFormatting.WHITE + new DecimalFormat().format(this.tank.getFluidInTank(this.tankSlot).getAmount()) + ChatFormatting.GOLD + "/" + ChatFormatting.WHITE + new DecimalFormat().format(this.tank.getTankCapacity(this.tankSlot)) + ChatFormatting.DARK_AQUA + "mb"))));
        return strings;
    }

    public int getXSize() {
        return this.asset != null ? this.asset.getArea().width : 0;
    }

    public int getYSize() {
        return this.asset != null ? this.asset.getArea().height : 0;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return false;
    }
}

