/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.integration.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.data.recipes.CrowFluteRecipe;
import net.joefoxe.hexerei.integration.jei.ExtraFluteIcon;
import net.joefoxe.hexerei.item.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.client.model.data.ModelData;

public class FluteRecipeCategory
implements IRecipeCategory<CrowFluteRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("hexerei", "crow_flute_dye");
    public static final ResourceLocation TEXTURE = new ResourceLocation("hexerei", "textures/gui/crow_flute_dye_gui_jei.png");
    private IDrawable background;
    private final IDrawable icon;

    public List<Component> getTooltipStrings(CrowFluteRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        return super.getTooltipStrings((Object)recipe, recipeSlotsView, mouseX, mouseY);
    }

    public boolean isHovering(double mouseX, double mouseY, double x, double y, double width, double height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public FluteRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 144, 86);
        this.icon = new ExtraFluteIcon(() -> new ItemStack((ItemLike)ModItems.CROW_FLUTE.get()));
    }

    public static Block getTagStack(TagKey<Block> key) {
        Optional<Block> optional = Registry.f_122824_.m_203431_(key).flatMap(tag -> tag.m_213653_(RandomSource.m_216327_())).map(Holder::m_203334_);
        return optional.orElse(Blocks.f_50016_);
    }

    public RecipeType<CrowFluteRecipe> getRecipeType() {
        return new RecipeType(new ResourceLocation("hexerei", "crow_flute_dye"), CrowFluteRecipe.class);
    }

    public Component getTitle() {
        return Component.m_237115_((String)"Crow Flute Crafting");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CrowFluteRecipe recipe, IFocusGroup focuses) {
        builder.moveRecipeTransferButton(160, 90);
        int size = recipe.getInputs().size();
        if (size > 0) {
            builder.addSlot(RecipeIngredientRole.INPUT, 15, 19).addIngredients((Ingredient)recipe.getInputs().get(0));
        }
        if (size > 1) {
            builder.addSlot(RecipeIngredientRole.INPUT, 33, 19).addIngredients((Ingredient)recipe.getInputs().get(1));
        }
        if (size > 2) {
            builder.addSlot(RecipeIngredientRole.INPUT, 51, 19).addIngredients((Ingredient)recipe.getInputs().get(2));
        }
        if (size > 3) {
            builder.addSlot(RecipeIngredientRole.INPUT, 15, 37).addIngredients((Ingredient)recipe.getInputs().get(3));
        }
        if (size > 4) {
            builder.addSlot(RecipeIngredientRole.INPUT, 33, 37).addIngredients((Ingredient)recipe.getInputs().get(4));
        }
        if (size > 5) {
            builder.addSlot(RecipeIngredientRole.INPUT, 51, 37).addIngredients((Ingredient)recipe.getInputs().get(5));
        }
        if (size > 6) {
            builder.addSlot(RecipeIngredientRole.INPUT, 15, 55).addIngredients((Ingredient)recipe.getInputs().get(6));
        }
        if (size > 7) {
            builder.addSlot(RecipeIngredientRole.INPUT, 33, 55).addIngredients((Ingredient)recipe.getInputs().get(7));
        }
        if (size > 8) {
            builder.addSlot(RecipeIngredientRole.INPUT, 51, 55).addIngredients((Ingredient)recipe.getInputs().get(8));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 109, 37).addItemStack(recipe.m_8043_());
    }

    public void draw(CrowFluteRecipe recipe, IRecipeSlotsView view, PoseStack matrixStack, double mouseX, double mouseY) {
        float newHeatSource = Hexerei.getClientTicks() % 200.0f / 200.0f;
        float craftPercent = Hexerei.getClientTicks() % 100.0f / 100.0f;
        boolean showOutput = Hexerei.getClientTicks() % 200.0f > 100.0f;
        Minecraft minecraft = Minecraft.m_91087_();
        Component outputName = recipe.m_8043_().m_41786_();
        int width = minecraft.f_91062_.m_92852_((FormattedText)outputName);
        Objects.requireNonNull(minecraft.f_91062_);
        float lineHeight = 9.0f / 2.0f;
        if (width > 131) {
            float percent = (float)width / 131.0f;
            matrixStack.m_85836_();
            matrixStack.m_85841_(1.0f / percent, 1.0f / percent, 1.0f / percent);
            minecraft.f_91062_.m_92889_(matrixStack, outputName, 7.0f * percent, (5.0f + lineHeight) * percent - 4.5f, -12566464);
            matrixStack.m_85849_();
        } else {
            minecraft.f_91062_.m_92889_(matrixStack, outputName, 7.0f, 5.0f + lineHeight - 4.5f, -12566464);
        }
    }

    private void renderItem(ItemStack stack, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.FIXED, combinedLightIn, OverlayTexture.f_118083_, matrixStackIn, bufferIn, 1);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderBlock(PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, BlockState state, int color) {
        this.renderSingleBlock(state, matrixStack, bufferIn, combinedLightIn, OverlayTexture.f_118083_, ModelData.EMPTY, color);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderSingleBlock(BlockState p_110913_, PoseStack poseStack, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, int color) {
        RenderShape rendershape = p_110913_.m_60799_();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
                    BakedModel bakedmodel = dispatcher.m_110910_(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    dispatcher.m_110937_().renderModel(poseStack.m_85850_(), p_110915_.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)p_110913_, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, null);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.m_60734_());
                    poseStack.m_85837_(0.2, -0.1, -0.1);
                    IClientItemExtensions.of((Item)stack.m_41720_()).getCustomRenderer().m_108829_(stack, ItemTransforms.TransformType.NONE, poseStack, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

