/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.custom;

import com.google.common.collect.Maps;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.block.custom.PickableDoubleFlower;
import net.joefoxe.hexerei.block.custom.PickableFlower;
import net.joefoxe.hexerei.client.renderer.entity.ModEntityTypes;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.ITargetsDroppedItems;
import net.joefoxe.hexerei.client.renderer.entity.render.CrowVariant;
import net.joefoxe.hexerei.config.HexConfig;
import net.joefoxe.hexerei.container.CrowContainer;
import net.joefoxe.hexerei.item.ModItems;
import net.joefoxe.hexerei.sounds.ModSounds;
import net.joefoxe.hexerei.tileentity.CofferTile;
import net.joefoxe.hexerei.tileentity.HerbJarTile;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiTags;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.joefoxe.hexerei.util.message.CrowAskForSyncPacket;
import net.joefoxe.hexerei.util.message.CrowCawPacket;
import net.joefoxe.hexerei.util.message.CrowEatParticlesPacket;
import net.joefoxe.hexerei.util.message.CrowPeckPacket;
import net.joefoxe.hexerei.util.message.CrowStartRidingPacket;
import net.joefoxe.hexerei.util.message.CrowSyncAdditonalDataPacket;
import net.joefoxe.hexerei.util.message.CrowSyncCommandToServer;
import net.joefoxe.hexerei.util.message.CrowSyncHelpCommandToServer;
import net.joefoxe.hexerei.util.message.CrowSyncPacket;
import net.joefoxe.hexerei.util.message.CrowTailFanPacket;
import net.joefoxe.hexerei.util.message.CrowTailWagPacket;
import net.minecraft.Util;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class CrowEntity
extends TamableAnimal
implements ContainerListener,
FlyingAnimal,
ITargetsDroppedItems,
Container,
MenuProvider,
PowerableMob {
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.SEED_MIXTURE.get()});
    public boolean headTilt;
    public int headTiltTimer;
    public float headZTiltAngle;
    public float headZTiltAngleActual;
    public float headXTiltAngle;
    public float headXTiltAngleActual;
    public boolean caw;
    public int cawTimer;
    public float cawTiltAngle;
    public float cawTiltAngleActual;
    public boolean tailWag;
    public int tailWagTimer;
    public float tailWagTiltAngle;
    public float tailWagTiltAngleActual;
    public boolean tailFan;
    public int tailFanTimer;
    public float tailFanTiltAngle;
    public float tailFanTiltAngleActual;
    public boolean peck;
    public int peckTimer;
    public float peckTiltAngle;
    public float peckTiltAngleActual;
    public float rightWingAngle;
    public float rightWingAngleActual;
    public float leftWingAngle;
    public float leftWingAngleActual;
    public boolean dance;
    public int animationCounter;
    public int pickpocketTimer;
    private BlockPos jukebox;
    private int rideCooldownCounter;
    public int cofferHerbJarListResetTimer;
    public List<BlockPos> cofferHerbJarList;
    public List<Villager> villagerList;
    protected final Predicate<Villager> targetEntitySelector;
    private UUID seedThrowerID;
    private int heldItemTime = 0;
    public boolean aiItemFlag = false;
    public boolean aiCofferTileFlag = false;
    public boolean doingTask;
    public boolean searchForNewCropTarget;
    public int searchForNewCropTargetTimer = 0;
    public boolean depositItemBeforePerch;
    public boolean breedNuggetGivenByPlayer = false;
    public int breedNuggetGivenByCrowTimer = 0;
    public UUID breedNuggetGivenByPlayerUUID;
    public int waitToGiveTime = 0;
    public int stuckTimer = 0;
    public List<Block> harvestWhitelist = new ArrayList<Block>();
    public Vec3 lastStuckCheckPos = new Vec3(0.0, 0.0, 0.0);
    public boolean sync;
    public final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.m_135353_(CrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HELP_COMMAND = SynchedEntityData.m_135353_(CrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<BlockPos>> PERCH_POS = SynchedEntityData.m_135353_(CrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Integer> CROW_DYE_COLOR = SynchedEntityData.m_135353_(CrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(CrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_PLAYING_DEAD = SynchedEntityData.m_135353_(CrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int playingDead;
    public int interactionRange;
    public boolean canAttack;
    private final Map<String, Vector3f> modelRotationValues = Maps.newHashMap();
    public static final int TOTAL_PLAYDEAD_TIME = 200;

    public CrowEntity(EntityType<CrowEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_8099_();
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, false){

            public void m_8126_() {
                if (!CrowEntity.this.isPlayingDead()) {
                    super.m_8126_();
                }
            }
        };
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.LEAVES, 4.0f);
        this.headTilt = false;
        this.headTiltTimer = new Random().nextInt(100);
        this.headZTiltAngle = 0.0f;
        this.headZTiltAngleActual = 0.0f;
        this.headXTiltAngle = 0.0f;
        this.headXTiltAngleActual = 0.0f;
        this.cofferHerbJarListResetTimer = 80;
        this.animationCounter = 0;
        this.pickpocketTimer = 0;
        this.targetEntitySelector = input -> true;
        this.doingTask = false;
        this.sync = false;
        this.caw = false;
        this.cawTimer = new Random().nextInt(360) + 360;
        this.cawTiltAngle = 0.0f;
        this.cawTiltAngleActual = 0.0f;
        this.tailWag = false;
        this.tailWagTimer = new Random().nextInt(100);
        this.tailWagTiltAngle = 0.0f;
        this.tailWagTiltAngleActual = 0.0f;
        this.tailFan = false;
        this.tailFanTimer = new Random().nextInt(100);
        this.tailFanTiltAngle = 0.0f;
        this.tailFanTiltAngleActual = 0.0f;
        this.peck = false;
        this.peckTiltAngle = 0.0f;
        this.peckTiltAngleActual = 0.0f;
        this.rightWingAngle = 0.0f;
        this.rightWingAngleActual = 0.0f;
        this.leftWingAngle = 0.0f;
        this.leftWingAngleActual = 0.0f;
        this.playingDead = 0;
        this.interactionRange = 24;
        this.canAttack = true;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.f_21345_.m_25352_(2, (Goal)new FlyBackToPerchGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new FollowOwnerGoal(this, 1.0, 5.0f, 1.0f, true));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.5));
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 1.0, TEMPTATION_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LandOnOwnersShoulderGoal(this));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f){

            public void m_8037_() {
                if (!CrowEntity.this.isPlayingDead()) {
                    super.m_8037_();
                }
            }
        });
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this){

            public void m_8037_() {
                if (!CrowEntity.this.isPlayingDead()) {
                    super.m_8037_();
                }
            }
        });
        this.f_21346_.m_25352_(2, new CrowGatherItems((PathfinderMob)this, false, false, 40, this.interactionRange));
        this.f_21345_.m_25352_(2, (Goal)new CrowDepositCoffer(this));
        this.f_21345_.m_25352_(2, (Goal)new CrowHarvestGoal(1.5, this.interactionRange, 6));
        this.f_21345_.m_25352_(2, (Goal)new CrowPickpocketVillager(this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtTargetGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COMMAND, (Object)0);
        this.f_19804_.m_135372_(HELP_COMMAND, (Object)0);
        this.f_19804_.m_135372_(PERCH_POS, Optional.empty());
        this.f_19804_.m_135372_(CROW_DYE_COLOR, (Object)-1);
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
        this.f_19804_.m_135372_(DATA_PLAYING_DEAD, (Object)false);
    }

    public void sync() {
        this.m_6596_();
        if (!this.f_19853_.f_46443_) {
            HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_19853_.m_46745_(this.m_20183_())), (Object)new CrowSyncPacket((Entity)this, this.m_20240_(new CompoundTag())));
        }
    }

    public void syncAdditionalData() {
        this.m_6596_();
        if (!this.f_19853_.f_46443_) {
            CompoundTag tag = new CompoundTag();
            this.addAdditionalSaveDataNoSuper(tag);
            HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_19853_.m_46745_(this.m_20183_())), (Object)new CrowSyncAdditonalDataPacket((Entity)this, tag));
        }
    }

    public boolean isMaxHealth() {
        return this.m_21223_() >= this.m_21233_();
    }

    public int getInteractionRange() {
        return this.interactionRange;
    }

    protected int getInventorySize() {
        return 3;
    }

    public void m_6667_(DamageSource pCause) {
        if (!this.m_21262_(pCause)) {
            super.m_6667_(pCause);
        }
    }

    public void reviveCrow() {
        this.revive();
        this.f_20890_ = false;
        this.m_21153_(this.m_21233_());
    }

    public boolean isDead() {
        return this.f_20890_;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        float f = this.m_21223_();
        if (!(this.f_19853_.f_46443_ || this.m_21525_() || !((float)this.f_19796_.m_188503_(3) < pAmount) && !(f / this.m_21233_() < 0.5f) || !(pAmount < f) || pSource.m_7639_() == null && pSource.m_7640_() == null || this.isPlayingDead())) {
            this.playingDead = 200;
        }
        if (pSource == DamageSource.f_19325_) {
            return false;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public boolean m_5830_() {
        if (this.m_20159_()) {
            return false;
        }
        return super.m_5830_();
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                CrowEntity.this.syncAdditionalData();
            }

            public int getSlotLimit(int slot) {
                if (slot == 0 || slot == 1 || slot == 2) {
                    return 1;
                }
                return 64;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Override
    public void peck() {
        this.peck = true;
        this.peckTiltAngle = 80.0f;
        this.peckTimer = 10;
        this.caw = false;
        if (!this.f_19853_.f_46443_) {
            this.cawTimer = new Random().nextInt(360) + 360;
        }
        this.cawTiltAngle = 0.0f;
        this.cawTiltAngleActual = 0.0f;
    }

    public void m_6083_() {
        Entity entity = this.m_20202_();
        if (this.m_20159_() && !entity.m_6084_()) {
            this.m_8127_();
        } else if (this.m_21824_() && entity instanceof LivingEntity && this.m_21830_((LivingEntity)entity)) {
            this.m_20334_(0.0, 0.0, 0.0);
            this.m_8119_();
            Entity player = this.m_20202_();
            if (this.m_20159_()) {
                int i = player.m_20197_().indexOf(this);
                float radius = 0.38f;
                float angle = (float)Math.PI / 180 * (((Player)player).f_20883_ + (float)(i == 0 ? -90 : 90));
                this.f_20885_ = ((Player)player).f_20885_;
                this.f_19859_ = ((Player)player).f_20885_;
                this.m_6034_(player.m_20185_() + (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))), player.m_20186_() + (!player.m_6144_() ? 1.4 : 1.2), player.m_20189_() + (double)(radius * Mth.m_14089_((float)angle)));
                if (!player.m_6084_() || player.m_6144_() || ((Player)player).m_21255_() || this.m_5448_() != null && this.m_5448_().m_6084_()) {
                    this.m_6038_();
                }
            }
        } else {
            super.m_6083_();
        }
    }

    private void setTypeVariant(int pTypeVariant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)pTypeVariant);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    public CrowVariant getVariant() {
        return CrowVariant.byId(this.getTypeVariant() & 0xFF);
    }

    public void m_6818_(BlockPos p_21082_, boolean p_21083_) {
        this.jukebox = p_21082_;
        this.dance = p_21083_;
    }

    protected AABB getTargetableArea(double targetDistance) {
        Vec3 renderCenter = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        AABB aabb = new AABB(-targetDistance, -targetDistance, -targetDistance, targetDistance, targetDistance, targetDistance);
        return aabb.m_82383_(renderCenter);
    }

    private void removeFramedMap(ItemStack pStack) {
        this.getFramedMapId().ifPresent(p_218864_ -> {
            MapItemSavedData mapitemsaveddata = MapItem.m_151128_((Integer)p_218864_, (Level)this.f_19853_);
            if (mapitemsaveddata != null) {
                mapitemsaveddata.m_77947_(this.m_20183_(), this.m_19879_());
                mapitemsaveddata.m_77760_(true);
            }
        });
        pStack.m_41636_(null);
    }

    public boolean m_21262_(DamageSource pDamageSource) {
        if (pDamageSource.m_19378_()) {
            return false;
        }
        ItemStack itemstack = null;
        boolean triggered = false;
        for (InteractionHand interactionhand : InteractionHand.values()) {
            ItemStack itemstack1 = this.m_21120_(interactionhand);
            if (!itemstack1.m_150930_((Item)ModItems.CROW_ANKH_AMULET.get())) continue;
            itemstack = itemstack1.m_41777_();
            itemstack1.m_41774_(1);
            triggered = true;
            break;
        }
        ItemStack itemstack1 = this.itemHandler.getStackInSlot(2);
        if (!triggered && itemstack1.m_150930_((Item)ModItems.CROW_ANKH_AMULET.get())) {
            itemstack = itemstack1.m_41777_();
            itemstack1.m_41774_(1);
            triggered = true;
        }
        if (triggered) {
            this.m_21153_(1.0f);
            this.m_21219_();
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 900, 1));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 800, 0));
            this.f_19853_.m_7605_((Entity)this, (byte)35);
            this.sync();
        }
        return triggered;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.sync && this.f_19853_ instanceof ServerLevel) {
            this.sync();
            this.sync = true;
        }
        if (!this.sync && this.f_19853_ instanceof ClientLevel) {
            if (this.f_19853_.f_46443_) {
                HexereiPacketHandler.sendToServer(new CrowAskForSyncPacket((Entity)this));
            }
            this.sync = true;
        }
        if (!this.f_19853_.f_46443_) {
            Item item;
            if (this.itemHandler.getStackInSlot(2).m_150930_((Item)ModItems.CROW_BLANK_AMULET.get())) {
                this.itemHandler.getStackInSlot(2).m_41666_(this.f_19853_, (Entity)this, 2, true);
            }
            if ((item = this.itemHandler.getStackInSlot(2).m_41720_()) instanceof MapItem) {
                MapItem mapItem = (MapItem)item;
                MapItemSavedData mapitemsaveddata = MapItem.m_42853_((ItemStack)this.itemHandler.getStackInSlot(2), (Level)this.f_19853_);
                if (mapitemsaveddata != null && !mapitemsaveddata.f_77892_) {
                    mapItem.m_42893_(this.f_19853_, (Entity)this, mapitemsaveddata);
                }
            }
        }
        if (this.playingDead > 0) {
            if (!this.isPlayingDead()) {
                this.setPlayingDead(true);
            }
            --this.playingDead;
        } else if (this.isPlayingDead()) {
            this.setPlayingDead(false);
        }
        if (this.isPlayingDead()) {
            return;
        }
        if (this.breedNuggetGivenByCrowTimer > 0 && !this.f_19853_.f_46443_) {
            --this.breedNuggetGivenByCrowTimer;
            if (this.breedNuggetGivenByCrowTimer == 10) {
                this.peck();
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_19853_.m_46745_(this.m_20183_())), (Object)new CrowPeckPacket((Entity)this));
            }
            if (this.breedNuggetGivenByCrowTimer == 0 && this.f_19853_.m_46003_(this.breedNuggetGivenByPlayerUUID) != null) {
                this.m_27595_(this.f_19853_.m_46003_(this.breedNuggetGivenByPlayerUUID));
            }
        }
        if (this.pickpocketTimer > 0) {
            --this.pickpocketTimer;
        }
        if (this.searchForNewCropTargetTimer > 0) {
            --this.searchForNewCropTargetTimer;
            if (this.searchForNewCropTargetTimer <= 0) {
                this.searchForNewCropTarget = false;
            }
        }
        ++this.animationCounter;
        ++this.rideCooldownCounter;
        if (!this.f_19853_.f_46443_ && this.m_21824_() && this.cofferHerbJarListResetTimer-- <= 0) {
            this.cofferHerbJarList = HexereiUtil.getAllToggledCofferAndHerbJarPositionsNearby(this.interactionRange, this.f_19853_, (Entity)this);
            this.cofferHerbJarListResetTimer = 200;
            this.villagerList = this.f_19853_.m_6443_(Villager.class, this.getTargetableArea(this.interactionRange), this.targetEntitySelector);
        }
        if (this.pickpocketTimer < 5 && this.pickpocketTimer > 0) {
            this.m_19983_(this.itemHandler.getStackInSlot(1).m_41777_());
            this.itemHandler.setStackInSlot(1, ItemStack.f_41583_);
        }
        if (this.m_20184_().f_82480_ < -0.0075) {
            this.rightWingAngle = Mth.m_14031_((float)(Hexerei.getClientTicksWithoutPartial() / 5.0f)) * 0.05f;
            this.leftWingAngle = -Mth.m_14031_((float)(0.97f + Hexerei.getClientTicksWithoutPartial() / 5.0f)) * 0.05f;
        } else {
            this.rightWingAngle = (float)Math.sin(Hexerei.getClientTicksWithoutPartial() / 5.0f) * 0.8f;
            this.leftWingAngle = -((float)Math.sin(Hexerei.getClientTicksWithoutPartial() / 5.0f)) * 0.8f;
        }
        this.rightWingAngleActual = this.moveTo(this.rightWingAngleActual, this.rightWingAngle, 0.1f);
        this.leftWingAngleActual = this.moveTo(this.leftWingAngleActual, this.leftWingAngle, 0.1f);
        if (this.headTiltTimer-- <= 0) {
            boolean bl = this.headTilt = !this.headTilt;
            if (this.headTilt) {
                this.headTiltTimer = this.f_19796_.m_188503_(80) + 20;
                this.headZTiltAngle = this.f_19796_.m_188503_(180) - 90;
                this.headXTiltAngle = this.f_19796_.m_188503_(180) - 90;
            } else {
                this.headTiltTimer = this.f_19796_.m_188503_(80) + 20;
                this.headZTiltAngle = 0.0f;
                this.headXTiltAngle = 0.0f;
            }
        }
        if (this.f_19853_.f_46443_) {
            this.headZTiltAngleActual = this.moveTo(this.headZTiltAngleActual, this.headZTiltAngle, 15.0f);
            this.headXTiltAngleActual = this.moveTo(this.headXTiltAngleActual, this.headXTiltAngle, 15.0f);
        }
        if (this.peckTimer > 0) {
            --this.peckTimer;
        }
        if (this.peckTimer <= 0 && this.peck) {
            this.peck = false;
            this.peckTiltAngle = 0.0f;
        }
        this.peckTiltAngleActual = this.moveTo(this.peckTiltAngleActual, this.peckTiltAngle, 15.0f);
        if (!this.f_19853_.f_46443_ && !this.itemHandler.getStackInSlot(1).m_41619_()) {
            this.cawTimer = 360;
        }
        if (this.cawTimer > 0) {
            --this.cawTimer;
            if (this.cawTimer <= 0) {
                boolean bl = this.caw = !this.caw;
                if (this.caw) {
                    if (!this.f_19853_.f_46443_) {
                        HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_19853_.m_46745_(this.m_20183_())), (Object)new CrowCawPacket((Entity)this));
                        this.m_5496_((SoundEvent)ModSounds.CROW_CAW.get(), this.m_6121_(), this.m_6100_());
                        this.cawTimer = 15;
                    }
                } else if (!this.f_19853_.f_46443_) {
                    this.cawTimer = this.f_19796_.m_188503_(360) + 360;
                } else {
                    this.cawTiltAngle = 0.0f;
                }
            }
        }
        if (this.f_19853_.f_46443_) {
            this.cawTiltAngleActual = this.moveTo(this.cawTiltAngleActual, this.cawTiltAngle, 30.0f);
        }
        if (this.tailWagTimer > 0) {
            --this.tailWagTimer;
            if (this.tailWagTimer <= 0) {
                boolean bl = this.tailWag = !this.tailWag;
                if (this.tailWag) {
                    if (!this.f_19853_.f_46443_) {
                        if (!this.tailFan) {
                            HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_19853_.m_46745_(this.m_20183_())), (Object)new CrowTailWagPacket((Entity)this));
                        } else {
                            this.tailWag = false;
                        }
                        this.tailWagTimer = 15;
                    }
                } else if (!this.f_19853_.f_46443_) {
                    this.tailWagTimer = this.f_19796_.m_188503_(80) + 80;
                } else {
                    this.tailWagTiltAngle = 0.0f;
                }
            }
        }
        if (this.f_19853_.f_46443_) {
            if (this.tailWag) {
                this.tailWagTiltAngle = Mth.m_14031_((float)Hexerei.getClientTicks()) * 100.0f;
            }
            this.tailWagTiltAngleActual = this.moveTo(this.tailWagTiltAngleActual, this.tailWagTiltAngle, 30.0f);
        }
        if (this.tailFanTimer > 0) {
            --this.tailFanTimer;
            if (this.tailFanTimer <= 0) {
                boolean bl = this.tailFan = !this.tailFan;
                if (this.tailFan) {
                    if (!this.f_19853_.f_46443_) {
                        if (!this.tailWag) {
                            HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_19853_.m_46745_(this.m_20183_())), (Object)new CrowTailFanPacket((Entity)this));
                        } else {
                            this.tailFan = false;
                        }
                        this.tailFanTimer = 15;
                    }
                } else if (!this.f_19853_.f_46443_) {
                    this.tailFanTimer = this.f_19796_.m_188503_(80) + 20;
                } else {
                    this.tailFanTiltAngle = 0.0f;
                }
            }
        }
        if (this.f_19853_.f_46443_) {
            this.tailFanTiltAngleActual = this.moveTo(this.tailFanTiltAngleActual, this.tailFanTiltAngle, 20.0f);
        }
        if (!this.itemHandler.getStackInSlot(1).m_41619_()) {
            ++this.heldItemTime;
            if (this.heldItemTime > 60 && this.isCrowEdible(this.itemHandler.getStackInSlot(1)) && (!this.m_21824_() || this.m_21223_() < this.m_21233_())) {
                this.heldItemTime = 0;
                this.m_5634_(4.0f);
                if (!this.f_19853_.f_46443_) {
                    HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_19853_.m_46745_(this.m_20183_())), (Object)new CrowEatParticlesPacket((Entity)this, this.itemHandler.getStackInSlot(1)));
                }
                this.m_5496_(SoundEvents.f_12190_, this.m_6121_(), this.m_6100_());
                if (this.itemHandler.getStackInSlot(1).m_41720_() == ModItems.SEED_MIXTURE.get() && this.seedThrowerID != null && !this.m_21824_()) {
                    if (this.m_217043_().m_188501_() < 0.3f) {
                        this.m_7105_(true);
                        this.setCommand(1);
                        this.m_21816_(this.seedThrowerID);
                        Player player = this.f_19853_.m_46003_(this.seedThrowerID);
                        if (player instanceof ServerPlayer) {
                            CriteriaTriggers.f_10590_.m_68829_((ServerPlayer)player, (Animal)this);
                        }
                        this.f_19853_.m_7605_((Entity)this, (byte)7);
                    } else {
                        this.f_19853_.m_7605_((Entity)this, (byte)6);
                    }
                }
                if (this.itemHandler.getStackInSlot(1).hasCraftingRemainingItem()) {
                    this.m_19983_(this.itemHandler.getStackInSlot(1).getCraftingRemainingItem());
                }
                this.itemHandler.getStackInSlot(1).m_41774_(1);
            }
        } else {
            this.heldItemTime = 0;
        }
    }

    public void eatParticles(ItemStack stack) {
        float scale = 3.0f;
        if (this.m_6162_()) {
            scale = 4.0f;
        }
        Vec3 vec3 = this.m_20171_(0.0f, this.f_20883_);
        for (int i = 0; i < 6; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), this.m_20208_(0.125) + vec3.f_82479_ / (double)scale, this.f_19796_.m_188500_() / 4.0 - 0.125 + this.m_20188_(), this.m_20262_(0.125) + vec3.f_82481_ / (double)scale, (this.f_19796_.m_188500_() - 0.5) / 15.0, (this.f_19796_.m_188500_() + 0.5) * 0.15, (this.f_19796_.m_188500_() - 0.5) / 15.0);
        }
    }

    private float moveTo(float input, float moveTo, float speed) {
        float distance = moveTo - input;
        if (Math.abs(distance) <= speed) {
            return moveTo;
        }
        input = distance > 0.0f ? (input += speed) : (input -= speed);
        return input;
    }

    public int getHelpCommand() {
        return (Integer)this.f_19804_.m_135370_(HELP_COMMAND);
    }

    public int getCommand() {
        return (Integer)this.f_19804_.m_135370_(COMMAND);
    }

    public boolean getCommandFollow() {
        return (Integer)this.f_19804_.m_135370_(COMMAND) == 0;
    }

    public boolean getCommandSit() {
        return (Integer)this.f_19804_.m_135370_(COMMAND) == 1;
    }

    public boolean getCommandWander() {
        return (Integer)this.f_19804_.m_135370_(COMMAND) == 2;
    }

    public boolean getCommandHelp() {
        return (Integer)this.f_19804_.m_135370_(COMMAND) == 3;
    }

    public void setCommand(int command) {
        this.f_19804_.m_135381_(COMMAND, (Object)command);
        if (this.f_19853_.f_46443_) {
            HexereiPacketHandler.sendToServer(new CrowSyncCommandToServer((Entity)this, command));
        } else {
            this.m_21839_(command == 1);
        }
    }

    public void setHelpCommand(int command) {
        this.f_19804_.m_135381_(HELP_COMMAND, (Object)command);
        if (this.f_19853_.f_46443_) {
            HexereiPacketHandler.sendToServer(new CrowSyncHelpCommandToServer((Entity)this, command));
        }
    }

    public void setCommandFollow() {
        this.f_19804_.m_135381_(COMMAND, (Object)0);
        this.m_21839_(false);
    }

    public void setCommandSit() {
        this.f_19804_.m_135381_(COMMAND, (Object)1);
        this.m_21839_(true);
    }

    public void setCommandWander() {
        this.f_19804_.m_135381_(COMMAND, (Object)2);
        this.m_21839_(false);
    }

    public void setCommandHelp() {
        this.f_19804_.m_135381_(COMMAND, (Object)3);
        this.m_21839_(false);
    }

    public void setPerchPos(BlockPos pos) {
        this.f_19804_.m_135381_(PERCH_POS, Optional.ofNullable(pos));
    }

    public BlockPos getPerchPos() {
        return ((Optional)this.f_19804_.m_135370_(PERCH_POS)).orElse(null);
    }

    public DyeColor getDyeColor() {
        DyeColor color = HexereiUtil.getDyeColorNamed(this.m_7755_().getString(), 0);
        return color == null ? DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(CROW_DYE_COLOR))) : color;
    }

    public int getDyeColorId() {
        return (Integer)this.f_19804_.m_135370_(CROW_DYE_COLOR);
    }

    public void setDyeColor(int color) {
        this.f_19804_.m_135381_(CROW_DYE_COLOR, (Object)color);
    }

    public void setDyeColor(DyeColor color) {
        this.f_19804_.m_135381_(CROW_DYE_COLOR, (Object)color.m_41060_());
    }

    protected PathNavigation m_6037_(Level worldIn) {
        FlyingPathNavigation flyingpathnavigator = new FlyingPathNavigation((Mob)this, worldIn);
        flyingpathnavigator.m_26440_(false);
        flyingpathnavigator.m_7008_(true);
        flyingpathnavigator.m_26443_(true);
        return flyingpathnavigator;
    }

    public static AttributeSupplier createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22280_, 0.6).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 3.0).m_22265_();
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        return switch (slot.m_20743_()) {
            default -> throw new IncompatibleClassChangeError();
            case EquipmentSlot.Type.HAND -> this.itemHandler.getStackInSlot(1);
            case EquipmentSlot.Type.ARMOR -> this.itemHandler.getStackInSlot(0);
        };
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setCommand(compound.m_128451_("Command"));
        this.setHelpCommand(compound.m_128451_("HelpCommand"));
        this.pickpocketTimer = compound.m_128451_("PickpocketTimer");
        this.setTypeVariant(compound.m_128451_("Variant"));
        this.playingDead = compound.m_128451_("PlayingDeadTimer");
        if (compound.m_128441_("InteractionRange")) {
            this.interactionRange = compound.m_128451_("InteractionRange");
        }
        if (compound.m_128441_("CanAttack")) {
            this.canAttack = compound.m_128471_("CanAttack");
        }
        this.itemHandler.deserializeNBT(compound.m_128469_("inv"));
        ArrayList<Block> list = new ArrayList<Block>();
        if (compound.m_128441_("HarvestWhitelistSize")) {
            int size = compound.m_128451_("HarvestWhitelistSize");
            for (int i = 0; i < size; ++i) {
                list.add((Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.m_135822_((String)compound.m_128461_("HarvestWhitelist_" + i), (char)':')));
            }
        }
        this.harvestWhitelist = list;
        this.removeFramedMap(this.itemHandler.getStackInSlot(2));
        if (compound.m_128441_("PerchX") && compound.m_128441_("PerchY") && compound.m_128441_("PerchZ")) {
            this.setPerchPos(new BlockPos(compound.m_128451_("PerchX"), compound.m_128451_("PerchY"), compound.m_128451_("PerchZ")));
        }
        if (compound.m_128441_("DyeColor")) {
            this.setDyeColor(compound.m_128451_("DyeColor"));
        }
    }

    public void readAdditionalSaveDataNoSuper(CompoundTag compound) {
        this.setCommand(compound.m_128451_("Command"));
        this.setHelpCommand(compound.m_128451_("HelpCommand"));
        this.pickpocketTimer = compound.m_128451_("PickpocketTimer");
        this.setTypeVariant(compound.m_128451_("Variant"));
        this.playingDead = compound.m_128451_("PlayingDeadTimer");
        if (compound.m_128441_("InteractionRange")) {
            this.interactionRange = compound.m_128451_("InteractionRange");
        }
        if (compound.m_128441_("CanAttack")) {
            this.canAttack = compound.m_128471_("CanAttack");
        }
        this.itemHandler.deserializeNBT(compound.m_128469_("inv"));
        ArrayList<Block> list = new ArrayList<Block>();
        if (compound.m_128441_("HarvestWhitelistSize")) {
            int size = compound.m_128451_("HarvestWhitelistSize");
            for (int i = 0; i < size; ++i) {
                list.add((Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.m_135822_((String)compound.m_128461_("HarvestWhitelist_" + i), (char)':')));
            }
        }
        this.harvestWhitelist = list;
        if (compound.m_128441_("PerchX") && compound.m_128441_("PerchY") && compound.m_128441_("PerchZ")) {
            this.setPerchPos(new BlockPos(compound.m_128451_("PerchX"), compound.m_128451_("PerchY"), compound.m_128451_("PerchZ")));
        }
        if (compound.m_128441_("DyeColor")) {
            this.setDyeColor(compound.m_128451_("DyeColor"));
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Command", this.getCommand());
        compound.m_128405_("HelpCommand", this.getHelpCommand());
        compound.m_128405_("PickpocketTimer", this.pickpocketTimer);
        compound.m_128405_("Variant", this.getTypeVariant());
        compound.m_128405_("PlayingDeadTimer", this.playingDead);
        compound.m_128405_("InteractionRange", this.interactionRange);
        compound.m_128379_("CanAttack", this.canAttack);
        compound.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        compound.m_128405_("HarvestWhitelistSize", this.harvestWhitelist.size());
        for (int i = 0; i < this.harvestWhitelist.size(); ++i) {
            ResourceLocation loc = ForgeRegistries.BLOCKS.getKey((Object)this.harvestWhitelist.get(i));
            if (loc == null) continue;
            compound.m_128359_("HarvestWhitelist_" + i, loc.toString());
        }
        if (this.getPerchPos() != null) {
            compound.m_128405_("PerchX", this.getPerchPos().m_123341_());
            compound.m_128405_("PerchY", this.getPerchPos().m_123342_());
            compound.m_128405_("PerchZ", this.getPerchPos().m_123343_());
        }
        compound.m_128405_("DyeColor", this.getDyeColorId());
    }

    public void addAdditionalSaveDataNoSuper(CompoundTag compound) {
        compound.m_128405_("Command", this.getCommand());
        compound.m_128405_("HelpCommand", this.getHelpCommand());
        compound.m_128405_("PickpocketTimer", this.pickpocketTimer);
        compound.m_128405_("Variant", this.getTypeVariant());
        compound.m_128405_("PlayingDeadTimer", this.playingDead);
        compound.m_128405_("InteractionRange", this.interactionRange);
        compound.m_128379_("CanAttack", this.canAttack);
        compound.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        compound.m_128405_("HarvestWhitelistSize", this.harvestWhitelist.size());
        for (int i = 0; i < this.harvestWhitelist.size(); ++i) {
            ResourceLocation loc = ForgeRegistries.BLOCKS.getKey((Object)this.harvestWhitelist.get(i));
            if (loc == null) continue;
            compound.m_128359_("HarvestWhitelist_" + i, loc.toString());
        }
        if (this.getPerchPos() != null) {
            compound.m_128405_("PerchX", this.getPerchPos().m_123341_());
            compound.m_128405_("PerchY", this.getPerchPos().m_123342_());
            compound.m_128405_("PerchZ", this.getPerchPos().m_123343_());
        }
        compound.m_128405_("DyeColor", this.getDyeColorId());
    }

    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @javax.annotation.Nullable SpawnGroupData pSpawnData, @javax.annotation.Nullable CompoundTag pDataTag) {
        CrowVariant variant;
        RandomSource randomsource = pLevel.m_213780_();
        if (pSpawnData instanceof CrowGroupData) {
            variant = ((CrowGroupData)((Object)pSpawnData)).variant;
        } else {
            boolean isVariant = randomsource.m_188503_(5) == 0;
            variant = (CrowVariant)((Object)Util.m_214670_((Object[])CrowVariant.values(), (RandomSource)randomsource));
            if (!isVariant) {
                variant = CrowVariant.BLACK;
            }
            pSpawnData = new CrowGroupData(variant);
        }
        this.setTypeVariant(variant.getId() & 0xFF);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void m_8107_() {
        super.m_8107_();
        Vec3 motion = this.m_20184_();
        if (!this.f_19861_ && motion.f_82480_ < 0.0) {
            this.m_20256_(motion.m_82542_(1.0, 0.6, 1.0));
        }
    }

    public void m_7023_(Vec3 vec3d) {
        if (this.getPerchPos() == null) {
            if (this.m_21825_()) {
                if (this.m_21573_().m_26570_() != null) {
                    this.m_21573_().m_26573_();
                }
                vec3d = Vec3.f_82478_;
            }
        } else {
            double topOffset = this.f_19853_.m_8055_(this.getPerchPos()).m_60734_().m_7952_(this.f_19853_.m_8055_(this.getPerchPos()), (BlockGetter)this.f_19853_, this.getPerchPos()).m_83297_(Direction.Axis.Y);
            if (this.distanceTo(this.getPerchPos().m_123341_(), this.getPerchPos().m_123343_()) < 1.0 && this.m_20182_().m_7098_() >= (double)this.getPerchPos().m_123342_() + topOffset && this.m_20182_().m_7098_() < (double)this.getPerchPos().m_7494_().m_123342_() + topOffset - 0.75 && this.m_21825_()) {
                if (this.m_21573_().m_26570_() != null) {
                    this.m_21573_().m_26573_();
                }
                vec3d = Vec3.f_82478_;
            }
        }
        super.m_7023_(vec3d);
    }

    public double distanceTo(double p_20276_, double p_20278_) {
        double d0 = this.m_20185_() - p_20276_ - 0.5;
        double d1 = this.m_20189_() - p_20278_ - 0.5;
        return Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1)));
    }

    protected int m_5639_(float p_21237_, float p_21238_) {
        return 0;
    }

    protected void m_7840_(double p_20990_, boolean p_20991_, BlockState p_20992_, BlockPos p_20993_) {
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == ModItems.SEED_MIXTURE.get();
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public OptionalInt getFramedMapId() {
        Integer integer;
        ItemStack itemstack = this.m_8020_(2);
        if (itemstack.m_150930_(Items.f_42573_) && (integer = MapItem.m_151131_((ItemStack)itemstack)) != null) {
            return OptionalInt.of(integer);
        }
        return OptionalInt.empty();
    }

    public boolean m_142066_() {
        return !this.isPlayingDead() && super.m_142066_();
    }

    public void setPlayingDead(boolean pPlayingDead) {
        if (this.m_8020_(2).m_150930_((Item)ModItems.CROW_ANKH_AMULET.get())) {
            this.m_8020_(2).m_41784_().m_128379_("Active", pPlayingDead);
            if (pPlayingDead) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 120, 1));
            }
        }
        if (pPlayingDead != this.isPlayingDead()) {
            this.m_20242_(false);
            this.m_7910_(0.0f);
            this.f_21344_.m_26573_();
            this.caw = false;
            this.cawTimer = this.f_19796_.m_188503_(360) + 360;
            this.tailFan = false;
            this.tailFanTimer = this.f_19796_.m_188503_(80) + 20;
            this.tailWag = false;
            this.tailWagTimer = this.f_19796_.m_188503_(80) + 80;
            this.sync();
        }
        this.f_19804_.m_135381_(DATA_PLAYING_DEAD, (Object)pPlayingDead);
    }

    public boolean isPlayingDead() {
        return (Boolean)this.f_19804_.m_135370_(DATA_PLAYING_DEAD);
    }

    public Map<String, Vector3f> getModelRotationValues() {
        return this.modelRotationValues;
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        CrowEntity crow = (CrowEntity)((EntityType)ModEntityTypes.CROW.get()).m_20615_((Level)world);
        if (crow != null) {
            CrowVariant crowVariant = this.f_19796_.m_188499_() ? this.getVariant() : ((CrowEntity)entity).getVariant();
            crow.setTypeVariant(crowVariant.getId() & 0xFF);
            crow.m_21530_();
        }
        return crow;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!player.m_36341_() && this.m_21824_() && this.m_21830_((LivingEntity)player) && player.m_21120_(hand).m_150930_((Item)ModItems.CROW_FLUTE.get()) && player.m_21120_(hand).m_41784_().m_128441_("commandMode") && player.m_21120_(hand).m_41784_().m_128451_("commandMode") == 1) {
            CompoundTag tag = player.m_21120_(hand).m_41784_();
            ListTag nbtTagList = tag.m_128437_("crowList", 10);
            CompoundTag itemTag = new CompoundTag();
            boolean flag = false;
            for (int i = 0; i < nbtTagList.size(); ++i) {
                CompoundTag compoundTag = nbtTagList.m_128728_(i);
                UUID thisuuid = this.m_20148_();
                UUID tempuuid = null;
                if (compoundTag.m_128441_("UUID")) {
                    tempuuid = compoundTag.m_128342_("UUID");
                }
                if (tempuuid == null || !thisuuid.toString().equals(tempuuid.toString())) continue;
                flag = true;
                player.m_5661_((Component)Component.m_237110_((String)"entity.hexerei.crow_flute_deselect_message", (Object[])new Object[]{this.m_7755_()}), true);
                this.m_5496_((SoundEvent)ModSounds.CROW_FLUTE_DESELECT.get(), 1.0f, 0.75f);
                nbtTagList.remove(i);
                break;
            }
            if (!flag) {
                if (nbtTagList.size() < 9) {
                    itemTag.m_128362_("UUID", this.m_20148_());
                    itemTag.m_128405_("ID", this.m_19879_());
                    nbtTagList.add((Object)itemTag);
                    player.m_5661_((Component)Component.m_237110_((String)"entity.hexerei.crow_flute_selected_message", (Object[])new Object[]{this.m_7755_()}), true);
                    this.m_5496_((SoundEvent)ModSounds.CROW_FLUTE_SELECT.get(), 1.0f, 0.75f);
                    tag.m_128365_("crowList", (Tag)nbtTagList);
                } else {
                    player.m_5496_((SoundEvent)ModSounds.CROW_FLUTE_DESELECT.get(), 1.0f, 0.1f);
                    player.m_36335_().m_41524_(player.m_21120_(hand).m_41720_(), 10);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (player.m_36341_() && this.m_21830_((LivingEntity)player)) {
            if (!this.f_19853_.m_5776_()) {
                MenuProvider containerProvider = this.createContainerProvider(this.f_19853_, this.m_20183_());
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, b -> b.writeInt(this.m_19879_()));
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (this.itemHandler.getStackInSlot(1).m_41619_()) {
            if (!this.m_21824_() && itemstack.m_41720_() == ModItems.SEED_MIXTURE.get()) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (!this.f_19853_.f_46443_) {
                    if (this.f_19796_.m_188503_(10) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                        this.m_21828_(player);
                        this.f_19853_.m_7605_((Entity)this, (byte)7);
                    } else {
                        this.f_19853_.m_7605_((Entity)this, (byte)6);
                    }
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            if (this.m_21824_() && !this.m_6162_() && itemstack.m_41720_() == Items.f_42587_ && !this.m_27593_()) {
                this.breedNuggetGivenByPlayer = true;
                this.breedNuggetGivenByPlayerUUID = player.m_20148_();
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (!this.f_19853_.f_46443_) {
                    this.m_27595_(player);
                    this.m_19983_(this.itemHandler.getStackInSlot(1).m_41777_());
                    this.itemHandler.setStackInSlot(1, new ItemStack((ItemLike)Items.f_42587_));
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            if (this.m_21824_() && this.m_21830_((LivingEntity)player)) {
                if (!this.f_19853_.f_46443_) {
                    DyeColor dyecolor;
                    if (itemstack.m_41720_() instanceof DyeItem && ((dyecolor = ((DyeItem)itemstack.m_41720_()).m_41089_()) != this.getDyeColor() || this.getDyeColorId() == -1)) {
                        this.setDyeColor(dyecolor);
                        if (!player.m_150110_().f_35937_) {
                            itemstack.m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    this.setCommand(this.getCommand() + 1);
                    if (this.getCommand() == 4) {
                        this.setCommand(0);
                    }
                    if (this.getCommand() == 3) {
                        if (this.getHelpCommand() == 0) {
                            player.m_5661_((Component)Component.m_237110_((String)"entity.hexerei.crow_command_3_0", (Object[])new Object[]{this.m_7755_()}), true);
                        }
                        if (this.getHelpCommand() == 1) {
                            player.m_5661_((Component)Component.m_237110_((String)"entity.hexerei.crow_command_3_1", (Object[])new Object[]{this.m_7755_()}), true);
                        }
                        if (this.getHelpCommand() == 2) {
                            player.m_5661_((Component)Component.m_237110_((String)"entity.hexerei.crow_command_3_2", (Object[])new Object[]{this.m_7755_()}), true);
                        }
                    } else {
                        player.m_5661_((Component)Component.m_237110_((String)("entity.hexerei.crow_command_" + this.getCommand()), (Object[])new Object[]{this.m_7755_()}), true);
                    }
                    this.m_21839_(this.getCommand() == 1);
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            return super.m_6071_(player, hand);
        }
        if (itemstack.m_41720_() != Items.f_42587_ || !this.breedNuggetGivenByPlayer && this.breedNuggetGivenByCrowTimer <= 0) {
            this.m_19983_(this.itemHandler.getStackInSlot(1).m_41777_());
            this.itemHandler.setStackInSlot(1, ItemStack.f_41583_);
        }
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    protected void m_6668_(DamageSource p_21192_) {
        ItemStack hat = this.itemHandler.getStackInSlot(0);
        ItemStack itemstack = this.itemHandler.getStackInSlot(1);
        if (!itemstack.m_41619_()) {
            this.m_19983_(itemstack);
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
        if (!hat.m_41619_()) {
            this.m_19983_(hat);
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
        super.m_6668_(p_21192_);
    }

    private boolean isCrowEdible(ItemStack stack) {
        return stack.m_41720_().m_41472_() || TEMPTATION_ITEMS.test(stack);
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        if (this.m_21824_() && this.getCommandHelp() && this.cofferHerbJarList != null && !this.cofferHerbJarList.isEmpty()) {
            int k = 0;
            boolean flag = false;
            if (this.getPerchPos() != null) {
                BlockEntity perchEntity = this.f_19853_.m_7702_(this.getPerchPos());
                if (perchEntity instanceof HerbJarTile) {
                    HerbJarTile herbJarTile = (HerbJarTile)perchEntity;
                    if (herbJarTile.buttonToggled != 0 && ((Boolean)HexConfig.JARS_ONLY_HOLD_HERBS.get() != false ? stack.m_204117_(HexereiTags.Items.HERB_ITEM) && (herbJarTile.itemHandler.getStackInSlot(0).m_41619_() || herbJarTile.itemHandler.getStackInSlot(0).m_41783_() == stack.m_41783_() && herbJarTile.itemHandler.getStackInSlot(0).m_41656_(stack)) : herbJarTile.itemHandler.getStackInSlot(0).m_41619_() || herbJarTile.itemHandler.getStackInSlot(0).m_41783_() == stack.m_41783_() && herbJarTile.itemHandler.getStackInSlot(0).m_41656_(stack))) {
                        return true;
                    }
                }
                if (perchEntity instanceof CofferTile) {
                    CofferTile cofferTile = (CofferTile)perchEntity;
                    if (cofferTile.buttonToggled != 0 && (cofferTile.m_7983_() || cofferTile.hasNonMaxStackItemStack(stack) || cofferTile.hasItem(Items.f_41852_))) {
                        return true;
                    }
                }
            }
            for (BlockPos blockPos : this.cofferHerbJarList) {
                BlockEntity blockEntity;
                if ((blockEntity = this.f_19853_.m_7702_(this.cofferHerbJarList.get(k++))) instanceof CofferTile) {
                    CofferTile cofferTile = (CofferTile)blockEntity;
                    for (int i = 0; i < cofferTile.itemStackHandler.getSlots(); ++i) {
                        if (!cofferTile.itemStackHandler.getStackInSlot(i).m_150930_(stack.m_41720_())) continue;
                        flag = true;
                        break;
                    }
                }
                if (!(blockEntity instanceof HerbJarTile)) continue;
                HerbJarTile herbJarTile = (HerbJarTile)blockEntity;
                if (!herbJarTile.itemHandler.getStackInSlot(0).m_150930_(stack.m_41720_())) continue;
                flag = true;
                break;
            }
            if (!flag) {
                this.isCrowEdible(stack);
            }
            return flag;
        }
        if (this.m_21824_() && this.m_21223_() < this.m_21233_()) {
            return this.isCrowEdible(stack);
        }
        return !this.m_21824_() && this.isCrowEdible(stack);
    }

    @Override
    public void onGetItem(ItemEntity e) {
        ItemStack duplicate = e.m_32055_().m_41777_();
        duplicate.m_41764_(1);
        if (!this.itemHandler.getStackInSlot(1).m_41619_() && !this.f_19853_.f_46443_) {
            this.m_5552_(this.itemHandler.getStackInSlot(1), 0.0f);
        }
        this.itemHandler.setStackInSlot(1, duplicate);
        this.seedThrowerID = e.m_32055_().m_41720_() == ModItems.SEED_MIXTURE.get() && !this.m_21824_() ? e.m_32057_() : null;
    }

    @Override
    public void onFindTarget(ItemEntity e) {
        ITargetsDroppedItems.super.onFindTarget(e);
    }

    @Override
    public double getMaxDistToItem() {
        return 1.0;
    }

    public boolean m_29443_() {
        return !this.f_19861_;
    }

    public boolean canSitOnShoulder() {
        return this.rideCooldownCounter > 100;
    }

    protected void m_7324_(Entity entityIn) {
        if (!(entityIn instanceof Player)) {
            super.m_7324_(entityIn);
        }
    }

    public int m_6643_() {
        return 3;
    }

    public boolean m_7983_() {
        return false;
    }

    public ItemStack m_8020_(int index) {
        return this.itemHandler.getStackInSlot(index);
    }

    public ItemStack m_7407_(int index, int count) {
        ItemStack stack = this.itemHandler.getStackInSlot(index).m_41777_();
        if (count >= stack.m_41613_()) {
            this.itemHandler.setStackInSlot(index, ItemStack.f_41583_);
        } else {
            this.itemHandler.getStackInSlot(index).m_41764_(stack.m_41613_() - count);
            stack.m_41764_(count);
        }
        return stack;
    }

    public ItemStack m_8016_(int index) {
        ItemStack stack = this.itemHandler.getStackInSlot(index).m_41777_();
        this.itemHandler.setStackInSlot(index, ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int index, ItemStack stack) {
        if (index >= 0 && index < 3) {
            this.itemHandler.setStackInSlot(index, stack);
        }
        this.syncAdditionalData();
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player player) {
        if (this.m_213877_()) {
            return false;
        }
        return !(player.m_20280_((Entity)this) > 144.0);
    }

    public void m_6211_() {
        for (int i = 0; i < 3; ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inv, Player player) {
        return new CrowContainer(id, this, inv, player);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @javax.annotation.Nullable Direction facing) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(capability, facing);
    }

    private MenuProvider createContainerProvider(Level worldIn, BlockPos pos) {
        return new MenuProvider(){

            @Nullable
            public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
                return new CrowContainer(i, CrowEntity.this, playerInventory, playerEntity);
            }

            public Component m_5446_() {
                return Component.m_237115_((String)"");
            }
        };
    }

    public boolean m_7090_() {
        return this.itemHandler.getStackInSlot(1).m_150930_((Item)ModItems.WARHAMMER.get()) && this.m_5446_().getString().equals("Thor");
    }

    public void m_5757_(Container p_18983_) {
        ItemStack stack = p_18983_.m_8020_(2);
        stack.m_41636_((Entity)this);
    }

    public class FloatGoal
    extends Goal {
        private final Mob mob;

        public FloatGoal(Mob p_25230_) {
            this.mob = p_25230_;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP));
            p_25230_.m_21573_().m_7008_(true);
        }

        public boolean m_8036_() {
            return this.mob.m_20069_() && this.mob.m_204036_(FluidTags.f_13131_) > this.mob.m_20204_() || this.mob.m_20077_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.mob.m_217043_().m_188501_() < 0.8f) {
                this.mob.m_21569_().m_24901_();
                Vec3 randomPos = DefaultRandomPos.m_148403_((PathfinderMob)CrowEntity.this, (int)10, (int)7);
                if (randomPos == null) {
                    randomPos = LandRandomPos.m_148488_((PathfinderMob)CrowEntity.this, (int)10, (int)7);
                }
                BlockPos pos = randomPos != null ? new BlockPos(randomPos.f_82479_, randomPos.f_82480_, randomPos.f_82481_) : (CrowEntity.this.getPerchPos() != null ? CrowEntity.this.getPerchPos().m_7494_().m_7494_() : CrowEntity.this.m_20183_().m_7494_().m_7494_());
                if (!CrowEntity.this.m_21825_() && !CrowEntity.this.getCommandSit()) {
                    this.mob.m_5997_(0.0, 0.1, 0.0);
                }
                CrowEntity.this.f_21344_.m_26536_(CrowEntity.this.m_21573_().m_7864_(pos, 0), 1.5);
            }
        }
    }

    public class FlyBackToPerchGoal
    extends Goal {
        private final TamableAnimal mob;

        public FlyBackToPerchGoal(TamableAnimal p_25898_) {
            this.mob = p_25898_;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8045_() {
            if (CrowEntity.this.getPerchPos() == null) {
                return false;
            }
            if (CrowEntity.this.aiItemFlag) {
                return false;
            }
            if (CrowEntity.this.depositItemBeforePerch) {
                return false;
            }
            if (CrowEntity.this.getCommand() == 0) {
                return false;
            }
            if (CrowEntity.this.getCommand() == 2 && CrowEntity.this.m_20275_(CrowEntity.this.getPerchPos().m_123341_(), CrowEntity.this.getPerchPos().m_123342_(), CrowEntity.this.getPerchPos().m_123343_()) < 288.0) {
                return false;
            }
            if (CrowEntity.this.getCommand() == 3) {
                if (CrowEntity.this.m_20275_(CrowEntity.this.getPerchPos().m_123341_(), CrowEntity.this.getPerchPos().m_123342_(), CrowEntity.this.getPerchPos().m_123343_()) > 288.0) {
                    if (CrowEntity.this.f_21344_.m_26570_() != null) {
                        if (CrowEntity.this.m_21825_()) {
                            CrowEntity.this.m_21837_(false);
                            CrowEntity.this.m_21839_(false);
                        }
                        return true;
                    }
                    if (CrowEntity.this.f_21344_.m_26577_()) {
                        if (CrowEntity.this.m_21825_()) {
                            CrowEntity.this.m_21837_(false);
                            CrowEntity.this.m_21839_(false);
                        }
                        return true;
                    }
                } else if (CrowEntity.this.f_21344_.m_26570_() == null) {
                    return true;
                }
            }
            double topOffset = 0.0;
            if (CrowEntity.this.getPerchPos() != null) {
                topOffset = CrowEntity.this.f_19853_.m_8055_(CrowEntity.this.getPerchPos()).m_60734_().m_7952_(CrowEntity.this.f_19853_.m_8055_(CrowEntity.this.getPerchPos()), (BlockGetter)CrowEntity.this.f_19853_, CrowEntity.this.getPerchPos()).m_83297_(Direction.Axis.Y);
            }
            if (this.distanceTo(CrowEntity.this.getPerchPos().m_123341_(), CrowEntity.this.getPerchPos().m_123343_()) < 1.0 && this.mob.m_20182_().m_7098_() >= (double)CrowEntity.this.getPerchPos().m_123342_() + topOffset && this.mob.m_20182_().m_7098_() < (double)CrowEntity.this.getPerchPos().m_7494_().m_123342_() + topOffset) {
                return false;
            }
            if (CrowEntity.this.m_21825_()) {
                CrowEntity.this.m_21837_(false);
                CrowEntity.this.m_21839_(false);
            }
            return true;
        }

        public double distanceTo(double p_20276_, double p_20278_) {
            double d0 = CrowEntity.this.m_20185_() - p_20276_ - 0.5;
            double d1 = CrowEntity.this.m_20189_() - p_20278_ - 0.5;
            return Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1)));
        }

        public boolean m_8036_() {
            if (CrowEntity.this.searchForNewCropTarget) {
                return false;
            }
            if (CrowEntity.this.aiItemFlag) {
                return false;
            }
            if (CrowEntity.this.doingTask) {
                return false;
            }
            if (CrowEntity.this.m_21825_()) {
                return false;
            }
            if (CrowEntity.this.depositItemBeforePerch) {
                if (!CrowEntity.this.m_8020_(1).m_41619_()) {
                    return false;
                }
                CrowEntity.this.depositItemBeforePerch = false;
            }
            if (!this.mob.m_21824_()) {
                return false;
            }
            if (this.mob.m_20072_()) {
                return false;
            }
            LivingEntity livingentity = this.mob.m_21826_();
            if (livingentity == null) {
                return true;
            }
            if (CrowEntity.this.getPerchPos() == null) {
                return false;
            }
            if (CrowEntity.this.getCommand() == 0) {
                return false;
            }
            if (CrowEntity.this.getCommand() == 2 && CrowEntity.this.m_20275_(CrowEntity.this.getPerchPos().m_123341_(), CrowEntity.this.getPerchPos().m_123342_(), CrowEntity.this.getPerchPos().m_123343_()) < 288.0) {
                return false;
            }
            if (CrowEntity.this.getCommand() == 3) {
                if (CrowEntity.this.m_20275_(CrowEntity.this.getPerchPos().m_123341_(), CrowEntity.this.getPerchPos().m_123342_(), CrowEntity.this.getPerchPos().m_123343_()) > 288.0) {
                    if (CrowEntity.this.f_21344_.m_26570_() != null) {
                        if (CrowEntity.this.m_21825_()) {
                            CrowEntity.this.m_21837_(false);
                            CrowEntity.this.m_21839_(false);
                        }
                        return true;
                    }
                    if (CrowEntity.this.f_21344_.m_26577_()) {
                        if (CrowEntity.this.m_21825_()) {
                            CrowEntity.this.m_21837_(false);
                            CrowEntity.this.m_21839_(false);
                        }
                        return true;
                    }
                } else if (CrowEntity.this.f_21344_.m_26570_() == null) {
                    return true;
                }
            }
            double topOffset = CrowEntity.this.f_19853_.m_8055_(CrowEntity.this.getPerchPos()).m_60734_().m_7952_(CrowEntity.this.f_19853_.m_8055_(CrowEntity.this.getPerchPos()), (BlockGetter)CrowEntity.this.f_19853_, CrowEntity.this.getPerchPos()).m_83297_(Direction.Axis.Y);
            if (this.distanceTo(CrowEntity.this.getPerchPos().m_123341_(), CrowEntity.this.getPerchPos().m_123343_()) < 1.0 && this.mob.m_20182_().m_7098_() >= (double)CrowEntity.this.getPerchPos().m_123342_() + topOffset && this.mob.m_20182_().m_7098_() < (double)CrowEntity.this.getPerchPos().m_7494_().m_123342_() + topOffset) {
                if (CrowEntity.this.m_21825_()) {
                    return false;
                }
            } else {
                if (CrowEntity.this.m_21825_()) {
                    CrowEntity.this.m_21837_(false);
                    CrowEntity.this.m_21839_(false);
                }
                return true;
            }
            return !(this.distanceTo(CrowEntity.this.getPerchPos().m_123341_(), CrowEntity.this.getPerchPos().m_123343_()) < 1.0 && this.mob.m_20182_().m_7098_() >= (double)CrowEntity.this.getPerchPos().m_123342_() + topOffset && this.mob.m_20182_().m_7098_() < (double)CrowEntity.this.getPerchPos().m_7494_().m_123342_() + topOffset);
        }

        public void m_8037_() {
            if (CrowEntity.this.isPlayingDead()) {
                return;
            }
            double topOffset = 0.0;
            if (CrowEntity.this.getPerchPos() != null) {
                topOffset = CrowEntity.this.f_19853_.m_8055_(CrowEntity.this.getPerchPos()).m_60734_().m_7952_(CrowEntity.this.f_19853_.m_8055_(CrowEntity.this.getPerchPos()), (BlockGetter)CrowEntity.this.f_19853_, CrowEntity.this.getPerchPos()).m_83297_(Direction.Axis.Y);
            }
            boolean isStuck = false;
            if (CrowEntity.this.stuckTimer++ > 80) {
                if (CrowEntity.this.m_20238_(CrowEntity.this.lastStuckCheckPos) < 2.25) {
                    isStuck = true;
                    CrowEntity.this.stuckTimer = 0;
                }
                CrowEntity.this.lastStuckCheckPos = CrowEntity.this.m_20182_();
            }
            if (isStuck) {
                Vec3 randomPos = DefaultRandomPos.m_148403_((PathfinderMob)this.mob, (int)10, (int)7);
                BlockPos pos = null;
                pos = CrowEntity.this.getPerchPos() != null ? CrowEntity.this.getPerchPos().m_7494_().m_7494_() : CrowEntity.this.m_20183_().m_7494_().m_7494_();
                CrowEntity.this.f_21344_.m_26573_();
                if (CrowEntity.this.m_20238_(CrowEntity.this.lastStuckCheckPos) < 0.1 && CrowEntity.this.m_20096_()) {
                    CrowEntity.this.m_5997_(Math.min((double)0.2f, ((double)pos.m_123341_() - CrowEntity.this.m_20182_().f_82479_) / 20.0), 0.15f, Math.min((double)0.2f, ((double)pos.m_123343_() - CrowEntity.this.m_20182_().f_82481_) / 20.0));
                    CrowEntity.this.f_21344_.m_26536_(CrowEntity.this.m_21573_().m_7864_(pos, 0), 1.5);
                } else {
                    CrowEntity.this.f_21344_.m_26536_(CrowEntity.this.m_21573_().m_7864_(CrowEntity.this.m_20183_().m_7494_().m_7494_(), 0), 1.5);
                }
                CrowEntity.this.stuckTimer = 0;
            } else if (!(CrowEntity.this.getPerchPos() == null || this.distanceTo(CrowEntity.this.getPerchPos().m_123341_(), CrowEntity.this.getPerchPos().m_123343_()) < 1.0 && this.mob.m_20182_().m_7098_() >= (double)CrowEntity.this.getPerchPos().m_123342_() + topOffset && this.mob.m_20182_().m_7098_() < (double)CrowEntity.this.getPerchPos().m_7494_().m_123342_() + topOffset)) {
                CrowEntity.this.f_21344_.m_26536_(this.mob.m_21573_().m_7864_(CrowEntity.this.getPerchPos().m_7494_(), 0), 1.5);
            }
            super.m_8037_();
        }

        public void m_8056_() {
            CrowEntity.this.lastStuckCheckPos = CrowEntity.this.m_20182_();
            if (CrowEntity.this.getPerchPos() != null) {
                CrowEntity.this.f_21344_.m_26536_(this.mob.m_21573_().m_7864_(CrowEntity.this.getPerchPos().m_7494_(), 0), 1.5);
            }
        }

        public void m_8041_() {
            CrowEntity.this.aiItemFlag = false;
            CrowEntity.this.doingTask = false;
            if (CrowEntity.this.getPerchPos() != null) {
                double topOffset = CrowEntity.this.f_19853_.m_8055_(CrowEntity.this.getPerchPos()).m_60734_().m_7952_(CrowEntity.this.f_19853_.m_8055_(CrowEntity.this.getPerchPos()), (BlockGetter)CrowEntity.this.f_19853_, CrowEntity.this.getPerchPos()).m_83297_(Direction.Axis.Y);
                if (this.distanceTo(CrowEntity.this.getPerchPos().m_123341_(), CrowEntity.this.getPerchPos().m_123343_()) < 1.0 && this.mob.m_20182_().m_7098_() >= (double)CrowEntity.this.getPerchPos().m_123342_() + topOffset && this.mob.m_20182_().m_7098_() < (double)CrowEntity.this.getPerchPos().m_7494_().m_123342_() + topOffset) {
                    CrowEntity.this.m_21837_(true);
                }
            }
        }
    }

    public class SitWhenOrderedToGoal
    extends Goal {
        private final TamableAnimal mob;

        public SitWhenOrderedToGoal(TamableAnimal p_25898_) {
            this.mob = p_25898_;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public double distanceTo(double p_20276_, double p_20278_) {
            double d0 = CrowEntity.this.m_20185_() - p_20276_ - 0.5;
            double d1 = CrowEntity.this.m_20189_() - p_20278_ - 0.5;
            return Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1)));
        }

        public boolean m_8045_() {
            if (CrowEntity.this.getPerchPos() != null) {
                double topOffset = CrowEntity.this.f_19853_.m_8055_(CrowEntity.this.getPerchPos()).m_60734_().m_7952_(CrowEntity.this.f_19853_.m_8055_(CrowEntity.this.getPerchPos()), (BlockGetter)CrowEntity.this.f_19853_, CrowEntity.this.getPerchPos()).m_83297_(Direction.Axis.Y);
                if (!(this.distanceTo(CrowEntity.this.getPerchPos().m_123341_(), CrowEntity.this.getPerchPos().m_123343_()) < 1.0 && this.mob.m_20182_().m_7098_() >= (double)CrowEntity.this.getPerchPos().m_123342_() + topOffset && this.mob.m_20182_().m_7098_() < (double)CrowEntity.this.getPerchPos().m_7494_().m_123342_() + topOffset)) {
                    CrowEntity.this.m_21839_(false);
                    return false;
                }
            }
            return this.mob.m_21827_();
        }

        public boolean m_8036_() {
            if (CrowEntity.this.doingTask) {
                return false;
            }
            if (!this.mob.m_21824_()) {
                return false;
            }
            if (this.mob.m_20072_()) {
                return false;
            }
            if (!this.mob.m_20096_()) {
                return false;
            }
            LivingEntity livingentity = this.mob.m_21826_();
            if (livingentity == null) {
                return true;
            }
            if (CrowEntity.this.getPerchPos() != null) {
                double topOffset = CrowEntity.this.f_19853_.m_8055_(CrowEntity.this.getPerchPos()).m_60734_().m_7952_(CrowEntity.this.f_19853_.m_8055_(CrowEntity.this.getPerchPos()), (BlockGetter)CrowEntity.this.f_19853_, CrowEntity.this.getPerchPos()).m_83297_(Direction.Axis.Y);
                if (!(this.distanceTo(CrowEntity.this.getPerchPos().m_123341_(), CrowEntity.this.getPerchPos().m_123343_()) < 1.0 && this.mob.m_20182_().m_7098_() >= (double)CrowEntity.this.getPerchPos().m_123342_() + topOffset && this.mob.m_20182_().m_7098_() < (double)CrowEntity.this.getPerchPos().m_7494_().m_123342_() + topOffset)) {
                    return false;
                }
            }
            return this.mob.m_20280_((Entity)livingentity) < 288.0 && livingentity.m_21188_() != null ? false : this.mob.m_21827_();
        }

        public void m_8037_() {
            if (CrowEntity.this.isPlayingDead()) {
                return;
            }
            super.m_8037_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26573_();
            this.mob.m_21837_(true);
        }

        public void m_8041_() {
            this.mob.m_21837_(false);
        }
    }

    public class FollowOwnerGoal
    extends Goal {
        private final TamableAnimal tamable;
        private LivingEntity owner;
        private final LevelReader level;
        private final double speedModifier;
        private final PathNavigation navigation;
        private int timeToRecalcPath;
        private final float stopDistance;
        private final float startDistance;
        private float oldWaterCost;
        private final boolean canFly;

        public FollowOwnerGoal(TamableAnimal p_25294_, double p_25295_, float p_25296_, float p_25297_, boolean p_25298_) {
            this.tamable = p_25294_;
            this.level = p_25294_.f_19853_;
            this.speedModifier = p_25295_;
            this.navigation = p_25294_.m_21573_();
            this.startDistance = p_25296_;
            this.stopDistance = p_25297_;
            this.canFly = p_25298_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            if (!(p_25294_.m_21573_() instanceof GroundPathNavigation) && !(p_25294_.m_21573_() instanceof FlyingPathNavigation)) {
                throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
            }
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.tamable.m_21826_();
            if (livingentity == null) {
                return false;
            }
            if (livingentity.m_5833_()) {
                return false;
            }
            if (this.tamable.m_21827_() || CrowEntity.this.m_21825_()) {
                return false;
            }
            if (((CrowEntity)this.tamable).getCommand() != 0) {
                return false;
            }
            if (this.tamable.m_20280_((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
                return false;
            }
            if (CrowEntity.this.getCommand() == 0 && CrowEntity.this.m_21825_()) {
                CrowEntity.this.m_21837_(false);
                CrowEntity.this.m_21839_(false);
            }
            this.owner = livingentity;
            return true;
        }

        public boolean m_8045_() {
            if (this.navigation.m_26571_()) {
                return false;
            }
            if (this.tamable.m_21827_() || CrowEntity.this.m_21825_()) {
                return false;
            }
            if (CrowEntity.this.getCommand() == 0 && CrowEntity.this.m_21825_()) {
                CrowEntity.this.m_21837_(false);
                CrowEntity.this.m_21839_(false);
            }
            return !(this.tamable.m_20280_((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = this.tamable.m_21439_(BlockPathTypes.WATER);
            this.tamable.m_21441_(BlockPathTypes.WATER, 0.0f);
        }

        public void m_8041_() {
            CrowEntity.this.doingTask = false;
            this.owner = null;
            this.navigation.m_26573_();
            this.tamable.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
        }

        public void m_8037_() {
            if (CrowEntity.this.isPlayingDead()) {
                return;
            }
            this.tamable.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.tamable.m_8132_());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(10);
                if (!this.tamable.m_21523_() && !this.tamable.m_20159_()) {
                    if (this.tamable.m_20280_((Entity)this.owner) >= 144.0) {
                        this.teleportToOwner();
                    } else {
                        this.navigation.m_5624_((Entity)this.owner, this.speedModifier);
                    }
                }
            }
        }

        private void teleportToOwner() {
            BlockPos blockpos = this.owner.m_20183_();
            for (int i = 0; i < 10; ++i) {
                int j = this.randomIntInclusive(-3, 3);
                int k = this.randomIntInclusive(-1, 1);
                int l = this.randomIntInclusive(-3, 3);
                boolean flag = this.maybeTeleportTo(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
                if (!flag) continue;
                return;
            }
        }

        private boolean maybeTeleportTo(int p_25304_, int p_25305_, int p_25306_) {
            if (Math.abs((double)p_25304_ - this.owner.m_20185_()) < 2.0 && Math.abs((double)p_25306_ - this.owner.m_20189_()) < 2.0) {
                return false;
            }
            if (!this.canTeleportTo(new BlockPos(p_25304_, p_25305_, p_25306_))) {
                return false;
            }
            this.tamable.m_7678_((double)p_25304_ + 0.5, (double)p_25305_, (double)p_25306_ + 0.5, this.tamable.m_146908_(), this.tamable.m_146909_());
            this.navigation.m_26573_();
            return true;
        }

        private boolean canTeleportTo(BlockPos p_25308_) {
            BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)p_25308_.m_122032_());
            BlockState blockstate = this.level.m_8055_(p_25308_.m_7495_());
            if (!this.canFly && blockstate.m_60734_() instanceof LeavesBlock) {
                return false;
            }
            BlockPos blockpos = p_25308_.m_121996_((Vec3i)this.tamable.m_20183_());
            return this.level.m_45756_((Entity)this.tamable, this.tamable.m_20191_().m_82338_(blockpos));
        }

        private int randomIntInclusive(int p_25301_, int p_25302_) {
            return this.tamable.m_217043_().m_188503_(p_25302_ - p_25301_ + 1) + p_25301_;
        }
    }

    public class BreedGoal
    extends Goal {
        private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_();
        protected final Animal animal;
        private final Class<? extends Animal> partnerClass;
        protected final Level level;
        @javax.annotation.Nullable
        protected Animal partner;
        private int loveTime;
        private final double speedModifier;

        public BreedGoal(Animal p_25122_, double p_25123_) {
            this(p_25122_, p_25123_, p_25122_.getClass());
        }

        public BreedGoal(Animal p_25125_, double p_25126_, Class<? extends Animal> p_25127_) {
            this.animal = p_25125_;
            this.level = p_25125_.f_19853_;
            this.partnerClass = p_25127_;
            this.speedModifier = p_25126_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (!this.animal.m_27593_()) {
                return false;
            }
            this.partner = this.getFreePartner();
            return this.partner != null;
        }

        public boolean m_8045_() {
            return this.partner.m_6084_() && this.partner.m_27593_() && this.loveTime < 120;
        }

        public void m_8056_() {
            CrowEntity.this.doingTask = true;
            CrowEntity.this.setCommandHelp();
            if (CrowEntity.this.m_21825_()) {
                CrowEntity.this.m_21837_(false);
                CrowEntity.this.m_21839_(false);
            }
            super.m_8056_();
        }

        public void m_8041_() {
            CrowEntity.this.doingTask = false;
            this.partner = null;
            this.loveTime = 0;
        }

        public void m_8037_() {
            if (CrowEntity.this.isPlayingDead()) {
                return;
            }
            if (this.partner != null) {
                this.animal.m_21563_().m_24960_((Entity)this.partner, 10.0f, (float)this.animal.m_8132_());
                this.animal.m_21573_().m_5624_((Entity)this.partner, this.speedModifier);
                ++this.loveTime;
                if (this.animal.m_20280_((Entity)this.partner) < 4.0 && CrowEntity.this.breedNuggetGivenByPlayer) {
                    if (!((CrowEntity)this.partner).getCommandSit()) {
                        ((CrowEntity)this.partner).setCommandSit();
                    }
                    this.partner.m_21563_().m_24960_((Entity)this.animal, 10.0f, (float)this.animal.m_8132_());
                    ++CrowEntity.this.waitToGiveTime;
                    if (CrowEntity.this.waitToGiveTime > 20 && CrowEntity.this.m_20096_() && CrowEntity.this.itemHandler.getStackInSlot(1).m_150930_(Items.f_42587_)) {
                        ((CrowEntity)this.partner).setCommandFollow();
                        CrowEntity.this.waitToGiveTime = 0;
                        CrowEntity.this.breedNuggetGivenByPlayer = false;
                        CrowEntity.this.peck();
                        HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.level.m_46745_(CrowEntity.this.m_20183_())), (Object)new CrowPeckPacket((Entity)CrowEntity.this));
                        ItemStack stack = ((CrowEntity)this.partner).itemHandler.getStackInSlot(1).m_41777_();
                        ItemStack stack2 = CrowEntity.this.itemHandler.getStackInSlot(1).m_41777_();
                        ((CrowEntity)this.partner).itemHandler.setStackInSlot(1, stack2);
                        CrowEntity.this.itemHandler.setStackInSlot(1, ItemStack.f_41583_);
                        ItemEntity itemEntity = new ItemEntity(this.partner.m_9236_(), this.partner.m_20182_().f_82479_, this.partner.m_20182_().f_82480_, this.partner.m_20182_().f_82481_, stack);
                        this.partner.m_9236_().m_7967_((Entity)itemEntity);
                        if (CrowEntity.this.breedNuggetGivenByPlayerUUID != null && this.level.m_46003_(CrowEntity.this.breedNuggetGivenByPlayerUUID) != null) {
                            ((CrowEntity)this.partner).breedNuggetGivenByPlayerUUID = CrowEntity.this.breedNuggetGivenByPlayerUUID;
                            ((CrowEntity)this.partner).breedNuggetGivenByCrowTimer = 20;
                        } else if (CrowEntity.this.m_21826_() instanceof Player) {
                            this.partner.m_27595_((Player)CrowEntity.this.m_21826_());
                        }
                    }
                }
                if (this.loveTime >= this.m_183277_(60) && this.animal.m_20280_((Entity)this.partner) < 9.0 && CrowEntity.this.itemHandler.getStackInSlot(1).m_150930_(Items.f_42587_)) {
                    this.breed();
                }
            }
        }

        public boolean canMateCrowBringNugget(Animal animal) {
            if (animal.m_6162_()) {
                return false;
            }
            if (animal == CrowEntity.this) {
                return false;
            }
            if (animal.getClass() != CrowEntity.this.getClass()) {
                return false;
            }
            return CrowEntity.this.m_27593_();
        }

        public boolean canMateCrowReceiveNugget(Animal animal) {
            if (animal.m_6162_()) {
                return false;
            }
            if (animal == CrowEntity.this) {
                return false;
            }
            if (animal.getClass() != CrowEntity.this.getClass()) {
                return false;
            }
            return CrowEntity.this.m_27593_() && animal.m_27593_();
        }

        @javax.annotation.Nullable
        private Animal getFreePartner() {
            List list = this.level.m_45971_(this.partnerClass, PARTNER_TARGETING, (LivingEntity)this.animal, this.animal.m_20191_().m_82400_(16.0));
            double d0 = Double.MAX_VALUE;
            Animal animal = null;
            if (CrowEntity.this.breedNuggetGivenByPlayer) {
                for (Animal animal1 : list) {
                    if (!this.canMateCrowBringNugget(animal1) || !(this.animal.m_20280_((Entity)animal1) < d0)) continue;
                    animal = animal1;
                    d0 = this.animal.m_20280_((Entity)animal1);
                }
            } else {
                for (Animal animal1 : list) {
                    if (!this.canMateCrowReceiveNugget(animal1) || !(this.animal.m_20280_((Entity)animal1) < d0)) continue;
                    animal = animal1;
                    d0 = this.animal.m_20280_((Entity)animal1);
                }
            }
            return animal;
        }

        protected void breed() {
            CrowEntity.this.itemHandler.setStackInSlot(1, ItemStack.f_41583_);
            this.spawnChildFromBreeding((ServerLevel)this.level, this.partner);
        }

        public void spawnChildFromBreeding(ServerLevel p_27564_, Animal p_27565_) {
            AgeableMob ageablemob = CrowEntity.this.m_142606_(p_27564_, (AgeableMob)p_27565_);
            BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((Mob)CrowEntity.this, (Mob)p_27565_, ageablemob);
            boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
            ageablemob = event.getChild();
            if (cancelled) {
                CrowEntity.this.m_146762_(6000);
                p_27565_.m_146762_(6000);
                CrowEntity.this.m_27594_();
                p_27565_.m_27594_();
                return;
            }
            if (ageablemob != null) {
                ServerPlayer serverplayer = CrowEntity.this.m_27592_();
                if (serverplayer == null && p_27565_.m_27592_() != null) {
                    serverplayer = p_27565_.m_27592_();
                }
                if (serverplayer != null) {
                    serverplayer.m_36220_(Stats.f_12937_);
                    CriteriaTriggers.f_10581_.m_147278_(serverplayer, (Animal)CrowEntity.this, p_27565_, ageablemob);
                }
                CrowEntity.this.m_146762_(6000);
                p_27565_.m_146762_(6000);
                CrowEntity.this.m_27594_();
                p_27565_.m_27594_();
                ageablemob.m_6863_(true);
                ageablemob.m_7678_(CrowEntity.this.m_20185_(), CrowEntity.this.m_20186_(), CrowEntity.this.m_20189_(), 0.0f, 0.0f);
                p_27564_.m_47205_((Entity)ageablemob);
                ((CrowEntity)ageablemob).m_21816_(CrowEntity.this.breedNuggetGivenByPlayerUUID);
                ((CrowEntity)ageablemob).setCommandSit();
                p_27564_.m_7605_((Entity)CrowEntity.this, (byte)18);
                if (p_27564_.m_46469_().m_46207_(GameRules.f_46135_)) {
                    p_27564_.m_7967_((Entity)new ExperienceOrb((Level)p_27564_, CrowEntity.this.m_20185_(), CrowEntity.this.m_20186_(), CrowEntity.this.m_20189_(), CrowEntity.this.m_217043_().m_188503_(7) + 1));
                }
            }
        }
    }

    public class TemptGoal
    extends Goal {
        private static final TargetingConditions TEMP_TARGETING = TargetingConditions.m_148353_().m_26883_(10.0).m_148355_();
        private final TargetingConditions targetingConditions;
        protected final PathfinderMob mob;
        private final double speedModifier;
        private double px;
        private double py;
        private double pz;
        private double pRotX;
        private double pRotY;
        @javax.annotation.Nullable
        protected Player player;
        private int calmDown;
        private boolean isRunning;
        private final Ingredient items;
        private final boolean canScare;

        public TemptGoal(PathfinderMob p_25939_, double p_25940_, Ingredient p_25941_, boolean p_25942_) {
            this.mob = p_25939_;
            this.speedModifier = p_25940_;
            this.items = p_25941_;
            this.canScare = p_25942_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.targetingConditions = TEMP_TARGETING.m_148354_().m_26888_(this::shouldFollow);
        }

        public boolean m_8036_() {
            if (CrowEntity.this.getCommandSit() && CrowEntity.this.m_21825_()) {
                return false;
            }
            if (this.calmDown > 0) {
                --this.calmDown;
                return false;
            }
            if (CrowEntity.this.m_21825_()) {
                CrowEntity.this.m_21837_(false);
                CrowEntity.this.m_21839_(false);
            }
            this.player = this.mob.f_19853_.m_45946_(this.targetingConditions, (LivingEntity)this.mob);
            return this.player != null;
        }

        private boolean shouldFollow(LivingEntity p_148139_) {
            return this.items.test(p_148139_.m_21205_()) || this.items.test(p_148139_.m_21206_());
        }

        public boolean m_8045_() {
            if (CrowEntity.this.getCommandSit() || CrowEntity.this.m_21825_()) {
                return false;
            }
            if (this.canScare()) {
                if (this.mob.m_20280_((Entity)this.player) < 36.0) {
                    if (this.player.m_20275_(this.px, this.py, this.pz) > 0.010000000000000002) {
                        return false;
                    }
                    if (Math.abs((double)this.player.m_146909_() - this.pRotX) > 5.0 || Math.abs((double)this.player.m_146908_() - this.pRotY) > 5.0) {
                        return false;
                    }
                } else {
                    this.px = this.player.m_20185_();
                    this.py = this.player.m_20186_();
                    this.pz = this.player.m_20189_();
                }
                this.pRotX = this.player.m_146909_();
                this.pRotY = this.player.m_146908_();
            }
            return this.m_8036_();
        }

        protected boolean canScare() {
            return this.canScare;
        }

        public void m_8056_() {
            this.px = this.player.m_20185_();
            this.py = this.player.m_20186_();
            this.pz = this.player.m_20189_();
            this.isRunning = true;
        }

        public void m_8041_() {
            CrowEntity.this.doingTask = false;
            this.player = null;
            this.mob.m_21573_().m_26573_();
            this.calmDown = TemptGoal.m_186073_((int)100);
            this.isRunning = false;
        }

        public void m_8037_() {
            if (CrowEntity.this.isPlayingDead()) {
                return;
            }
            this.mob.m_21563_().m_24960_((Entity)this.player, (float)(this.mob.m_8085_() + 20), (float)this.mob.m_8132_());
            if (this.mob.m_20280_((Entity)this.player) < 6.25) {
                this.mob.m_21573_().m_26573_();
            } else {
                this.mob.m_21573_().m_5624_((Entity)this.player, this.speedModifier);
            }
        }

        public boolean isRunning() {
            return this.isRunning;
        }
    }

    public class FollowParentGoal
    extends Goal {
        public static final int HORIZONTAL_SCAN_RANGE = 8;
        public static final int VERTICAL_SCAN_RANGE = 4;
        public static final int DONT_FOLLOW_IF_CLOSER_THAN = 3;
        private final Animal animal;
        @javax.annotation.Nullable
        private Animal parent;
        private final double speedModifier;
        private int timeToRecalcPath;

        public FollowParentGoal(Animal p_25319_, double p_25320_) {
            this.animal = p_25319_;
            this.speedModifier = p_25320_;
        }

        public boolean m_8036_() {
            if (this.animal.m_146764_() >= 0) {
                return false;
            }
            if (CrowEntity.this.m_21827_() || CrowEntity.this.m_21825_()) {
                return false;
            }
            List list = this.animal.f_19853_.m_45976_(this.animal.getClass(), this.animal.m_20191_().m_82377_(8.0, 4.0, 8.0));
            Animal animal = null;
            double d0 = Double.MAX_VALUE;
            for (Animal animal1 : list) {
                double d1;
                if (animal1.m_146764_() < 0 || (d1 = this.animal.m_20280_((Entity)animal1)) > d0) continue;
                d0 = d1;
                animal = animal1;
            }
            if (animal == null) {
                return false;
            }
            if (d0 < 9.0) {
                return false;
            }
            this.parent = animal;
            return true;
        }

        public boolean m_8045_() {
            if (this.animal.m_146764_() >= 0) {
                return false;
            }
            if (!this.parent.m_6084_()) {
                return false;
            }
            if (CrowEntity.this.m_21827_() || CrowEntity.this.m_21825_()) {
                return false;
            }
            double d0 = this.animal.m_20280_((Entity)this.parent);
            return !(d0 < 9.0) && !(d0 > 256.0);
        }

        public void m_8056_() {
            this.timeToRecalcPath = 0;
        }

        public void m_8041_() {
            this.parent = null;
        }

        public void m_8037_() {
            if (CrowEntity.this.isPlayingDead()) {
                return;
            }
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.m_183277_(10);
                this.animal.m_21573_().m_5624_((Entity)this.parent, this.speedModifier);
            }
        }
    }

    public class WaterAvoidingRandomFlyingGoal
    extends WaterAvoidingRandomStrollGoal {
        public WaterAvoidingRandomFlyingGoal(PathfinderMob p_25981_, double p_25982_) {
            super(p_25981_, p_25982_);
        }

        @Override
        public boolean m_8036_() {
            if (CrowEntity.this.doingTask) {
                return false;
            }
            if (CrowEntity.this.m_21825_() || CrowEntity.this.m_21827_()) {
                return false;
            }
            if (CrowEntity.this.getCommand() == 3 && (CrowEntity.this.getHelpCommand() != 2 || CrowEntity.this.pickpocketTimer >= 0)) {
                return false;
            }
            return super.m_8036_();
        }

        @Override
        public boolean m_8045_() {
            if (CrowEntity.this.m_21825_() || CrowEntity.this.m_21827_()) {
                return false;
            }
            if (CrowEntity.this.getCommand() == 3 && (CrowEntity.this.getHelpCommand() != 2 || CrowEntity.this.pickpocketTimer >= 0)) {
                return false;
            }
            return super.m_8045_();
        }

        @Override
        @javax.annotation.Nullable
        protected Vec3 m_7037_() {
            Vec3 vec3 = this.f_25725_.m_20252_(0.0f);
            int i = 8;
            Vec3 vec31 = HoverRandomPos.m_148465_((PathfinderMob)this.f_25725_, (int)8, (int)7, (double)vec3.f_82479_, (double)vec3.f_82481_, (float)1.5707964f, (int)3, (int)1);
            return vec31 != null ? vec31 : AirAndWaterRandomPos.m_148357_((PathfinderMob)this.f_25725_, (int)8, (int)4, (int)-2, (double)vec3.f_82479_, (double)vec3.f_82481_, (double)1.5707963705062866);
        }
    }

    public class WaterAvoidingRandomStrollGoal
    extends RandomStrollGoal {
        public static final float PROBABILITY = 0.001f;
        protected final float probability;

        public WaterAvoidingRandomStrollGoal(PathfinderMob p_25987_, double p_25988_) {
            this(p_25987_, p_25988_, 0.001f);
        }

        public WaterAvoidingRandomStrollGoal(PathfinderMob p_25990_, double p_25991_, float p_25992_) {
            super(p_25990_, p_25991_);
            this.probability = p_25992_;
        }

        public boolean m_8036_() {
            if (CrowEntity.this.doingTask) {
                return false;
            }
            if (CrowEntity.this.m_21825_() || CrowEntity.this.m_21827_()) {
                return false;
            }
            if (CrowEntity.this.getCommand() == 3 && (CrowEntity.this.getHelpCommand() != 2 || CrowEntity.this.pickpocketTimer >= 0)) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (CrowEntity.this.m_21825_() || CrowEntity.this.m_21827_()) {
                return false;
            }
            if (CrowEntity.this.getCommand() == 3 && (CrowEntity.this.getHelpCommand() != 2 || CrowEntity.this.pickpocketTimer >= 0)) {
                return false;
            }
            return super.m_8045_();
        }

        @javax.annotation.Nullable
        protected Vec3 m_7037_() {
            if (this.f_25725_.m_20072_()) {
                Vec3 vec3 = LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)15, (int)7);
                return vec3 == null ? super.m_7037_() : vec3;
            }
            return this.f_25725_.m_217043_().m_188501_() >= this.probability ? LandRandomPos.m_148488_((PathfinderMob)this.f_25725_, (int)10, (int)7) : super.m_7037_();
        }
    }

    public class LandOnOwnersShoulderGoal
    extends Goal {
        private final CrowEntity entity;
        private ServerPlayer owner;
        private boolean isSittingOnShoulder;

        public LandOnOwnersShoulderGoal(CrowEntity p_25483_) {
            this.entity = p_25483_;
        }

        public boolean m_8045_() {
            if (CrowEntity.this.getCommand() == 0 && CrowEntity.this.m_21825_()) {
                CrowEntity.this.m_21837_(false);
                CrowEntity.this.m_21839_(false);
            }
            return super.m_8045_();
        }

        public boolean m_8036_() {
            if (CrowEntity.this.m_6162_()) {
                return false;
            }
            ServerPlayer serverplayer = (ServerPlayer)this.entity.m_21826_();
            boolean flag = serverplayer != null && !serverplayer.m_5833_() && !serverplayer.m_150110_().f_35935_ && !serverplayer.m_20069_() && !serverplayer.f_146808_;
            return !this.entity.m_21827_() && !this.entity.m_21825_() && flag && this.entity.getCommand() == 0 && this.entity.canSitOnShoulder() && serverplayer.m_20197_().size() < 2;
        }

        public boolean m_6767_() {
            return !this.isSittingOnShoulder;
        }

        public void m_8056_() {
            this.owner = (ServerPlayer)this.entity.m_21826_();
            this.isSittingOnShoulder = false;
        }

        public void m_8037_() {
            if (CrowEntity.this.isPlayingDead()) {
                return;
            }
            if (!this.isSittingOnShoulder && !this.entity.m_21825_() && !this.entity.m_21523_() && this.entity.m_20191_().m_82381_(this.owner.m_20191_())) {
                this.isSittingOnShoulder = this.entity.m_7998_((Entity)this.owner, true);
                if (!CrowEntity.this.f_19853_.f_46443_) {
                    HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> CrowEntity.this.f_19853_.m_46745_(CrowEntity.this.m_20183_())), (Object)new CrowStartRidingPacket((Entity)this.entity, (Player)this.owner));
                }
            }
            if (this.isSittingOnShoulder) {
                this.entity.rideCooldownCounter = 0;
            }
        }
    }

    public class CrowGatherItems<T extends ItemEntity>
    extends TargetGoal {
        protected final Sorter theNearestAttackableTargetSorter;
        protected final Predicate<? super ItemEntity> targetEntitySelector;
        protected int executionChance;
        protected boolean mustUpdate;
        protected ItemEntity targetEntity;
        protected ITargetsDroppedItems hunter;
        private int tickThreshold;
        private int walkCooldown;
        protected int tryTicks;

        public CrowGatherItems(PathfinderMob creature, boolean checkSight, boolean onlyNearby, int tickThreshold, int radius) {
            this(creature, 1, checkSight, onlyNearby, null, tickThreshold);
        }

        public CrowGatherItems(PathfinderMob creature, int chance, boolean checkSight, @javax.annotation.Nullable boolean onlyNearby, Predicate<? super T> targetSelector, int ticksExisted) {
            super((Mob)creature, checkSight, onlyNearby);
            this.walkCooldown = 0;
            this.tryTicks = 0;
            this.executionChance = chance;
            this.tickThreshold = ticksExisted;
            this.hunter = (ITargetsDroppedItems)creature;
            this.theNearestAttackableTargetSorter = new Sorter((Entity)creature);
            this.targetEntitySelector = item -> {
                ItemStack stack = item.m_32055_();
                return !stack.m_41619_() && this.hunter.canTargetItem(stack) && item.f_19797_ > this.tickThreshold;
            };
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            List list;
            if (CrowEntity.this.doingTask) {
                return false;
            }
            if (CrowEntity.this.m_21824_() && CrowEntity.this.isMaxHealth() && (CrowEntity.this.getCommand() != 3 || CrowEntity.this.getHelpCommand() != 0)) {
                return false;
            }
            if (!CrowEntity.this.m_21824_() && CrowEntity.this.isMaxHealth()) {
                return false;
            }
            if (CrowEntity.this.m_20159_() || CrowEntity.this.m_20160_() && CrowEntity.this.m_6688_() != null) {
                return false;
            }
            if (!CrowEntity.this.itemHandler.getStackInSlot(1).m_41619_()) {
                return false;
            }
            if (!this.mustUpdate) {
                long worldTime = CrowEntity.this.f_19853_.m_46467_() % 10L;
                if (this.f_26135_.m_21216_() >= 100 && worldTime != 0L) {
                    return false;
                }
                if (this.f_26135_.m_217043_().m_188503_(this.executionChance) != 0 && worldTime != 0L) {
                    return false;
                }
            }
            if ((list = this.f_26135_.f_19853_.m_6443_(ItemEntity.class, this.getTargetableArea(CrowEntity.this.interactionRange + 1), this.targetEntitySelector)).isEmpty()) {
                return false;
            }
            if (CrowEntity.this.m_21825_()) {
                CrowEntity.this.m_21837_(false);
                CrowEntity.this.m_21839_(false);
            }
            list.sort(this.theNearestAttackableTargetSorter);
            this.targetEntity = (ItemEntity)list.get(0);
            this.mustUpdate = false;
            if (this.targetEntity == null) {
                return false;
            }
            this.hunter.onFindTarget(this.targetEntity);
            return !((CrowEntity)this.f_26135_).m_21825_() && (this.f_26135_.m_5448_() == null || !this.f_26135_.m_5448_().m_6084_());
        }

        public boolean shouldRecalculatePath() {
            return this.tryTicks % 10 == 0;
        }

        protected double m_7623_() {
            return 16.0;
        }

        protected AABB getTargetableArea(double targetDistance) {
            Vec3 renderCenter = new Vec3(this.f_26135_.m_20185_() + 0.5, this.f_26135_.m_20186_() + 0.5, this.f_26135_.m_20189_() + 0.5);
            AABB aabb = new AABB(-targetDistance, -targetDistance, -targetDistance, targetDistance, targetDistance, targetDistance);
            return aabb.m_82383_(renderCenter);
        }

        public void m_8056_() {
            CrowEntity.this.doingTask = true;
            CrowEntity.this.lastStuckCheckPos = CrowEntity.this.m_20182_();
            this.moveTo();
            super.m_8056_();
        }

        protected void moveTo() {
            if (this.walkCooldown > 0) {
                --this.walkCooldown;
            } else {
                this.f_26135_.m_21573_().m_26536_(CrowEntity.this.m_21573_().m_26524_(this.targetEntity.m_20185_() + 0.5, this.targetEntity.m_20186_() + 0.25, this.targetEntity.m_20189_() + 0.5, 0), 1.0);
                this.walkCooldown = 30 + this.f_26135_.m_217043_().m_188503_(40);
            }
        }

        public void m_8041_() {
            CrowEntity.this.doingTask = false;
            super.m_8041_();
            this.f_26135_.m_21573_().m_26573_();
            this.targetEntity = null;
            ((CrowEntity)this.f_26135_).aiItemFlag = false;
        }

        public void m_8037_() {
            if (CrowEntity.this.isPlayingDead()) {
                return;
            }
            super.m_8037_();
            boolean isStuck = false;
            if (CrowEntity.this.stuckTimer++ > 80) {
                if (CrowEntity.this.m_20238_(CrowEntity.this.lastStuckCheckPos) < 2.25) {
                    isStuck = true;
                }
                CrowEntity.this.lastStuckCheckPos = CrowEntity.this.m_20182_();
            }
            if (isStuck) {
                Vec3 randomPos = DefaultRandomPos.m_148403_((PathfinderMob)CrowEntity.this, (int)10, (int)7);
                if (randomPos == null) {
                    randomPos = LandRandomPos.m_148488_((PathfinderMob)CrowEntity.this, (int)10, (int)7);
                }
                BlockPos pos = randomPos != null ? new BlockPos(randomPos.f_82479_, randomPos.f_82480_, randomPos.f_82481_) : (CrowEntity.this.getPerchPos() != null ? CrowEntity.this.getPerchPos().m_7494_().m_7494_() : CrowEntity.this.m_20183_().m_7494_().m_7494_());
                CrowEntity.this.f_21344_.m_26573_();
                if (CrowEntity.this.m_20238_(CrowEntity.this.lastStuckCheckPos) < 0.1 && CrowEntity.this.m_20096_()) {
                    CrowEntity.this.m_5997_(Math.min((double)0.2f, ((double)pos.m_123341_() - CrowEntity.this.m_20182_().f_82479_) / 20.0), 0.15f, Math.min((double)0.2f, ((double)pos.m_123343_() - CrowEntity.this.m_20182_().f_82481_) / 20.0));
                    CrowEntity.this.f_21344_.m_26536_(CrowEntity.this.m_21573_().m_7864_(pos, 0), 1.5);
                } else {
                    CrowEntity.this.f_21344_.m_26536_(CrowEntity.this.m_21573_().m_7864_(CrowEntity.this.m_20183_().m_7494_().m_7494_(), 0), 1.5);
                }
                CrowEntity.this.stuckTimer = 0;
            }
            if (this.targetEntity == null || this.targetEntity != null && !this.targetEntity.m_6084_()) {
                this.m_8041_();
                this.f_26135_.m_21573_().m_26573_();
            } else {
                this.moveTo();
            }
            if (this.targetEntity != null && this.f_26135_.m_142582_((Entity)this.targetEntity) && (double)this.f_26135_.m_20205_() > this.hunter.getMaxDistToItem() && this.f_26135_.m_20096_()) {
                this.f_26135_.m_21566_().m_6849_(this.targetEntity.m_20185_(), this.targetEntity.m_20186_() + 0.5, this.targetEntity.m_20189_(), 1.5);
            }
            if (this.targetEntity != null && this.targetEntity.m_6084_() && this.f_26135_.m_20280_((Entity)this.targetEntity) < this.hunter.getMaxDistToItem() && CrowEntity.this.itemHandler.getStackInSlot(1).m_41619_()) {
                if (!((CrowEntity)this.hunter).peck) {
                    this.hunter.peck();
                    HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> ((CrowEntity)this.hunter).f_19853_.m_46745_(((CrowEntity)this.hunter).m_20183_())), (Object)new CrowPeckPacket((Entity)this.f_26135_));
                }
                if (((CrowEntity)this.hunter).peckTiltAngleActual > 40.0f) {
                    this.hunter.onGetItem(this.targetEntity);
                    CrowEntity.this.depositItemBeforePerch = true;
                    this.targetEntity.m_32055_().m_41774_(1);
                    this.m_8041_();
                }
            }
            CrowEntity crow = (CrowEntity)this.f_26135_;
            if (this.targetEntity != null) {
                crow.aiItemFlag = true;
                if ((double)this.f_26135_.m_20270_((Entity)this.targetEntity) <= CrowEntity.this.getMaxDistToItem()) {
                    crow.m_21566_().m_6849_(this.targetEntity.m_20185_(), this.targetEntity.m_20186_() + 0.5, this.targetEntity.m_20189_(), 1.5);
                }
                if (!crow.m_21825_()) {
                    this.f_26135_.m_21573_().m_26536_(CrowEntity.this.m_21573_().m_26524_(this.targetEntity.m_20185_(), this.targetEntity.m_20186_() + 0.5, this.targetEntity.m_20189_(), 0), 1.5);
                }
                ++this.tryTicks;
                if (this.shouldRecalculatePath()) {
                    if (this.targetEntity.m_20182_().m_82554_(CrowEntity.this.m_20182_()) < 3.0 && CrowEntity.this.m_20182_().f_82480_ < this.targetEntity.m_20182_().m_7098_()) {
                        CrowEntity.this.m_20242_(false);
                        CrowEntity.this.m_5997_((this.targetEntity.m_20182_().f_82479_ - CrowEntity.this.m_20182_().f_82479_) / 50.0, (this.targetEntity.m_20182_().f_82480_ - CrowEntity.this.m_20182_().f_82480_) / 50.0 + (double)0.1f, (this.targetEntity.m_20182_().f_82481_ - CrowEntity.this.m_20182_().f_82481_) / 50.0);
                    }
                    this.f_26135_.m_21573_().m_26536_(CrowEntity.this.m_21573_().m_26524_(this.targetEntity.m_20185_(), this.targetEntity.m_20186_() + 3.0, this.targetEntity.m_20189_(), 0), 1.5);
                }
            }
        }

        public void makeUpdate() {
            this.mustUpdate = true;
        }

        public boolean m_8045_() {
            boolean path;
            if (CrowEntity.this.m_21223_() >= CrowEntity.this.m_21233_() && CrowEntity.this.m_21824_() && (((CrowEntity)this.f_26135_).getCommand() != 3 || ((CrowEntity)this.f_26135_).getHelpCommand() != 0)) {
                return false;
            }
            boolean bl = path = (double)this.f_26135_.m_20205_() > 2.0 || !this.f_26135_.m_21573_().m_26571_();
            if (CrowEntity.this.m_21825_()) {
                CrowEntity.this.m_21837_(false);
                CrowEntity.this.m_21839_(false);
            }
            return path && this.targetEntity != null && this.targetEntity.m_6084_() && !((CrowEntity)this.f_26135_).m_21825_() && (this.f_26135_.m_5448_() == null || !this.f_26135_.m_5448_().m_6084_());
        }

        public static class Sorter
        implements Comparator<Entity> {
            private final Entity theEntity;

            public Sorter(Entity theEntityIn) {
                this.theEntity = theEntityIn;
            }

            @Override
            public int compare(Entity p_compare_1_, Entity p_compare_2_) {
                double d0 = this.theEntity.m_20280_(p_compare_1_);
                double d1 = this.theEntity.m_20280_(p_compare_2_);
                return Double.compare(d0, d1);
            }
        }
    }

    private class CrowDepositCoffer
    extends Goal {
        private final CrowEntity entity;
        protected final Sorter theNearestAttackableTargetSorter;
        protected int executionChance = 8;
        protected boolean mustUpdate;
        private BlockEntity targetEntity;
        private BlockPos flightTarget = null;
        private int cooldown = 0;
        private int tryTicks = 0;
        private Tag tag;

        CrowDepositCoffer(CrowEntity entity) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.theNearestAttackableTargetSorter = new Sorter((Entity)CrowEntity.this);
        }

        public boolean m_8036_() {
            if (CrowEntity.this.doingTask) {
                return false;
            }
            if (CrowEntity.this.m_20159_() || CrowEntity.this.aiItemFlag || CrowEntity.this.m_20160_() || CrowEntity.this.m_21825_() || !CrowEntity.this.m_21824_()) {
                return false;
            }
            if (CrowEntity.this.itemHandler.getStackInSlot(1).m_41619_()) {
                return false;
            }
            if (!this.mustUpdate) {
                long worldTime = CrowEntity.this.f_19853_.m_46467_() % 10L;
                if (CrowEntity.this.m_21216_() >= 100 && worldTime != 0L) {
                    return false;
                }
                if (CrowEntity.this.m_217043_().m_188503_(this.executionChance) != 0 && worldTime != 0L) {
                    return false;
                }
            }
            if (this.entity.cofferHerbJarList == null || this.entity.cofferHerbJarList.isEmpty()) {
                return false;
            }
            if (CrowEntity.this.getHelpCommand() == 0 && CrowEntity.this.getCommand() == 3) {
                if (CrowEntity.this.m_21825_()) {
                    CrowEntity.this.m_21837_(false);
                    CrowEntity.this.m_21839_(false);
                }
            } else {
                return false;
            }
            this.entity.cofferHerbJarList.sort(this.theNearestAttackableTargetSorter);
            boolean flag = false;
            for (BlockPos pos : this.entity.cofferHerbJarList) {
                this.targetEntity = CrowEntity.this.f_19853_.m_7702_(pos);
                if (this.targetEntity == null) break;
                BlockPos perchPos = CrowEntity.this.getPerchPos();
                if (this.targetEntity.m_58899_().equals((Object)perchPos)) {
                    BlockEntity blockEntity = this.targetEntity;
                    if (blockEntity instanceof CofferTile) {
                        CofferTile cofferTile = (CofferTile)blockEntity;
                        if (cofferTile.m_7983_() || cofferTile.hasNonMaxStackItemStack(CrowEntity.this.itemHandler.getStackInSlot(1)) || cofferTile.hasItem(Items.f_41852_)) {
                            flag = true;
                            break;
                        }
                    } else {
                        blockEntity = this.targetEntity;
                        if (blockEntity instanceof HerbJarTile) {
                            HerbJarTile herbJarTile = (HerbJarTile)blockEntity;
                            if (herbJarTile.itemHandler.getStackInSlot(0).m_41619_() || herbJarTile.itemHandler.getStackInSlot(0).m_41783_() == CrowEntity.this.itemHandler.getStackInSlot(1).m_41783_() && herbJarTile.itemHandler.getStackInSlot(0).m_41656_(CrowEntity.this.itemHandler.getStackInSlot(1))) {
                                flag = true;
                                break;
                            }
                        }
                    }
                }
                if (this.targetEntity instanceof CofferTile) {
                    if (!((CofferTile)this.targetEntity).hasItem(CrowEntity.this.itemHandler.getStackInSlot(1).m_41720_())) continue;
                    flag = true;
                    break;
                }
                if (!(this.targetEntity instanceof HerbJarTile) || ((HerbJarTile)this.targetEntity).itemHandler.getStackInSlot(0).m_41720_() != CrowEntity.this.itemHandler.getStackInSlot(1).m_41720_()) continue;
                flag = true;
                break;
            }
            if (!flag) {
                return false;
            }
            this.mustUpdate = false;
            CrowEntity.this.aiCofferTileFlag = true;
            return true;
        }

        public boolean m_8045_() {
            if (CrowEntity.this.getHelpCommand() == 0 && CrowEntity.this.getCommand() == 3 && CrowEntity.this.m_21825_()) {
                CrowEntity.this.m_21837_(false);
                CrowEntity.this.m_21839_(false);
            }
            return this.targetEntity != null && !CrowEntity.this.itemHandler.getStackInSlot(1).m_41619_() && CrowEntity.this.getCommand() == 3 && CrowEntity.this.getHelpCommand() == 0;
        }

        public void m_8056_() {
            CrowEntity.this.doingTask = true;
            CrowEntity.this.lastStuckCheckPos = CrowEntity.this.m_20182_();
        }

        public void m_8041_() {
            CrowEntity.this.doingTask = false;
            this.flightTarget = null;
            this.targetEntity = null;
            CrowEntity.this.aiCofferTileFlag = false;
            CrowEntity.this.depositItemBeforePerch = false;
        }

        public boolean shouldRecalculatePath() {
            return this.tryTicks % 20 == 0;
        }

        public void m_8037_() {
            if (CrowEntity.this.isPlayingDead()) {
                return;
            }
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            boolean isStuck = false;
            if (CrowEntity.this.stuckTimer++ > 80) {
                if (CrowEntity.this.m_20238_(CrowEntity.this.lastStuckCheckPos) < 2.25) {
                    isStuck = true;
                }
                CrowEntity.this.lastStuckCheckPos = CrowEntity.this.m_20182_();
            }
            if (isStuck) {
                Vec3 randomPos = DefaultRandomPos.m_148403_((PathfinderMob)CrowEntity.this, (int)10, (int)7);
                if (randomPos == null) {
                    randomPos = LandRandomPos.m_148488_((PathfinderMob)CrowEntity.this, (int)10, (int)7);
                }
                BlockPos pos = randomPos != null ? new BlockPos(randomPos.f_82479_, randomPos.f_82480_, randomPos.f_82481_) : (CrowEntity.this.getPerchPos() != null ? CrowEntity.this.getPerchPos().m_7494_().m_7494_() : CrowEntity.this.m_20183_().m_7494_().m_7494_());
                CrowEntity.this.f_21344_.m_26573_();
                if (CrowEntity.this.m_20238_(CrowEntity.this.lastStuckCheckPos) < 0.1 && CrowEntity.this.m_20096_()) {
                    CrowEntity.this.m_5997_(Math.min((double)0.2f, ((double)pos.m_123341_() - CrowEntity.this.m_20182_().f_82479_) / 20.0), 0.15f, Math.min((double)0.2f, ((double)pos.m_123343_() - CrowEntity.this.m_20182_().f_82481_) / 20.0));
                    CrowEntity.this.f_21344_.m_26536_(CrowEntity.this.m_21573_().m_7864_(pos, 0), 1.5);
                } else {
                    CrowEntity.this.f_21344_.m_26536_(CrowEntity.this.m_21573_().m_7864_(CrowEntity.this.m_20183_().m_7494_().m_7494_(), 0), 1.5);
                }
                CrowEntity.this.stuckTimer = 0;
            }
            ++this.tryTicks;
            if (this.shouldRecalculatePath()) {
                this.entity.m_21573_().m_26536_(this.entity.m_21573_().m_26524_((double)this.targetEntity.m_58899_().m_123341_() + 0.5, (double)((float)this.targetEntity.m_58899_().m_123342_() + 0.5f), (double)this.targetEntity.m_58899_().m_123343_() + 0.5, 0), 1.5);
                if (this.targetEntity.m_58899_().m_123314_(new Vec3i(CrowEntity.this.m_20182_().f_82479_, CrowEntity.this.m_20182_().f_82480_, CrowEntity.this.m_20182_().f_82481_), 3.0) && CrowEntity.this.m_20182_().f_82480_ < (double)this.targetEntity.m_58899_().m_123342_()) {
                    CrowEntity.this.m_20242_(false);
                    CrowEntity.this.m_5997_(((double)this.targetEntity.m_58899_().m_123341_() - CrowEntity.this.m_20182_().f_82479_) / 50.0, ((double)this.targetEntity.m_58899_().m_123342_() - CrowEntity.this.m_20182_().f_82480_) / 50.0 + (double)0.1f, ((double)this.targetEntity.m_58899_().m_123343_() - CrowEntity.this.m_20182_().f_82481_) / 50.0);
                }
            }
            if (this.flightTarget != null) {
                if (CrowEntity.this.f_19862_) {
                    CrowEntity.this.m_21566_().m_6849_((double)((float)this.flightTarget.m_123341_() + 0.5f), CrowEntity.this.m_20186_() + 1.0, (double)((float)this.flightTarget.m_123343_() + 0.5f), 1.5);
                } else {
                    CrowEntity.this.m_21573_().m_26536_(this.entity.m_21573_().m_26524_((double)((float)this.flightTarget.m_123341_() + 0.5f), (double)((float)this.flightTarget.m_123342_() + 1.0f), (double)((float)this.flightTarget.m_123343_() + 0.5f), 0), 1.5);
                }
            }
            if (this.targetEntity != null) {
                this.flightTarget = this.targetEntity.m_58899_();
                if (CrowEntity.this.m_20275_((float)this.targetEntity.m_58899_().m_123341_() + 0.5f, this.targetEntity.m_58899_().m_123342_(), (float)this.targetEntity.m_58899_().m_123343_() + 0.5f) < this.entity.getMaxDistToItem() * 1.25) {
                    try {
                        BlockEntity entity = this.targetEntity;
                        LazyOptional handler = entity.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN);
                        if (handler.orElse(null) != null && this.cooldown == 0) {
                            ItemStack duplicate = CrowEntity.this.itemHandler.getStackInSlot(1).m_41777_();
                            ItemStack insertSimulate = ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)handler.orElse(null)), (ItemStack)duplicate, (boolean)true);
                            if (!insertSimulate.equals(duplicate)) {
                                ItemStack shrunkenStack = ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)handler.orElse(null)), (ItemStack)duplicate, (boolean)false);
                                if (shrunkenStack.m_41619_()) {
                                    CrowEntity.this.itemHandler.setStackInSlot(1, ItemStack.f_41583_);
                                } else {
                                    CrowEntity.this.itemHandler.setStackInSlot(1, shrunkenStack);
                                }
                                CrowEntity.this.peck();
                                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> CrowEntity.this.f_19853_.m_46745_(CrowEntity.this.m_20183_())), (Object)new CrowPeckPacket((Entity)CrowEntity.this));
                            } else {
                                this.cooldown = 20;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.m_8041_();
                }
            }
        }

        protected double getTargetDistance() {
            return 4.0;
        }

        protected AABB getTargetableArea(double targetDistance) {
            Vec3 renderCenter = new Vec3(CrowEntity.this.m_20185_(), CrowEntity.this.m_20186_(), CrowEntity.this.m_20189_());
            AABB aabb = new AABB(-16.0, -16.0, -16.0, 16.0, 16.0, 16.0);
            return aabb.m_82383_(renderCenter);
        }

        public class Sorter
        implements Comparator<BlockPos> {
            private final Entity theEntity;

            public Sorter(Entity theEntityIn) {
                this.theEntity = theEntityIn;
            }

            @Override
            public int compare(BlockPos p_compare_1_, BlockPos p_compare_2_) {
                double d0 = this.theEntity.m_20238_(Vec3.m_82512_((Vec3i)p_compare_1_));
                double d1 = this.theEntity.m_20238_(Vec3.m_82512_((Vec3i)p_compare_2_));
                return Double.compare(d0, d1);
            }
        }
    }

    public class CrowHarvestGoal
    extends MoveToBlockGoal {
        private static final int WAIT_TICKS = 40;
        protected int ticksWaited;
        protected int f_25601_;

        public CrowHarvestGoal(double p_28675_, int p_28676_, int p_28677_) {
            super((PathfinderMob)CrowEntity.this, p_28675_, p_28676_, p_28677_);
            this.f_25601_ = 0;
            this.f_25606_ = CrowEntity.this.interactionRange + 1;
        }

        protected int m_6099_(PathfinderMob p_25618_) {
            return CrowHarvestGoal.m_186073_((int)(20 + p_25618_.m_217043_().m_188503_(20)));
        }

        public double m_8052_() {
            return 2.0;
        }

        public boolean m_8064_() {
            return this.f_25601_ % 100 == 0;
        }

        protected boolean m_6465_(LevelReader p_28680_, BlockPos pos) {
            double dist;
            if (CrowEntity.this.getPerchPos() != null && (dist = pos.m_203198_((double)CrowEntity.this.getPerchPos().m_123341_(), (double)CrowEntity.this.getPerchPos().m_123342_(), (double)CrowEntity.this.getPerchPos().m_123343_())) > (double)(CrowEntity.this.interactionRange * CrowEntity.this.interactionRange)) {
                return false;
            }
            BlockState blockstate = p_28680_.m_8055_(pos);
            if (CrowEntity.this.harvestWhitelist.isEmpty() || CrowEntity.this.harvestWhitelist.contains(blockstate.m_60734_())) {
                if (blockstate.m_204336_(HexereiTags.Blocks.CROW_HARVESTABLE)) {
                    if (blockstate.m_60734_() instanceof StemBlock) {
                        return false;
                    }
                    if (blockstate.m_61138_((Property)BlockStateProperties.f_61405_)) {
                        return (Integer)blockstate.m_61143_((Property)BlockStateProperties.f_61405_) >= 1;
                    }
                    if (blockstate.m_61138_((Property)BlockStateProperties.f_61406_)) {
                        return (Integer)blockstate.m_61143_((Property)BlockStateProperties.f_61406_) >= 2;
                    }
                    if (blockstate.m_61138_((Property)BlockStateProperties.f_61407_)) {
                        return (Integer)blockstate.m_61143_((Property)BlockStateProperties.f_61407_) >= 3;
                    }
                    if (blockstate.m_61138_((Property)BlockStateProperties.f_222999_)) {
                        return (Integer)blockstate.m_61143_((Property)BlockStateProperties.f_222999_) >= 4;
                    }
                    if (blockstate.m_61138_((Property)BlockStateProperties.f_61408_)) {
                        return (Integer)blockstate.m_61143_((Property)BlockStateProperties.f_61408_) >= 5;
                    }
                    if (blockstate.m_61138_((Property)BlockStateProperties.f_61409_)) {
                        return (Integer)blockstate.m_61143_((Property)BlockStateProperties.f_61409_) >= 7;
                    }
                    return CaveVines.m_152951_((BlockState)blockstate);
                }
                if (blockstate.m_204336_(HexereiTags.Blocks.CROW_BLOCK_HARVESTABLE)) {
                    if (blockstate.m_60734_() instanceof StemGrownBlock) {
                        AttachedStemBlock stemBlock;
                        Block block = CrowEntity.this.f_19853_.m_8055_(pos.m_122012_()).m_60734_();
                        if (block instanceof AttachedStemBlock) {
                            stemBlock = (AttachedStemBlock)block;
                            if (stemBlock.f_48831_ == CrowEntity.this.f_19853_.m_8055_(pos).m_60734_()) {
                                return true;
                            }
                        }
                        if ((block = CrowEntity.this.f_19853_.m_8055_(pos.m_122019_()).m_60734_()) instanceof AttachedStemBlock) {
                            stemBlock = (AttachedStemBlock)block;
                            if (stemBlock.f_48831_ == CrowEntity.this.f_19853_.m_8055_(pos).m_60734_()) {
                                return true;
                            }
                        }
                        if ((block = CrowEntity.this.f_19853_.m_8055_(pos.m_122029_()).m_60734_()) instanceof AttachedStemBlock) {
                            stemBlock = (AttachedStemBlock)block;
                            if (stemBlock.f_48831_ == CrowEntity.this.f_19853_.m_8055_(pos).m_60734_()) {
                                return true;
                            }
                        }
                        if ((block = CrowEntity.this.f_19853_.m_8055_(pos.m_122024_()).m_60734_()) instanceof AttachedStemBlock) {
                            stemBlock = (AttachedStemBlock)block;
                            if (stemBlock.f_48831_ == CrowEntity.this.f_19853_.m_8055_(pos).m_60734_()) {
                                return true;
                            }
                        }
                        return false;
                    }
                    if (ForgeRegistries.BLOCKS.getKey((Object)blockstate.m_60734_()).toString().equals("immersiveengineering:hemp")) {
                        return CrowEntity.this.f_19853_.m_8055_(pos.m_7495_()).m_60713_(blockstate.m_60734_());
                    }
                    if (blockstate.m_60734_() instanceof SugarCaneBlock) {
                        return CrowEntity.this.f_19853_.m_8055_(pos.m_7495_()).m_60713_(blockstate.m_60734_()) && !CrowEntity.this.f_19853_.m_8055_(pos.m_7495_().m_7495_()).m_60713_(blockstate.m_60734_());
                    }
                    return true;
                }
            }
            return false;
        }

        public void m_8037_() {
            if (CrowEntity.this.isPlayingDead()) {
                return;
            }
            BlockPos blockpos = this.m_6669_();
            if (this.m_25625_()) {
                if (this.ticksWaited >= 10) {
                    this.onReachedTarget();
                } else {
                    ++this.ticksWaited;
                }
            }
            ++this.f_25601_;
            if (this.m_8064_()) {
                if (blockpos.m_123314_(new Vec3i(CrowEntity.this.m_20182_().f_82479_, CrowEntity.this.m_20182_().f_82480_, CrowEntity.this.m_20182_().f_82481_), 3.0) && CrowEntity.this.m_20182_().f_82480_ < (double)blockpos.m_123342_()) {
                    CrowEntity.this.m_20242_(false);
                    if (CrowEntity.this.m_20096_()) {
                        CrowEntity.this.m_5997_(((double)blockpos.m_123341_() - CrowEntity.this.m_20182_().f_82479_) / 50.0, ((double)blockpos.m_123342_() - CrowEntity.this.m_20182_().f_82480_) / 50.0 + 0.25, ((double)blockpos.m_123343_() - CrowEntity.this.m_20182_().f_82481_) / 50.0);
                    } else {
                        CrowEntity.this.m_5997_(((double)blockpos.m_123341_() - CrowEntity.this.m_20182_().f_82479_) / 50.0, ((double)blockpos.m_123342_() - CrowEntity.this.m_20182_().f_82480_) / 50.0 + (double)0.1f, ((double)blockpos.m_123343_() - CrowEntity.this.m_20182_().f_82481_) / 50.0);
                    }
                }
                this.f_25598_.m_21573_().m_26536_(CrowEntity.this.m_21573_().m_26524_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 1.0, (double)blockpos.m_123343_() + 0.5, 0), this.f_25599_);
            }
            super.m_8037_();
        }

        protected void onReachedTarget() {
            if (ForgeEventFactory.getMobGriefingEvent((Level)CrowEntity.this.f_19853_, (Entity)CrowEntity.this)) {
                BlockState blockstate = CrowEntity.this.f_19853_.m_8055_(this.f_25602_);
                if (blockstate.m_204336_(HexereiTags.Blocks.CROW_HARVESTABLE)) {
                    if (blockstate.m_60713_(Blocks.f_50685_)) {
                        this.pickSweetBerries(blockstate);
                        CrowEntity.this.peck();
                        HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> CrowEntity.this.f_19853_.m_46745_(CrowEntity.this.m_20183_())), (Object)new CrowPeckPacket((Entity)CrowEntity.this));
                    } else if (CaveVines.m_152951_((BlockState)blockstate)) {
                        this.pickGlowBerry(blockstate);
                        CrowEntity.this.peck();
                        HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> CrowEntity.this.f_19853_.m_46745_(CrowEntity.this.m_20183_())), (Object)new CrowPeckPacket((Entity)CrowEntity.this));
                    } else if (blockstate.m_60734_() instanceof PickableDoubleFlower && !CrowEntity.this.f_19853_.f_46443_) {
                        ItemStack firstOutput = new ItemStack((ItemLike)((PickableDoubleFlower)blockstate.m_60734_()).firstOutput.get(), 4);
                        ItemStack secondOutput = ItemStack.f_41583_;
                        if (((PickableDoubleFlower)blockstate.m_60734_()).secondOutput != null) {
                            secondOutput = new ItemStack((ItemLike)((PickableDoubleFlower)blockstate.m_60734_()).secondOutput.get(), ((PickableDoubleFlower)blockstate.m_60734_()).maxSecondOutput);
                        }
                        int j = Math.max(1, CrowEntity.this.f_19796_.m_188503_(firstOutput.m_41613_()));
                        int k = 0;
                        if (((PickableDoubleFlower)blockstate.m_60734_()).secondOutput != null) {
                            k = Math.max(1, CrowEntity.this.f_19796_.m_188503_(secondOutput.m_41613_()));
                        }
                        Block.m_49840_((Level)CrowEntity.this.f_19853_, (BlockPos)this.f_25602_, (ItemStack)new ItemStack((ItemLike)firstOutput.m_41720_(), Math.max(1, (int)Math.floor(j))));
                        if (CrowEntity.this.f_19796_.m_188503_(2) == 0 && ((PickableDoubleFlower)blockstate.m_60734_()).secondOutput != null) {
                            Block.m_49840_((Level)CrowEntity.this.f_19853_, (BlockPos)this.f_25602_, (ItemStack)new ItemStack((ItemLike)secondOutput.m_41720_(), Math.max(1, (int)Math.floor(k))));
                        }
                        if (blockstate.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.LOWER) {
                            CrowEntity.this.f_19853_.m_7731_(this.f_25602_, (BlockState)CrowEntity.this.f_19853_.m_8055_(this.f_25602_).m_61124_((Property)BlockStateProperties.f_61407_, (Comparable)Integer.valueOf(0)), 2);
                            CrowEntity.this.f_19853_.m_7731_(this.f_25602_.m_7494_(), (BlockState)CrowEntity.this.f_19853_.m_8055_(this.f_25602_.m_7494_()).m_61124_((Property)BlockStateProperties.f_61407_, (Comparable)Integer.valueOf(0)), 2);
                        }
                        if (blockstate.m_61143_((Property)BlockStateProperties.f_61401_) == DoubleBlockHalf.UPPER) {
                            CrowEntity.this.f_19853_.m_7731_(this.f_25602_.m_7495_(), (BlockState)CrowEntity.this.f_19853_.m_8055_(this.f_25602_.m_7495_()).m_61124_((Property)BlockStateProperties.f_61407_, (Comparable)Integer.valueOf(0)), 2);
                            CrowEntity.this.f_19853_.m_7731_(this.f_25602_, (BlockState)CrowEntity.this.f_19853_.m_8055_(this.f_25602_).m_61124_((Property)BlockStateProperties.f_61407_, (Comparable)Integer.valueOf(0)), 2);
                        }
                        CrowEntity.this.peck();
                        CrowEntity.this.m_5496_(SoundEvents.f_144088_, 1.0f, 1.0f);
                        HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> CrowEntity.this.f_19853_.m_46745_(CrowEntity.this.m_20183_())), (Object)new CrowPeckPacket((Entity)CrowEntity.this));
                    } else if (blockstate.m_60734_() instanceof PickableFlower && !CrowEntity.this.f_19853_.f_46443_) {
                        ItemStack firstOutput = new ItemStack((ItemLike)((PickableFlower)blockstate.m_60734_()).firstOutput.get(), 4);
                        ItemStack secondOutput = ItemStack.f_41583_;
                        if (((PickableFlower)blockstate.m_60734_()).secondOutput != null) {
                            secondOutput = new ItemStack((ItemLike)((PickableFlower)blockstate.m_60734_()).secondOutput.get(), ((PickableFlower)blockstate.m_60734_()).maxSecondOutput);
                        }
                        int j = Math.max(1, CrowEntity.this.f_19796_.m_188503_(firstOutput.m_41613_()));
                        int k = 0;
                        if (((PickableFlower)blockstate.m_60734_()).secondOutput != null) {
                            k = Math.max(1, CrowEntity.this.f_19796_.m_188503_(secondOutput.m_41613_()));
                        }
                        PickableFlower cfr_ignored_0 = (PickableFlower)blockstate.m_60734_();
                        PickableFlower.m_49840_((Level)CrowEntity.this.f_19853_, (BlockPos)this.f_25602_, (ItemStack)new ItemStack((ItemLike)firstOutput.m_41720_(), Math.max(1, (int)Math.floor(j))));
                        if (CrowEntity.this.f_19796_.m_188503_(2) == 0 && ((PickableFlower)blockstate.m_60734_()).secondOutput != null) {
                            PickableFlower cfr_ignored_1 = (PickableFlower)blockstate.m_60734_();
                            PickableFlower.m_49840_((Level)CrowEntity.this.f_19853_, (BlockPos)this.f_25602_, (ItemStack)new ItemStack((ItemLike)secondOutput.m_41720_(), Math.max(1, (int)Math.floor(k))));
                        }
                        CrowEntity.this.f_19853_.m_7731_(this.f_25602_, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61407_, (Comparable)Integer.valueOf(0)), 2);
                        CrowEntity.this.peck();
                        CrowEntity.this.m_5496_(SoundEvents.f_144088_, 1.0f, 1.0f);
                        HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> CrowEntity.this.f_19853_.m_46745_(CrowEntity.this.m_20183_())), (Object)new CrowPeckPacket((Entity)CrowEntity.this));
                    } else if (!CrowEntity.this.f_19853_.f_46443_) {
                        blockstate.m_60734_();
                        List drops = Block.m_49869_((BlockState)blockstate, (ServerLevel)((ServerLevel)CrowEntity.this.f_19853_), (BlockPos)this.f_25602_, (BlockEntity)CrowEntity.this.f_19853_.m_7702_(this.f_25602_));
                        for (ItemStack drop : drops) {
                            if (blockstate.m_61138_((Property)BlockStateProperties.f_61407_)) {
                                CrowEntity.this.f_19853_.m_7967_((Entity)new ItemEntity(CrowEntity.this.f_19853_, (double)((float)this.f_25602_.m_123341_() + 0.5f), (double)((float)this.f_25602_.m_123342_() + 0.25f), (double)((float)this.f_25602_.m_123343_() + 0.5f), drop));
                                CrowEntity.this.f_19853_.m_7731_(this.f_25602_, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61407_, (Comparable)Integer.valueOf(0)), 2);
                            }
                            if (blockstate.m_61138_((Property)BlockStateProperties.f_61409_)) {
                                CrowEntity.this.f_19853_.m_7967_((Entity)new ItemEntity(CrowEntity.this.f_19853_, (double)((float)this.f_25602_.m_123341_() + 0.5f), (double)((float)this.f_25602_.m_123342_() + 0.25f), (double)((float)this.f_25602_.m_123343_() + 0.5f), drop));
                                CrowEntity.this.f_19853_.m_7731_(this.f_25602_, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61409_, (Comparable)Integer.valueOf(0)), 2);
                            }
                            CrowEntity.this.peck();
                            CrowEntity.this.m_5496_(SoundEvents.f_11838_, 1.0f, 1.0f);
                            HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> CrowEntity.this.f_19853_.m_46745_(CrowEntity.this.m_20183_())), (Object)new CrowPeckPacket((Entity)CrowEntity.this));
                        }
                    }
                } else if (blockstate.m_204336_(HexereiTags.Blocks.CROW_BLOCK_HARVESTABLE)) {
                    LootContext.Builder builder = new LootContext.Builder((ServerLevel)CrowEntity.this.f_19853_).m_230911_(CrowEntity.this.f_19853_.m_213780_()).m_78972_(LootContextParams.f_81460_, (Object)CrowEntity.this.m_20182_()).m_78972_(LootContextParams.f_81463_, (Object)new ItemStack((ItemLike)Items.f_42387_));
                    for (ItemStack stack : blockstate.m_60724_(builder)) {
                        Block.m_49840_((Level)CrowEntity.this.f_19853_, (BlockPos)this.f_25602_, (ItemStack)stack);
                        CrowEntity.this.m_5496_(blockstate.m_60827_().m_56775_(), 1.0f, 1.0f);
                        HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> CrowEntity.this.f_19853_.m_46745_(CrowEntity.this.m_20183_())), (Object)new CrowPeckPacket((Entity)CrowEntity.this));
                    }
                    CrowEntity.this.f_19853_.m_7731_(this.f_25602_, Blocks.f_50016_.m_49966_(), 3);
                }
            }
        }

        private void pickGlowBerry(BlockState p_148927_) {
            CaveVines.m_152953_((BlockState)p_148927_, (Level)CrowEntity.this.f_19853_, (BlockPos)this.f_25602_);
        }

        private void pickSweetBerries(BlockState p_148929_) {
            int i = (Integer)p_148929_.m_61143_((Property)SweetBerryBushBlock.f_57244_);
            p_148929_.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(1));
            int j = 1 + CrowEntity.this.f_19796_.m_188503_(2) + (i == 3 ? 1 : 0);
            ItemStack itemstack = CrowEntity.this.m_6844_(EquipmentSlot.MAINHAND);
            if (itemstack.m_41619_()) {
                CrowEntity.this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42780_));
                --j;
            }
            if (j > 0) {
                Block.m_49840_((Level)CrowEntity.this.f_19853_, (BlockPos)this.f_25602_, (ItemStack)new ItemStack((ItemLike)Items.f_42780_, j));
            }
            CrowEntity.this.m_5496_(SoundEvents.f_12457_, 1.0f, 1.0f);
            CrowEntity.this.f_19853_.m_7731_(this.f_25602_, (BlockState)p_148929_.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(1)), 2);
        }

        public boolean m_8036_() {
            double dist;
            this.f_25606_ = CrowEntity.this.interactionRange + 1;
            if (CrowEntity.this.doingTask) {
                return false;
            }
            if (CrowEntity.this.getPerchPos() != null && (dist = CrowEntity.this.m_20183_().m_203198_((double)CrowEntity.this.getPerchPos().m_123341_(), (double)CrowEntity.this.getPerchPos().m_123342_(), (double)CrowEntity.this.getPerchPos().m_123343_())) > (double)(CrowEntity.this.interactionRange * CrowEntity.this.interactionRange)) {
                return false;
            }
            if (CrowEntity.this.getHelpCommand() == 1 && CrowEntity.this.getCommand() == 3 && CrowEntity.this.m_21825_()) {
                CrowEntity.this.m_21837_(false);
                CrowEntity.this.m_21839_(false);
            }
            return !CrowEntity.this.m_5803_() && CrowEntity.this.getHelpCommand() == 1 && CrowEntity.this.getCommand() == 3 && super.m_8036_();
        }

        public boolean m_8045_() {
            if (CrowEntity.this.getHelpCommand() == 1 && CrowEntity.this.getCommand() == 3 && CrowEntity.this.m_21825_()) {
                CrowEntity.this.m_21837_(false);
                CrowEntity.this.m_21839_(false);
            }
            return super.m_8045_() && CrowEntity.this.getCommand() == 3 && CrowEntity.this.getHelpCommand() == 1;
        }

        public void m_8056_() {
            CrowEntity.this.doingTask = true;
            this.ticksWaited = 0;
            super.m_8056_();
        }

        public void m_8041_() {
            if (CrowEntity.this.getCommandHelp() && CrowEntity.this.getHelpCommand() == 1) {
                CrowEntity.this.searchForNewCropTarget = true;
                CrowEntity.this.searchForNewCropTargetTimer = 40;
            }
            CrowEntity.this.doingTask = false;
        }
    }

    private class CrowPickpocketVillager
    extends Goal {
        private final CrowEntity entity;
        protected final Sorter theNearestAttackableTargetSorter;
        protected int executionChance = 8;
        protected boolean mustUpdate;
        private Villager targetEntity;
        private Vec3 flightTarget = null;
        private int tryTicks = 0;
        private boolean success = false;

        CrowPickpocketVillager(CrowEntity entity) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.theNearestAttackableTargetSorter = new Sorter((Entity)CrowEntity.this);
        }

        public boolean m_8036_() {
            if (CrowEntity.this.doingTask) {
                return false;
            }
            if (CrowEntity.this.pickpocketTimer > 0) {
                return false;
            }
            if (!CrowEntity.this.m_21824_()) {
                return false;
            }
            if (CrowEntity.this.m_20160_()) {
                return false;
            }
            if (CrowEntity.this.m_20159_()) {
                return false;
            }
            if (CrowEntity.this.getCommand() != 3) {
                return false;
            }
            if (CrowEntity.this.getHelpCommand() != 2) {
                return false;
            }
            if (!this.mustUpdate) {
                long worldTime = CrowEntity.this.f_19853_.m_46467_() % 10L;
                if (CrowEntity.this.m_21216_() >= 100 && worldTime != 0L) {
                    return false;
                }
                if (CrowEntity.this.m_217043_().m_188503_(this.executionChance) != 0 && worldTime != 0L) {
                    return false;
                }
            }
            if (this.entity.villagerList == null || this.entity.villagerList.isEmpty()) {
                return false;
            }
            if (CrowEntity.this.getHelpCommand() == 2 && CrowEntity.this.getCommand() == 3 && CrowEntity.this.m_21825_()) {
                CrowEntity.this.m_21837_(false);
                CrowEntity.this.m_21839_(false);
            }
            this.entity.villagerList.sort(this.theNearestAttackableTargetSorter);
            this.targetEntity = this.entity.villagerList.get(0);
            this.mustUpdate = false;
            if (!CrowEntity.this.itemHandler.getStackInSlot(1).m_41619_()) {
                CrowEntity.this.m_19983_(CrowEntity.this.itemHandler.getStackInSlot(1).m_41777_());
                CrowEntity.this.itemHandler.setStackInSlot(1, ItemStack.f_41583_);
            }
            return true;
        }

        public boolean m_8045_() {
            if (CrowEntity.this.getHelpCommand() == 2 && CrowEntity.this.getCommand() == 3 && CrowEntity.this.m_21825_()) {
                CrowEntity.this.m_21837_(false);
                CrowEntity.this.m_21839_(false);
            }
            if (!CrowEntity.this.itemHandler.getStackInSlot(1).m_41619_() && CrowEntity.this.pickpocketTimer > 0) {
                return true;
            }
            return this.targetEntity != null && CrowEntity.this.getCommand() == 3 && CrowEntity.this.getHelpCommand() == 2;
        }

        public void m_8056_() {
            CrowEntity.this.doingTask = true;
            this.success = false;
        }

        public void m_8041_() {
            CrowEntity.this.doingTask = false;
            this.flightTarget = null;
            this.targetEntity = null;
        }

        public void m_8037_() {
            BlockPos pos;
            if (CrowEntity.this.isPlayingDead()) {
                return;
            }
            if (CrowEntity.this.pickpocketTimer <= 0 && this.targetEntity != null) {
                if (CrowEntity.this.m_20275_(this.targetEntity.m_20182_().f_82479_, this.targetEntity.m_20182_().f_82480_ + 0.75, this.targetEntity.m_20182_().f_82481_) < this.entity.getMaxDistToItem() * 8.0) {
                    this.entity.m_21573_().m_26536_(this.entity.m_21573_().m_26524_(this.targetEntity.m_20182_().f_82479_, this.targetEntity.m_20182_().f_82480_ + 0.75, this.targetEntity.m_20182_().f_82481_, 0), 1.5);
                } else {
                    this.entity.m_21573_().m_26536_(this.entity.m_21573_().m_26524_(this.targetEntity.m_20182_().f_82479_, this.targetEntity.m_20182_().f_82480_ + 1.75, this.targetEntity.m_20182_().f_82481_, 0), 1.5);
                }
                this.flightTarget = this.targetEntity.m_20182_();
                if (CrowEntity.this.m_20275_(this.targetEntity.m_20182_().f_82479_, this.targetEntity.m_20182_().f_82480_ + 0.75, this.targetEntity.m_20182_().f_82481_) < this.entity.getMaxDistToItem() * 2.0) {
                    this.entity.m_21391_((Entity)this.targetEntity, 10.0f, this.entity.m_8132_());
                    CrowEntity.this.peck();
                    HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> CrowEntity.this.f_19853_.m_46745_(CrowEntity.this.m_20183_())), (Object)new CrowPeckPacket((Entity)CrowEntity.this));
                    CrowEntity.this.pickpocketTimer = (Integer)HexConfig.CROW_PICKPOCKET_COOLDOWN.get();
                    pos = RandomPos.m_217851_((RandomSource)this.entity.m_217043_(), (int)10, (int)1);
                    this.flightTarget = new Vec3((double)pos.m_123341_() + CrowEntity.this.m_20182_().f_82479_, (double)pos.m_123342_() + CrowEntity.this.m_20182_().f_82480_ + 2.0, (double)pos.m_123343_() + CrowEntity.this.m_20182_().f_82481_);
                    LootContext.Builder builder = new LootContext.Builder((ServerLevel)CrowEntity.this.f_19853_).m_230911_(CrowEntity.this.f_19853_.m_213780_()).m_78972_(LootContextParams.f_81455_, (Object)this.targetEntity);
                    LootContext ctx = builder.m_78975_(LootContextParamSet.m_165477_().m_81405_());
                    NonNullList stacks = NonNullList.m_122779_();
                    stacks.addAll((Collection)CrowEntity.this.f_19853_.m_7654_().m_129898_().m_79217_(new ResourceLocation("hexerei:entities/crow_pickpocket_villager")).m_230922_(ctx));
                    if (!stacks.isEmpty()) {
                        CrowEntity.this.itemHandler.setStackInSlot(1, (ItemStack)stacks.get(0));
                    }
                    this.targetEntity.m_6274_().m_21889_(Activity.f_37984_);
                    this.success = true;
                }
                ++this.tryTicks;
                if (this.shouldRecalculatePath()) {
                    if (this.targetEntity.m_20182_().m_82554_(CrowEntity.this.m_20182_()) < 3.0 && CrowEntity.this.m_20182_().f_82480_ < this.targetEntity.m_20182_().m_7098_()) {
                        CrowEntity.this.m_20242_(false);
                        CrowEntity.this.m_5997_((this.targetEntity.m_20182_().f_82479_ - CrowEntity.this.m_20182_().f_82479_) / 50.0, (this.targetEntity.m_20182_().f_82480_ - CrowEntity.this.m_20182_().f_82480_) / 50.0 + (double)0.1f, (this.targetEntity.m_20182_().f_82481_ - CrowEntity.this.m_20182_().f_82481_) / 50.0);
                    }
                    CrowEntity.this.m_21573_().m_26536_(this.entity.m_21573_().m_26524_(this.targetEntity.m_20185_(), this.targetEntity.m_20186_() + 3.0, this.targetEntity.m_20189_(), 0), 1.5);
                }
            }
            if (CrowEntity.this.pickpocketTimer < (Integer)HexConfig.CROW_PICKPOCKET_COOLDOWN.get() && CrowEntity.this.pickpocketTimer > (Integer)HexConfig.CROW_PICKPOCKET_COOLDOWN.get() / 2 && this.flightTarget != null) {
                this.entity.m_21573_().m_26536_(this.entity.m_21573_().m_26524_(this.flightTarget.f_82479_, this.flightTarget.f_82480_ + 0.75, this.flightTarget.f_82481_, 0), 1.5);
                if (CrowEntity.this.m_20275_(this.flightTarget.f_82479_, this.flightTarget.f_82480_ + 0.75, this.flightTarget.f_82481_) < this.entity.getMaxDistToItem() * 4.0) {
                    pos = RandomPos.m_217851_((RandomSource)this.entity.m_217043_(), (int)10, (int)4);
                    this.flightTarget = new Vec3((double)pos.m_123341_() + CrowEntity.this.m_20182_().f_82479_, CrowEntity.this.m_20182_().f_82480_, (double)pos.m_123343_() + CrowEntity.this.m_20182_().f_82481_);
                }
            }
            if (CrowEntity.this.pickpocketTimer <= (Integer)HexConfig.CROW_PICKPOCKET_COOLDOWN.get() / 2 && CrowEntity.this.pickpocketTimer > 5) {
                if (CrowEntity.this.getPerchPos() == null) {
                    if (this.flightTarget != null) {
                        this.entity.m_21573_().m_26536_(this.entity.m_21573_().m_26524_(this.flightTarget.f_82479_, this.flightTarget.f_82480_ + 0.75, this.flightTarget.f_82481_, 0), 1.5);
                        if (CrowEntity.this.m_20275_(this.flightTarget.f_82479_, this.flightTarget.f_82480_ + 0.75, this.flightTarget.f_82481_) < this.entity.getMaxDistToItem() * 4.0) {
                            pos = RandomPos.m_217851_((RandomSource)this.entity.m_217043_(), (int)10, (int)4);
                            this.flightTarget = new Vec3((double)pos.m_123341_() + CrowEntity.this.m_20182_().f_82479_, CrowEntity.this.m_20182_().f_82480_, (double)pos.m_123343_() + CrowEntity.this.m_20182_().f_82481_);
                        }
                    }
                } else {
                    CrowEntity.this.f_21344_.m_26536_(CrowEntity.this.m_21573_().m_7864_(CrowEntity.this.getPerchPos().m_7494_(), 0), 1.5);
                }
            }
            if (CrowEntity.this.pickpocketTimer < 5 && CrowEntity.this.pickpocketTimer > 0 || CrowEntity.this.m_8020_(1).m_41619_() && this.success) {
                this.m_8041_();
            }
        }

        public boolean shouldRecalculatePath() {
            return this.tryTicks % 20 == 0;
        }

        public class Sorter
        implements Comparator<Villager> {
            private final Entity crow;

            public Sorter(Entity theEntityIn) {
                this.crow = theEntityIn;
            }

            @Override
            public int compare(Villager p_compare_1_, Villager p_compare_2_) {
                double d0 = this.crow.m_20238_(new Vec3(p_compare_1_.m_20182_().f_82479_, p_compare_1_.m_20182_().f_82480_, p_compare_1_.m_20182_().f_82481_));
                double d1 = this.crow.m_20238_(new Vec3(p_compare_2_.m_20182_().f_82479_, p_compare_2_.m_20182_().f_82480_, p_compare_2_.m_20182_().f_82481_));
                return Double.compare(d0, d1);
            }
        }
    }

    public class OwnerHurtByTargetGoal
    extends TargetGoal {
        private final TamableAnimal tameAnimal;
        private LivingEntity ownerLastHurtBy;
        private int timestamp;

        public OwnerHurtByTargetGoal(TamableAnimal p_26107_) {
            super((Mob)p_26107_, false);
            this.tameAnimal = p_26107_;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        protected boolean m_26150_(@Nullable LivingEntity entity, TargetingConditions p_26152_) {
            if (entity instanceof TamableAnimal && CrowEntity.this.m_21826_() != null && ((TamableAnimal)entity).m_21830_(CrowEntity.this.m_21826_())) {
                return false;
            }
            return super.m_26150_(entity, p_26152_);
        }

        public boolean m_8036_() {
            if (this.tameAnimal.m_21824_() && !this.tameAnimal.m_21827_() && !CrowEntity.this.getCommandSit()) {
                LivingEntity livingentity = this.tameAnimal.m_21826_();
                if (livingentity == null) {
                    return false;
                }
                if (CrowEntity.this.m_21825_()) {
                    CrowEntity.this.m_21837_(false);
                    CrowEntity.this.m_21839_(false);
                }
                this.ownerLastHurtBy = livingentity.m_21188_();
                int i = livingentity.m_21213_();
                return i != this.timestamp && this.m_26150_(this.ownerLastHurtBy, TargetingConditions.f_26872_) && this.tameAnimal.m_7757_(this.ownerLastHurtBy, livingentity);
            }
            return false;
        }

        public void m_8056_() {
            this.f_26135_.m_6710_(this.ownerLastHurtBy);
            LivingEntity livingentity = this.tameAnimal.m_21826_();
            if (livingentity != null) {
                this.timestamp = livingentity.m_21213_();
            }
            super.m_8056_();
        }
    }

    public class OwnerHurtTargetGoal
    extends TargetGoal {
        private final TamableAnimal tameAnimal;
        private LivingEntity ownerLastHurt;
        private int timestamp;

        public OwnerHurtTargetGoal(TamableAnimal p_26114_) {
            super((Mob)p_26114_, false);
            this.tameAnimal = p_26114_;
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        }

        protected boolean m_26150_(@Nullable LivingEntity entity, TargetingConditions p_26152_) {
            if (entity instanceof TamableAnimal && CrowEntity.this.m_21826_() != null && ((TamableAnimal)entity).m_21830_(CrowEntity.this.m_21826_())) {
                return false;
            }
            return super.m_26150_(entity, p_26152_);
        }

        public boolean m_8036_() {
            if (this.tameAnimal.m_21824_() && !this.tameAnimal.m_21827_() && !CrowEntity.this.getCommandSit()) {
                LivingEntity livingentity = this.tameAnimal.m_21826_();
                if (livingentity == null) {
                    return false;
                }
                if (CrowEntity.this.m_21825_()) {
                    CrowEntity.this.m_21837_(false);
                    CrowEntity.this.m_21839_(false);
                }
                this.ownerLastHurt = livingentity.m_21214_();
                int i = livingentity.m_21215_();
                return i != this.timestamp && this.m_26150_(this.ownerLastHurt, TargetingConditions.f_26872_) && this.tameAnimal.m_7757_(this.ownerLastHurt, livingentity);
            }
            return false;
        }

        public void m_8056_() {
            this.f_26135_.m_6710_(this.ownerLastHurt);
            LivingEntity livingentity = this.tameAnimal.m_21826_();
            if (livingentity != null) {
                this.timestamp = livingentity.m_21215_();
            }
            super.m_8056_();
        }
    }

    public class MeleeAttackGoal
    extends Goal {
        protected final PathfinderMob mob;
        private final double speedModifier;
        private final boolean followingTargetEvenIfNotSeen;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private final int attackInterval = 20;
        private long lastCanUseCheck;
        private static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20L;
        private int failedPathFindingPenalty = 0;
        private boolean canPenalize = false;

        public MeleeAttackGoal(PathfinderMob p_25552_, double p_25553_, boolean p_25554_) {
            this.mob = p_25552_;
            this.speedModifier = p_25553_;
            this.followingTargetEvenIfNotSeen = p_25554_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (!CrowEntity.this.canAttack) {
                return false;
            }
            long i = this.mob.f_19853_.m_46467_();
            if (i - this.lastCanUseCheck < 20L) {
                return false;
            }
            this.lastCanUseCheck = i;
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (this.canPenalize) {
                if (--this.ticksUntilNextPathRecalculation <= 0) {
                    this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
                    this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                    return this.path != null;
                }
                return true;
            }
            if (CrowEntity.this.getCommand() != 1 && CrowEntity.this.m_21825_()) {
                CrowEntity.this.m_21837_(false);
                CrowEntity.this.m_21839_(false);
            }
            this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(livingentity) >= this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (!this.followingTargetEvenIfNotSeen) {
                return !this.mob.m_21573_().m_26571_();
            }
            if (!this.mob.m_21444_(livingentity.m_20183_())) {
                return false;
            }
            if (CrowEntity.this.getCommand() != 1 && CrowEntity.this.m_21825_()) {
                CrowEntity.this.m_21837_(false);
                CrowEntity.this.m_21839_(false);
            }
            return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
        }

        public void m_8056_() {
            this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
            this.mob.m_21561_(true);
            this.ticksUntilNextPathRecalculation = 0;
            this.ticksUntilNextAttack = 0;
        }

        public void m_8041_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (!EntitySelector.f_20406_.test(livingentity)) {
                this.mob.m_6710_(null);
            }
            this.mob.m_21561_(false);
            this.mob.m_21573_().m_26573_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (CrowEntity.this.isPlayingDead()) {
                return;
            }
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null) {
                this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
                double d0 = this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                double d1 = this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_() + (double)livingentity.m_20206_(), livingentity.m_20189_());
                this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
                    this.pathedTargetX = livingentity.m_20185_();
                    this.pathedTargetY = livingentity.m_20186_();
                    this.pathedTargetZ = livingentity.m_20189_();
                    this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                    if (this.canPenalize) {
                        Node finalPathPoint;
                        this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                        this.failedPathFindingPenalty = this.mob.m_21573_().m_26570_() != null ? ((finalPathPoint = this.mob.m_21573_().m_26570_().m_77395_()) != null && livingentity.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                    }
                    if (d0 > 1024.0) {
                        this.ticksUntilNextPathRecalculation += 10;
                    } else if (d0 > 256.0) {
                        this.ticksUntilNextPathRecalculation += 5;
                    }
                    if (!this.mob.m_21573_().m_26536_(CrowEntity.this.m_21573_().m_6570_((Entity)livingentity, 0), this.speedModifier)) {
                        this.ticksUntilNextPathRecalculation += 15;
                    }
                    this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
                }
                this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
                this.checkAndPerformAttack(livingentity, d0, d1);
            }
        }

        protected void checkAndPerformAttack(LivingEntity p_25557_, double p_25558_, double p_25559_) {
            double d0 = this.getAttackReachSqr(p_25557_);
            if ((p_25558_ <= d0 || p_25559_ <= d0) && this.ticksUntilNextAttack <= 0) {
                this.resetAttackCooldown();
                this.mob.m_6674_(InteractionHand.MAIN_HAND);
                this.doHurtTarget((Entity)p_25557_);
                CrowEntity.this.peck();
                HexereiPacketHandler.instance.send(PacketDistributor.TRACKING_CHUNK.with(() -> CrowEntity.this.f_19853_.m_46745_(CrowEntity.this.m_20183_())), (Object)new CrowPeckPacket((Entity)this.mob));
            }
        }

        public boolean doHurtTarget(Entity p_21372_) {
            boolean flag;
            int i;
            float f = (float)CrowEntity.this.m_21133_(Attributes.f_22281_);
            float f1 = (float)CrowEntity.this.m_21133_(Attributes.f_22282_);
            if (p_21372_ instanceof LivingEntity) {
                f += EnchantmentHelper.m_44833_((ItemStack)CrowEntity.this.itemHandler.getStackInSlot(1), (MobType)((LivingEntity)p_21372_).m_6336_());
                f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)CrowEntity.this);
            }
            if ((i = EnchantmentHelper.m_44914_((LivingEntity)CrowEntity.this)) > 0) {
                p_21372_.m_20254_(i * 4);
            }
            if (flag = p_21372_.m_6469_(DamageSource.m_19370_((LivingEntity)CrowEntity.this), f)) {
                if (f1 > 0.0f && p_21372_ instanceof LivingEntity) {
                    ((LivingEntity)p_21372_).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(CrowEntity.this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(CrowEntity.this.m_146908_() * ((float)Math.PI / 180)))));
                    CrowEntity.this.m_20256_(CrowEntity.this.m_20184_().m_82542_(0.6, 1.0, 0.6));
                }
                if (p_21372_ instanceof Player) {
                    Player player = (Player)p_21372_;
                    this.maybeDisableShield(player, CrowEntity.this.itemHandler.getStackInSlot(1), player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_);
                }
                CrowEntity.this.m_19970_((LivingEntity)CrowEntity.this, p_21372_);
                CrowEntity.this.m_21335_(p_21372_);
            }
            return flag;
        }

        private void maybeDisableShield(Player p_21425_, ItemStack p_21426_, ItemStack p_21427_) {
            if (!p_21426_.m_41619_() && !p_21427_.m_41619_() && p_21426_.m_41720_() instanceof AxeItem && p_21427_.m_150930_(Items.f_42740_)) {
                float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)CrowEntity.this) * 0.05f;
                if (CrowEntity.this.f_19796_.m_188501_() < f) {
                    p_21425_.m_36335_().m_41524_(Items.f_42740_, 100);
                    CrowEntity.this.f_19853_.m_7605_((Entity)p_21425_, (byte)30);
                }
            }
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = this.m_183277_(20);
        }

        protected boolean isTimeToAttack() {
            return this.ticksUntilNextAttack <= 0;
        }

        protected int getTicksUntilNextAttack() {
            return this.ticksUntilNextAttack;
        }

        protected int getAttackInterval() {
            return this.m_183277_(20);
        }

        protected double getAttackReachSqr(LivingEntity p_25556_) {
            return this.mob.m_20205_() * 2.5f * this.mob.m_20205_() * 2.5f + p_25556_.m_20205_();
        }
    }

    public static class CrowGroupData
    extends AgeableMob.AgeableMobGroupData {
        public final CrowVariant variant;

        public CrowGroupData(CrowVariant pVariant) {
            super(true);
            this.variant = pVariant;
        }
    }
}

