/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.cap;

import at.petrak.hexcasting.forge.network.MsgColorizerUpdateAck;
import at.petrak.hexcasting.forge.network.MsgSentinelStatusUpdateAck;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CapSyncers {
    @SubscribeEvent
    public static void copyDataOnDeath(PlayerEvent.Clone evt) {
        Player eitherSidePlayer = evt.getEntity();
        if (!(eitherSidePlayer instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)eitherSidePlayer;
        Player eitherSideProto = evt.getOriginal();
        if (!(eitherSideProto instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer proto = (ServerPlayer)eitherSideProto;
        IXplatAbstractions x = IXplatAbstractions.INSTANCE;
        x.setFlight(player, x.getFlight(proto));
        x.setSentinel((Player)player, x.getSentinel((Player)proto));
        x.setColorizer((Player)player, x.getColorizer((Player)proto));
        x.setHarness(player, x.getHarness(proto, InteractionHand.MAIN_HAND));
        x.setPatterns(player, x.getPatterns(proto));
    }

    @SubscribeEvent
    public static void syncDataOnLogin(PlayerEvent.PlayerLoggedInEvent evt) {
        Player player = evt.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        CapSyncers.syncSentinel(player2);
        CapSyncers.syncColorizer(player2);
    }

    @SubscribeEvent
    public static void syncDataOnRejoin(PlayerEvent.PlayerRespawnEvent evt) {
        Player player = evt.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        CapSyncers.syncSentinel(player2);
        CapSyncers.syncColorizer(player2);
    }

    public static void syncSentinel(ServerPlayer player) {
        IXplatAbstractions.INSTANCE.sendPacketToPlayer(player, new MsgSentinelStatusUpdateAck(IXplatAbstractions.INSTANCE.getSentinel((Player)player)));
    }

    public static void syncColorizer(ServerPlayer player) {
        IXplatAbstractions.INSTANCE.sendPacketToPlayer(player, new MsgColorizerUpdateAck(IXplatAbstractions.INSTANCE.getColorizer((Player)player)));
    }
}

