/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge;

import at.petrak.hexcasting.api.misc.ScrollQuantity;
import at.petrak.hexcasting.api.mod.HexConfig;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;

public class ForgeHexConfig
implements HexConfig.CommonConfigAccess {
    private static ForgeConfigSpec.IntValue dustMediaAmount;
    private static ForgeConfigSpec.IntValue shardMediaAmount;
    private static ForgeConfigSpec.IntValue chargedCrystalMediaAmount;
    private static ForgeConfigSpec.DoubleValue mediaToHealthRate;

    public ForgeHexConfig(ForgeConfigSpec.Builder builder) {
        builder.push("Media Amounts");
        dustMediaAmount = builder.comment("How much media a single Amethyst Dust item is worth").defineInRange("dustMediaAmount", 10000, 0, Integer.MAX_VALUE);
        shardMediaAmount = builder.comment("How much media a single Amethyst Shard item is worth").defineInRange("shardMediaAmount", 50000, 0, Integer.MAX_VALUE);
        chargedCrystalMediaAmount = builder.comment("How much media a single Charged Amethyst Crystal item is worth").defineInRange("chargedCrystalMediaAmount", 100000, 0, Integer.MAX_VALUE);
        mediaToHealthRate = builder.comment("How many points of media a half-heart is worth when casting from HP").defineInRange("mediaToHealthRate", 10000.0, 0.0, Double.POSITIVE_INFINITY);
        builder.pop();
    }

    @Override
    public int dustMediaAmount() {
        return (Integer)dustMediaAmount.get();
    }

    @Override
    public int shardMediaAmount() {
        return (Integer)shardMediaAmount.get();
    }

    @Override
    public int chargedCrystalMediaAmount() {
        return (Integer)chargedCrystalMediaAmount.get();
    }

    @Override
    public double mediaToHealthRate() {
        return (Double)mediaToHealthRate.get();
    }

    public static class Server
    implements HexConfig.ServerConfigAccess {
        private static ForgeConfigSpec.IntValue opBreakHarvestLevel;
        private static ForgeConfigSpec.IntValue maxRecurseDepth;
        private static ForgeConfigSpec.IntValue maxSpellCircleLength;
        private static ForgeConfigSpec.ConfigValue<List<? extends String>> actionDenyList;
        private static ForgeConfigSpec.ConfigValue<List<? extends String>> circleActionDenyList;
        private static ForgeConfigSpec.BooleanValue villagersOffendedByMindMurder;
        private static ForgeConfigSpec.ConfigValue<List<? extends String>> tpDimDenyList;
        private static ForgeConfigSpec.ConfigValue<List<? extends String>> fewScrollTables;
        private static ForgeConfigSpec.ConfigValue<List<? extends String>> someScrollTables;
        private static ForgeConfigSpec.ConfigValue<List<? extends String>> manyScrollTables;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("Spells");
            maxRecurseDepth = builder.comment("How many times a spell can recursively cast other spells").defineInRange("maxRecurseDepth", 512, 0, Integer.MAX_VALUE);
            opBreakHarvestLevel = builder.comment(new String[]{"The harvest level of the Break Block spell.", "0 = wood, 1 = stone, 2 = iron, 3 = diamond, 4 = netherite."}).defineInRange("opBreakHarvestLevel", 3, 0, 4);
            builder.pop();
            builder.push("Spell Circles");
            maxSpellCircleLength = builder.comment("The maximum number of slates in a spell circle").defineInRange("maxSpellCircleLength", 1024, 4, Integer.MAX_VALUE);
            circleActionDenyList = builder.comment("Resource locations of disallowed actions within circles. Trying to cast one of these in a circle will result in a mishap.").defineList("circleActionDenyList", List.of(), Server::isValidReslocArg);
            builder.pop();
            actionDenyList = builder.comment("Resource locations of disallowed actions. Trying to cast one of these will result in a mishap.").defineList("actionDenyList", List.of(), Server::isValidReslocArg);
            villagersOffendedByMindMurder = builder.comment("Should villagers take offense when you flay the mind of their fellow villagers?").define("villagersOffendedByMindMurder", true);
            tpDimDenyList = builder.comment("Resource locations of dimensions you can't Blink or Greater Teleport in.").defineList("tpDimDenyList", DEFAULT_DIM_TP_DENYLIST, Server::isValidReslocArg);
            builder.push("Scrolls in Loot");
            fewScrollTables = builder.comment("Which loot tables should a small number of Ancient Scrolls be injected into?").defineList("fewScrollTables", DEFAULT_FEW_SCROLL_TABLES, Server::isValidReslocArg);
            someScrollTables = builder.comment("Which loot tables should a decent number of Ancient Scrolls be injected into?").defineList("someScrollTables", DEFAULT_SOME_SCROLL_TABLES, Server::isValidReslocArg);
            manyScrollTables = builder.comment("Which loot tables should a huge number of Ancient Scrolls be injected into?").defineList("manyScrollTables", DEFAULT_MANY_SCROLL_TABLES, Server::isValidReslocArg);
        }

        @Override
        public int opBreakHarvestLevelBecauseForgeThoughtItWasAGoodIdeaToImplementHarvestTiersUsingAnHonestToGodTopoSort() {
            return (Integer)opBreakHarvestLevel.get();
        }

        @Override
        public int maxRecurseDepth() {
            return (Integer)maxRecurseDepth.get();
        }

        @Override
        public int maxSpellCircleLength() {
            return (Integer)maxSpellCircleLength.get();
        }

        @Override
        public boolean isActionAllowed(ResourceLocation actionID) {
            return HexConfig.noneMatch((List)actionDenyList.get(), actionID);
        }

        @Override
        public boolean isActionAllowedInCircles(ResourceLocation actionID) {
            return HexConfig.noneMatch((List)circleActionDenyList.get(), actionID);
        }

        @Override
        public boolean doVillagersTakeOffenseAtMindMurder() {
            return (Boolean)villagersOffendedByMindMurder.get();
        }

        @Override
        public boolean canTeleportInThisDimension(ResourceKey<Level> dimension) {
            return HexConfig.noneMatch((List)tpDimDenyList.get(), dimension.m_135782_());
        }

        @Override
        public ScrollQuantity scrollsForLootTable(ResourceLocation lootTable) {
            try {
                if (HexConfig.anyMatch(HexConfig.ServerConfigAccess.DEFAULT_FEW_SCROLL_TABLES, lootTable)) {
                    return ScrollQuantity.FEW;
                }
                if (HexConfig.anyMatch(HexConfig.ServerConfigAccess.DEFAULT_SOME_SCROLL_TABLES, lootTable)) {
                    return ScrollQuantity.SOME;
                }
                if (HexConfig.anyMatch(HexConfig.ServerConfigAccess.DEFAULT_MANY_SCROLL_TABLES, lootTable)) {
                    return ScrollQuantity.MANY;
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            return ScrollQuantity.NONE;
        }

        private static boolean isValidReslocArg(Object o) {
            String s;
            return o instanceof String && ResourceLocation.m_135830_((String)(s = (String)o));
        }
    }

    public static class Client
    implements HexConfig.ClientConfigAccess {
        private static ForgeConfigSpec.BooleanValue ctrlTogglesOffStrokeOrder;
        private static ForgeConfigSpec.BooleanValue invertSpellbookScrollDirection;
        private static ForgeConfigSpec.BooleanValue invertAbacusScrollDirection;
        private static ForgeConfigSpec.DoubleValue gridSnapThreshold;

        public Client(ForgeConfigSpec.Builder builder) {
            ctrlTogglesOffStrokeOrder = builder.comment("Whether the ctrl key will instead turn *off* the color gradient on patterns").define("ctrlTogglesOffStrokeOrder", false);
            invertSpellbookScrollDirection = builder.comment("Whether scrolling up (as opposed to down) will increase the page index of the spellbook, and vice versa").define("invertSpellbookScrollDirection", false);
            invertAbacusScrollDirection = builder.comment("Whether scrolling up (as opposed to down) will increase the value of the abacus, and vice versa").define("invertAbacusScrollDirection", false);
            gridSnapThreshold = builder.comment("When using a staff, the distance from one dot you have to go to snap to the next dot, where 0.5 means 50% of the way.").defineInRange("gridSnapThreshold", 0.5, 0.5, 1.0);
        }

        @Override
        public boolean invertSpellbookScrollDirection() {
            return (Boolean)invertSpellbookScrollDirection.get();
        }

        @Override
        public boolean invertAbacusScrollDirection() {
            return (Boolean)invertAbacusScrollDirection.get();
        }

        @Override
        public boolean ctrlTogglesOffStrokeOrder() {
            return (Boolean)ctrlTogglesOffStrokeOrder.get();
        }

        @Override
        public double gridSnapThreshold() {
            return (Double)gridSnapThreshold.get();
        }
    }
}

