/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.recipe.ingredient;

import at.petrak.hexcasting.common.recipe.ingredient.StateIngredient;
import at.petrak.hexcasting.common.recipe.ingredient.StateIngredientBlock;
import at.petrak.hexcasting.common.recipe.ingredient.StateIngredientBlockState;
import at.petrak.hexcasting.common.recipe.ingredient.StateIngredientBlocks;
import at.petrak.hexcasting.common.recipe.ingredient.StateIngredientTag;
import at.petrak.hexcasting.common.recipe.ingredient.StateIngredientTagExcluding;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class StateIngredientHelper {
    public static StateIngredient of(Block block) {
        return new StateIngredientBlock(block);
    }

    public static StateIngredient of(BlockState state) {
        return new StateIngredientBlockState(state);
    }

    public static StateIngredient of(TagKey<Block> tag) {
        return StateIngredientHelper.of(tag.f_203868_());
    }

    public static StateIngredient of(ResourceLocation id) {
        return new StateIngredientTag(id);
    }

    public static StateIngredient of(Collection<Block> blocks) {
        return new StateIngredientBlocks(blocks);
    }

    public static StateIngredient tagExcluding(TagKey<Block> tag, StateIngredient ... excluded) {
        return new StateIngredientTagExcluding(tag.f_203868_(), List.of(excluded));
    }

    public static StateIngredient deserialize(JsonObject object) {
        switch (GsonHelper.m_13906_((JsonObject)object, (String)"type")) {
            case "tag": {
                return new StateIngredientTag(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"tag")));
            }
            case "block": {
                return new StateIngredientBlock((Block)Registry.f_122824_.m_7745_(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"block"))));
            }
            case "state": {
                return new StateIngredientBlockState(StateIngredientHelper.readBlockState(object));
            }
            case "blocks": {
                ArrayList<Block> blocks = new ArrayList<Block>();
                for (JsonElement element : GsonHelper.m_13933_((JsonObject)object, (String)"blocks")) {
                    blocks.add((Block)Registry.f_122824_.m_7745_(new ResourceLocation(element.getAsString())));
                }
                return new StateIngredientBlocks(blocks);
            }
            case "tag_excluding": {
                ResourceLocation tag = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"tag"));
                ArrayList<StateIngredient> ingr = new ArrayList<StateIngredient>();
                for (JsonElement element : GsonHelper.m_13933_((JsonObject)object, (String)"exclude")) {
                    ingr.add(StateIngredientHelper.deserialize(GsonHelper.m_13918_((JsonElement)element, (String)"exclude entry")));
                }
                return new StateIngredientTagExcluding(tag, ingr);
            }
        }
        throw new JsonParseException("Unknown type!");
    }

    @Nullable
    public static StateIngredient tryDeserialize(JsonObject object) {
        StateIngredient ingr = StateIngredientHelper.deserialize(object);
        if (ingr instanceof StateIngredientTag) {
            StateIngredientTag sit = (StateIngredientTag)ingr;
            if (sit.resolve().findAny().isEmpty()) {
                return null;
            }
            return ingr;
        }
        if (ingr instanceof StateIngredientBlock || ingr instanceof StateIngredientBlockState) {
            if (ingr.test(Blocks.f_50016_.m_49966_())) {
                return null;
            }
        } else if (ingr instanceof StateIngredientBlocks) {
            StateIngredientBlocks sib = (StateIngredientBlocks)ingr;
            ImmutableSet<Block> blocks = sib.blocks;
            ArrayList<Block> list = new ArrayList<Block>((Collection<Block>)blocks);
            if (list.removeIf(b -> b == Blocks.f_50016_)) {
                if (list.size() == 0) {
                    return null;
                }
                return StateIngredientHelper.of(list);
            }
        }
        return ingr;
    }

    public static StateIngredient read(FriendlyByteBuf buffer) {
        switch (buffer.m_130242_()) {
            case 0: {
                int count = buffer.m_130242_();
                HashSet<Block> set = new HashSet<Block>();
                for (int i = 0; i < count; ++i) {
                    int id = buffer.m_130242_();
                    Block block = (Block)Registry.f_122824_.m_7942_(id);
                    set.add(block);
                }
                return new StateIngredientBlocks(set);
            }
            case 1: {
                return new StateIngredientBlock((Block)Registry.f_122824_.m_7942_(buffer.m_130242_()));
            }
            case 2: {
                return new StateIngredientBlockState(Block.m_49803_((int)buffer.m_130242_()));
            }
        }
        throw new IllegalArgumentException("Unknown input discriminator!");
    }

    public static JsonObject serializeBlockState(BlockState state) {
        CompoundTag nbt = NbtUtils.m_129202_((BlockState)state);
        StateIngredientHelper.renameTag(nbt, "Name", "name");
        StateIngredientHelper.renameTag(nbt, "Properties", "properties");
        Dynamic dyn = new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)nbt);
        return ((JsonElement)dyn.convert((DynamicOps)JsonOps.INSTANCE).getValue()).getAsJsonObject();
    }

    public static BlockState readBlockState(JsonObject object) {
        CompoundTag nbt = (CompoundTag)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)object).convert((DynamicOps)NbtOps.f_128958_).getValue();
        StateIngredientHelper.renameTag(nbt, "name", "Name");
        StateIngredientHelper.renameTag(nbt, "properties", "Properties");
        String name = nbt.m_128461_("Name");
        ResourceLocation id = ResourceLocation.m_135820_((String)name);
        if (id == null || !Registry.f_122824_.m_6612_(id).isPresent()) {
            throw new IllegalArgumentException("Invalid or unknown block ID: " + name);
        }
        return NbtUtils.m_129241_((CompoundTag)nbt);
    }

    @Deprecated
    @Nonnull
    public static List<ItemStack> toStackList(StateIngredient input) {
        return input.getDisplayedStacks();
    }

    private static void renameTag(CompoundTag tag, String from, String to) {
        Tag t = tag.m_128423_(from);
        if (t != null) {
            tag.m_128473_(from);
            tag.m_128365_(to, t);
        }
    }
}

