/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.spell.mishaps;

import at.petrak.hexcasting.api.misc.FrozenColorizer;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.api.spell.mishaps.Mishap;
import at.petrak.hexcasting.api.spell.mishaps.MishapBadItem;
import at.petrak.hexcasting.api.utils.HexUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lat/petrak/hexcasting/api/spell/mishaps/MishapBadEntity;", "Lat/petrak/hexcasting/api/spell/mishaps/Mishap;", "entity", "Lnet/minecraft/world/entity/Entity;", "wanted", "Lnet/minecraft/network/chat/Component;", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/network/chat/Component;)V", "getEntity", "()Lnet/minecraft/world/entity/Entity;", "getWanted", "()Lnet/minecraft/network/chat/Component;", "accentColor", "Lat/petrak/hexcasting/api/misc/FrozenColorizer;", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "errorCtx", "Lat/petrak/hexcasting/api/spell/mishaps/Mishap$Context;", "errorMessage", "execute", "", "stack", "", "Lat/petrak/hexcasting/api/spell/iota/Iota;", "Companion", "hexcasting-forge-1.19.2"})
public final class MishapBadEntity
extends Mishap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Entity entity;
    @NotNull
    private final Component wanted;

    public MishapBadEntity(@NotNull Entity entity, @NotNull Component wanted) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)wanted, (String)"wanted");
        this.entity = entity;
        this.wanted = wanted;
    }

    @NotNull
    public final Entity getEntity() {
        return this.entity;
    }

    @NotNull
    public final Component getWanted() {
        return this.wanted;
    }

    @Override
    @NotNull
    public FrozenColorizer accentColor(@NotNull CastingContext ctx, @NotNull Mishap.Context errorCtx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)errorCtx, (String)"errorCtx");
        return this.dyeColor(DyeColor.BROWN);
    }

    @Override
    public void execute(@NotNull CastingContext ctx, @NotNull Mishap.Context errorCtx, @NotNull List<Iota> stack) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)errorCtx, (String)"errorCtx");
        Intrinsics.checkNotNullParameter(stack, (String)"stack");
        Vec3 vec3 = this.entity.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"entity.position()");
        this.yeetHeldItemsTowards(ctx, vec3);
    }

    @Override
    @NotNull
    public Component errorMessage(@NotNull CastingContext ctx, @NotNull Mishap.Context errorCtx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)errorCtx, (String)"errorCtx");
        Object[] objectArray = new Object[3];
        objectArray[0] = this.actionName(errorCtx.getAction());
        objectArray[1] = this.wanted;
        MutableComponent mutableComponent = this.entity.m_5446_().m_6879_();
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"entity.displayName.plainCopy()");
        objectArray[2] = HexUtils.getAqua(mutableComponent);
        return this.error("bad_entity", objectArray);
    }

    @JvmStatic
    @NotNull
    public static final Mishap of(@NotNull Entity entity, @NotNull String stub) {
        return Companion.of(entity, stub);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lat/petrak/hexcasting/api/spell/mishaps/MishapBadEntity$Companion;", "", "()V", "of", "Lat/petrak/hexcasting/api/spell/mishaps/Mishap;", "entity", "Lnet/minecraft/world/entity/Entity;", "stub", "", "hexcasting-forge-1.19.2"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Mishap of(@NotNull Entity entity, @NotNull String stub) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
            MutableComponent component = HexUtils.getAsTranslatedComponent("hexcasting.mishap.bad_item." + stub);
            if (entity instanceof ItemEntity) {
                return new MishapBadItem((ItemEntity)entity, (Component)component);
            }
            return new MishapBadEntity(entity, (Component)component);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

