/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.common.casting.actions.spells.great;

import at.petrak.hexcasting.api.spell.OperationResult;
import at.petrak.hexcasting.api.spell.OperatorUtils;
import at.petrak.hexcasting.api.spell.ParticleSpray;
import at.petrak.hexcasting.api.spell.RenderedSpell;
import at.petrak.hexcasting.api.spell.SpellAction;
import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.casting.eval.SpellContinuation;
import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.api.spell.mishaps.MishapInvalidIota;
import com.mojang.datafixers.util.Either;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.HexalAPI;
import ram.talia.hexal.api.config.HexalConfig;
import ram.talia.hexal.api.spell.casting.IMixinCastingContext;
import ram.talia.hexal.common.entities.BaseCastingWisp;
import ram.talia.hexal.common.entities.IMediaEntity;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\t\u00a8\u0006\u0014"}, d2={"Lram/talia/hexal/common/casting/actions/spells/great/OpConsumeWisp;", "Lat/petrak/hexcasting/api/spell/SpellAction;", "()V", "argc", "", "getArgc", "()I", "isGreat", "", "()Z", "execute", "Lkotlin/Triple;", "Lat/petrak/hexcasting/api/spell/RenderedSpell;", "", "Lat/petrak/hexcasting/api/spell/ParticleSpray;", "args", "Lat/petrak/hexcasting/api/spell/iota/Iota;", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "Spell", "hexal-forge-1.19.2"})
public final class OpConsumeWisp
implements SpellAction {
    @NotNull
    public static final OpConsumeWisp INSTANCE = new OpConsumeWisp();
    private static final int argc = 1;
    private static final boolean isGreat = true;

    private OpConsumeWisp() {
    }

    public int getArgc() {
        return argc;
    }

    public boolean isGreat() {
        return isGreat;
    }

    @NotNull
    public Triple<RenderedSpell, Integer, List<ParticleSpray>> execute(@NotNull List<? extends Iota> args, @NotNull CastingContext ctx) {
        int n;
        Either either;
        IMixinCastingContext mCast;
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Entity entity = OperatorUtils.getEntity(args, (int)0, (int)this.getArgc());
        IMediaEntity iMediaEntity = entity instanceof IMediaEntity ? (IMediaEntity)entity : null;
        if (iMediaEntity == null) {
            throw MishapInvalidIota.Companion.ofType(args.get(0), 0, "consumable_entity");
        }
        IMediaEntity consumed = iMediaEntity;
        ctx.assertEntityInRange(consumed.get());
        IMixinCastingContext iMixinCastingContext = mCast = ctx instanceof IMixinCastingContext ? (IMixinCastingContext)ctx : null;
        if (mCast != null && mCast.getWisp() != null) {
            Either either2 = Either.left((Object)mCast.getWisp());
            either = either2;
            Intrinsics.checkNotNullExpressionValue((Object)either2, (String)"left(mCast.wisp)");
        } else {
            Either either3 = Either.right((Object)ctx.getCaster());
            either = either3;
            Intrinsics.checkNotNullExpressionValue((Object)either3, (String)"right(ctx.caster)");
        }
        Either consumer = either;
        HexalAPI.LOGGER.debug("consumer: {}, {}", (Object)consumer, (Object)consumed.fightConsume((Either<BaseCastingWisp, ServerPlayer>)consumer));
        boolean bl = consumed.fightConsume((Either<BaseCastingWisp, ServerPlayer>)consumer);
        if (!bl) {
            n = HexalConfig.getServer().getConsumeWispOwnCost();
        } else if (bl) {
            n = (int)(HexalConfig.getServer().getConsumeWispOthersCostPerMedia() * (double)consumed.getMedia());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        int cost = n;
        HexalAPI.LOGGER.debug("cost to consume {} is {}", (Object)consumed, (Object)cost);
        Spell spell = new Spell(consumed);
        Integer n2 = cost;
        Vec3 vec3 = consumed.get().m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"consumed.get().position()");
        return new Triple((Object)spell, (Object)n2, (Object)CollectionsKt.listOf((Object)ParticleSpray.Companion.burst(vec3, 1.0, (int)(Math.log(10.0) * (double)14 * Math.log((double)consumed.getMedia() / 10.0 + 1.0)))));
    }

    public boolean getAlwaysProcessGreatSpell() {
        return SpellAction.DefaultImpls.getAlwaysProcessGreatSpell((SpellAction)this);
    }

    public boolean getCausesBlindDiversion() {
        return SpellAction.DefaultImpls.getCausesBlindDiversion((SpellAction)this);
    }

    @NotNull
    public Component getDisplayName() {
        return SpellAction.DefaultImpls.getDisplayName((SpellAction)this);
    }

    public boolean awardsCastingStat(@NotNull CastingContext ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat((SpellAction)this, (CastingContext)ctx);
    }

    public boolean hasCastingSound(@NotNull CastingContext ctx) {
        return SpellAction.DefaultImpls.hasCastingSound((SpellAction)this, (CastingContext)ctx);
    }

    @NotNull
    public OperationResult operate(@NotNull SpellContinuation continuation, @NotNull List<Iota> stack, @Nullable Iota ravenmind, @NotNull CastingContext ctx) {
        return SpellAction.DefaultImpls.operate((SpellAction)this, (SpellContinuation)continuation, stack, (Iota)ravenmind, (CastingContext)ctx);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\r\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\u0017\u0010\f\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lram/talia/hexal/common/casting/actions/spells/great/OpConsumeWisp$Spell;", "Lat/petrak/hexcasting/api/spell/RenderedSpell;", "consumed", "Lram/talia/hexal/common/entities/IMediaEntity;", "(Lram/talia/hexal/common/entities/IMediaEntity;)V", "getConsumed", "()Lram/talia/hexal/common/entities/IMediaEntity;", "cast", "", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hexal-forge-1.19.2"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final IMediaEntity<?> consumed;

        public Spell(@NotNull IMediaEntity<?> consumed) {
            Intrinsics.checkNotNullParameter(consumed, (String)"consumed");
            this.consumed = consumed;
        }

        @NotNull
        public final IMediaEntity<?> getConsumed() {
            return this.consumed;
        }

        public void cast(@NotNull CastingContext ctx) {
            IMixinCastingContext mCast;
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            HexalAPI.LOGGER.debug("cast method of Spell of OpConsumeWisp triggered targeting {}", this.consumed);
            IMixinCastingContext iMixinCastingContext = mCast = ctx instanceof IMixinCastingContext ? (IMixinCastingContext)ctx : null;
            if (mCast != null && mCast.getWisp() != null) {
                BaseCastingWisp baseCastingWisp = mCast.getWisp();
                Intrinsics.checkNotNull((Object)baseCastingWisp);
                baseCastingWisp.addMedia(19 * this.consumed.getMedia() / 20);
            } else if (mCast != null) {
                mCast.setConsumedMedia(mCast.getConsumedMedia() + 19 * this.consumed.getMedia() / 20);
            }
            HexalAPI.LOGGER.debug("discarding {}", this.consumed);
            this.consumed.get().m_146870_();
        }

        @NotNull
        public final IMediaEntity<?> component1() {
            return this.consumed;
        }

        @NotNull
        public final Spell copy(@NotNull IMediaEntity<?> consumed) {
            Intrinsics.checkNotNullParameter(consumed, (String)"consumed");
            return new Spell(consumed);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, IMediaEntity iMediaEntity, int n, Object object) {
            if ((n & 1) != 0) {
                iMediaEntity = spell.consumed;
            }
            return spell.copy(iMediaEntity);
        }

        @NotNull
        public String toString() {
            return "Spell(consumed=" + this.consumed + ")";
        }

        public int hashCode() {
            return this.consumed.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            return Intrinsics.areEqual(this.consumed, spell.consumed);
        }
    }
}

