/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.api.spell.casting.triggers;

import at.petrak.hexcasting.api.spell.casting.CastingContext;
import at.petrak.hexcasting.api.spell.iota.Iota;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.spell.casting.triggers.IWispTrigger;
import ram.talia.hexal.api.spell.casting.triggers.WispTriggerTypes;
import ram.talia.hexal.common.entities.BaseCastingWisp;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0015\u0016\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\tJ\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lram/talia/hexal/api/spell/casting/triggers/WispTriggerRegistry;", "", "()V", "TAG_TYPE", "", "TAG_WISP_TRIGGER", "triggerTypes", "", "Lnet/minecraft/resources/ResourceLocation;", "Lram/talia/hexal/api/spell/casting/triggers/WispTriggerRegistry$WispTriggerType;", "fromNbt", "Lram/talia/hexal/api/spell/casting/triggers/IWispTrigger;", "tag", "Lnet/minecraft/nbt/CompoundTag;", "level", "Lnet/minecraft/server/level/ServerLevel;", "registerWispTriggerType", "", "type", "wrapNbt", "trigger", "InvalidWispTriggerTypeException", "RegisterWispTriggerTypeException", "WispTriggerType", "hexal-forge-1.19.2"})
public final class WispTriggerRegistry {
    @NotNull
    public static final WispTriggerRegistry INSTANCE = new WispTriggerRegistry();
    @NotNull
    public static final String TAG_TYPE = "type";
    @NotNull
    public static final String TAG_WISP_TRIGGER = "trigger";
    @NotNull
    private static final Map<ResourceLocation, WispTriggerType<?>> triggerTypes = new LinkedHashMap();

    private WispTriggerRegistry() {
    }

    public final void registerWispTriggerType(@NotNull WispTriggerType<?> type2) {
        Intrinsics.checkNotNullParameter(type2, (String)TAG_TYPE);
        if (triggerTypes.containsKey(type2.getId())) {
            throw new RegisterWispTriggerTypeException("LinkableRegistry already contains resource id " + type2.getId());
        }
        triggerTypes.put(type2.getId(), type2);
    }

    @NotNull
    public final CompoundTag wrapNbt(@NotNull IWispTrigger trigger) {
        Intrinsics.checkNotNullParameter((Object)trigger, (String)TAG_WISP_TRIGGER);
        return trigger.getTriggerType().wrapNbt(trigger.writeToNbt());
    }

    @Nullable
    public final IWispTrigger fromNbt(@NotNull CompoundTag tag, @NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        String typeId = tag.m_128461_(TAG_TYPE);
        if (!ResourceLocation.m_135830_((String)typeId)) {
            throw new InvalidWispTriggerTypeException(typeId + " is not a valid resource location");
        }
        WispTriggerType<?> wispTriggerType = triggerTypes.get(new ResourceLocation(typeId));
        if (wispTriggerType == null) {
            throw new InvalidWispTriggerTypeException("no WispTriggerType registered for " + typeId);
        }
        WispTriggerType<?> type2 = wispTriggerType;
        Tag tag2 = tag.m_128423_(TAG_WISP_TRIGGER);
        Intrinsics.checkNotNull((Object)tag2);
        return type2.fromNbt(tag2, level);
    }

    static {
        INSTANCE.registerWispTriggerType(WispTriggerTypes.TICK_TRIGGER_TYPE);
        INSTANCE.registerWispTriggerType(WispTriggerTypes.COMM_TRIGGER_TYPE);
        INSTANCE.registerWispTriggerType(WispTriggerTypes.MOVE_TRIGGER_TYPE);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lram/talia/hexal/api/spell/casting/triggers/WispTriggerRegistry$RegisterWispTriggerTypeException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "msg", "", "(Ljava/lang/String;)V", "hexal-forge-1.19.2"})
    public static final class RegisterWispTriggerTypeException
    extends Exception {
        public RegisterWispTriggerTypeException(@NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            super(msg);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lram/talia/hexal/api/spell/casting/triggers/WispTriggerRegistry$InvalidWispTriggerTypeException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "msg", "", "(Ljava/lang/String;)V", "hexal-forge-1.19.2"})
    public static final class InvalidWispTriggerTypeException
    extends Exception {
        public InvalidWispTriggerTypeException(@NotNull String msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            super(msg);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001f\u0010\r\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&\u00a2\u0006\u0002\u0010\u0012J+\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aH&\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000fR\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lram/talia/hexal/api/spell/casting/triggers/WispTriggerRegistry$WispTriggerType;", "T", "Lram/talia/hexal/api/spell/casting/triggers/IWispTrigger;", "", "id", "Lnet/minecraft/resources/ResourceLocation;", "(Lnet/minecraft/resources/ResourceLocation;)V", "argc", "", "getArgc", "()I", "getId", "()Lnet/minecraft/resources/ResourceLocation;", "fromNbt", "tag", "Lnet/minecraft/nbt/Tag;", "level", "Lnet/minecraft/server/level/ServerLevel;", "(Lnet/minecraft/nbt/Tag;Lnet/minecraft/server/level/ServerLevel;)Lram/talia/hexal/api/spell/casting/triggers/IWispTrigger;", "makeFromArgs", "wisp", "Lram/talia/hexal/common/entities/BaseCastingWisp;", "args", "", "Lat/petrak/hexcasting/api/spell/iota/Iota;", "ctx", "Lat/petrak/hexcasting/api/spell/casting/CastingContext;", "(Lram/talia/hexal/common/entities/BaseCastingWisp;Ljava/util/List;Lat/petrak/hexcasting/api/spell/casting/CastingContext;)Lram/talia/hexal/api/spell/casting/triggers/IWispTrigger;", "wrapNbt", "Lnet/minecraft/nbt/CompoundTag;", "itTag", "hexal-forge-1.19.2"})
    public static abstract class WispTriggerType<T extends IWispTrigger> {
        @NotNull
        private final ResourceLocation id;

        public WispTriggerType(@NotNull ResourceLocation id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
        }

        @NotNull
        public final ResourceLocation getId() {
            return this.id;
        }

        public abstract int getArgc();

        @NotNull
        public abstract T makeFromArgs(@NotNull BaseCastingWisp var1, @NotNull List<? extends Iota> var2, @NotNull CastingContext var3);

        @NotNull
        public final CompoundTag wrapNbt(@NotNull Tag itTag) {
            Intrinsics.checkNotNullParameter((Object)itTag, (String)"itTag");
            CompoundTag tag = new CompoundTag();
            tag.m_128359_(WispTriggerRegistry.TAG_TYPE, String.valueOf(this.id));
            tag.m_128365_(WispTriggerRegistry.TAG_WISP_TRIGGER, itTag);
            return tag;
        }

        @Nullable
        public abstract T fromNbt(@NotNull Tag var1, @NotNull ServerLevel var2);
    }
}

