/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting;

import com.google.common.base.Objects;
import com.mojang.math.Matrix4f;
import com.mojang.math.Transformation;
import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;

public class SurroundingBlockData {
    private final Map<Direction, SideConnections> connections;
    private final int hashCode;

    public static SurroundingBlockData create(BlockAndTintGetter level, BlockPos pos, Transformation rotation, List<ConnectionPredicate> predicates) {
        Transformation inverseRotation = rotation.m_121103_();
        Matrix4f rotationMatrix = inverseRotation == null ? Transformation.m_121093_().m_121104_() : rotation.m_121104_();
        Matrix4f inverseRotationMatrix = inverseRotation == null ? Transformation.m_121093_().m_121104_() : inverseRotation.m_121104_();
        EnumMap<Direction, SideConnections> connections = new EnumMap<Direction, SideConnections>(Direction.class);
        for (Direction side : Direction.values()) {
            connections.put(side, SurroundingBlockData.getConnections(side, rotationMatrix, inverseRotationMatrix, level, pos, predicates));
        }
        return new SurroundingBlockData(connections);
    }

    private static SideConnections getConnections(Direction side, Matrix4f rotation, Matrix4f inverseRotation, BlockAndTintGetter level, BlockPos pos, List<ConnectionPredicate> predicates) {
        Direction down;
        Direction up;
        Direction right;
        Direction left;
        Direction originalSide = Direction.m_122384_((Matrix4f)inverseRotation, (Direction)side);
        if (originalSide.m_122434_() == Direction.Axis.Y) {
            left = Direction.WEST;
            right = Direction.EAST;
            up = originalSide == Direction.UP ? Direction.NORTH : Direction.SOUTH;
            down = originalSide == Direction.UP ? Direction.SOUTH : Direction.NORTH;
        } else {
            left = originalSide.m_122427_();
            right = originalSide.m_122428_();
            up = Direction.UP;
            down = Direction.DOWN;
        }
        left = Direction.m_122384_((Matrix4f)rotation, (Direction)left);
        right = Direction.m_122384_((Matrix4f)rotation, (Direction)right);
        up = Direction.m_122384_((Matrix4f)rotation, (Direction)up);
        down = Direction.m_122384_((Matrix4f)rotation, (Direction)down);
        BlockState self = level.m_8055_(pos);
        boolean connectTop = SurroundingBlockData.shouldConnect(level, side, originalSide, self, pos.m_121945_(up), ConnectionDirection.TOP, predicates);
        boolean connectTopRight = SurroundingBlockData.shouldConnect(level, side, originalSide, self, pos.m_121945_(up).m_121945_(right), ConnectionDirection.TOP_RIGHT, predicates);
        boolean connectRight = SurroundingBlockData.shouldConnect(level, side, originalSide, self, pos.m_121945_(right), ConnectionDirection.RIGHT, predicates);
        boolean connectBottomRight = SurroundingBlockData.shouldConnect(level, side, originalSide, self, pos.m_121945_(down).m_121945_(right), ConnectionDirection.BOTTOM_RIGHT, predicates);
        boolean connectBottom = SurroundingBlockData.shouldConnect(level, side, originalSide, self, pos.m_121945_(down), ConnectionDirection.BOTTOM, predicates);
        boolean connectBottomLeft = SurroundingBlockData.shouldConnect(level, side, originalSide, self, pos.m_121945_(down).m_121945_(left), ConnectionDirection.BOTTOM_LEFT, predicates);
        boolean connectLeft = SurroundingBlockData.shouldConnect(level, side, originalSide, self, pos.m_121945_(left), ConnectionDirection.LEFT, predicates);
        boolean connectTopLeft = SurroundingBlockData.shouldConnect(level, side, originalSide, self, pos.m_121945_(up).m_121945_(left), ConnectionDirection.TOP_LEFT, predicates);
        return new SideConnections(side, connectTop, connectTopRight, connectRight, connectBottomRight, connectBottom, connectBottomLeft, connectLeft, connectTopLeft);
    }

    private static boolean shouldConnect(BlockAndTintGetter level, Direction side, Direction originalSide, BlockState self, BlockPos neighborPos, ConnectionDirection direction, List<ConnectionPredicate> predicates) {
        BlockState otherState = level.m_8055_(neighborPos);
        BlockState stateInFront = level.m_8055_(neighborPos.m_121945_(side));
        return predicates.stream().anyMatch(predicate -> predicate.shouldConnect(originalSide, self, otherState, stateInFront, direction));
    }

    public SurroundingBlockData(Map<Direction, SideConnections> connections) {
        this.connections = connections;
        this.hashCode = this.connections.hashCode();
    }

    public SideConnections getConnections(Direction side) {
        return this.connections.get(side);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return obj instanceof SurroundingBlockData && this.hashCode == ((SurroundingBlockData)obj).hashCode;
    }

    public static final class SideConnections {
        public final Direction side;
        public final boolean top;
        public final boolean topRight;
        public final boolean right;
        public final boolean bottomRight;
        public final boolean bottom;
        public final boolean bottomLeft;
        public final boolean left;
        public final boolean topLeft;

        public SideConnections(Direction side, boolean top, boolean topRight, boolean right, boolean bottomRight, boolean bottom, boolean bottomLeft, boolean left, boolean topLeft) {
            this.side = side;
            this.top = top;
            this.topRight = topRight;
            this.right = right;
            this.bottomRight = bottomRight;
            this.bottom = bottom;
            this.bottomLeft = bottomLeft;
            this.left = left;
            this.topLeft = topLeft;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SideConnections that = (SideConnections)o;
            return this.left == that.left && this.right == that.right && this.top == that.top && this.topLeft == that.topLeft && this.topRight == that.topRight && this.bottom == that.bottom && this.bottomLeft == that.bottomLeft && this.bottomRight == that.bottomRight && this.side == that.side;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.side, this.left, this.right, this.top, this.topLeft, this.topRight, this.bottom, this.bottomLeft, this.bottomRight});
        }
    }
}

