/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksExpected;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.data.AllyMode;
import dev.ftb.mods.ftbchunks.data.ClaimResult;
import dev.ftb.mods.ftbchunks.data.ClaimResults;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManager;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.ForceLoadMode;
import dev.ftb.mods.ftbchunks.data.PartyLimitMode;
import dev.ftb.mods.ftbchunks.data.TeamMemberData;
import dev.ftb.mods.ftbchunks.event.ClaimedChunkEvent;
import dev.ftb.mods.ftbchunks.net.ChunkSendingUtils;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftbchunks.net.SendManyChunksPacket;
import dev.ftb.mods.ftbchunks.util.DimensionFilter;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.PrivacyMode;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.property.BooleanProperty;
import dev.ftb.mods.ftbteams.property.PrivacyProperty;
import dev.ftb.mods.ftbteams.property.StringListProperty;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class FTBChunksTeamData {
    public static final BooleanProperty ALLOW_ALL_FAKE_PLAYERS = new BooleanProperty(new ResourceLocation("ftbchunks", "allow_fake_players"), Boolean.valueOf(false));
    public static final StringListProperty ALLOW_NAMED_FAKE_PLAYERS = new StringListProperty(new ResourceLocation("ftbchunks", "allow_named_fake_players"), new ArrayList());
    public static final BooleanProperty ALLOW_FAKE_PLAYERS_BY_ID = new BooleanProperty(new ResourceLocation("ftbchunks", "allow_fake_players_by_id"), Boolean.valueOf(true));
    public static final PrivacyProperty BLOCK_EDIT_MODE = new PrivacyProperty(new ResourceLocation("ftbchunks", "block_edit_mode"), PrivacyMode.ALLIES);
    public static final PrivacyProperty BLOCK_INTERACT_MODE = new PrivacyProperty(new ResourceLocation("ftbchunks", "block_interact_mode"), PrivacyMode.ALLIES);
    public static final PrivacyProperty BLOCK_EDIT_AND_INTERACT_MODE = new PrivacyProperty(new ResourceLocation("ftbchunks", "block_edit_and_interact_mode"), PrivacyMode.ALLIES);
    public static final PrivacyProperty ENTITY_INTERACT_MODE = new PrivacyProperty(new ResourceLocation("ftbchunks", "entity_interact_mode"), PrivacyMode.ALLIES);
    public static final PrivacyProperty NONLIVING_ENTITY_ATTACK_MODE = new PrivacyProperty(new ResourceLocation("ftbchunks", "nonliving_entity_attack_mode"), PrivacyMode.ALLIES);
    public static final BooleanProperty ALLOW_EXPLOSIONS = new BooleanProperty(new ResourceLocation("ftbchunks", "allow_explosions"), Boolean.valueOf(false));
    public static final BooleanProperty ALLOW_MOB_GRIEFING = new BooleanProperty(new ResourceLocation("ftbchunks", "allow_mob_griefing"), Boolean.valueOf(false));
    public static final PrivacyProperty CLAIM_VISIBILITY = new PrivacyProperty(new ResourceLocation("ftbchunks", "claim_visibility"), PrivacyMode.PUBLIC);
    public static final PrivacyProperty LOCATION_MODE = new PrivacyProperty(new ResourceLocation("ftbchunks", "location_mode"), PrivacyMode.ALLIES);
    public final ClaimedChunkManager manager;
    private final Team team;
    public final Path file;
    private boolean shouldSave;
    private int maxClaimChunks;
    private int maxForceLoadChunks;
    public int extraClaimChunks;
    public int extraForceLoadChunks;
    private Boolean canForceLoadChunks;
    private final Map<UUID, TeamMemberData> memberData;
    public int prevChunkX = Integer.MAX_VALUE;
    public int prevChunkZ = Integer.MAX_VALUE;
    public String lastChunkID = "";
    private long lastLoginTime;
    private Set<String> fakePlayerNameCache;

    public FTBChunksTeamData(ClaimedChunkManager m, Path f, Team t) {
        this.manager = m;
        this.team = t;
        this.file = f;
        this.shouldSave = false;
        this.maxClaimChunks = -1;
        this.maxForceLoadChunks = -1;
        this.extraClaimChunks = 0;
        this.extraForceLoadChunks = 0;
        this.lastLoginTime = 0L;
        this.memberData = new HashMap<UUID, TeamMemberData>();
    }

    public String toString() {
        return this.team.getStringID();
    }

    public ClaimedChunkManager getManager() {
        return this.manager;
    }

    public Team getTeam() {
        return this.team;
    }

    public UUID getTeamId() {
        return this.team.getId();
    }

    public Collection<ClaimedChunk> getClaimedChunks() {
        ArrayList<ClaimedChunk> list = new ArrayList<ClaimedChunk>();
        for (ClaimedChunk chunk : this.manager.getAllClaimedChunks()) {
            if (chunk.teamData != this) continue;
            list.add(chunk);
        }
        return list;
    }

    public Collection<ClaimedChunk> getForceLoadedChunks() {
        ArrayList<ClaimedChunk> list = new ArrayList<ClaimedChunk>();
        for (ClaimedChunk chunk : this.manager.getAllClaimedChunks()) {
            if (chunk.teamData != this || !chunk.isForceLoaded()) continue;
            list.add(chunk);
        }
        return list;
    }

    public Collection<ClaimedChunk> getOriginalClaims(UUID playerID) {
        if (!this.memberData.containsKey(playerID)) {
            return Collections.emptyList();
        }
        ArrayList<ClaimedChunk> res = new ArrayList<ClaimedChunk>();
        for (ChunkDimPos cdp : this.memberData.get(playerID).getOriginalClaims()) {
            ClaimedChunk cc = this.manager.getChunk(cdp);
            if (cc == null || cc.teamData != this) continue;
            res.add(this.manager.getChunk(cdp));
        }
        return res;
    }

    public ClaimResult claim(CommandSourceStack source, ChunkDimPos pos, boolean checkOnly) {
        ClaimedChunk chunk = this.manager.getChunk(pos);
        if (chunk != null) {
            return ClaimResults.ALREADY_CLAIMED;
        }
        if (!DimensionFilter.isDimensionOK((ResourceKey<Level>)pos.dimension)) {
            return ClaimResults.DIMENSION_FORBIDDEN;
        }
        if (!this.team.getType().isServer() && this.getClaimedChunks().size() >= this.getMaxClaimChunks()) {
            return ClaimResults.NOT_ENOUGH_POWER;
        }
        chunk = new ClaimedChunk(this, pos);
        ClaimResult r = (ClaimResult)((ClaimedChunkEvent.Before)ClaimedChunkEvent.BEFORE_CLAIM.invoker()).before(source, chunk).object();
        if (r == null) {
            r = chunk;
        }
        if (checkOnly || !r.isSuccess()) {
            return r;
        }
        chunk.setClaimedTime(System.currentTimeMillis());
        this.manager.registerClaim(pos, chunk);
        ((ClaimedChunkEvent.After)ClaimedChunkEvent.AFTER_CLAIM.invoker()).after(source, chunk);
        this.save();
        return chunk;
    }

    public ClaimResult unclaim(CommandSourceStack source, ChunkDimPos pos, boolean checkOnly) {
        ClaimedChunk chunk = this.manager.getChunk(pos);
        if (chunk == null) {
            return ClaimResults.NOT_CLAIMED;
        }
        if (chunk.teamData != this && !source.m_6761_(2) && !source.m_81377_().m_129792_()) {
            return ClaimResults.NOT_OWNER;
        }
        ClaimResult r = (ClaimResult)((ClaimedChunkEvent.Before)ClaimedChunkEvent.BEFORE_UNCLAIM.invoker()).before(source, chunk).object();
        if (r == null) {
            r = chunk;
        }
        if (checkOnly || !r.isSuccess()) {
            return r;
        }
        chunk.unclaim(source, true);
        return chunk;
    }

    public ClaimResult load(CommandSourceStack source, ChunkDimPos pos, boolean checkOnly) {
        ClaimedChunk chunk = this.manager.getChunk(pos);
        if (chunk == null) {
            return ClaimResults.NOT_CLAIMED;
        }
        if (chunk.teamData != this && !source.m_6761_(2) && !source.m_81377_().m_129792_()) {
            return ClaimResults.NOT_OWNER;
        }
        if (chunk.isForceLoaded()) {
            return ClaimResults.ALREADY_LOADED;
        }
        if (!this.team.getType().isServer() && this.getForceLoadedChunks().size() >= this.getMaxForceLoadChunks()) {
            return ClaimResults.NOT_ENOUGH_POWER;
        }
        ClaimResult r = (ClaimResult)((ClaimedChunkEvent.Before)ClaimedChunkEvent.BEFORE_LOAD.invoker()).before(source, chunk).object();
        if (r == null) {
            r = chunk;
        }
        if (checkOnly || !r.isSuccess()) {
            return r;
        }
        chunk.setForceLoadedTime(System.currentTimeMillis());
        ((ClaimedChunkEvent.After)ClaimedChunkEvent.AFTER_LOAD.invoker()).after(source, chunk);
        chunk.teamData.save();
        chunk.sendUpdateToAll();
        return chunk;
    }

    public ClaimResult unload(CommandSourceStack source, ChunkDimPos pos, boolean checkOnly) {
        ClaimedChunk chunk = this.manager.getChunk(pos);
        if (chunk == null) {
            return ClaimResults.NOT_CLAIMED;
        }
        if (!(chunk.teamData == this || source.m_6761_(2) || source.m_81377_().m_129792_() || source.m_81373_() instanceof ServerPlayer && this.isTeamMember(source.m_81373_().m_20148_()))) {
            return ClaimResults.NOT_OWNER;
        }
        if (!chunk.isForceLoaded()) {
            return ClaimResults.NOT_LOADED;
        }
        ClaimResult r = (ClaimResult)((ClaimedChunkEvent.Before)ClaimedChunkEvent.BEFORE_UNLOAD.invoker()).before(source, chunk).object();
        if (r == null) {
            r = chunk;
        }
        if (checkOnly || !r.isSuccess()) {
            return r;
        }
        chunk.unload(source);
        return chunk;
    }

    public void save() {
        this.shouldSave = true;
        this.team.save();
    }

    public boolean isTeamMember(UUID p) {
        if (p.equals(this.getTeamId())) {
            return true;
        }
        return this.team.equals((Object)FTBTeamsAPI.getManager().getPlayerTeam(p));
    }

    public boolean isAlly(UUID p) {
        if (FTBChunksWorldConfig.ALLY_MODE.get() == AllyMode.FORCED_ALL || this.team.isMember(p)) {
            return true;
        }
        if (FTBChunksWorldConfig.ALLY_MODE.get() == AllyMode.FORCED_NONE) {
            return false;
        }
        return this.team.isAlly(p);
    }

    public boolean canUse(ServerPlayer p, PrivacyProperty property) {
        PrivacyMode mode = (PrivacyMode)this.team.getProperty((TeamProperty)property);
        if (mode == PrivacyMode.PUBLIC) {
            return true;
        }
        if (PlayerHooks.isFake((Player)p)) {
            return this.canFakePlayerUse((Player)p, mode);
        }
        if (mode == PrivacyMode.ALLIES) {
            return this.isAlly(p.m_20148_());
        }
        return this.team.isMember(p.m_20148_());
    }

    private boolean canFakePlayerUse(Player player, PrivacyMode mode) {
        boolean checkById;
        if (((Boolean)this.team.getProperty((TeamProperty)ALLOW_ALL_FAKE_PLAYERS)).booleanValue()) {
            return mode == PrivacyMode.ALLIES;
        }
        boolean bl = checkById = (Boolean)this.team.getProperty((TeamProperty)ALLOW_FAKE_PLAYERS_BY_ID) != false && player.m_20148_() != null;
        if (mode == PrivacyMode.ALLIES) {
            return checkById && this.isAlly(player.m_20148_()) || this.getCachedFakePlayerNames().contains(player.m_36316_().getName().toLowerCase(Locale.ROOT)) || this.getCachedFakePlayerNames().contains(player.m_36316_().getId().toString().toLowerCase(Locale.ROOT));
        }
        if (mode == PrivacyMode.PRIVATE) {
            return checkById && this.team.isMember(player.m_20148_());
        }
        return false;
    }

    private Set<String> getCachedFakePlayerNames() {
        if (this.fakePlayerNameCache == null) {
            this.fakePlayerNameCache = ((List)this.team.getProperty((TeamProperty)ALLOW_NAMED_FAKE_PLAYERS)).stream().map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        }
        return this.fakePlayerNameCache;
    }

    public void clearFakePlayerNameCache() {
        this.fakePlayerNameCache = null;
    }

    public SNBTCompoundTag serializeNBT() {
        SNBTCompoundTag tag = new SNBTCompoundTag();
        tag.m_128405_("max_claim_chunks", this.getMaxClaimChunks());
        tag.m_128405_("max_force_load_chunks", this.getMaxForceLoadChunks());
        if (this.extraClaimChunks > 0 && !(this.team instanceof PartyTeam)) {
            tag.m_128405_("extra_claim_chunks", this.extraClaimChunks);
        }
        if (this.extraForceLoadChunks > 0 && !(this.team instanceof PartyTeam)) {
            tag.m_128405_("extra_force_load_chunks", this.extraForceLoadChunks);
        }
        tag.m_128356_("last_login_time", this.lastLoginTime);
        CompoundTag chunksTag = new CompoundTag();
        for (ClaimedChunk chunk : this.getClaimedChunks()) {
            String key = chunk.getPos().dimension.m_135782_().toString();
            ListTag chunksListTag = chunksTag.m_128437_(key, 10);
            if (chunksListTag.isEmpty()) {
                chunksTag.m_128365_(key, (Tag)chunksListTag);
            }
            chunksListTag.add((Object)chunk.serializeNBT());
        }
        tag.m_128365_("chunks", (Tag)chunksTag);
        CompoundTag memberTag = new CompoundTag();
        this.memberData.forEach((id, data) -> memberTag.m_128365_(id.toString(), (Tag)data.serializeNBT()));
        if (!memberTag.m_128456_()) {
            tag.m_128365_("member_data", (Tag)memberTag);
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.maxClaimChunks = tag.m_128451_("max_claim_chunks");
        this.maxForceLoadChunks = tag.m_128451_("max_force_load_chunks");
        this.extraClaimChunks = tag.m_128451_("extra_claim_chunks");
        this.extraForceLoadChunks = tag.m_128451_("extra_force_load_chunks");
        this.lastLoginTime = tag.m_128454_("last_login_time");
        this.canForceLoadChunks = null;
        CompoundTag chunksTag = tag.m_128469_("chunks");
        for (String key : chunksTag.m_128431_()) {
            ResourceKey dimKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(key));
            ListTag chunksListTag = chunksTag.m_128437_(key, 10);
            for (int i = 0; i < chunksListTag.size(); ++i) {
                ClaimedChunk chunk = ClaimedChunk.deserializeNBT(this, (ResourceKey<Level>)dimKey, chunksListTag.m_128728_(i));
                this.manager.registerClaim(chunk.pos, chunk);
            }
        }
        this.memberData.clear();
        CompoundTag memberTag = tag.m_128469_("member_data");
        for (String key : memberTag.m_128431_()) {
            try {
                UUID id = UUID.fromString(key);
                if (id == Util.f_137441_) continue;
                this.memberData.put(id, TeamMemberData.deserializeNBT(memberTag.m_128469_(key)));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
    }

    public int getExtraClaimChunks() {
        if (this.extraClaimChunks > 0 && this.team instanceof PartyTeam) {
            FTBChunks.LOGGER.info("found non-zero extra_claim_chunks={} in party team {}: transferring to owner {}", (Object)this.extraClaimChunks, (Object)this.getTeamId(), (Object)this.team.getOwner());
            FTBChunksTeamData personalTeam = FTBChunksAPI.getManager().getPersonalData(this.team.getOwner());
            personalTeam.extraClaimChunks = this.extraClaimChunks;
            this.extraClaimChunks = 0;
            this.save();
            personalTeam.save();
        }
        return this.extraClaimChunks;
    }

    public int getExtraForceLoadChunks() {
        if (this.extraForceLoadChunks > 0 && this.team instanceof PartyTeam) {
            FTBChunks.LOGGER.info("found non-zero extra_force_load_chunks={} in party team {}: transferring to owner {}", (Object)this.extraForceLoadChunks, (Object)this.getTeamId(), (Object)this.team.getOwner());
            FTBChunksTeamData personalTeam = FTBChunksAPI.getManager().getPersonalData(this.team.getOwner());
            personalTeam.extraForceLoadChunks = this.extraForceLoadChunks;
            this.extraForceLoadChunks = 0;
            this.save();
            personalTeam.save();
        }
        return this.extraForceLoadChunks;
    }

    public void setForceLoadMember(UUID id, boolean val) {
        long oldForceCount = this.memberData.values().stream().filter(TeamMemberData::isOfflineForceLoader).count();
        this.getTeamMemberData(id).setOfflineForceLoader(val);
        long newForceCount = this.memberData.values().stream().filter(TeamMemberData::isOfflineForceLoader).count();
        if (oldForceCount != newForceCount) {
            FTBChunks.LOGGER.debug("team {}: set force load member {} = {}", (Object)this.team.getId(), (Object)id, (Object)val);
            this.save();
            this.canForceLoadChunks = null;
            this.manager.clearForceLoadedCache();
        }
    }

    @NotNull
    private TeamMemberData getTeamMemberData(UUID id) {
        if (id.equals(Util.f_137441_)) {
            FTBChunks.LOGGER.warn("attempt to get member data for nil UUID");
            new RuntimeException().printStackTrace();
            return TeamMemberData.defaultData();
        }
        return this.memberData.computeIfAbsent(id, k -> TeamMemberData.defaultData());
    }

    public void updateChunkTickets(boolean load) {
        this.getClaimedChunks().forEach(chunk -> {
            ServerLevel level;
            if (chunk.isForceLoaded() && (level = this.manager.getMinecraftServer().m_129880_(chunk.pos.dimension)) != null) {
                FTBChunksExpected.addChunkToForceLoaded(level, "ftbchunks", this.getTeamId(), chunk.pos.x, chunk.pos.z, load);
            }
        });
    }

    public void saveNow() {
        if (this.shouldSave && SNBT.write((Path)this.file, (CompoundTag)this.serializeNBT())) {
            this.shouldSave = false;
        }
    }

    public boolean canForceLoadChunks() {
        if (this.canForceLoadChunks == null) {
            this.canForceLoadChunks = switch ((ForceLoadMode)((Object)FTBChunksWorldConfig.FORCE_LOAD_MODE.get())) {
                case ForceLoadMode.ALWAYS -> true;
                case ForceLoadMode.NEVER -> false;
                default -> (Boolean)FTBChunksWorldConfig.CHUNK_LOAD_OFFLINE.get() != false || this.hasForceLoadMembers();
            };
        }
        return this.canForceLoadChunks;
    }

    public boolean hasForceLoadMembers() {
        return this.memberData.values().stream().anyMatch(TeamMemberData::isOfflineForceLoader);
    }

    public boolean allowExplosions() {
        return (Boolean)this.team.getProperty((TeamProperty)ALLOW_EXPLOSIONS);
    }

    public boolean allowMobGriefing() {
        return (Boolean)this.team.getProperty((TeamProperty)ALLOW_MOB_GRIEFING);
    }

    public void setLastLoginTime(long when) {
        this.lastLoginTime = when;
        this.save();
    }

    public long getLastLoginTime() {
        if (this.lastLoginTime == 0L) {
            this.setLastLoginTime(System.currentTimeMillis());
        }
        return this.lastLoginTime;
    }

    public boolean shouldHideClaims() {
        return this.getTeam().getProperty((TeamProperty)CLAIM_VISIBILITY) != PrivacyMode.PUBLIC;
    }

    public void syncChunksToPlayer(ServerPlayer recipient) {
        this.chunksByDimension().forEach((dimension, chunkPackets) -> {
            if (!chunkPackets.isEmpty()) {
                ChunkSendingUtils.sendManyChunksToPlayer(recipient, this, new SendManyChunksPacket((ResourceKey<Level>)dimension, this.getTeamId(), (List<SendChunkPacket.SingleChunk>)chunkPackets));
            }
        });
    }

    public void syncChunksToAll(MinecraftServer server) {
        this.chunksByDimension().forEach((dimension, chunkPackets) -> {
            if (!chunkPackets.isEmpty()) {
                ChunkSendingUtils.sendManyChunksToAll(server, this, new SendManyChunksPacket((ResourceKey<Level>)dimension, this.getTeamId(), (List<SendChunkPacket.SingleChunk>)chunkPackets));
            }
        });
    }

    private Map<ResourceKey<Level>, List<SendChunkPacket.SingleChunk>> chunksByDimension() {
        long now = System.currentTimeMillis();
        return this.getClaimedChunks().stream().collect(Collectors.groupingBy(c -> c.pos.dimension, Collectors.mapping(c -> new SendChunkPacket.SingleChunk(now, c.pos.x, c.pos.z, (ClaimedChunk)c), Collectors.toList())));
    }

    public int getMaxClaimChunks() {
        return this.maxClaimChunks;
    }

    public int getMaxForceLoadChunks() {
        return this.maxForceLoadChunks;
    }

    public void updateLimits() {
        this.updateMemberLimitData(!this.memberData.isEmpty());
        if (!(this.team instanceof PartyTeam)) {
            TeamMemberData m2 = this.getTeamMemberData(this.getTeam().getId());
            this.maxClaimChunks = m2.getMaxClaims();
            this.maxForceLoadChunks = m2.getMaxForceLoads();
        } else {
            switch ((PartyLimitMode)((Object)FTBChunksWorldConfig.PARTY_LIMIT_MODE.get())) {
                case OWNER: {
                    TeamMemberData m3 = this.getTeamMemberData(this.getTeam().getOwner());
                    this.maxClaimChunks = m3.getMaxClaims();
                    this.maxForceLoadChunks = m3.getMaxForceLoads();
                    break;
                }
                case SUM: {
                    this.maxForceLoadChunks = 0;
                    this.maxClaimChunks = 0;
                    this.memberData.values().forEach(m -> {
                        this.maxClaimChunks += m.getMaxClaims();
                        this.maxForceLoadChunks += m.getMaxForceLoads();
                    });
                    break;
                }
                case LARGEST: {
                    this.maxForceLoadChunks = 0;
                    this.maxClaimChunks = 0;
                    for (TeamMemberData m4 : this.memberData.values()) {
                        this.maxClaimChunks = Math.max(m4.getMaxClaims(), this.maxClaimChunks);
                        this.maxForceLoadChunks = Math.max(m4.getMaxForceLoads(), this.maxForceLoadChunks);
                    }
                    break;
                }
                case AVERAGE: {
                    this.maxForceLoadChunks = 0;
                    this.maxClaimChunks = 0;
                    this.memberData.values().forEach(m -> {
                        this.maxClaimChunks += m.getMaxClaims();
                        this.maxForceLoadChunks += m.getMaxForceLoads();
                    });
                    if (this.memberData.size() <= 0) break;
                    this.maxClaimChunks /= this.memberData.size();
                    this.maxForceLoadChunks /= this.memberData.size();
                }
            }
        }
        if ((Integer)FTBChunksWorldConfig.HARD_TEAM_CLAIM_LIMIT.get() > 0) {
            this.maxClaimChunks = Math.min(this.maxClaimChunks, (Integer)FTBChunksWorldConfig.HARD_TEAM_CLAIM_LIMIT.get());
        }
        if ((Integer)FTBChunksWorldConfig.HARD_TEAM_FORCE_LIMIT.get() > 0) {
            this.maxForceLoadChunks = Math.min(this.maxForceLoadChunks, (Integer)FTBChunksWorldConfig.HARD_TEAM_FORCE_LIMIT.get());
        }
        SendGeneralDataPacket.send(this, this.getTeam().getOnlineMembers());
        this.save();
    }

    private void updateMemberLimitData(boolean onlinePlayersOnly) {
        HashSet members = new HashSet(this.team.getMembers());
        for (ServerPlayer p : this.team.getOnlineMembers()) {
            PlayerTeam playerTeam = FTBTeamsAPI.getManager().getInternalPlayerTeam(p.m_20148_());
            TeamMemberData m = this.getTeamMemberData(p.m_20148_());
            if (playerTeam != null) {
                FTBChunksTeamData personalData = FTBChunksAPI.getManager().getData((Team)playerTeam);
                m.setMaxClaims(FTBChunksWorldConfig.getMaxClaimedChunks(personalData, p));
                m.setMaxForceLoads(FTBChunksWorldConfig.getMaxForceLoadedChunks(personalData, p));
            } else {
                m.setMaxClaims((Integer)FTBChunksWorldConfig.MAX_CLAIMED_CHUNKS.get());
                m.setMaxForceLoads((Integer)FTBChunksWorldConfig.MAX_CLAIMED_CHUNKS.get());
            }
            members.remove(p.m_20148_());
        }
        if (!onlinePlayersOnly) {
            for (UUID id : members) {
                int maxF;
                int maxC;
                TeamMemberData m = this.getTeamMemberData(id);
                PlayerTeam playerTeam = FTBTeamsAPI.getManager().getInternalPlayerTeam(id);
                if (playerTeam != null) {
                    FTBChunksTeamData personalData = FTBChunksAPI.getManager().getData((Team)playerTeam);
                    maxC = (Integer)FTBChunksWorldConfig.MAX_CLAIMED_CHUNKS.get() + personalData.getExtraClaimChunks();
                    maxF = (Integer)FTBChunksWorldConfig.MAX_FORCE_LOADED_CHUNKS.get() + personalData.getExtraForceLoadChunks();
                } else {
                    maxC = (Integer)FTBChunksWorldConfig.MAX_CLAIMED_CHUNKS.get();
                    maxF = (Integer)FTBChunksWorldConfig.MAX_FORCE_LOADED_CHUNKS.get();
                }
                m.setMaxClaims(maxC);
                m.setMaxForceLoads(maxF);
            }
        }
        this.save();
    }

    public void addMemberData(ServerPlayer player, FTBChunksTeamData otherTeam) {
        if (otherTeam.team instanceof PlayerTeam) {
            this.memberData.put(otherTeam.getTeamId(), TeamMemberData.fromPlayerData(player, otherTeam));
            this.save();
        }
    }

    public void deleteMemberData(UUID playerId) {
        if (this.memberData.remove(playerId) != null) {
            this.save();
        }
    }
}

